/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.model;

import org.apache.poi.ddf.EscherClientDataRecord;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.ddf.EscherOptRecord;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.ddf.EscherSpRecord;
import org.apache.poi.hssf.model.AbstractShape;
import org.apache.poi.hssf.record.CommonObjectDataSubRecord;
import org.apache.poi.hssf.record.EndSubRecord;
import org.apache.poi.hssf.record.ObjRecord;
import org.apache.poi.hssf.usermodel.HSSFShape;
import org.apache.poi.hssf.usermodel.HSSFSimpleShape;

public class SimpleFilledShape
extends AbstractShape {
    private EscherContainerRecord spContainer;
    private ObjRecord objRecord;

    SimpleFilledShape(HSSFSimpleShape hssfShape, int shapeId) {
        this.spContainer = this.createSpContainer(hssfShape, shapeId);
        this.objRecord = this.createObjRecord(hssfShape, shapeId);
    }

    private EscherContainerRecord createSpContainer(HSSFSimpleShape hssfShape, int shapeId) {
        HSSFSimpleShape shape = hssfShape;
        EscherContainerRecord spContainer = new EscherContainerRecord();
        EscherSpRecord sp = new EscherSpRecord();
        EscherOptRecord opt = new EscherOptRecord();
        EscherClientDataRecord clientData = new EscherClientDataRecord();
        spContainer.setRecordId((short)-4092);
        spContainer.setOptions((short)15);
        sp.setRecordId((short)-4086);
        short shapeType = this.objTypeToShapeType(hssfShape.getShapeType());
        sp.setOptions((short)(shapeType << 4 | 2));
        sp.setShapeId(shapeId);
        sp.setFlags(2560);
        opt.setRecordId((short)-4085);
        this.addStandardOptions(shape, opt);
        EscherRecord anchor = this.createAnchor(shape.getAnchor());
        clientData.setRecordId((short)-4079);
        clientData.setOptions((short)0);
        spContainer.addChildRecord(sp);
        spContainer.addChildRecord(opt);
        spContainer.addChildRecord(anchor);
        spContainer.addChildRecord(clientData);
        return spContainer;
    }

    private short objTypeToShapeType(int objType) {
        short shapeType;
        if (objType == 3) {
            shapeType = 3;
        } else if (objType == 2) {
            shapeType = 1;
        } else {
            throw new IllegalArgumentException("Unable to handle an object of this type");
        }
        return shapeType;
    }

    private ObjRecord createObjRecord(HSSFShape hssfShape, int shapeId) {
        HSSFShape shape = hssfShape;
        ObjRecord obj = new ObjRecord();
        CommonObjectDataSubRecord c2 = new CommonObjectDataSubRecord();
        c2.setObjectType((short)((HSSFSimpleShape)shape).getShapeType());
        c2.setObjectId(shapeId);
        c2.setLocked(true);
        c2.setPrintable(true);
        c2.setAutofill(true);
        c2.setAutoline(true);
        EndSubRecord e2 = new EndSubRecord();
        obj.addSubRecord(c2);
        obj.addSubRecord(e2);
        return obj;
    }

    public EscherContainerRecord getSpContainer() {
        return this.spContainer;
    }

    public ObjRecord getObjRecord() {
        return this.objRecord;
    }
}

