/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hpsf;

import java.util.Map;
import org.apache.poi.hpsf.CustomProperties;
import org.apache.poi.hpsf.CustomProperty;
import org.apache.poi.hpsf.HPSFRuntimeException;
import org.apache.poi.hpsf.MutableSection;
import org.apache.poi.hpsf.Property;
import org.apache.poi.hpsf.PropertySet;
import org.apache.poi.hpsf.Section;
import org.apache.poi.hpsf.SpecialPropertySet;
import org.apache.poi.hpsf.UnexpectedPropertySetTypeException;
import org.apache.poi.hpsf.wellknown.PropertyIDMap;
import org.apache.poi.hpsf.wellknown.SectionIDMap;

public class DocumentSummaryInformation
extends SpecialPropertySet {
    public static final String DEFAULT_STREAM_NAME = "\u0005DocumentSummaryInformation";

    public PropertyIDMap getPropertySetIDMap() {
        return PropertyIDMap.getDocumentSummaryInformationProperties();
    }

    public DocumentSummaryInformation(PropertySet ps) throws UnexpectedPropertySetTypeException {
        super(ps);
        if (!this.isDocumentSummaryInformation()) {
            throw new UnexpectedPropertySetTypeException("Not a " + this.getClass().getName());
        }
    }

    public String getCategory() {
        return (String)this.getProperty(2);
    }

    public void setCategory(String category) {
        MutableSection s2 = (MutableSection)this.getFirstSection();
        s2.setProperty(2, category);
    }

    public void removeCategory() {
        MutableSection s2 = (MutableSection)this.getFirstSection();
        s2.removeProperty(2L);
    }

    public String getPresentationFormat() {
        return (String)this.getProperty(3);
    }

    public void setPresentationFormat(String presentationFormat) {
        MutableSection s2 = (MutableSection)this.getFirstSection();
        s2.setProperty(3, presentationFormat);
    }

    public void removePresentationFormat() {
        MutableSection s2 = (MutableSection)this.getFirstSection();
        s2.removeProperty(3L);
    }

    public int getByteCount() {
        return this.getPropertyIntValue(4);
    }

    public void setByteCount(int byteCount) {
        MutableSection s2 = (MutableSection)this.getFirstSection();
        s2.setProperty(4, byteCount);
    }

    public void removeByteCount() {
        MutableSection s2 = (MutableSection)this.getFirstSection();
        s2.removeProperty(4L);
    }

    public int getLineCount() {
        return this.getPropertyIntValue(5);
    }

    public void setLineCount(int lineCount) {
        MutableSection s2 = (MutableSection)this.getFirstSection();
        s2.setProperty(5, lineCount);
    }

    public void removeLineCount() {
        MutableSection s2 = (MutableSection)this.getFirstSection();
        s2.removeProperty(5L);
    }

    public int getParCount() {
        return this.getPropertyIntValue(6);
    }

    public void setParCount(int parCount) {
        MutableSection s2 = (MutableSection)this.getFirstSection();
        s2.setProperty(6, parCount);
    }

    public void removeParCount() {
        MutableSection s2 = (MutableSection)this.getFirstSection();
        s2.removeProperty(6L);
    }

    public int getSlideCount() {
        return this.getPropertyIntValue(7);
    }

    public void setSlideCount(int slideCount) {
        MutableSection s2 = (MutableSection)this.getFirstSection();
        s2.setProperty(7, slideCount);
    }

    public void removeSlideCount() {
        MutableSection s2 = (MutableSection)this.getFirstSection();
        s2.removeProperty(7L);
    }

    public int getNoteCount() {
        return this.getPropertyIntValue(8);
    }

    public void setNoteCount(int noteCount) {
        MutableSection s2 = (MutableSection)this.getFirstSection();
        s2.setProperty(8, noteCount);
    }

    public void removeNoteCount() {
        MutableSection s2 = (MutableSection)this.getFirstSection();
        s2.removeProperty(8L);
    }

    public int getHiddenCount() {
        return this.getPropertyIntValue(9);
    }

    public void setHiddenCount(int hiddenCount) {
        MutableSection s2 = (MutableSection)this.getSections().get(0);
        s2.setProperty(9, hiddenCount);
    }

    public void removeHiddenCount() {
        MutableSection s2 = (MutableSection)this.getFirstSection();
        s2.removeProperty(9L);
    }

    public int getMMClipCount() {
        return this.getPropertyIntValue(10);
    }

    public void setMMClipCount(int mmClipCount) {
        MutableSection s2 = (MutableSection)this.getFirstSection();
        s2.setProperty(10, mmClipCount);
    }

    public void removeMMClipCount() {
        MutableSection s2 = (MutableSection)this.getFirstSection();
        s2.removeProperty(10L);
    }

    public boolean getScale() {
        return this.getPropertyBooleanValue(11);
    }

    public void setScale(boolean scale) {
        MutableSection s2 = (MutableSection)this.getFirstSection();
        s2.setProperty(11, scale);
    }

    public void removeScale() {
        MutableSection s2 = (MutableSection)this.getFirstSection();
        s2.removeProperty(11L);
    }

    public byte[] getHeadingPair() {
        this.notYetImplemented("Reading byte arrays ");
        return (byte[])this.getProperty(12);
    }

    public void setHeadingPair(byte[] headingPair) {
        this.notYetImplemented("Writing byte arrays ");
    }

    public void removeHeadingPair() {
        MutableSection s2 = (MutableSection)this.getFirstSection();
        s2.removeProperty(12L);
    }

    public byte[] getDocparts() {
        this.notYetImplemented("Reading byte arrays");
        return (byte[])this.getProperty(13);
    }

    public void setDocparts(byte[] docparts) {
        this.notYetImplemented("Writing byte arrays");
    }

    public void removeDocparts() {
        MutableSection s2 = (MutableSection)this.getFirstSection();
        s2.removeProperty(13L);
    }

    public String getManager() {
        return (String)this.getProperty(14);
    }

    public void setManager(String manager) {
        MutableSection s2 = (MutableSection)this.getFirstSection();
        s2.setProperty(14, manager);
    }

    public void removeManager() {
        MutableSection s2 = (MutableSection)this.getFirstSection();
        s2.removeProperty(14L);
    }

    public String getCompany() {
        return (String)this.getProperty(15);
    }

    public void setCompany(String company) {
        MutableSection s2 = (MutableSection)this.getFirstSection();
        s2.setProperty(15, company);
    }

    public void removeCompany() {
        MutableSection s2 = (MutableSection)this.getFirstSection();
        s2.removeProperty(15L);
    }

    public boolean getLinksDirty() {
        return this.getPropertyBooleanValue(16);
    }

    public void setLinksDirty(boolean linksDirty) {
        MutableSection s2 = (MutableSection)this.getFirstSection();
        s2.setProperty(16, linksDirty);
    }

    public void removeLinksDirty() {
        MutableSection s2 = (MutableSection)this.getFirstSection();
        s2.removeProperty(16L);
    }

    public CustomProperties getCustomProperties() {
        CustomProperties cps = null;
        if (this.getSectionCount() >= 2) {
            cps = new CustomProperties();
            Section section = (Section)this.getSections().get(1);
            Map dictionary = section.getDictionary();
            Property[] properties = section.getProperties();
            int propertyCount = 0;
            for (int i2 = 0; i2 < properties.length; ++i2) {
                Property p2 = properties[i2];
                long id = p2.getID();
                if (id == 0L || id == 1L) continue;
                ++propertyCount;
                CustomProperty cp = new CustomProperty(p2, (String)dictionary.get(id));
                cps.put((Object)cp.getName(), cp);
            }
            if (cps.size() != propertyCount) {
                cps.setPure(false);
            }
        }
        return cps;
    }

    public void setCustomProperties(CustomProperties customProperties) {
        this.ensureSection2();
        MutableSection section = (MutableSection)this.getSections().get(1);
        Map dictionary = customProperties.getDictionary();
        section.clear();
        int cpCodepage = customProperties.getCodepage();
        if (cpCodepage < 0) {
            cpCodepage = section.getCodepage();
        }
        if (cpCodepage < 0) {
            cpCodepage = 1200;
        }
        customProperties.setCodepage(cpCodepage);
        section.setCodepage(cpCodepage);
        section.setDictionary(dictionary);
        for (Property p2 : customProperties.values()) {
            section.setProperty(p2);
        }
    }

    private void ensureSection2() {
        if (this.getSectionCount() < 2) {
            MutableSection s2 = new MutableSection();
            s2.setFormatID(SectionIDMap.DOCUMENT_SUMMARY_INFORMATION_ID[1]);
            this.addSection(s2);
        }
    }

    public void removeCustomProperties() {
        if (this.getSectionCount() < 2) {
            throw new HPSFRuntimeException("Illegal internal format of Document SummaryInformation stream: second section is missing.");
        }
        this.getSections().remove(1);
    }

    private void notYetImplemented(String msg) {
        throw new UnsupportedOperationException(msg + " is not yet implemented.");
    }
}

