/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ddf;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.apache.poi.ddf.EscherBlipRecord;
import org.apache.poi.ddf.EscherRecordFactory;
import org.apache.poi.ddf.EscherSerializationListener;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.RecordFormatException;

public class EscherBlipWMFRecord
extends EscherBlipRecord {
    public static final String RECORD_DESCRIPTION = "msofbtBlip";
    private static final int HEADER_SIZE = 8;
    private byte[] field_1_secondaryUID;
    private int field_2_cacheOfSize;
    private int field_3_boundaryTop;
    private int field_4_boundaryLeft;
    private int field_5_boundaryWidth;
    private int field_6_boundaryHeight;
    private int field_7_width;
    private int field_8_height;
    private int field_9_cacheOfSavedSize;
    private byte field_10_compressionFlag;
    private byte field_11_filter;
    private byte[] field_12_data;

    public int fillFields(byte[] data, int offset, EscherRecordFactory recordFactory) {
        int bytesAfterHeader = this.readHeader(data, offset);
        int pos = offset + 8;
        int size = 0;
        this.field_1_secondaryUID = new byte[16];
        System.arraycopy(data, pos + size, this.field_1_secondaryUID, 0, 16);
        this.field_2_cacheOfSize = LittleEndian.getInt(data, pos + (size += 16));
        this.field_3_boundaryTop = LittleEndian.getInt(data, pos + (size += 4));
        this.field_4_boundaryLeft = LittleEndian.getInt(data, pos + (size += 4));
        this.field_5_boundaryWidth = LittleEndian.getInt(data, pos + (size += 4));
        this.field_6_boundaryHeight = LittleEndian.getInt(data, pos + (size += 4));
        this.field_7_width = LittleEndian.getInt(data, pos + (size += 4));
        this.field_8_height = LittleEndian.getInt(data, pos + (size += 4));
        this.field_9_cacheOfSavedSize = LittleEndian.getInt(data, pos + (size += 4));
        this.field_10_compressionFlag = data[pos + (size += 4)];
        this.field_11_filter = data[pos + ++size];
        int bytesRemaining = bytesAfterHeader - ++size;
        this.field_12_data = new byte[bytesRemaining];
        System.arraycopy(data, pos + size, this.field_12_data, 0, bytesRemaining);
        return 8 + (size += bytesRemaining);
    }

    public int serialize(int offset, byte[] data, EscherSerializationListener listener) {
        listener.beforeRecordSerialize(offset, this.getRecordId(), this);
        LittleEndian.putShort(data, offset, this.getOptions());
        LittleEndian.putShort(data, offset + 2, this.getRecordId());
        int remainingBytes = this.field_12_data.length + 36;
        LittleEndian.putInt(data, offset + 4, remainingBytes);
        int pos = offset + 8;
        System.arraycopy(this.field_1_secondaryUID, 0, data, pos, 16);
        LittleEndian.putInt(data, pos += 16, this.field_2_cacheOfSize);
        LittleEndian.putInt(data, pos += 4, this.field_3_boundaryTop);
        LittleEndian.putInt(data, pos += 4, this.field_4_boundaryLeft);
        LittleEndian.putInt(data, pos += 4, this.field_5_boundaryWidth);
        LittleEndian.putInt(data, pos += 4, this.field_6_boundaryHeight);
        LittleEndian.putInt(data, pos += 4, this.field_7_width);
        LittleEndian.putInt(data, pos += 4, this.field_8_height);
        LittleEndian.putInt(data, pos += 4, this.field_9_cacheOfSavedSize);
        pos += 4;
        data[pos++] = this.field_10_compressionFlag;
        data[pos++] = this.field_11_filter;
        System.arraycopy(this.field_12_data, 0, data, pos, this.field_12_data.length);
        listener.afterRecordSerialize(pos += this.field_12_data.length, this.getRecordId(), pos - offset, this);
        return pos - offset;
    }

    public int getRecordSize() {
        return 58 + this.field_12_data.length;
    }

    public String getRecordName() {
        return "Blip";
    }

    public byte[] getSecondaryUID() {
        return this.field_1_secondaryUID;
    }

    public void setSecondaryUID(byte[] field_1_secondaryUID) {
        this.field_1_secondaryUID = field_1_secondaryUID;
    }

    public int getCacheOfSize() {
        return this.field_2_cacheOfSize;
    }

    public void setCacheOfSize(int field_2_cacheOfSize) {
        this.field_2_cacheOfSize = field_2_cacheOfSize;
    }

    public int getBoundaryTop() {
        return this.field_3_boundaryTop;
    }

    public void setBoundaryTop(int field_3_boundaryTop) {
        this.field_3_boundaryTop = field_3_boundaryTop;
    }

    public int getBoundaryLeft() {
        return this.field_4_boundaryLeft;
    }

    public void setBoundaryLeft(int field_4_boundaryLeft) {
        this.field_4_boundaryLeft = field_4_boundaryLeft;
    }

    public int getBoundaryWidth() {
        return this.field_5_boundaryWidth;
    }

    public void setBoundaryWidth(int field_5_boundaryWidth) {
        this.field_5_boundaryWidth = field_5_boundaryWidth;
    }

    public int getBoundaryHeight() {
        return this.field_6_boundaryHeight;
    }

    public void setBoundaryHeight(int field_6_boundaryHeight) {
        this.field_6_boundaryHeight = field_6_boundaryHeight;
    }

    public int getWidth() {
        return this.field_7_width;
    }

    public void setWidth(int width) {
        this.field_7_width = width;
    }

    public int getHeight() {
        return this.field_8_height;
    }

    public void setHeight(int height) {
        this.field_8_height = height;
    }

    public int getCacheOfSavedSize() {
        return this.field_9_cacheOfSavedSize;
    }

    public void setCacheOfSavedSize(int field_9_cacheOfSavedSize) {
        this.field_9_cacheOfSavedSize = field_9_cacheOfSavedSize;
    }

    public byte getCompressionFlag() {
        return this.field_10_compressionFlag;
    }

    public void setCompressionFlag(byte field_10_compressionFlag) {
        this.field_10_compressionFlag = field_10_compressionFlag;
    }

    public byte getFilter() {
        return this.field_11_filter;
    }

    public void setFilter(byte field_11_filter) {
        this.field_11_filter = field_11_filter;
    }

    public byte[] getData() {
        return this.field_12_data;
    }

    public void setData(byte[] field_12_data) {
        this.field_12_data = field_12_data;
    }

    public String toString() {
        String extraData;
        String nl = System.getProperty("line.separator");
        ByteArrayOutputStream b2 = new ByteArrayOutputStream();
        try {
            HexDump.dump(this.field_12_data, 0L, b2, 0);
            extraData = b2.toString();
        }
        catch (Exception e2) {
            extraData = e2.toString();
        }
        return this.getClass().getName() + ":" + nl + "  RecordId: 0x" + HexDump.toHex(this.getRecordId()) + nl + "  Options: 0x" + HexDump.toHex(this.getOptions()) + nl + "  Secondary UID: " + HexDump.toHex(this.field_1_secondaryUID) + nl + "  CacheOfSize: " + this.field_2_cacheOfSize + nl + "  BoundaryTop: " + this.field_3_boundaryTop + nl + "  BoundaryLeft: " + this.field_4_boundaryLeft + nl + "  BoundaryWidth: " + this.field_5_boundaryWidth + nl + "  BoundaryHeight: " + this.field_6_boundaryHeight + nl + "  X: " + this.field_7_width + nl + "  Y: " + this.field_8_height + nl + "  CacheOfSavedSize: " + this.field_9_cacheOfSavedSize + nl + "  CompressionFlag: " + this.field_10_compressionFlag + nl + "  Filter: " + this.field_11_filter + nl + "  Data:" + nl + extraData;
    }

    public static byte[] compress(byte[] data) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(out);
        try {
            for (int i2 = 0; i2 < data.length; ++i2) {
                deflaterOutputStream.write(data[i2]);
            }
        }
        catch (IOException e2) {
            throw new RecordFormatException(e2.toString());
        }
        return out.toByteArray();
    }

    public static byte[] decompress(byte[] data, int pos, int length) {
        byte[] compressedData = new byte[length];
        System.arraycopy(data, pos + 50, compressedData, 0, length);
        ByteArrayInputStream compressedInputStream = new ByteArrayInputStream(compressedData);
        InflaterInputStream inflaterInputStream = new InflaterInputStream(compressedInputStream);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            int c2;
            while ((c2 = inflaterInputStream.read()) != -1) {
                out.write(c2);
            }
        }
        catch (IOException e2) {
            throw new RecordFormatException(e2.toString());
        }
        return out.toByteArray();
    }
}

