/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang.exception;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang.exception.Nestable;

public class NestableDelegate
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final transient String MUST_BE_THROWABLE = "The Nestable implementation passed to the NestableDelegate(Nestable) constructor must extend java.lang.Throwable";
    private Throwable nestable = null;
    public static boolean topDown = true;
    public static boolean trimStackFrames = true;
    public static boolean matchSubclasses = true;
    static /* synthetic */ Class class$org$apache$commons$lang$exception$Nestable;

    public NestableDelegate(Nestable nestable) {
        if (!(nestable instanceof Throwable)) {
            throw new IllegalArgumentException(MUST_BE_THROWABLE);
        }
        this.nestable = (Throwable)((Object)nestable);
    }

    public String getMessage(int index) {
        Throwable t2;
        if ((class$org$apache$commons$lang$exception$Nestable == null ? (class$org$apache$commons$lang$exception$Nestable = NestableDelegate.class$("org.apache.commons.lang.exception.Nestable")) : class$org$apache$commons$lang$exception$Nestable).isInstance(t2 = this.getThrowable(index))) {
            return ((Nestable)((Object)t2)).getMessage(0);
        }
        return t2.getMessage();
    }

    public String getMessage(String baseMsg) {
        String causeMsg;
        Throwable nestedCause = ExceptionUtils.getCause(this.nestable);
        String string = causeMsg = nestedCause == null ? null : nestedCause.getMessage();
        if (nestedCause == null || causeMsg == null) {
            return baseMsg;
        }
        if (baseMsg == null) {
            return causeMsg;
        }
        return baseMsg + ": " + causeMsg;
    }

    public String[] getMessages() {
        Throwable[] throwables = this.getThrowables();
        String[] msgs = new String[throwables.length];
        for (int i2 = 0; i2 < throwables.length; ++i2) {
            msgs[i2] = (class$org$apache$commons$lang$exception$Nestable == null ? NestableDelegate.class$("org.apache.commons.lang.exception.Nestable") : class$org$apache$commons$lang$exception$Nestable).isInstance(throwables[i2]) ? ((Nestable)((Object)throwables[i2])).getMessage(0) : throwables[i2].getMessage();
        }
        return msgs;
    }

    public Throwable getThrowable(int index) {
        if (index == 0) {
            return this.nestable;
        }
        Throwable[] throwables = this.getThrowables();
        return throwables[index];
    }

    public int getThrowableCount() {
        return ExceptionUtils.getThrowableCount(this.nestable);
    }

    public Throwable[] getThrowables() {
        return ExceptionUtils.getThrowables(this.nestable);
    }

    public int indexOfThrowable(Class type, int fromIndex) {
        if (type == null) {
            return -1;
        }
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("The start index was out of bounds: " + fromIndex);
        }
        Throwable[] throwables = ExceptionUtils.getThrowables(this.nestable);
        if (fromIndex >= throwables.length) {
            throw new IndexOutOfBoundsException("The start index was out of bounds: " + fromIndex + " >= " + throwables.length);
        }
        if (matchSubclasses) {
            for (int i2 = fromIndex; i2 < throwables.length; ++i2) {
                if (!type.isAssignableFrom(throwables[i2].getClass())) continue;
                return i2;
            }
        } else {
            for (int i3 = fromIndex; i3 < throwables.length; ++i3) {
                if (!type.equals(throwables[i3].getClass())) continue;
                return i3;
            }
        }
        return -1;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintStream out) {
        PrintStream printStream = out;
        synchronized (printStream) {
            PrintWriter pw = new PrintWriter(out, false);
            this.printStackTrace(pw);
            pw.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintWriter out) {
        Throwable throwable = this.nestable;
        if (ExceptionUtils.isThrowableNested()) {
            if (throwable instanceof Nestable) {
                ((Nestable)((Object)throwable)).printPartialStackTrace(out);
            } else {
                throwable.printStackTrace(out);
            }
            return;
        }
        ArrayList<String[]> stacks = new ArrayList<String[]>();
        while (throwable != null) {
            String[] st = this.getStackFrames(throwable);
            stacks.add(st);
            throwable = ExceptionUtils.getCause(throwable);
        }
        String separatorLine = "Caused by: ";
        if (!topDown) {
            separatorLine = "Rethrown as: ";
            Collections.reverse(stacks);
        }
        if (trimStackFrames) {
            this.trimStackFrames(stacks);
        }
        PrintWriter printWriter = out;
        synchronized (printWriter) {
            Iterator iter = stacks.iterator();
            while (iter.hasNext()) {
                String[] st = (String[])iter.next();
                int len = st.length;
                for (int i2 = 0; i2 < len; ++i2) {
                    out.println(st[i2]);
                }
                if (!iter.hasNext()) continue;
                out.print(separatorLine);
            }
        }
    }

    protected String[] getStackFrames(Throwable t2) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        if (t2 instanceof Nestable) {
            ((Nestable)((Object)t2)).printPartialStackTrace(pw);
        } else {
            t2.printStackTrace(pw);
        }
        return ExceptionUtils.getStackFrames(sw.getBuffer().toString());
    }

    protected void trimStackFrames(List stacks) {
        int size = stacks.size();
        for (int i2 = size - 1; i2 > 0; --i2) {
            String[] curr = (String[])stacks.get(i2);
            String[] next = (String[])stacks.get(i2 - 1);
            ArrayList<String> currList = new ArrayList<String>(Arrays.asList(curr));
            ArrayList<String> nextList = new ArrayList<String>(Arrays.asList(next));
            ExceptionUtils.removeCommonFrames(currList, nextList);
            int trimmed = curr.length - currList.size();
            if (trimmed <= 0) continue;
            currList.add("\t... " + trimmed + " more");
            stacks.set(i2, currList.toArray(new String[currList.size()]));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

