/*
 * Decompiled with CFR 0.152.
 */
package mymdbce.theMovieDb.v3.request_services;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mymdbce.theMovieDb.v3.addons.AddonsService;
import mymdbce.theMovieDb.v3.models._shared.TMDBV3SharedNameId;
import mymdbce.theMovieDb.v3.models.optionalRequestParams.search.TMDBV3OptinalSearchMovieRequestParams;
import mymdbce.theMovieDb.v3.models.optionalRequestParams.search.TMDBV3OptinalSearchMultiRequestParams;
import mymdbce.theMovieDb.v3.models.optionalRequestParams.search.TMDBV3OptinalSearchPersonRequestParams;
import mymdbce.theMovieDb.v3.models.optionalRequestParams.search.TMDBV3OptinalSearchTVRequestParams;
import mymdbce.theMovieDb.v3.models.params.TMDBV3ParamsAppendToRespone;
import mymdbce.theMovieDb.v3.models.search.TMDBV3SearchCollection;
import mymdbce.theMovieDb.v3.models.search.TMDBV3SearchCompany;
import mymdbce.theMovieDb.v3.models.search.TMDBV3SearchMovie;
import mymdbce.theMovieDb.v3.models.search.TMDBV3SearchMulti;
import mymdbce.theMovieDb.v3.models.search.TMDBV3SearchPerson;
import mymdbce.theMovieDb.v3.models.search.TMDBV3SearchTv;
import mymdbce.theMovieDb.v3.models.tv.TMDBV3TvDetails;
import mymdbce.theMovieDb.v3.models.tv.TMDBV3TvDetailsSeason;
import mymdbce.theMovieDb.v3.models.tv_seasons.TMDBV3TVSeasonsDetails;
import mymdbce.theMovieDb.v3.request_services.TMDBV3SearchService;
import mymdbce.theMovieDb.v3.request_services.TMDBV3TVSeasonsService;
import mymdbce.theMovieDb.v3.request_services.TMDBV3TVService;

public class TMDBV3Service {
    private TMDBV3SearchService searchService;
    private TMDBV3TVService tvService;
    private TMDBV3TVSeasonsService tvSeasonService;
    private AddonsService addonsService;

    public TMDBV3Service(String string, boolean bl) {
        this.init(string, bl);
    }

    private void init(String string, boolean bl) {
        this.searchService = new TMDBV3SearchService(string, bl);
        this.tvService = new TMDBV3TVService(string, bl);
        this.tvSeasonService = new TMDBV3TVSeasonsService(string, bl);
        this.addonsService = new AddonsService();
    }

    public List<String> generateSeasonEpisodeFileNames(int n2, int n3, int n4, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        TMDBV3TvDetails tMDBV3TvDetails = this.getTvDetails(n2, null);
        List<TMDBV3TvDetailsSeason> list = Arrays.asList(tMDBV3TvDetails.seasons);
        list.forEach(tMDBV3TvDetailsSeason -> {
            if (n3 <= tMDBV3TvDetailsSeason.season_number && tMDBV3TvDetailsSeason.season_number <= n4) {
                TMDBV3TVSeasonsDetails tMDBV3TVSeasonsDetails = this.getTvSeasonDetails(n2, tMDBV3TvDetailsSeason.season_number, null);
                arrayList.addAll(this.addonsService.generateSeasonEpisodeFileNames(tMDBV3TvDetails.name, tMDBV3TVSeasonsDetails, string));
            }
        });
        return arrayList;
    }

    public TMDBV3TVSeasonsDetails getTvSeasonDetails(int n2, int n3, TMDBV3ParamsAppendToRespone tMDBV3ParamsAppendToRespone) {
        return this.tvSeasonService.getDetails(n2, n3, tMDBV3ParamsAppendToRespone);
    }

    public TMDBV3TvDetails getTvDetails(int n2, TMDBV3ParamsAppendToRespone tMDBV3ParamsAppendToRespone) {
        return this.tvService.getDetails(n2, tMDBV3ParamsAppendToRespone);
    }

    public List<TMDBV3SearchCompany> searchCompanies(String string) {
        return this.searchService.getCompanies(string);
    }

    public List<TMDBV3SearchCollection> searchCollections(String string) {
        return this.searchService.getCollections(string);
    }

    public List<TMDBV3SharedNameId> searchKeywords(String string) {
        return this.searchService.getKeywords(string);
    }

    public List<TMDBV3SearchMovie> searchMovies(String string, TMDBV3OptinalSearchMovieRequestParams tMDBV3OptinalSearchMovieRequestParams) {
        return this.searchService.getMovies(string, tMDBV3OptinalSearchMovieRequestParams);
    }

    public List<TMDBV3SearchMulti> searchMultis(String string, TMDBV3OptinalSearchMultiRequestParams tMDBV3OptinalSearchMultiRequestParams) {
        return this.searchService.getMultis(string, tMDBV3OptinalSearchMultiRequestParams);
    }

    public List<TMDBV3SearchPerson> searchPersons(String string, TMDBV3OptinalSearchPersonRequestParams tMDBV3OptinalSearchPersonRequestParams) {
        return this.searchService.getPersons(string, tMDBV3OptinalSearchPersonRequestParams);
    }

    public List<TMDBV3SearchTv> searchTVs(String string, TMDBV3OptinalSearchTVRequestParams tMDBV3OptinalSearchTVRequestParams) {
        return this.searchService.getTVs(string, tMDBV3OptinalSearchTVRequestParams);
    }
}

