/*
 * Decompiled with CFR 0.152.
 */
package mymdbce.theMovieDb.v3.request_services;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mymdbce.af;
import mymdbce.theMovieDb.v3.models._shared.TMDBV3SharedMultipage;
import mymdbce.theMovieDb.v3.models.optionalRequestParams.TMDBV3OptionalRequestParams;
import mymdbce.theMovieDb.v3.models.params.TDMBV3ParamsBase;
import mymdbce.theMovieDb.v3.models.params.TMDBV3ParamsAppendToRespone;
import mymdbce.theMovieDb.v3.models.params.TMDBV3RequestParams;
import mymdbce.theMovieDb.v3.models.params.TMDBV3UrlParams;
import mymdbce.theMovieDb.v3.models.params.TMDBV3_PARAMS;
import mymdbce.theMovieDb.v3.models.responses.TMDBV3ExtendedResponse;
import mymdbce.theMovieDb.v3.request_services.ConfigParams;
import mymdbce.theMovieDb.v3.request_services.TMDBV3_ENDPOINT;
import org.apache.commons.io.IOUtils;

abstract class RequestBaseV3 {
    private String urlPrefix = "api.themoviedb.org/3/";
    private String apiKey = ConfigParams.getApiKey();
    private String language;
    private boolean include_adult;
    private String guest_session_id;
    private String session_id;
    private ObjectMapper objectMapper;

    RequestBaseV3() {
        this("en-US", false);
    }

    RequestBaseV3(String string) {
        this(string, false);
    }

    RequestBaseV3(String string, boolean bl) {
        this.language = string;
        this.include_adult = bl;
        this.objectMapper = new ObjectMapper();
    }

    protected <T> List<T> executeMultipageRequest(TMDBV3UrlParams tMDBV3UrlParams, TDMBV3ParamsBase tDMBV3ParamsBase, TypeReference<T> typeReference) {
        Object object2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (tDMBV3ParamsBase == null) {
            tDMBV3ParamsBase = new TDMBV3ParamsBase(){};
        }
        tDMBV3ParamsBase.addParameter(TMDBV3_PARAMS.LANGUAGE, (Object)this.language);
        tDMBV3ParamsBase.addParameter(TMDBV3_PARAMS.PAGE, 1);
        tDMBV3ParamsBase.addParameter(TMDBV3_PARAMS.INCLUDE_ADULT, this.include_adult);
        try {
            object2 = this.executeMultipageRequestForPage(tMDBV3UrlParams, tDMBV3ParamsBase, typeReference);
            Object[] objectArray = ((TMDBV3SharedMultipage)object2).results;
            arrayList.addAll(Arrays.asList(objectArray));
            for (int i2 = 2; i2 <= ((TMDBV3SharedMultipage)object2).total_pages; ++i2) {
                tDMBV3ParamsBase.addParameter(TMDBV3_PARAMS.PAGE, i2);
                object2 = this.executeMultipageRequestForPage(tMDBV3UrlParams, tDMBV3ParamsBase, typeReference);
                objectArray = ((TMDBV3SharedMultipage)object2).results;
                arrayList.addAll(Arrays.asList(objectArray));
            }
        }
        catch (IOException iOException) {
            object2 = iOException;
            iOException.printStackTrace();
        }
        catch (TMDBV3RequestFailedException tMDBV3RequestFailedException) {
            object2 = tMDBV3RequestFailedException;
            tMDBV3RequestFailedException.printStackTrace();
        }
        object2 = new ArrayList();
        arrayList.forEach(object -> object2.add(this.objectMapper.convertValue(object, typeReference)));
        return object2;
    }

    protected <T> List<T> executeMultipageRequest(TMDBV3_ENDPOINT tMDBV3_ENDPOINT, TDMBV3ParamsBase tDMBV3ParamsBase, TypeReference<T> typeReference) {
        Object object2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (tDMBV3ParamsBase == null) {
            tDMBV3ParamsBase = new TDMBV3ParamsBase(){};
        }
        tDMBV3ParamsBase.addParameter(TMDBV3_PARAMS.LANGUAGE, (Object)this.language);
        tDMBV3ParamsBase.addParameter(TMDBV3_PARAMS.PAGE, 1);
        tDMBV3ParamsBase.addParameter(TMDBV3_PARAMS.INCLUDE_ADULT, this.include_adult);
        try {
            object2 = this.executeMultipageRequestForPage(tMDBV3_ENDPOINT, tDMBV3ParamsBase, typeReference);
            Object[] objectArray = ((TMDBV3SharedMultipage)object2).results;
            arrayList.addAll(Arrays.asList(objectArray));
            for (int i2 = 2; i2 <= ((TMDBV3SharedMultipage)object2).total_pages; ++i2) {
                tDMBV3ParamsBase.addParameter(TMDBV3_PARAMS.PAGE, i2);
                object2 = this.executeMultipageRequestForPage(tMDBV3_ENDPOINT, tDMBV3ParamsBase, typeReference);
                objectArray = ((TMDBV3SharedMultipage)object2).results;
                arrayList.addAll(Arrays.asList(objectArray));
            }
        }
        catch (IOException iOException) {
            object2 = iOException;
            iOException.printStackTrace();
        }
        catch (TMDBV3RequestFailedException tMDBV3RequestFailedException) {
            object2 = tMDBV3RequestFailedException;
            tMDBV3RequestFailedException.printStackTrace();
        }
        object2 = new ArrayList();
        arrayList.forEach(object -> object2.add(this.objectMapper.convertValue(object, typeReference)));
        return object2;
    }

    protected <T> T executeSingleRequest(TMDBV3UrlParams tMDBV3UrlParams, TDMBV3ParamsBase object, TMDBV3ParamsAppendToRespone tMDBV3ParamsAppendToRespone, TypeReference<T> typeReference) {
        if (object == null) {
            object = new TMDBV3RequestParams();
        }
        if (tMDBV3ParamsAppendToRespone == null) {
            new TMDBV3ParamsAppendToRespone();
        }
        ((TDMBV3ParamsBase)object).addParameter(TMDBV3_PARAMS.LANGUAGE, (Object)this.language);
        ((TDMBV3ParamsBase)object).addParameter(TMDBV3_PARAMS.INCLUDE_ADULT, this.include_adult);
        try {
            object = this.executeSingleRequestForInfo(tMDBV3UrlParams, (TDMBV3ParamsBase)object, typeReference);
            return this.objectMapper.convertValue(object, typeReference);
        }
        catch (IOException iOException) {
            af.b("tmdbJSonError.log", "Url: " + tMDBV3UrlParams.generateParamsResult(), iOException.getMessage());
        }
        catch (TMDBV3RequestFailedException tMDBV3RequestFailedException) {
            object = tMDBV3RequestFailedException;
            tMDBV3RequestFailedException.printStackTrace();
        }
        return null;
    }

    protected <T> T executeUserSpecificSingleRequest(TMDBV3UrlParams tMDBV3UrlParams, TDMBV3ParamsBase tDMBV3ParamsBase, TypeReference<T> typeReference) {
        if (tDMBV3ParamsBase == null) {
            tDMBV3ParamsBase = new TMDBV3RequestParams();
        }
        tDMBV3ParamsBase.addParameter(TMDBV3_PARAMS.SESSION_ID, (Object)this.session_id);
        tDMBV3ParamsBase.addParameter(TMDBV3_PARAMS.GUEST_SESSION_ID, (Object)this.guest_session_id);
        return this.executeSingleRequest(tMDBV3UrlParams, tDMBV3ParamsBase, null, typeReference);
    }

    protected TMDBV3RequestParams createRequestParams(String string) {
        TMDBV3RequestParams tMDBV3RequestParams = new TMDBV3RequestParams();
        tMDBV3RequestParams.addParameter(TMDBV3_PARAMS.QUERY, string);
        return tMDBV3RequestParams;
    }

    protected boolean isOptinalParameterAvailable(TMDBV3OptionalRequestParams tMDBV3OptionalRequestParams) {
        return tMDBV3OptionalRequestParams != null;
    }

    private <T> T executeSingleRequestForInfo(TMDBV3UrlParams object, TDMBV3ParamsBase tDMBV3ParamsBase, TypeReference<T> typeReference) throws IOException, TMDBV3RequestFailedException {
        if (this.areParamsValid(tDMBV3ParamsBase)) {
            object = this.generateUrl((TMDBV3UrlParams)object, tDMBV3ParamsBase);
            object = this.executeRequest((URL)object);
            object = this.convertToJson((String)object, typeReference);
            return (T)object;
        }
        throw new TMDBV3RequestFailedException(this.generateUrl((TMDBV3UrlParams)object, tDMBV3ParamsBase), "Requestparams have an invalid format", -1);
    }

    private <T> TMDBV3SharedMultipage<T> executeMultipageRequestForPage(TMDBV3UrlParams object, TDMBV3ParamsBase object2, TypeReference<T> typeReference) throws IOException, TMDBV3RequestFailedException {
        if (this.areParamsValid((TDMBV3ParamsBase)object2)) {
            object = this.executeRequest(new URL(((TMDBV3UrlParams)object).generateParamsResult()));
            object2 = new TypeReference<TMDBV3SharedMultipage<T>>(){};
            object = (TMDBV3SharedMultipage)this.convertToJson((String)object, (TypeReference<T>)object2);
            return object;
        }
        throw new TMDBV3RequestFailedException(new URL(((TMDBV3UrlParams)object).generateParamsResult()), "Requestparams have an invalid format", -1);
    }

    private <T> TMDBV3SharedMultipage<T> executeMultipageRequestForPage(TMDBV3_ENDPOINT object, TDMBV3ParamsBase object2, TypeReference<T> typeReference) throws IOException, TMDBV3RequestFailedException {
        if (this.areParamsValid((TDMBV3ParamsBase)object2)) {
            object = this.generateUrl((TMDBV3_ENDPOINT)((Object)object), (TDMBV3ParamsBase)object2);
            object = this.executeRequest((URL)object);
            object2 = new TypeReference<TMDBV3SharedMultipage<T>>(){};
            object = (TMDBV3SharedMultipage)this.convertToJson((String)object, (TypeReference<T>)object2);
            return object;
        }
        throw new TMDBV3RequestFailedException(this.generateUrl((TMDBV3_ENDPOINT)((Object)object), (TDMBV3ParamsBase)object2), "Requestparams have an invalid format", -1);
    }

    private URL generateUrl(TMDBV3_ENDPOINT tMDBV3_ENDPOINT, TDMBV3ParamsBase tDMBV3ParamsBase) throws MalformedURLException {
        return this.generateUrl(tMDBV3_ENDPOINT.getValue(), tDMBV3ParamsBase);
    }

    private URL generateUrl(TMDBV3UrlParams tMDBV3UrlParams, TDMBV3ParamsBase tDMBV3ParamsBase) throws MalformedURLException {
        return this.generateUrl(tMDBV3UrlParams.generateParamsResult(), tDMBV3ParamsBase);
    }

    private URL generateUrl(String string, TDMBV3ParamsBase object) throws MalformedURLException {
        ((TDMBV3ParamsBase)object).addParameter(TMDBV3_PARAMS.API_KEY, (Object)this.apiKey);
        object = object instanceof TMDBV3RequestParams ? ((TMDBV3RequestParams)object).generateParamsResult() : ((TDMBV3ParamsBase)object).generateParamsResult();
        string = "https://" + (this.urlPrefix + "/" + string + (String)object).replaceAll("[/]+", "/").replaceAll(" ", "%20");
        return new URL(string);
    }

    private String executeRequest(URL uRL) throws IOException, TMDBV3RequestFailedException {
        Object object = (HttpURLConnection)uRL.openConnection();
        ((URLConnection)object).setConnectTimeout(1000);
        ((URLConnection)object).connect();
        int n2 = ((HttpURLConnection)object).getResponseCode();
        object = n2 == 200 ? ((URLConnection)object).getInputStream() : ((HttpURLConnection)object).getErrorStream();
        String string = IOUtils.toString((InputStream)object, StandardCharsets.UTF_8);
        ((InputStream)object).close();
        if (n2 != 200) {
            throw new TMDBV3RequestFailedException(uRL, string, n2);
        }
        return string;
    }

    private <T> Object convertToJson(String string, TypeReference<T> typeReference) throws JsonParseException, JsonMappingException, IOException {
        return this.objectMapper.readValue(string, typeReference);
    }

    private boolean areParamsValid(TDMBV3ParamsBase tDMBV3ParamsBase) {
        return this.validateMultipageNumber(tDMBV3ParamsBase.getValue(TMDBV3_PARAMS.PAGE)) && this.validatePattern("([a-z]{2})-([A-Z]{2})", tDMBV3ParamsBase.getValue(TMDBV3_PARAMS.LANGUAGE)) && this.validatePattern("^[A-Z]{2}$", tDMBV3ParamsBase.getValue(TMDBV3_PARAMS.REGION));
    }

    private boolean validatePattern(String string, String string2) {
        return string2 == null || string2.matches(string);
    }

    private boolean validateMultipageNumber(String string) {
        return string == null || 1 <= Integer.parseInt(string) && Integer.parseInt(string) <= 1000;
    }

    class TMDBV3RequestFailedException
    extends Exception {
        private TMDBV3ExtendedResponse payload;
        private String url;
        private int statuscode;

        TMDBV3RequestFailedException(URL uRL, String string, int n2) {
            super(uRL.toString());
            this.url = uRL.toString().replaceAll("api_key=[0-9a-z]*", "api_key=xzy");
            this.statuscode = n2;
            try {
                this.payload = this.convertToErrorResponse(string);
                return;
            }
            catch (IOException iOException) {
                RequestBaseV3.this = iOException;
                iOException.printStackTrace();
                this.payload = new TMDBV3ExtendedResponse("Convert from Json failed for url: " + this.url, -1);
                return;
            }
        }

        private TMDBV3ExtendedResponse convertToErrorResponse(String string) throws JsonParseException, JsonMappingException, IOException {
            return RequestBaseV3.this.objectMapper.readValue(string, TMDBV3ExtendedResponse.class);
        }

        @Override
        public String toString() {
            return "TMDBV3RequestFailedException [httpStatus: " + this.statuscode + ", payload=" + this.payload.toString() + " for url: " + this.url + "]";
        }
    }
}

