/*
 * Decompiled with CFR 0.152.
 */
package mymdbce.mobileBackend;

import java.io.Serializable;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import javax.servlet.Filter;
import mymdbce.d.a;
import mymdbce.mobileBackend.handler.AdditionalMovieInformationRequestHandler;
import mymdbce.mobileBackend.handler.DefaultRequestHandler;
import mymdbce.mobileBackend.handler.FilterRequestHandler;
import mymdbce.mobileBackend.handler.LocationRequestHandler;
import mymdbce.mobileBackend.handler.PictureRequestHandler;
import mymdbce.mobileBackend.handler.SynchronizeMoviesRequestHandler;
import mymdbce.mobileBackend.handler.UpdateExisitingDbsRequestHandler;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.AbstractNetworkConnector;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.Holder;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public class JettyServer {
    private Server server;
    private int port;

    protected JettyServer(int n2) {
        this.port = n2;
    }

    protected String getHostName() {
        String string = "Unknown";
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            string = inetAddress.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            System.out.println("Hostname can not be resolved");
        }
        return string;
    }

    protected String getIpAddress() {
        try {
            DatagramSocket datagramSocket = new DatagramSocket();
            datagramSocket.connect(InetAddress.getByName("8.8.8.8"), 10002);
            return datagramSocket.getLocalAddress().getHostAddress();
        }
        catch (SocketException | UnknownHostException iOException) {
            try {
                Serializable serializable = iOException;
                iOException.printStackTrace();
                serializable = InetAddress.getLocalHost();
                return ((InetAddress)serializable).getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                UnknownHostException unknownHostException2 = unknownHostException;
                unknownHostException.printStackTrace();
                return a.a("MOBILE_BACKEND.IP_ADDRESS.NOT_AVAILABLE");
            }
        }
    }

    protected void start() {
        Object object = new QueuedThreadPool(100, 10, 120);
        this.server = new Server((ThreadPool)object);
        object = new ServerConnector(this.server);
        ((AbstractNetworkConnector)object).setPort(this.port);
        ((AbstractConnector)object).setName("connA");
        ((AbstractConnector)object).setIdleTimeout(0L);
        this.server.setConnectors(new Connector[]{object});
        object = new ServletHandler();
        FilterHolder filterHolder = new FilterHolder();
        filterHolder.setInitParameter("allowedOrigins", "http://localhost:8080, http://localhost:8089,http://localhost:8090/, http://localhost:8090/*");
        filterHolder.setInitParameter("allowedMethods", "POST,GET,OPTIONS,PUT,DELETE,HEAD");
        filterHolder.setInitParameter("allowedHeaders", "X-PINGOTHER, Origin, X-Requested-With, Content-Type, Accept");
        filterHolder.setInitParameter("preflightMaxAge", "728000");
        filterHolder.setInitParameter("allowCredentials", "true");
        Object object2 = new CrossOriginFilter();
        filterHolder.setFilter((Filter)object2);
        object2 = new FilterHolder(CrossOriginFilter.class);
        ((Holder)object2).setInitParameter("allowedOrigins", "*");
        ((Holder)object2).setInitParameter("Access-Control-Allow-Origin", "*");
        ((Holder)object2).setInitParameter("allowedMethods", "GET,POST,HEAD");
        ((Holder)object2).setInitParameter("allowedHeaders", "X-Requested-With,Content-Type,Accept,Origin");
        ((ServletHandler)object).addServletWithMapping(DefaultRequestHandler.class, "");
        ((ServletHandler)object).addServletWithMapping(SynchronizeMoviesRequestHandler.class, "/synchronizeMovies");
        ((ServletHandler)object).addServletWithMapping(UpdateExisitingDbsRequestHandler.class, "/updateExistingDBs");
        ((ServletHandler)object).addServletWithMapping(AdditionalMovieInformationRequestHandler.class, "/additionalMovieInformation");
        ((ServletHandler)object).addServletWithMapping(PictureRequestHandler.class, "/updatePicture");
        ((ServletHandler)object).addServletWithMapping(FilterRequestHandler.class, "/synchronizeFilters");
        ((ServletHandler)object).addServletWithMapping(LocationRequestHandler.class, "/synchronizeLocations");
        ((ServletHandler)object).addFilter(filterHolder);
        ((ServletHandler)object).addFilter((FilterHolder)object2);
        this.server.setHandler((Handler)object);
        try {
            this.server.start();
            return;
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
            return;
        }
    }

    protected void stop() {
        try {
            this.server.stop();
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return;
        }
    }

    protected boolean isRunning() {
        return this.server != null && (this.server.isRunning() || this.server.isStarted() || this.server.isStarting());
    }
}

