/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocWriter;
import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.AcroFields;
import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.FdfReader;
import com.lowagie.text.pdf.PdfAcroForm;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfException;
import com.lowagie.text.pdf.PdfFileSpecification;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfLiteral;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfSigGenericPKCS;
import com.lowagie.text.pdf.PdfSignatureAppearance;
import com.lowagie.text.pdf.PdfStamperImp;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfTransition;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.collection.PdfCollection;
import com.lowagie.text.pdf.interfaces.PdfEncryptionSettings;
import com.lowagie.text.pdf.interfaces.PdfViewerPreferences;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PdfStamper
implements PdfViewerPreferences,
PdfEncryptionSettings {
    protected PdfStamperImp stamper;
    private HashMap moreInfo;
    private boolean hasSignature;
    private PdfSignatureAppearance sigApp;

    public PdfStamper(PdfReader pdfReader, OutputStream outputStream) throws DocumentException, IOException {
        this.stamper = new PdfStamperImp(pdfReader, outputStream, '\u0000', false);
    }

    public PdfStamper(PdfReader pdfReader, OutputStream outputStream, char c2) throws DocumentException, IOException {
        this.stamper = new PdfStamperImp(pdfReader, outputStream, c2, false);
    }

    public PdfStamper(PdfReader pdfReader, OutputStream outputStream, char c2, boolean bl) throws DocumentException, IOException {
        this.stamper = new PdfStamperImp(pdfReader, outputStream, c2, bl);
    }

    public HashMap getMoreInfo() {
        return this.moreInfo;
    }

    public void setMoreInfo(HashMap hashMap) {
        this.moreInfo = hashMap;
    }

    public void replacePage(PdfReader pdfReader, int n2, int n3) {
        this.stamper.replacePage(pdfReader, n2, n3);
    }

    public void insertPage(int n2, Rectangle rectangle) {
        this.stamper.insertPage(n2, rectangle);
    }

    public PdfSignatureAppearance getSignatureAppearance() {
        return this.sigApp;
    }

    public void close() throws DocumentException, IOException {
        if (!this.hasSignature) {
            this.stamper.close(this.moreInfo);
            return;
        }
        this.sigApp.preClose();
        PdfSigGenericPKCS pdfSigGenericPKCS = this.sigApp.getSigStandard();
        PdfLiteral pdfLiteral = (PdfLiteral)pdfSigGenericPKCS.get(PdfName.CONTENTS);
        int n2 = (pdfLiteral.getPosLength() - 2) / 2;
        byte[] byArray = new byte[8192];
        InputStream inputStream = this.sigApp.getRangeStream();
        try {
            int n3;
            while ((n3 = inputStream.read(byArray)) > 0) {
                pdfSigGenericPKCS.getSigner().update(byArray, 0, n3);
            }
        }
        catch (SignatureException signatureException) {
            throw new ExceptionConverter(signatureException);
        }
        byArray = new byte[n2];
        byte[] byArray2 = pdfSigGenericPKCS.getSignerContents();
        System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
        PdfString pdfString = new PdfString(byArray);
        pdfString.setHexWriting(true);
        PdfDictionary pdfDictionary = new PdfDictionary();
        pdfDictionary.put(PdfName.CONTENTS, pdfString);
        this.sigApp.close(pdfDictionary);
        this.stamper.reader.close();
    }

    public PdfContentByte getUnderContent(int n2) {
        return this.stamper.getUnderContent(n2);
    }

    public PdfContentByte getOverContent(int n2) {
        return this.stamper.getOverContent(n2);
    }

    public boolean isRotateContents() {
        return this.stamper.isRotateContents();
    }

    public void setRotateContents(boolean bl) {
        this.stamper.setRotateContents(bl);
    }

    public void setEncryption(byte[] byArray, byte[] byArray2, int n2, boolean bl) throws DocumentException {
        if (this.stamper.isAppend()) {
            throw new DocumentException("Append mode does not support changing the encryption status.");
        }
        if (this.stamper.isContentWritten()) {
            throw new DocumentException("Content was already written to the output.");
        }
        this.stamper.setEncryption(byArray, byArray2, n2, bl ? 1 : 0);
    }

    public void setEncryption(byte[] byArray, byte[] byArray2, int n2, int n3) throws DocumentException {
        if (this.stamper.isAppend()) {
            throw new DocumentException("Append mode does not support changing the encryption status.");
        }
        if (this.stamper.isContentWritten()) {
            throw new DocumentException("Content was already written to the output.");
        }
        this.stamper.setEncryption(byArray, byArray2, n2, n3);
    }

    public void setEncryption(boolean bl, String string, String string2, int n2) throws DocumentException {
        this.setEncryption(DocWriter.getISOBytes(string), DocWriter.getISOBytes(string2), n2, bl);
    }

    public void setEncryption(int n2, String string, String string2, int n3) throws DocumentException {
        this.setEncryption(DocWriter.getISOBytes(string), DocWriter.getISOBytes(string2), n3, n2);
    }

    public void setEncryption(Certificate[] certificateArray, int[] nArray, int n2) throws DocumentException {
        if (this.stamper.isAppend()) {
            throw new DocumentException("Append mode does not support changing the encryption status.");
        }
        if (this.stamper.isContentWritten()) {
            throw new DocumentException("Content was already written to the output.");
        }
        this.stamper.setEncryption(certificateArray, nArray, n2);
    }

    public PdfImportedPage getImportedPage(PdfReader pdfReader, int n2) {
        return this.stamper.getImportedPage(pdfReader, n2);
    }

    public PdfWriter getWriter() {
        return this.stamper;
    }

    public PdfReader getReader() {
        return this.stamper.reader;
    }

    public AcroFields getAcroFields() {
        return this.stamper.getAcroFields();
    }

    public void setFormFlattening(boolean bl) {
        this.stamper.setFormFlattening(bl);
    }

    public void setFreeTextFlattening(boolean bl) {
        this.stamper.setFreeTextFlattening(bl);
    }

    public void addAnnotation(PdfAnnotation pdfAnnotation, int n2) {
        this.stamper.addAnnotation(pdfAnnotation, n2);
    }

    public PdfFormField addSignature(String string, int n2, float f2, float f3, float f4, float f5) {
        PdfAcroForm pdfAcroForm = this.stamper.getAcroForm();
        PdfFormField pdfFormField = PdfFormField.createSignature(this.stamper);
        pdfAcroForm.setSignatureParams(pdfFormField, string, f2, f3, f4, f5);
        pdfAcroForm.drawSignatureAppearences(pdfFormField, f2, f3, f4, f5);
        this.addAnnotation(pdfFormField, n2);
        return pdfFormField;
    }

    public void addComments(FdfReader fdfReader) throws IOException {
        this.stamper.addComments(fdfReader);
    }

    public void setOutlines(List list) {
        this.stamper.setOutlines(list);
    }

    public void setThumbnail(Image image, int n2) throws PdfException, DocumentException {
        this.stamper.setThumbnail(image, n2);
    }

    public boolean partialFormFlattening(String string) {
        return this.stamper.partialFormFlattening(string);
    }

    public void addJavaScript(String string) {
        this.stamper.addJavaScript(string, !PdfEncodings.isPdfDocEncoding(string));
    }

    public void addFileAttachment(String string, byte[] byArray, String string2, String string3) throws IOException {
        this.addFileAttachment(string, PdfFileSpecification.fileEmbedded(this.stamper, string2, string3, byArray));
    }

    public void addFileAttachment(String string, PdfFileSpecification pdfFileSpecification) throws IOException {
        this.stamper.addFileAttachment(string, pdfFileSpecification);
    }

    public void makePackage(PdfName pdfName) {
        PdfCollection pdfCollection = new PdfCollection(0);
        pdfCollection.put(PdfName.VIEW, pdfName);
        this.stamper.makePackage(pdfCollection);
    }

    public void makePackage(PdfCollection pdfCollection) {
        this.stamper.makePackage(pdfCollection);
    }

    public void setViewerPreferences(int n2) {
        this.stamper.setViewerPreferences(n2);
    }

    public void addViewerPreference(PdfName pdfName, PdfObject pdfObject) {
        this.stamper.addViewerPreference(pdfName, pdfObject);
    }

    public void setXmpMetadata(byte[] byArray) {
        this.stamper.setXmpMetadata(byArray);
    }

    public boolean isFullCompression() {
        return this.stamper.isFullCompression();
    }

    public void setFullCompression() {
        if (this.stamper.isAppend()) {
            return;
        }
        this.stamper.setFullCompression();
    }

    public void setPageAction(PdfName pdfName, PdfAction pdfAction, int n2) throws PdfException {
        this.stamper.setPageAction(pdfName, pdfAction, n2);
    }

    public void setDuration(int n2, int n3) {
        this.stamper.setDuration(n2, n3);
    }

    public void setTransition(PdfTransition pdfTransition, int n2) {
        this.stamper.setTransition(pdfTransition, n2);
    }

    public static PdfStamper createSignature(PdfReader pdfReader, OutputStream outputStream, char c2, File file, boolean bl) throws DocumentException, IOException {
        PdfStamper pdfStamper;
        Object object;
        if (file == null) {
            object = new ByteBuffer();
            pdfStamper = new PdfStamper(pdfReader, (OutputStream)object, c2, bl);
            pdfStamper.sigApp = new PdfSignatureAppearance(pdfStamper.stamper);
            pdfStamper.sigApp.setSigout((ByteBuffer)object);
        } else {
            if (file.isDirectory()) {
                file = File.createTempFile("pdf", null, file);
            }
            object = new FileOutputStream(file);
            pdfStamper = new PdfStamper(pdfReader, (OutputStream)object, c2, bl);
            pdfStamper.sigApp = new PdfSignatureAppearance(pdfStamper.stamper);
            pdfStamper.sigApp.setTempFile(file);
        }
        pdfStamper.sigApp.setOriginalout(outputStream);
        pdfStamper.sigApp.setStamper(pdfStamper);
        pdfStamper.hasSignature = true;
        object = pdfReader.getCatalog();
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(((PdfDictionary)object).get(PdfName.ACROFORM), (PdfObject)object);
        if (pdfDictionary != null) {
            pdfDictionary.remove(PdfName.NEEDAPPEARANCES);
            pdfStamper.stamper.markUsed(pdfDictionary);
        }
        return pdfStamper;
    }

    public static PdfStamper createSignature(PdfReader pdfReader, OutputStream outputStream, char c2) throws DocumentException, IOException {
        return PdfStamper.createSignature(pdfReader, outputStream, c2, null, false);
    }

    public static PdfStamper createSignature(PdfReader pdfReader, OutputStream outputStream, char c2, File file) throws DocumentException, IOException {
        return PdfStamper.createSignature(pdfReader, outputStream, c2, file, false);
    }

    public Map getPdfLayers() {
        return this.stamper.getPdfLayers();
    }
}

