/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPCellEvent;
import com.lowagie.text.pdf.PdfPTable;
import java.awt.Color;

public class PdfPRow {
    public static final float BOTTOM_LIMIT = -1.0737418E9f;
    public static final float RIGHT_LIMIT = 20000.0f;
    protected PdfPCell[] cells;
    protected float[] widths;
    protected float[] extraHeights;
    protected float maxHeight = 0.0f;
    protected boolean calculated = false;
    private int[] canvasesPos;

    public PdfPRow(PdfPCell[] pdfPCellArray) {
        this.cells = pdfPCellArray;
        this.widths = new float[pdfPCellArray.length];
        this.initExtraHeights();
    }

    public PdfPRow(PdfPRow pdfPRow) {
        this.maxHeight = pdfPRow.maxHeight;
        this.calculated = pdfPRow.calculated;
        this.cells = new PdfPCell[pdfPRow.cells.length];
        for (int i2 = 0; i2 < this.cells.length; ++i2) {
            if (pdfPRow.cells[i2] == null) continue;
            this.cells[i2] = new PdfPCell(pdfPRow.cells[i2]);
        }
        this.widths = new float[this.cells.length];
        System.arraycopy(pdfPRow.widths, 0, this.widths, 0, this.cells.length);
        this.initExtraHeights();
    }

    public boolean setWidths(float[] fArray) {
        if (fArray.length != this.cells.length) {
            return false;
        }
        System.arraycopy(fArray, 0, this.widths, 0, this.cells.length);
        float f2 = 0.0f;
        this.calculated = false;
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            PdfPCell pdfPCell = this.cells[i2];
            if (pdfPCell == null) {
                f2 += fArray[i2];
                continue;
            }
            pdfPCell.setLeft(f2);
            int n2 = i2 + pdfPCell.getColspan();
            while (i2 < n2) {
                f2 += fArray[i2];
                ++i2;
            }
            --i2;
            pdfPCell.setRight(f2);
            pdfPCell.setTop(0.0f);
        }
        return true;
    }

    public void initExtraHeights() {
        this.extraHeights = new float[this.cells.length];
        for (int i2 = 0; i2 < this.extraHeights.length; ++i2) {
            this.extraHeights[i2] = 0.0f;
        }
    }

    public void setExtraHeight(int n2, float f2) {
        if (n2 < 0 || n2 >= this.cells.length) {
            return;
        }
        this.extraHeights[n2] = f2;
    }

    public float calculateHeights() {
        this.maxHeight = 0.0f;
        for (int i2 = 0; i2 < this.cells.length; ++i2) {
            PdfPCell pdfPCell = this.cells[i2];
            float f2 = 0.0f;
            if (pdfPCell == null || !((f2 = pdfPCell.getMaxHeight()) > this.maxHeight) || pdfPCell.getRowspan() != 1) continue;
            this.maxHeight = f2;
        }
        this.calculated = true;
        return this.maxHeight;
    }

    public void writeBorderAndBackground(float f2, float f3, float f4, PdfPCell pdfPCell, PdfContentByte[] pdfContentByteArray) {
        Color color = pdfPCell.getBackgroundColor();
        if (color != null || pdfPCell.hasBorders()) {
            Object object;
            float f5 = pdfPCell.getRight() + f2;
            float f6 = pdfPCell.getTop() + f3;
            float f7 = pdfPCell.getLeft() + f2;
            float f8 = f6 - f4;
            if (color != null) {
                object = pdfContentByteArray[1];
                ((PdfContentByte)object).setColorFill(color);
                ((PdfContentByte)object).rectangle(f7, f8, f5 - f7, f6 - f8);
                ((PdfContentByte)object).fill();
            }
            if (pdfPCell.hasBorders()) {
                object = new Rectangle(f7, f8, f5, f6);
                ((Rectangle)object).cloneNonPositionParameters(pdfPCell);
                ((Rectangle)object).setBackgroundColor(null);
                PdfContentByte pdfContentByte = pdfContentByteArray[2];
                pdfContentByte.rectangle((Rectangle)object);
            }
        }
    }

    protected void saveAndRotateCanvases(PdfContentByte[] pdfContentByteArray, float f2, float f3, float f4, float f5, float f6, float f7) {
        int n2 = 4;
        if (this.canvasesPos == null) {
            this.canvasesPos = new int[n2 * 2];
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            ByteBuffer byteBuffer = pdfContentByteArray[i2].getInternalBuffer();
            this.canvasesPos[i2 * 2] = byteBuffer.size();
            pdfContentByteArray[i2].saveState();
            pdfContentByteArray[i2].concatCTM(f2, f3, f4, f5, f6, f7);
            this.canvasesPos[i2 * 2 + 1] = byteBuffer.size();
        }
    }

    protected void restoreCanvases(PdfContentByte[] pdfContentByteArray) {
        int n2 = 4;
        for (int i2 = 0; i2 < n2; ++i2) {
            ByteBuffer byteBuffer = pdfContentByteArray[i2].getInternalBuffer();
            int n3 = byteBuffer.size();
            pdfContentByteArray[i2].restoreState();
            if (n3 != this.canvasesPos[i2 * 2 + 1]) continue;
            byteBuffer.setSize(this.canvasesPos[i2 * 2]);
        }
    }

    public static float setColumn(ColumnText columnText, float f2, float f3, float f4, float f5) {
        if (f2 > f4) {
            f4 = f2;
        }
        if (f3 > f5) {
            f5 = f3;
        }
        columnText.setSimpleColumn(f2, f3, f4, f5);
        return f5;
    }

    public void writeCells(int n2, int n3, float f2, float f3, PdfContentByte[] pdfContentByteArray) {
        int n4;
        if (!this.calculated) {
            this.calculateHeights();
        }
        n3 = n3 < 0 ? this.cells.length : Math.min(n3, this.cells.length);
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 >= n3) {
            return;
        }
        for (n4 = n2; n4 >= 0 && this.cells[n4] == null; --n4) {
            if (n4 <= 0) continue;
            f2 -= this.widths[n4 - 1];
        }
        if (n4 < 0) {
            n4 = 0;
        }
        if (this.cells[n4] != null) {
            f2 -= this.cells[n4].getLeft();
        }
        for (int i2 = n4; i2 < n3; ++i2) {
            float f4;
            float f5;
            float f6;
            PdfPCell pdfPCell = this.cells[i2];
            if (pdfPCell == null) continue;
            float f7 = this.maxHeight + this.extraHeights[i2];
            this.writeBorderAndBackground(f2, f3, f7, pdfPCell, pdfContentByteArray);
            Image image = pdfPCell.getImage();
            float f8 = pdfPCell.getTop() + f3 - pdfPCell.getEffectivePaddingTop();
            if (pdfPCell.getHeight() <= f7) {
                switch (pdfPCell.getVerticalAlignment()) {
                    case 6: {
                        f8 = pdfPCell.getTop() + f3 - f7 + pdfPCell.getHeight() - pdfPCell.getEffectivePaddingTop();
                        break;
                    }
                    case 5: {
                        f8 = pdfPCell.getTop() + f3 + (pdfPCell.getHeight() - f7) / 2.0f - pdfPCell.getEffectivePaddingTop();
                        break;
                    }
                }
            }
            if (image != null) {
                if (pdfPCell.getRotation() != 0) {
                    image = Image.getInstance(image);
                    image.setRotation(image.getImageRotation() + (float)((double)pdfPCell.getRotation() * Math.PI / 180.0));
                }
                boolean bl = false;
                if (pdfPCell.getHeight() > f7) {
                    image.scalePercent(100.0f);
                    f6 = (f7 - pdfPCell.getEffectivePaddingTop() - pdfPCell.getEffectivePaddingBottom()) / image.getScaledHeight();
                    image.scalePercent(f6 * 100.0f);
                    bl = true;
                }
                f6 = pdfPCell.getLeft() + f2 + pdfPCell.getEffectivePaddingLeft();
                if (bl) {
                    switch (pdfPCell.getHorizontalAlignment()) {
                        case 1: {
                            f6 = f2 + (pdfPCell.getLeft() + pdfPCell.getEffectivePaddingLeft() + pdfPCell.getRight() - pdfPCell.getEffectivePaddingRight() - image.getScaledWidth()) / 2.0f;
                            break;
                        }
                        case 2: {
                            f6 = f2 + pdfPCell.getRight() - pdfPCell.getEffectivePaddingRight() - image.getScaledWidth();
                            break;
                        }
                    }
                    f8 = pdfPCell.getTop() + f3 - pdfPCell.getEffectivePaddingTop();
                }
                image.setAbsolutePosition(f6, f8 - image.getScaledHeight());
                try {
                    pdfContentByteArray[3].addImage(image);
                }
                catch (DocumentException documentException) {
                    throw new ExceptionConverter(documentException);
                }
            }
            if (pdfPCell.getRotation() == 90 || pdfPCell.getRotation() == 270) {
                float f9 = f7 - pdfPCell.getEffectivePaddingTop() - pdfPCell.getEffectivePaddingBottom();
                f6 = pdfPCell.getWidth() - pdfPCell.getEffectivePaddingLeft() - pdfPCell.getEffectivePaddingRight();
                ColumnText columnText = ColumnText.duplicate(pdfPCell.getColumn());
                columnText.setCanvases(pdfContentByteArray);
                columnText.setSimpleColumn(0.0f, 0.0f, f9 + 0.001f, -f6);
                try {
                    columnText.go(true);
                }
                catch (DocumentException documentException) {
                    throw new ExceptionConverter(documentException);
                }
                float f10 = -columnText.getYLine();
                if (f9 <= 0.0f || f6 <= 0.0f) {
                    f10 = 0.0f;
                }
                if (f10 > 0.0f) {
                    if (pdfPCell.isUseDescender()) {
                        f10 -= columnText.getDescender();
                    }
                    columnText = ColumnText.duplicate(pdfPCell.getColumn());
                    columnText.setCanvases(pdfContentByteArray);
                    columnText.setSimpleColumn(-0.003f, -0.001f, f9 + 0.003f, f10);
                    if (pdfPCell.getRotation() == 90) {
                        f5 = pdfPCell.getTop() + f3 - f7 + pdfPCell.getEffectivePaddingBottom();
                        switch (pdfPCell.getVerticalAlignment()) {
                            case 6: {
                                f4 = pdfPCell.getLeft() + f2 + pdfPCell.getWidth() - pdfPCell.getEffectivePaddingRight();
                                break;
                            }
                            case 5: {
                                f4 = pdfPCell.getLeft() + f2 + (pdfPCell.getWidth() + pdfPCell.getEffectivePaddingLeft() - pdfPCell.getEffectivePaddingRight() + f10) / 2.0f;
                                break;
                            }
                            default: {
                                f4 = pdfPCell.getLeft() + f2 + pdfPCell.getEffectivePaddingLeft() + f10;
                            }
                        }
                        this.saveAndRotateCanvases(pdfContentByteArray, 0.0f, 1.0f, -1.0f, 0.0f, f4, f5);
                    } else {
                        f5 = pdfPCell.getTop() + f3 - pdfPCell.getEffectivePaddingTop();
                        switch (pdfPCell.getVerticalAlignment()) {
                            case 6: {
                                f4 = pdfPCell.getLeft() + f2 + pdfPCell.getEffectivePaddingLeft();
                                break;
                            }
                            case 5: {
                                f4 = pdfPCell.getLeft() + f2 + (pdfPCell.getWidth() + pdfPCell.getEffectivePaddingLeft() - pdfPCell.getEffectivePaddingRight() - f10) / 2.0f;
                                break;
                            }
                            default: {
                                f4 = pdfPCell.getLeft() + f2 + pdfPCell.getWidth() - pdfPCell.getEffectivePaddingRight() - f10;
                            }
                        }
                        this.saveAndRotateCanvases(pdfContentByteArray, 0.0f, -1.0f, 1.0f, 0.0f, f4, f5);
                    }
                    try {
                        columnText.go();
                    }
                    catch (DocumentException documentException) {
                        throw new ExceptionConverter(documentException);
                    }
                    finally {
                        this.restoreCanvases(pdfContentByteArray);
                    }
                }
            } else {
                float f11 = pdfPCell.getFixedHeight();
                f6 = pdfPCell.getRight() + f2 - pdfPCell.getEffectivePaddingRight();
                float f12 = pdfPCell.getLeft() + f2 + pdfPCell.getEffectivePaddingLeft();
                if (pdfPCell.isNoWrap()) {
                    switch (pdfPCell.getHorizontalAlignment()) {
                        case 1: {
                            f6 += 10000.0f;
                            f12 -= 10000.0f;
                            break;
                        }
                        case 2: {
                            if (pdfPCell.getRotation() == 180) {
                                f6 += 20000.0f;
                                break;
                            }
                            f12 -= 20000.0f;
                            break;
                        }
                        default: {
                            if (pdfPCell.getRotation() == 180) {
                                f12 -= 20000.0f;
                                break;
                            }
                            f6 += 20000.0f;
                        }
                    }
                }
                ColumnText columnText = ColumnText.duplicate(pdfPCell.getColumn());
                columnText.setCanvases(pdfContentByteArray);
                f4 = f8 - (f7 - pdfPCell.getEffectivePaddingTop() - pdfPCell.getEffectivePaddingBottom());
                if (f11 > 0.0f && pdfPCell.getHeight() > f7) {
                    f8 = pdfPCell.getTop() + f3 - pdfPCell.getEffectivePaddingTop();
                    f4 = pdfPCell.getTop() + f3 - f7 + pdfPCell.getEffectivePaddingBottom();
                }
                if ((f8 > f4 || columnText.zeroHeightElement()) && f12 < f6) {
                    columnText.setSimpleColumn(f12, f4 - 0.001f, f6, f8);
                    if (pdfPCell.getRotation() == 180) {
                        f5 = f12 + f6;
                        float f13 = f3 + f3 - f7 + pdfPCell.getEffectivePaddingBottom() - pdfPCell.getEffectivePaddingTop();
                        this.saveAndRotateCanvases(pdfContentByteArray, -1.0f, 0.0f, 0.0f, -1.0f, f5, f13);
                    }
                    try {
                        columnText.go();
                    }
                    catch (DocumentException documentException) {
                        throw new ExceptionConverter(documentException);
                    }
                    finally {
                        if (pdfPCell.getRotation() == 180) {
                            this.restoreCanvases(pdfContentByteArray);
                        }
                    }
                }
            }
            PdfPCellEvent pdfPCellEvent = pdfPCell.getCellEvent();
            if (pdfPCellEvent == null) continue;
            Rectangle rectangle = new Rectangle(pdfPCell.getLeft() + f2, pdfPCell.getTop() + f3 - f7, pdfPCell.getRight() + f2, pdfPCell.getTop() + f3);
            pdfPCellEvent.cellLayout(pdfPCell, rectangle, pdfContentByteArray);
        }
    }

    public boolean isCalculated() {
        return this.calculated;
    }

    public float getMaxHeights() {
        if (this.calculated) {
            return this.maxHeight;
        }
        return this.calculateHeights();
    }

    public void setMaxHeights(float f2) {
        this.maxHeight = f2;
    }

    float[] getEventWidth(float f2) {
        int n2 = 0;
        for (int i2 = 0; i2 < this.cells.length; ++i2) {
            if (this.cells[i2] == null) continue;
            ++n2;
        }
        float[] fArray = new float[n2 + 1];
        n2 = 0;
        fArray[n2++] = f2;
        for (int i3 = 0; i3 < this.cells.length; ++i3) {
            if (this.cells[i3] == null) continue;
            fArray[n2] = fArray[n2 - 1] + this.cells[i3].getWidth();
            ++n2;
        }
        return fArray;
    }

    public PdfPRow splitRow(PdfPTable pdfPTable, int n2, float f2) {
        int n3;
        PdfPCell[] pdfPCellArray = new PdfPCell[this.cells.length];
        float[] fArray = new float[this.cells.length];
        float[] fArray2 = new float[this.cells.length];
        boolean bl = true;
        for (n3 = 0; n3 < this.cells.length; ++n3) {
            Object object;
            float f3 = f2;
            PdfPCell pdfPCell = this.cells[n3];
            if (pdfPCell == null) {
                int n4 = n2;
                if (!pdfPTable.rowSpanAbove(n4, n3)) continue;
                f3 += pdfPTable.getRowHeight(n4);
                while (pdfPTable.rowSpanAbove(--n4, n3)) {
                    f3 += pdfPTable.getRowHeight(n4);
                }
                object = pdfPTable.getRow(n4);
                if (object == null || ((PdfPRow)object).getCells()[n3] == null) continue;
                pdfPCellArray[n3] = new PdfPCell(((PdfPRow)object).getCells()[n3]);
                pdfPCellArray[n3].consumeHeight(f3);
                pdfPCellArray[n3].setRowspan(((PdfPRow)object).getCells()[n3].getRowspan() - n2 + n4);
                bl = false;
                continue;
            }
            fArray[n3] = pdfPCell.getFixedHeight();
            fArray2[n3] = pdfPCell.getMinimumHeight();
            Image image = pdfPCell.getImage();
            object = new PdfPCell(pdfPCell);
            if (image != null) {
                if (f3 > pdfPCell.getEffectivePaddingBottom() + pdfPCell.getEffectivePaddingTop() + 2.0f) {
                    ((PdfPCell)object).setPhrase(null);
                    bl = false;
                }
            } else {
                boolean bl2;
                int n5;
                float f4;
                ColumnText columnText = ColumnText.duplicate(pdfPCell.getColumn());
                float f5 = pdfPCell.getLeft() + pdfPCell.getEffectivePaddingLeft();
                float f6 = pdfPCell.getTop() + pdfPCell.getEffectivePaddingBottom() - f3;
                float f7 = pdfPCell.getRight() - pdfPCell.getEffectivePaddingRight();
                float f8 = pdfPCell.getTop() - pdfPCell.getEffectivePaddingTop();
                switch (pdfPCell.getRotation()) {
                    case 90: 
                    case 270: {
                        f4 = PdfPRow.setColumn(columnText, f6, f5, f8, f7);
                        break;
                    }
                    default: {
                        f4 = PdfPRow.setColumn(columnText, f5, f6, pdfPCell.isNoWrap() ? 20000.0f : f7, f8);
                    }
                }
                try {
                    n5 = columnText.go(true);
                }
                catch (DocumentException documentException) {
                    throw new ExceptionConverter(documentException);
                }
                boolean bl3 = bl2 = columnText.getYLine() == f4;
                if (bl2) {
                    ((PdfPCell)object).setColumn(ColumnText.duplicate(pdfPCell.getColumn()));
                    columnText.setFilledWidth(0.0f);
                } else if ((n5 & 1) == 0) {
                    ((PdfPCell)object).setColumn(columnText);
                    columnText.setFilledWidth(0.0f);
                } else {
                    ((PdfPCell)object).setPhrase(null);
                }
                bl = bl && bl2;
            }
            pdfPCellArray[n3] = object;
            pdfPCell.setFixedHeight(f3);
        }
        if (bl) {
            for (n3 = 0; n3 < this.cells.length; ++n3) {
                PdfPCell pdfPCell = this.cells[n3];
                if (pdfPCell == null) continue;
                if (fArray[n3] > 0.0f) {
                    pdfPCell.setFixedHeight(fArray[n3]);
                    continue;
                }
                pdfPCell.setMinimumHeight(fArray2[n3]);
            }
            return null;
        }
        this.calculateHeights();
        PdfPRow pdfPRow = new PdfPRow(pdfPCellArray);
        pdfPRow.widths = (float[])this.widths.clone();
        pdfPRow.calculateHeights();
        return pdfPRow;
    }

    public PdfPCell[] getCells() {
        return this.cells;
    }
}

