/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.html.simpleparser;

import com.lowagie.text.Chunk;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.FontFactoryImp;
import com.lowagie.text.ListItem;
import com.lowagie.text.Paragraph;
import com.lowagie.text.html.Markup;
import com.lowagie.text.html.simpleparser.ChainedProperties;
import com.lowagie.text.pdf.HyphenationAuto;
import com.lowagie.text.pdf.HyphenationEvent;
import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;

public class FactoryProperties {
    private FontFactoryImp fontImp = FontFactory.getFontImp();
    public static HashMap followTags = new HashMap();

    public Chunk createChunk(String string, ChainedProperties chainedProperties) {
        Font font = this.getFont(chainedProperties);
        float f2 = font.getSize();
        f2 /= 2.0f;
        Chunk chunk = new Chunk(string, font);
        if (chainedProperties.hasProperty("sub")) {
            chunk.setTextRise(-f2);
        } else if (chainedProperties.hasProperty("sup")) {
            chunk.setTextRise(f2);
        }
        chunk.setHyphenation(FactoryProperties.getHyphenation(chainedProperties));
        return chunk;
    }

    private static void setParagraphLeading(Paragraph paragraph, String string) {
        if (string == null) {
            paragraph.setLeading(0.0f, 1.5f);
            return;
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
            String string2 = stringTokenizer.nextToken();
            float f2 = Float.parseFloat(string2);
            if (!stringTokenizer.hasMoreTokens()) {
                paragraph.setLeading(f2, 0.0f);
                return;
            }
            string2 = stringTokenizer.nextToken();
            float f3 = Float.parseFloat(string2);
            paragraph.setLeading(f2, f3);
        }
        catch (Exception exception) {
            paragraph.setLeading(0.0f, 1.5f);
        }
    }

    public static void createParagraph(Paragraph paragraph, ChainedProperties chainedProperties) {
        String string = chainedProperties.getProperty("align");
        if (string != null) {
            if (string.equalsIgnoreCase("center")) {
                paragraph.setAlignment(1);
            } else if (string.equalsIgnoreCase("right")) {
                paragraph.setAlignment(2);
            } else if (string.equalsIgnoreCase("justify")) {
                paragraph.setAlignment(3);
            }
        }
        paragraph.setHyphenation(FactoryProperties.getHyphenation(chainedProperties));
        FactoryProperties.setParagraphLeading(paragraph, chainedProperties.getProperty("leading"));
        string = chainedProperties.getProperty("before");
        if (string != null) {
            try {
                paragraph.setSpacingBefore(Float.parseFloat(string));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string = chainedProperties.getProperty("after")) != null) {
            try {
                paragraph.setSpacingAfter(Float.parseFloat(string));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string = chainedProperties.getProperty("extraparaspace")) != null) {
            try {
                paragraph.setExtraParagraphSpace(Float.parseFloat(string));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static Paragraph createParagraph(ChainedProperties chainedProperties) {
        Paragraph paragraph = new Paragraph();
        FactoryProperties.createParagraph(paragraph, chainedProperties);
        return paragraph;
    }

    public static ListItem createListItem(ChainedProperties chainedProperties) {
        ListItem listItem = new ListItem();
        FactoryProperties.createParagraph(listItem, chainedProperties);
        return listItem;
    }

    public Font getFont(ChainedProperties chainedProperties) {
        String string = chainedProperties.getProperty("face");
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken().trim();
                if (string.startsWith("\"")) {
                    string = string.substring(1);
                }
                if (string.endsWith("\"")) {
                    string = string.substring(0, string.length() - 1);
                }
                if (!this.fontImp.isRegistered(string)) continue;
            }
        }
        int n2 = 0;
        if (chainedProperties.hasProperty("i")) {
            n2 |= 2;
        }
        if (chainedProperties.hasProperty("b")) {
            n2 |= 1;
        }
        if (chainedProperties.hasProperty("u")) {
            n2 |= 4;
        }
        if (chainedProperties.hasProperty("s")) {
            n2 |= 8;
        }
        String string2 = chainedProperties.getProperty("size");
        float f2 = 12.0f;
        if (string2 != null) {
            f2 = Float.parseFloat(string2);
        }
        Color color = Markup.decodeColor(chainedProperties.getProperty("color"));
        String string3 = chainedProperties.getProperty("encoding");
        if (string3 == null) {
            string3 = "Cp1252";
        }
        return this.fontImp.getFont(string, string3, true, f2, n2, color);
    }

    public static HyphenationEvent getHyphenation(ChainedProperties chainedProperties) {
        return FactoryProperties.getHyphenation(chainedProperties.getProperty("hyphenation"));
    }

    public static HyphenationEvent getHyphenation(HashMap hashMap) {
        return FactoryProperties.getHyphenation((String)hashMap.get("hyphenation"));
    }

    public static HyphenationEvent getHyphenation(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        String string2 = string;
        String string3 = null;
        int n2 = 2;
        int n3 = 2;
        int n4 = string.indexOf(95);
        if (n4 == -1) {
            return new HyphenationAuto(string2, string3, n2, n3);
        }
        string2 = string.substring(0, n4);
        string3 = string.substring(n4 + 1);
        if ((n4 = string3.indexOf(44)) == -1) {
            return new HyphenationAuto(string2, string3, n2, n3);
        }
        string = string3.substring(n4 + 1);
        string3 = string3.substring(0, n4);
        n4 = string.indexOf(44);
        if (n4 == -1) {
            n2 = Integer.parseInt(string);
        } else {
            n2 = Integer.parseInt(string.substring(0, n4));
            n3 = Integer.parseInt(string.substring(n4 + 1));
        }
        return new HyphenationAuto(string2, string3, n2, n3);
    }

    public static void insertStyle(HashMap hashMap) {
        String string = (String)hashMap.get("style");
        if (string == null) {
            return;
        }
        Properties properties = Markup.parseAttributes(string);
        Iterator<Object> iterator = properties.keySet().iterator();
        while (iterator.hasNext()) {
            Object object;
            String string2 = (String)iterator.next();
            if (string2.equals("font-family")) {
                hashMap.put("face", properties.getProperty(string2));
                continue;
            }
            if (string2.equals("font-size")) {
                hashMap.put("size", Float.toString(Markup.parseLength(properties.getProperty(string2))) + "pt");
                continue;
            }
            if (string2.equals("font-style")) {
                object = properties.getProperty(string2).trim().toLowerCase();
                if (!((String)object).equals("italic") && !((String)object).equals("oblique")) continue;
                hashMap.put("i", null);
                continue;
            }
            if (string2.equals("font-weight")) {
                object = properties.getProperty(string2).trim().toLowerCase();
                if (!((String)object).equals("bold") && !((String)object).equals("700") && !((String)object).equals("800") && !((String)object).equals("900")) continue;
                hashMap.put("b", null);
                continue;
            }
            if (string2.equals("text-decoration")) {
                object = properties.getProperty(string2).trim().toLowerCase();
                if (!((String)object).equals("underline")) continue;
                hashMap.put("u", null);
                continue;
            }
            if (string2.equals("color")) {
                object = Markup.decodeColor(properties.getProperty(string2));
                if (object == null) continue;
                int n2 = ((Color)object).getRGB();
                String string3 = Integer.toHexString(n2);
                string3 = "000000" + string3;
                string3 = "#" + string3.substring(string3.length() - 6);
                hashMap.put("color", string3);
                continue;
            }
            if (string2.equals("line-height")) {
                object = properties.getProperty(string2).trim();
                float f2 = Markup.parseLength(properties.getProperty(string2));
                if (((String)object).endsWith("%")) {
                    hashMap.put("leading", "0," + f2 / 100.0f);
                    continue;
                }
                if ("normal".equalsIgnoreCase((String)object)) {
                    hashMap.put("leading", "0,1.5");
                    continue;
                }
                hashMap.put("leading", f2 + ",0");
                continue;
            }
            if (!string2.equals("text-align")) continue;
            object = properties.getProperty(string2).trim().toLowerCase();
            hashMap.put("align", object);
        }
    }

    public static void insertStyle(HashMap hashMap, ChainedProperties chainedProperties) {
        String string = (String)hashMap.get("style");
        if (string == null) {
            return;
        }
        Properties properties = Markup.parseAttributes(string);
        Iterator<Object> iterator = properties.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (string2.equals("font-family")) {
                hashMap.put("face", properties.getProperty(string2));
                continue;
            }
            if (string2.equals("font-size")) {
                float f2 = Markup.parseLength(chainedProperties.getProperty("size"), 12.0f);
                if (f2 <= 0.0f) {
                    f2 = 12.0f;
                }
                hashMap.put("size", Float.toString(Markup.parseLength(properties.getProperty(string2), f2)) + "pt");
                continue;
            }
            if (string2.equals("font-style")) {
                String string3 = properties.getProperty(string2).trim().toLowerCase();
                if (!string3.equals("italic") && !string3.equals("oblique")) continue;
                hashMap.put("i", null);
                continue;
            }
            if (string2.equals("font-weight")) {
                String string4 = properties.getProperty(string2).trim().toLowerCase();
                if (!string4.equals("bold") && !string4.equals("700") && !string4.equals("800") && !string4.equals("900")) continue;
                hashMap.put("b", null);
                continue;
            }
            if (string2.equals("text-decoration")) {
                String string5 = properties.getProperty(string2).trim().toLowerCase();
                if (!string5.equals("underline")) continue;
                hashMap.put("u", null);
                continue;
            }
            if (string2.equals("color")) {
                Color color = Markup.decodeColor(properties.getProperty(string2));
                if (color == null) continue;
                int n2 = color.getRGB();
                String string6 = Integer.toHexString(n2);
                string6 = "000000" + string6;
                string6 = "#" + string6.substring(string6.length() - 6);
                hashMap.put("color", string6);
                continue;
            }
            if (string2.equals("line-height")) {
                String string7 = properties.getProperty(string2).trim();
                float f3 = Markup.parseLength(chainedProperties.getProperty("size"), 12.0f);
                if (f3 <= 0.0f) {
                    f3 = 12.0f;
                }
                float f4 = Markup.parseLength(properties.getProperty(string2), f3);
                if (string7.endsWith("%")) {
                    hashMap.put("leading", "0," + f4 / 100.0f);
                    return;
                }
                if ("normal".equalsIgnoreCase(string7)) {
                    hashMap.put("leading", "0,1.5");
                    return;
                }
                hashMap.put("leading", f4 + ",0");
                continue;
            }
            if (string2.equals("text-align")) {
                String string8 = properties.getProperty(string2).trim().toLowerCase();
                hashMap.put("align", string8);
                continue;
            }
            if (!string2.equals("padding-left")) continue;
            String string9 = properties.getProperty(string2).trim().toLowerCase();
            hashMap.put("indent", Float.toString(Markup.parseLength(string9)));
        }
    }

    public FontFactoryImp getFontImp() {
        return this.fontImp;
    }

    public void setFontImp(FontFactoryImp fontFactoryImp) {
        this.fontImp = fontFactoryImp;
    }

    static {
        followTags.put("i", "i");
        followTags.put("b", "b");
        followTags.put("u", "u");
        followTags.put("sub", "sub");
        followTags.put("sup", "sup");
        followTags.put("em", "i");
        followTags.put("strong", "b");
        followTags.put("s", "s");
        followTags.put("strike", "s");
    }
}

