/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.hsqldb.lib.java.JavaSystem;

public class ScriptTool {
    private static Properties pProperties = new Properties();
    private Connection cConn;
    private Statement sStatement;
    private boolean BATCH = true;
    private String EKW = new String("go");
    private boolean EOF = false;
    private int ln = 0;

    public static void main(String[] stringArray) {
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string = stringArray[i2];
            if (!string.equals("-?")) continue;
            ScriptTool.printHelp();
            System.exit(0);
        }
        ScriptTool scriptTool = new ScriptTool();
        scriptTool.execute(stringArray);
        System.exit(0);
    }

    public void execute(String[] stringArray) {
        Object object;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            object = stringArray[i2];
            if (((String)object).charAt(0) != '-') continue;
            pProperties.put(((String)object).substring(1), stringArray[i2 + 1]);
            ++i2;
        }
        this.ln = 0;
        this.EOF = false;
        BufferedReader bufferedReader = null;
        object = pProperties;
        String string = ((Properties)object).getProperty("driver", "org.hsqldb.jdbcDriver");
        String string2 = ((Properties)object).getProperty("url", "jdbc:hsqldb:");
        String string3 = ((Properties)object).getProperty("database", "test");
        String string4 = ((Properties)object).getProperty("user", "sa");
        String string5 = ((Properties)object).getProperty("password", "");
        String string6 = ((Properties)object).getProperty("script", "st.sql");
        boolean bl = ((Properties)object).getProperty("log", "false").equalsIgnoreCase("true");
        this.BATCH = ((Properties)object).getProperty("batch", "true").equalsIgnoreCase("true");
        try {
            if (bl) {
                this.trace("driver   = " + string);
                this.trace("url      = " + string2);
                this.trace("database = " + string3);
                this.trace("user     = " + string4);
                this.trace("password = " + string5);
                this.trace("script   = " + string6);
                this.trace("log      = " + bl);
                this.trace("batch    = " + this.BATCH);
                JavaSystem.setLogToSystem(true);
            }
            Class.forName(string).newInstance();
            this.cConn = DriverManager.getConnection(string2 + string3, string4, string5);
            bufferedReader = new BufferedReader(new FileReader(string6));
        }
        catch (Exception exception) {
            System.out.println("ScriptTool.init error: " + exception.getMessage());
            exception.printStackTrace();
        }
        try {
            String string7;
            this.sStatement = this.cConn.createStatement();
            while ((string7 = this.fileToString(bufferedReader)) != null) {
                if (string7.length() == 1) continue;
                if (bl) {
                    this.trace("SQL (" + this.ln + ") : " + string7.substring(0, string7.length() - 2));
                }
                this.sStatement.execute(string7);
                ResultSet resultSet = this.sStatement.getResultSet();
                int n2 = this.sStatement.getUpdateCount();
                if (n2 == -1) {
                    this.trace(this.toString(resultSet));
                    continue;
                }
                this.trace("update count " + n2);
            }
        }
        catch (SQLException sQLException) {
            System.out.println("SQL Error at line " + this.ln + ": " + sQLException);
        }
        try {
            this.cConn.close();
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String toString(ResultSet resultSet) {
        try {
            int n2;
            if (resultSet == null) {
                return "No Result";
            }
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n3 = resultSetMetaData.getColumnCount();
            StringBuffer stringBuffer = new StringBuffer();
            for (n2 = 1; n2 <= n3; ++n2) {
                stringBuffer = stringBuffer.append(resultSetMetaData.getColumnLabel(n2) + "\t");
            }
            stringBuffer = stringBuffer.append("\n");
            while (resultSet.next()) {
                for (n2 = 1; n2 <= n3; ++n2) {
                    stringBuffer = stringBuffer.append(resultSet.getString(n2) + "\t");
                    if (!resultSet.wasNull()) continue;
                    stringBuffer = stringBuffer.append("(null)\t");
                }
                stringBuffer = stringBuffer.append("\n");
            }
            return stringBuffer.toString();
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    private String fileToString(BufferedReader bufferedReader) {
        if (this.EOF) {
            return null;
        }
        this.EOF = true;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                ++this.ln;
                if (this.BATCH) {
                    if (string.startsWith("print ")) {
                        this.trace("\n" + string.substring(5));
                        continue;
                    }
                    if (string.equalsIgnoreCase(this.EKW)) {
                        this.EOF = false;
                        break;
                    }
                }
                stringBuffer.append(string);
                stringBuffer.append('\n');
            }
            stringBuffer.append('\n');
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception.getMessage());
        }
    }

    private void trace(String string) {
        System.out.println(string);
    }

    private static void printHelp() {
        System.out.println("Usage: java ScriptTool [-options]\nwhere options include:\n    -driver <classname>     name of the driver class\n    -url <name>             first part of the jdbc url\n    -database <name>        second part of the jdbc url\n    -user <name>            username used for connection\n    -password <name>        password for this user\n    -log <true/false>       write log to system out\n    -batch <true/false>     allow go/print pseudo statements\n    -script <script file>   reads from script file\n");
    }
}

