/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.store;

public class BitMap {
    int defaultCapacity;
    int capacity;
    int[] map;

    public BitMap(int n2) {
        int n3 = n2 / 32;
        if (n2 % 32 != 0) {
            ++n3;
        }
        this.defaultCapacity = this.capacity = n3 * 32;
        this.map = new int[n3];
    }

    public void reset() {
        this.map = new int[this.defaultCapacity / 32];
        this.capacity = this.defaultCapacity;
    }

    public int set(int n2) {
        while (n2 >= this.capacity) {
            this.doubleCapacity();
        }
        int n3 = n2 >> 5;
        int n4 = this.map[n3];
        int n5 = Integer.MIN_VALUE >>> (n2 & 0x1F);
        int n6 = (n4 & n5) == 0 ? 0 : 1;
        this.map[n3] = n4 | n5;
        return n6;
    }

    public int unset(int n2) {
        if (n2 >= this.capacity) {
            return 0;
        }
        int n3 = n2 >> 5;
        int n4 = this.map[n3];
        int n5 = Integer.MIN_VALUE >>> (n2 & 0x1F);
        int n6 = (n4 & n5) == 0 ? 0 : 1;
        this.map[n3] = n4 & (n5 ^= 0xFFFFFFFF);
        return n6;
    }

    public int get(int n2) {
        while (n2 >= this.capacity) {
            this.doubleCapacity();
        }
        int n3 = n2 >> 5;
        int n4 = this.map[n3];
        int n5 = Integer.MIN_VALUE >>> (n2 & 0x1F);
        return (n4 & n5) == 0 ? 0 : 1;
    }

    public static int set(int n2, int n3) {
        int n4 = Integer.MIN_VALUE >>> n3;
        return n2 | n4;
    }

    public static int unset(int n2, int n3) {
        int n4 = Integer.MIN_VALUE >>> n3;
        return n2 & (n4 ^= 0xFFFFFFFF);
    }

    public static boolean isSet(int n2, int n3) {
        int n4 = Integer.MIN_VALUE >>> n3;
        return (n2 & n4) != 0;
    }

    private void doubleCapacity() {
        int[] nArray = new int[this.map.length * 2];
        this.capacity *= 2;
        System.arraycopy(this.map, 0, nArray, 0, this.map.length);
        this.map = nArray;
    }
}

