/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.store;

import java.util.NoSuchElementException;
import org.hsqldb.lib.ArrayCounter;
import org.hsqldb.lib.Iterator;
import org.hsqldb.store.HashIndex;

public class BaseHashMap {
    boolean isIntKey;
    boolean isLongKey;
    boolean isObjectKey;
    boolean isNoValue;
    boolean isIntValue;
    boolean isLongValue;
    boolean isObjectValue;
    protected HashIndex hashIndex;
    protected int[] intKeyTable;
    protected Object[] objectKeyTable;
    protected long[] longKeyTable;
    protected int[] intValueTable;
    protected Object[] objectValueTable;
    protected long[] longValueTable;
    int accessMin;
    int accessCount;
    int[] accessTable;
    final float loadFactor;
    final int initialCapacity;
    int threshold;
    int maxCapacity;
    protected int purgePolicy = 0;
    protected boolean minimizeOnEmpty;
    boolean hasZeroKey;
    int zeroKeyIndex = -1;
    protected static final int noKeyOrValue = 0;
    protected static final int intKeyOrValue = 1;
    protected static final int longKeyOrValue = 2;
    protected static final int objectKeyOrValue = 3;
    protected static final int NO_PURGE = 0;
    protected static final int PURGE_ALL = 1;
    protected static final int PURGE_HALF = 2;
    protected static final int PURGE_QUARTER = 3;

    protected BaseHashMap(int n2, float f2, int n3, int n4, boolean bl) throws IllegalArgumentException {
        int n5;
        this.loadFactor = f2;
        this.initialCapacity = n2;
        if (n2 <= 0 || (double)f2 <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.threshold = n2;
        if (this.threshold < 3) {
            this.threshold = 3;
        }
        if ((n5 = (int)((float)n2 * f2)) < 3) {
            n5 = 3;
        }
        this.hashIndex = new HashIndex(n5, n2, true);
        int n6 = this.threshold;
        if (n3 == 1) {
            this.isIntKey = true;
            this.intKeyTable = new int[n6];
        } else if (n3 == 3) {
            this.isObjectKey = true;
            this.objectKeyTable = new Object[n6];
        } else {
            this.isLongKey = true;
            this.longKeyTable = new long[n6];
        }
        if (n4 == 1) {
            this.isIntValue = true;
            this.intValueTable = new int[n6];
        } else if (n4 == 3) {
            this.isObjectValue = true;
            this.objectValueTable = new Object[n6];
        } else if (n4 == 2) {
            this.isLongValue = true;
            this.longValueTable = new long[n6];
        } else {
            this.isNoValue = true;
        }
        if (bl) {
            this.accessTable = new int[n6];
        }
    }

    protected int getLookup(Object object, int n2) {
        int n3 = this.hashIndex.getLookup(n2);
        while (n3 >= 0) {
            Object object2 = this.objectKeyTable[n3];
            if (object.equals(object2)) {
                return n3;
            }
            n3 = this.hashIndex.getNextLookup(n3);
        }
        return n3;
    }

    protected int getLookup(int n2) {
        int n3 = this.hashIndex.getLookup(n2);
        while (n3 >= 0) {
            int n4 = this.intKeyTable[n3];
            if (n2 == n4) {
                return n3;
            }
            n3 = this.hashIndex.getNextLookup(n3);
        }
        return n3;
    }

    protected int getLookup(long l2) {
        int n2 = this.hashIndex.getLookup((int)l2);
        while (n2 >= 0) {
            long l3 = this.longKeyTable[n2];
            if (l2 == l3) {
                return n2;
            }
            n2 = this.hashIndex.getNextLookup(n2);
        }
        return n2;
    }

    protected Object addOrRemove(long l2, long l3, Object object, Object object2, boolean bl) {
        int n2 = (int)l2;
        if (this.isObjectKey) {
            if (object == null) {
                return null;
            }
            n2 = object.hashCode();
        }
        int n3 = this.hashIndex.getHashIndex(n2);
        int n4 = this.hashIndex.hashTable[n3];
        int n5 = -1;
        Object object3 = null;
        while (n4 >= 0 && !(this.isObjectKey ? this.objectKeyTable[n4].equals(object) : (this.isIntKey ? l2 == (long)this.intKeyTable[n4] : this.isLongKey && l2 == this.longKeyTable[n4]))) {
            n5 = n4;
            n4 = this.hashIndex.getNextLookup(n4);
        }
        if (n4 >= 0) {
            if (bl) {
                if (this.isObjectKey) {
                    this.objectKeyTable[n4] = null;
                } else {
                    if (l2 == 0L) {
                        this.hasZeroKey = false;
                        this.zeroKeyIndex = -1;
                    }
                    if (this.isIntKey) {
                        this.intKeyTable[n4] = 0;
                    } else {
                        this.longKeyTable[n4] = 0L;
                    }
                }
                if (this.isObjectValue) {
                    object3 = this.objectValueTable[n4];
                    this.objectValueTable[n4] = null;
                } else if (this.isIntValue) {
                    this.intValueTable[n4] = 0;
                } else if (this.isLongValue) {
                    this.longValueTable[n4] = 0L;
                }
                this.hashIndex.unlinkNode(n3, n5, n4);
                if (this.accessTable != null) {
                    this.accessTable[n4] = 0;
                }
                if (this.minimizeOnEmpty && this.hashIndex.elementCount == 0) {
                    this.rehash(this.initialCapacity);
                }
                return object3;
            }
            if (this.isObjectValue) {
                object3 = this.objectValueTable[n4];
                this.objectValueTable[n4] = object2;
            } else if (this.isIntValue) {
                this.intValueTable[n4] = (int)l3;
            } else if (this.isLongValue) {
                this.longValueTable[n4] = l3;
            }
            if (this.accessTable != null) {
                ++this.accessCount;
            }
            return object3;
        }
        if (bl) {
            return null;
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            if (this.reset()) {
                return this.addOrRemove(l2, l3, object, object2, bl);
            }
            return null;
        }
        n4 = this.hashIndex.linkNode(n3, n5);
        if (this.isObjectKey) {
            this.objectKeyTable[n4] = object;
        } else if (this.isIntKey) {
            this.intKeyTable[n4] = (int)l2;
            if (l2 == 0L) {
                this.hasZeroKey = true;
                this.zeroKeyIndex = n4;
            }
        } else if (this.isLongKey) {
            this.longKeyTable[n4] = l2;
            if (l2 == 0L) {
                this.hasZeroKey = true;
                this.zeroKeyIndex = n4;
            }
        }
        if (this.isObjectValue) {
            this.objectValueTable[n4] = object2;
        } else if (this.isIntValue) {
            this.intValueTable[n4] = (int)l3;
        } else if (this.isLongValue) {
            this.longValueTable[n4] = l3;
        }
        if (this.accessTable != null) {
            ++this.accessCount;
        }
        return object3;
    }

    protected Object addOrRemove(int n2, Object object, boolean bl) {
        int n3 = n2;
        int n4 = this.hashIndex.getHashIndex(n3);
        int n5 = this.hashIndex.hashTable[n4];
        int n6 = -1;
        Object object2 = null;
        while (n5 >= 0 && n2 != this.intKeyTable[n5]) {
            n6 = n5;
            n5 = this.hashIndex.getNextLookup(n5);
        }
        if (n5 >= 0) {
            if (bl) {
                if (n2 == 0) {
                    this.hasZeroKey = false;
                    this.zeroKeyIndex = -1;
                }
                this.intKeyTable[n5] = 0;
                object2 = this.objectValueTable[n5];
                this.objectValueTable[n5] = null;
                this.hashIndex.unlinkNode(n4, n6, n5);
                if (this.accessTable != null) {
                    this.accessTable[n5] = 0;
                }
                return object2;
            }
            if (this.isObjectValue) {
                object2 = this.objectValueTable[n5];
                this.objectValueTable[n5] = object;
            }
            if (this.accessTable != null) {
                ++this.accessCount;
            }
            return object2;
        }
        if (bl) {
            return object2;
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            if (this.reset()) {
                return this.addOrRemove(n2, object, bl);
            }
            return null;
        }
        n5 = this.hashIndex.linkNode(n4, n6);
        this.intKeyTable[n5] = n2;
        if (n2 == 0) {
            this.hasZeroKey = true;
            this.zeroKeyIndex = n5;
        }
        this.objectValueTable[n5] = object;
        if (this.accessTable != null) {
            ++this.accessCount;
        }
        return object2;
    }

    protected Object removeObject(Object object) {
        if (object == null) {
            return null;
        }
        int n2 = object.hashCode();
        int n3 = this.hashIndex.getHashIndex(n2);
        int n4 = this.hashIndex.hashTable[n3];
        int n5 = -1;
        Object object2 = null;
        while (n4 >= 0) {
            if (this.objectKeyTable[n4].equals(object)) {
                this.objectKeyTable[n4] = null;
                this.hashIndex.unlinkNode(n3, n5, n4);
                if (this.isObjectValue) {
                    object2 = this.objectValueTable[n4];
                    this.objectValueTable[n4] = null;
                }
                return object2;
            }
            n5 = n4;
            n4 = this.hashIndex.getNextLookup(n4);
        }
        return object2;
    }

    protected boolean reset() {
        if (this.maxCapacity == 0 || this.maxCapacity > this.threshold) {
            this.rehash(this.hashIndex.hashTable.length * 2);
            return true;
        }
        if (this.purgePolicy == 1) {
            this.clear();
            return true;
        }
        if (this.purgePolicy == 3) {
            this.clear(this.threshold / 4, this.threshold >> 8);
            return true;
        }
        if (this.purgePolicy == 2) {
            this.clear(this.threshold / 2, this.threshold >> 8);
            return true;
        }
        if (this.purgePolicy == 0) {
            return false;
        }
        return false;
    }

    protected void rehash(int n2) {
        int n3 = this.hashIndex.newNodePointer;
        boolean bl = this.hasZeroKey;
        int n4 = this.zeroKeyIndex;
        if (n2 < this.hashIndex.elementCount) {
            return;
        }
        this.hashIndex.reset((int)((float)n2 * this.loadFactor), n2);
        this.hasZeroKey = false;
        this.zeroKeyIndex = -1;
        this.threshold = n2;
        int n5 = -1;
        while ((n5 = this.nextLookup(n5, n3, bl, n4)) < n3) {
            long l2 = 0L;
            long l3 = 0L;
            Object object = null;
            Object object2 = null;
            if (this.isObjectKey) {
                object = this.objectKeyTable[n5];
            } else {
                l2 = this.isIntKey ? (long)this.intKeyTable[n5] : this.longKeyTable[n5];
            }
            if (this.isObjectValue) {
                object2 = this.objectValueTable[n5];
            } else if (this.isIntValue) {
                l3 = this.intValueTable[n5];
            } else if (this.isLongValue) {
                l3 = this.longValueTable[n5];
            }
            this.addOrRemove(l2, l3, object, object2, false);
            if (this.accessTable == null) continue;
            this.accessTable[this.hashIndex.elementCount - 1] = this.accessTable[n5];
        }
        this.resizeElementArrays(this.hashIndex.newNodePointer, n2);
    }

    private void resizeElementArrays(int n2, int n3) {
        Object[] objectArray;
        int n4;
        int n5 = n4 = n3 > n2 ? n2 : n3;
        if (this.isIntKey) {
            objectArray = this.intKeyTable;
            this.intKeyTable = new int[n3];
            System.arraycopy(objectArray, 0, this.intKeyTable, 0, n4);
        }
        if (this.isIntValue) {
            objectArray = this.intValueTable;
            this.intValueTable = new int[n3];
            System.arraycopy(objectArray, 0, this.intValueTable, 0, n4);
        }
        if (this.isLongKey) {
            objectArray = this.longKeyTable;
            this.longKeyTable = new long[n3];
            System.arraycopy(objectArray, 0, this.longKeyTable, 0, n4);
        }
        if (this.isLongValue) {
            objectArray = this.longValueTable;
            this.longValueTable = new long[n3];
            System.arraycopy(objectArray, 0, this.longValueTable, 0, n4);
        }
        if (this.isObjectKey) {
            objectArray = this.objectKeyTable;
            this.objectKeyTable = new Object[n3];
            System.arraycopy(objectArray, 0, this.objectKeyTable, 0, n4);
        }
        if (this.isObjectValue) {
            objectArray = this.objectValueTable;
            this.objectValueTable = new Object[n3];
            System.arraycopy(objectArray, 0, this.objectValueTable, 0, n4);
        }
        if (this.accessTable != null) {
            objectArray = this.accessTable;
            this.accessTable = new int[n3];
            System.arraycopy(objectArray, 0, this.accessTable, 0, n4);
        }
    }

    private void clearElementArrays(int n2, int n3) {
        int n4;
        if (this.isIntKey) {
            n4 = n3;
            while (--n4 >= n2) {
                this.intKeyTable[n4] = 0;
            }
        }
        if (this.isLongKey) {
            n4 = n3;
            while (--n4 >= n2) {
                this.longKeyTable[n4] = 0L;
            }
        }
        if (this.isObjectKey) {
            n4 = n3;
            while (--n4 >= n2) {
                this.objectKeyTable[n4] = null;
            }
        }
        if (this.isIntValue) {
            n4 = n3;
            while (--n4 >= n2) {
                this.intValueTable[n4] = 0;
            }
        }
        if (this.isLongValue) {
            n4 = n3;
            while (--n4 >= n2) {
                this.longValueTable[n4] = 0L;
            }
        }
        if (this.isObjectValue) {
            n4 = n3;
            while (--n4 >= n2) {
                this.objectValueTable[n4] = null;
            }
        }
        if (this.accessTable != null) {
            n4 = n3;
            while (--n4 >= n2) {
                this.accessTable[n4] = 0;
            }
        }
    }

    void removeFromElementArrays(int n2) {
        Object[] objectArray;
        int n3 = this.hashIndex.linkTable.length;
        if (this.isIntKey) {
            objectArray = this.intKeyTable;
            System.arraycopy(objectArray, n2 + 1, objectArray, n2, n3 - n2 - 1);
            this.intKeyTable[n3 - 1] = 0;
        }
        if (this.isLongKey) {
            objectArray = this.longKeyTable;
            System.arraycopy(objectArray, n2 + 1, objectArray, n2, n3 - n2 - 1);
            this.longKeyTable[n3 - 1] = 0L;
        }
        if (this.isObjectKey) {
            objectArray = this.objectKeyTable;
            System.arraycopy(objectArray, n2 + 1, objectArray, n2, n3 - n2 - 1);
            this.objectKeyTable[n3 - 1] = null;
        }
        if (this.isIntValue) {
            objectArray = this.intValueTable;
            System.arraycopy(objectArray, n2 + 1, objectArray, n2, n3 - n2 - 1);
            this.intValueTable[n3 - 1] = 0;
        }
        if (this.isLongValue) {
            objectArray = this.longValueTable;
            System.arraycopy(objectArray, n2 + 1, objectArray, n2, n3 - n2 - 1);
            this.longValueTable[n3 - 1] = 0L;
        }
        if (this.isObjectValue) {
            objectArray = this.objectValueTable;
            System.arraycopy(objectArray, n2 + 1, objectArray, n2, n3 - n2 - 1);
            this.objectValueTable[n3 - 1] = null;
        }
    }

    int nextLookup(int n2, int n3, boolean bl, int n4) {
        ++n2;
        while (n2 < n3) {
            if (this.isObjectKey) {
                if (this.objectKeyTable[n2] != null) {
                    return n2;
                }
            } else if (this.isIntKey) {
                if (this.intKeyTable[n2] != 0) {
                    return n2;
                }
                if (bl && n2 == n4) {
                    return n2;
                }
            } else {
                if (this.longKeyTable[n2] != 0L) {
                    return n2;
                }
                if (bl && n2 == n4) {
                    return n2;
                }
            }
            ++n2;
        }
        return n2;
    }

    protected int nextLookup(int n2) {
        ++n2;
        while (n2 < this.hashIndex.newNodePointer) {
            if (this.isObjectKey) {
                if (this.objectKeyTable[n2] != null) {
                    return n2;
                }
            } else if (this.isIntKey) {
                if (this.intKeyTable[n2] != 0) {
                    return n2;
                }
                if (this.hasZeroKey && n2 == this.zeroKeyIndex) {
                    return n2;
                }
            } else {
                if (this.longKeyTable[n2] != 0L) {
                    return n2;
                }
                if (this.hasZeroKey && n2 == this.zeroKeyIndex) {
                    return n2;
                }
            }
            ++n2;
        }
        return n2;
    }

    protected void removeRow(int n2) {
        this.hashIndex.removeEmptyNode(n2);
        this.removeFromElementArrays(n2);
    }

    protected Object removeLookup(int n2) {
        if (this.isObjectKey) {
            return this.addOrRemove(0L, 0L, this.objectKeyTable[n2], null, true);
        }
        return this.addOrRemove(this.intKeyTable[n2], 0L, null, null, true);
    }

    public void clear() {
        this.accessMin = this.accessCount = 0;
        this.hasZeroKey = false;
        this.zeroKeyIndex = -1;
        this.clearElementArrays(0, this.hashIndex.linkTable.length);
        this.hashIndex.clear();
        if (this.minimizeOnEmpty) {
            this.rehash(this.initialCapacity);
        }
    }

    protected int getAccessCountCeiling(int n2, int n3) {
        return ArrayCounter.rank(this.accessTable, this.hashIndex.newNodePointer, n2, this.accessMin + 1, this.accessCount, n3);
    }

    protected void clear(int n2, int n3) {
        if (n3 < 64) {
            n3 = 64;
        }
        int n4 = this.hashIndex.newNodePointer;
        int n5 = this.getAccessCountCeiling(n2, n3);
        for (int i2 = 0; i2 < n4; ++i2) {
            Object object = this.objectKeyTable[i2];
            if (object == null || this.accessTable[i2] >= n5) continue;
            this.removeObject(object);
        }
        this.accessMin = n5;
    }

    void resetAccessCount() {
        if (this.accessCount < Integer.MAX_VALUE) {
            return;
        }
        this.accessMin >>= 2;
        this.accessCount >>= 2;
        int n2 = this.accessTable.length;
        while (--n2 >= 0) {
            int n3 = n2;
            this.accessTable[n3] = this.accessTable[n3] >> 2;
        }
    }

    public int size() {
        return this.hashIndex.elementCount;
    }

    public boolean isEmpty() {
        return this.hashIndex.elementCount == 0;
    }

    protected boolean containsKey(Object object) {
        if (object == null) {
            return false;
        }
        int n2 = this.getLookup(object, object.hashCode());
        return n2 != -1;
    }

    protected boolean containsKey(int n2) {
        int n3 = this.getLookup(n2);
        return n3 != -1;
    }

    protected boolean containsKey(long l2) {
        int n2 = this.getLookup(l2);
        return n2 != -1;
    }

    protected boolean containsValue(Object object) {
        int n2;
        if (object == null) {
            for (n2 = 0; n2 < this.hashIndex.newNodePointer; ++n2) {
                if (this.objectValueTable[n2] != null) continue;
                if (this.isObjectKey) {
                    if (this.objectKeyTable[n2] == null) continue;
                    return true;
                }
                if (this.isIntKey) {
                    if (this.intKeyTable[n2] != 0) {
                        return true;
                    }
                    if (!this.hasZeroKey || n2 != this.zeroKeyIndex) continue;
                    return true;
                }
                if (this.longKeyTable[n2] != 0L) {
                    return true;
                }
                if (!this.hasZeroKey || n2 != this.zeroKeyIndex) continue;
                return true;
            }
        } else {
            while (n2 < this.hashIndex.newNodePointer) {
                if (object.equals(this.objectValueTable[n2])) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    protected class BaseHashIterator
    implements Iterator {
        boolean keys;
        int lookup = -1;
        int counter;
        boolean removed;

        public BaseHashIterator() {
        }

        public BaseHashIterator(boolean bl) {
            this.keys = bl;
        }

        public boolean hasNext() {
            return this.counter < BaseHashMap.this.hashIndex.elementCount;
        }

        public Object next() throws NoSuchElementException {
            if (this.keys && !BaseHashMap.this.isObjectKey || !this.keys && !BaseHashMap.this.isObjectValue) {
                throw new NoSuchElementException("Hash Iterator");
            }
            this.removed = false;
            if (this.hasNext()) {
                ++this.counter;
                this.lookup = BaseHashMap.this.nextLookup(this.lookup);
                if (this.keys) {
                    return BaseHashMap.this.objectKeyTable[this.lookup];
                }
                return BaseHashMap.this.objectValueTable[this.lookup];
            }
            throw new NoSuchElementException("Hash Iterator");
        }

        public int nextInt() throws NoSuchElementException {
            if (this.keys && !BaseHashMap.this.isIntKey || !this.keys && !BaseHashMap.this.isIntValue) {
                throw new NoSuchElementException("Hash Iterator");
            }
            this.removed = false;
            if (this.hasNext()) {
                ++this.counter;
                this.lookup = BaseHashMap.this.nextLookup(this.lookup);
                if (this.keys) {
                    return BaseHashMap.this.intKeyTable[this.lookup];
                }
                return BaseHashMap.this.intValueTable[this.lookup];
            }
            throw new NoSuchElementException("Hash Iterator");
        }

        public long nextLong() throws NoSuchElementException {
            if (!BaseHashMap.this.isLongKey || !this.keys) {
                throw new NoSuchElementException("Hash Iterator");
            }
            this.removed = false;
            if (this.hasNext()) {
                ++this.counter;
                this.lookup = BaseHashMap.this.nextLookup(this.lookup);
                if (this.keys) {
                    return BaseHashMap.this.longKeyTable[this.lookup];
                }
                return BaseHashMap.this.longValueTable[this.lookup];
            }
            throw new NoSuchElementException("Hash Iterator");
        }

        public void remove() throws NoSuchElementException {
            if (this.removed) {
                throw new NoSuchElementException("Hash Iterator");
            }
            --this.counter;
            this.removed = true;
            BaseHashMap.this.removeLookup(this.lookup);
        }

        public int getAccessCount() {
            if (this.removed || BaseHashMap.this.accessTable == null) {
                throw new NoSuchElementException();
            }
            return BaseHashMap.this.accessTable[this.lookup];
        }
    }
}

