/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rowio;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.hsqldb.CachedRow;
import org.hsqldb.Trace;
import org.hsqldb.Types;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.rowio.RowOutputBase;
import org.hsqldb.types.Binary;
import org.hsqldb.types.JavaObject;

public class RowOutputBinary
extends RowOutputBase {
    private static final int INT_STORE_SIZE = 4;
    int storageSize;

    public RowOutputBinary() {
    }

    public RowOutputBinary(int n2) {
        super(n2);
    }

    public RowOutputBinary(byte[] byArray) {
        super(byArray);
    }

    public void writeShortData(short s2) {
        this.writeShort(s2);
    }

    public void writeIntData(int n2) {
        this.writeInt(n2);
    }

    public void writeIntData(int n2, int n3) {
        int n4 = this.count;
        this.count = n3;
        this.writeInt(n2);
        if (this.count < n4) {
            this.count = n4;
        }
    }

    public void writeLongData(long l2) {
        this.writeLong(l2);
    }

    public void writeEnd() {
        while (this.count < this.storageSize) {
            this.write(0);
        }
    }

    public void writeSize(int n2) {
        this.storageSize = n2;
        this.writeInt(n2);
    }

    public void writeType(int n2) {
        this.writeShort(n2);
    }

    public void writeString(String string) {
        int n2 = this.count;
        this.writeInt(0);
        StringConverter.writeUTF(string, this);
        this.writeIntData(this.count - n2 - 4, n2);
    }

    public int getSize(CachedRow cachedRow) {
        Object[] objectArray = cachedRow.getData();
        int[] nArray = cachedRow.getTable().getColumnTypes();
        int n2 = cachedRow.getTable().getColumnCount();
        return 4 + RowOutputBinary.getSize(objectArray, n2, nArray);
    }

    public static int getRowSize(CachedRow cachedRow) {
        Object[] objectArray = cachedRow.getData();
        int[] nArray = cachedRow.getTable().getColumnTypes();
        int n2 = cachedRow.getTable().getColumnCount();
        return RowOutputBinary.getSize(objectArray, n2, nArray);
    }

    protected void writeFieldType(int n2) {
        this.write(1);
    }

    protected void writeNull(int n2) {
        this.write(0);
    }

    protected void writeChar(String string, int n2) {
        this.writeString(string);
    }

    protected void writeSmallint(Number number) {
        this.writeShort(number.intValue());
    }

    protected void writeInteger(Number number) {
        this.writeInt(number.intValue());
    }

    protected void writeBigint(Number number) {
        this.writeLong(number.longValue());
    }

    protected void writeReal(Double d2, int n2) {
        this.writeLong(Double.doubleToLongBits(d2));
    }

    protected void writeDecimal(BigDecimal bigDecimal) {
        int n2 = bigDecimal.scale();
        BigInteger bigInteger = JavaSystem.getUnscaledValue(bigDecimal);
        byte[] byArray = bigInteger.toByteArray();
        this.writeByteArray(byArray);
        this.writeInt(n2);
    }

    protected void writeBit(Boolean bl) {
        this.write(bl != false ? 1 : 0);
    }

    protected void writeDate(Date date) {
        this.writeLong(date.getTime());
    }

    protected void writeTime(Time time) {
        this.writeLong(time.getTime());
    }

    protected void writeTimestamp(Timestamp timestamp) {
        this.writeLong(timestamp.getTime());
        this.writeInt(timestamp.getNanos());
    }

    protected void writeOther(JavaObject javaObject) {
        this.writeByteArray(javaObject.getBytes());
    }

    protected void writeBinary(Binary binary, int n2) {
        this.writeByteArray(binary.getBytes());
    }

    protected void writeByteArray(byte[] byArray) {
        this.writeInt(byArray.length);
        this.write(byArray, 0, byArray.length);
    }

    private static int getSize(Object[] objectArray, int n2, int[] nArray) {
        int n3 = 0;
        block12: for (int i2 = 0; i2 < n2; ++i2) {
            Object object = objectArray[i2];
            ++n3;
            if (object == null) continue;
            switch (nArray[i2]) {
                case -1: 
                case 0: 
                case 1: 
                case 12: 
                case 100: {
                    n3 += 4;
                    n3 += StringConverter.getUTFSize((String)object);
                    continue block12;
                }
                case -6: 
                case 5: {
                    n3 += 2;
                    continue block12;
                }
                case 4: {
                    n3 += 4;
                    continue block12;
                }
                case -5: 
                case 6: 
                case 7: 
                case 8: {
                    n3 += 8;
                    continue block12;
                }
                case 2: 
                case 3: {
                    n3 += 8;
                    BigDecimal bigDecimal = (BigDecimal)object;
                    BigInteger bigInteger = JavaSystem.getUnscaledValue(bigDecimal);
                    n3 += bigInteger.toByteArray().length;
                    continue block12;
                }
                case 16: {
                    ++n3;
                    continue block12;
                }
                case 91: 
                case 92: {
                    n3 += 8;
                    continue block12;
                }
                case 93: {
                    n3 += 12;
                    continue block12;
                }
                case -4: 
                case -3: 
                case -2: {
                    n3 += 4;
                    n3 += ((Binary)object).getBytesLength();
                    continue block12;
                }
                case 1111: {
                    JavaObject javaObject = (JavaObject)object;
                    n3 += 4;
                    n3 += javaObject.getBytesLength();
                    continue block12;
                }
                default: {
                    Trace.printSystemOut("20 " + Types.getTypeString(nArray[i2]));
                }
            }
        }
        return n3;
    }

    public void ensureRoom(int n2) {
        super.ensureRoom(n2);
    }

    public void reset() {
        super.reset();
        this.storageSize = 0;
    }

    public void reset(int n2) {
        super.reset(n2);
        this.storageSize = 0;
    }

    public void setBuffer(byte[] byArray) {
        this.buf = byArray;
        this.reset();
    }
}

