/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.IOException;
import org.hsqldb.Database;
import org.hsqldb.persist.ScaledRAFile;
import org.hsqldb.persist.ScaledRAFileNIO;
import org.hsqldb.persist.ScaledRAInterface;

public class ScaledRAFileHybrid
implements ScaledRAInterface {
    final Database database;
    final String fileName;
    final boolean isReadOnly;
    final boolean wasNio;
    long maxLength;
    ScaledRAInterface store;

    public ScaledRAFileHybrid(Database database, String string, boolean bl) throws IOException {
        this.database = database;
        this.fileName = string;
        this.isReadOnly = bl;
        this.newStore(0L);
        this.wasNio = this.store.wasNio();
    }

    public long length() throws IOException {
        return this.store.length();
    }

    public void seek(long l2) throws IOException {
        this.checkSeek(l2);
        this.store.seek(l2);
    }

    public long getFilePointer() throws IOException {
        return this.store.getFilePointer();
    }

    public int read() throws IOException {
        this.checkLength(1);
        return this.store.read();
    }

    public void read(byte[] byArray, int n2, int n3) throws IOException {
        this.checkLength(n3);
        this.store.read(byArray, n2, n3);
    }

    public void write(byte[] byArray, int n2, int n3) throws IOException {
        this.checkLength(n3);
        this.store.write(byArray, n2, n3);
    }

    public int readInt() throws IOException {
        this.checkLength(4);
        return this.store.readInt();
    }

    public void writeInt(int n2) throws IOException {
        this.checkLength(4);
        this.store.writeInt(n2);
    }

    public long readLong() throws IOException {
        this.checkLength(8);
        return this.store.readLong();
    }

    public void writeLong(long l2) throws IOException {
        this.checkLength(8);
        this.store.writeLong(l2);
    }

    public void close() throws IOException {
        this.store.close();
    }

    public boolean isReadOnly() {
        return this.store.isReadOnly();
    }

    public boolean wasNio() {
        return this.wasNio;
    }

    public boolean canAccess(int n2) {
        return true;
    }

    public boolean canSeek(long l2) {
        return true;
    }

    public Database getDatabase() {
        return null;
    }

    private void checkLength(int n2) throws IOException {
        if (this.store.canAccess(n2)) {
            return;
        }
        this.newStore(this.store.getFilePointer() + (long)n2);
    }

    private void checkSeek(long l2) throws IOException {
        if (this.store.canSeek(l2)) {
            return;
        }
        this.newStore(l2);
    }

    void newStore(long l2) throws IOException {
        long l3 = 0L;
        if (this.store != null) {
            l3 = this.store.getFilePointer();
            this.store.close();
        }
        if (l2 <= 0x10000000L) {
            try {
                this.store = new ScaledRAFileNIO(this.database, this.fileName, this.isReadOnly, (int)l2);
                this.store.seek(l3);
                return;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.store = new ScaledRAFile(this.database, this.fileName, this.isReadOnly);
        this.store.seek(l3);
    }
}

