/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.lib.DoubleIntIndex;

public class DataFileBlockManager {
    private DoubleIntIndex lookup;
    private final int capacity;
    private int midSize;
    private final int scale;
    private long releaseCount;
    private long requestCount;
    private long requestSize;
    long lostFreeBlockSize;
    boolean isModified;

    public DataFileBlockManager(int n2, int n3, long l2) {
        this.lookup = new DoubleIntIndex(n2, true);
        this.lookup.setValuesSearchTarget();
        this.capacity = n2;
        this.scale = n3;
        this.lostFreeBlockSize = l2;
        this.midSize = 128;
    }

    void add(int n2, int n3) {
        this.isModified = true;
        if (this.capacity == 0) {
            this.lostFreeBlockSize += (long)n3;
            return;
        }
        ++this.releaseCount;
        if (this.lookup.size() == this.capacity) {
            this.resetList();
        }
        this.lookup.add(n2, n3);
    }

    int get(int n2) {
        if (this.lookup.size() == 0) {
            return -1;
        }
        int n3 = this.lookup.findFirstGreaterEqualKeyIndex(n2);
        if (n3 == -1) {
            return -1;
        }
        ++this.requestCount;
        this.requestSize += (long)n2;
        int n4 = this.lookup.getValue(n3);
        int n5 = n4 - n2;
        int n6 = this.lookup.getKey(n3);
        this.lookup.remove(n3);
        if (n5 >= this.midSize) {
            int n7 = n6 + n2 / this.scale;
            this.lookup.add(n7, n5);
        } else {
            this.lostFreeBlockSize += (long)n5;
        }
        return n6;
    }

    int size() {
        return this.lookup.size();
    }

    long getLostBlocksSize() {
        return this.lostFreeBlockSize;
    }

    boolean isModified() {
        return this.isModified;
    }

    void clear() {
        this.removeBlocks(this.lookup.size());
    }

    private void resetList() {
        int n2;
        if (this.requestCount != 0L) {
            this.midSize = (int)(this.requestSize / this.requestCount);
        }
        if ((n2 = this.lookup.findFirstGreaterEqualSlotIndex(this.midSize)) < this.lookup.size() / 4) {
            n2 = this.lookup.size() / 4;
        }
        this.removeBlocks(n2);
    }

    private void removeBlocks(int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            this.lostFreeBlockSize += (long)this.lookup.getValue(i2);
        }
        this.lookup.removeRange(0, n2);
    }

    private void checkIntegrity() throws NullPointerException {
    }
}

