/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hsqldb.DatabaseManager;
import org.hsqldb.DatabaseURL;
import org.hsqldb.HsqlException;
import org.hsqldb.Result;
import org.hsqldb.Session;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.rowio.RowInputBinary;
import org.hsqldb.rowio.RowOutputBinary;

public class Servlet
extends HttpServlet {
    private static final int BUFFER_SIZE = 256;
    private String dbType;
    private String dbPath;
    private String errorStr;
    private RowOutputBinary rowOut;
    private RowInputBinary rowIn;
    private int iQueries;
    private static long lModified = 0L;

    public void init(ServletConfig servletConfig) {
        try {
            super.init(servletConfig);
            this.rowOut = new RowOutputBinary(256);
            this.rowIn = new RowInputBinary(this.rowOut);
        }
        catch (ServletException servletException) {
            this.log(servletException.toString());
        }
        String string = this.getInitParameter("hsqldb.server.database");
        if (string == null) {
            string = ".";
        }
        String string2 = this.getInitParameter("hsqldb.server.use_web-inf_path");
        if (!string.equals(".") && "true".equalsIgnoreCase(string2)) {
            string = this.getServletContext().getRealPath("/") + "WEB-INF" + string;
        }
        HsqlProperties hsqlProperties = DatabaseURL.parseURL(string, false);
        this.log("Database filename = " + string);
        if (hsqlProperties == null) {
            this.errorStr = "Bad Database name";
        } else {
            this.dbPath = hsqlProperties.getProperty("database");
            this.dbType = hsqlProperties.getProperty("connection_type");
            try {
                DatabaseManager.getDatabase(this.dbType, this.dbPath, hsqlProperties);
            }
            catch (HsqlException hsqlException) {
                this.errorStr = hsqlException.getMessage();
            }
        }
        this.log(this.errorStr);
        this.log("Initialization completed.");
    }

    protected long getLastModified(HttpServletRequest httpServletRequest) {
        return lModified++;
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        String string = httpServletRequest.getQueryString();
        if (string == null || string.length() == 0) {
            httpServletResponse.setContentType("text/html");
            httpServletResponse.setHeader("Pragma", "no-cache");
            PrintWriter printWriter = httpServletResponse.getWriter();
            printWriter.println("<html><head><title>HSQL Database Engine Servlet</title>");
            printWriter.println("</head><body><h1>HSQL Database Engine Servlet</h1>");
            printWriter.println("The servlet is running.<p>");
            if (this.errorStr == null) {
                printWriter.println("The database is also running.<p>");
                printWriter.println("Database name: " + this.dbType + this.dbPath + "<p>");
                printWriter.println("Queries processed: " + this.iQueries + "<p>");
            } else {
                printWriter.println("<h2>The database is not running!</h2>");
                printWriter.println("The error message is:<p>");
                printWriter.println(this.errorStr);
            }
            printWriter.println("</body></html>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        Servlet servlet = this;
        synchronized (servlet) {
            block12: {
                DataInputStream dataInputStream;
                block13: {
                    dataInputStream = null;
                    OutputStream outputStream = null;
                    try {
                        try {
                            Result result;
                            dataInputStream = new DataInputStream(httpServletRequest.getInputStream());
                            Result result2 = Result.read(this.rowIn, dataInputStream);
                            if (result2.mode == 65543) {
                                try {
                                    Session session = DatabaseManager.newSession(this.dbType, this.dbPath, result2.getMainString(), result2.getSubString(), new HsqlProperties());
                                    result = new Result(1);
                                    result.sessionID = session.getId();
                                }
                                catch (HsqlException hsqlException) {
                                    result = new Result(hsqlException, null);
                                }
                            } else {
                                int n2 = result2.databaseID;
                                int n3 = result2.sessionID;
                                Session session = DatabaseManager.getSession(n2, n3);
                                result = session.execute(result2);
                            }
                            this.rowOut.reset();
                            result.write(this.rowOut);
                            httpServletResponse.setContentType("application/octet-stream");
                            httpServletResponse.setContentLength(this.rowOut.size());
                            outputStream = httpServletResponse.getOutputStream();
                            outputStream.write(this.rowOut.getOutputStream().getBuffer(), 0, this.rowOut.getOutputStream().size());
                            ++this.iQueries;
                        }
                        catch (HsqlException hsqlException) {
                            Object var12_15 = null;
                            if (outputStream != null) {
                                outputStream.flush();
                                outputStream.close();
                            }
                            if (dataInputStream == null) return;
                            dataInputStream.close();
                            break block12;
                        }
                        Object var12_14 = null;
                        if (outputStream == null) break block13;
                    }
                    catch (Throwable throwable) {
                        Object var12_16 = null;
                        if (outputStream != null) {
                            outputStream.flush();
                            outputStream.close();
                        }
                        if (dataInputStream == null) throw throwable;
                        dataInputStream.close();
                        throw throwable;
                    }
                    outputStream.flush();
                    outputStream.close();
                }
                if (dataInputStream == null) return;
                dataInputStream.close();
            }
            return;
        }
    }
}

