/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.net.InetAddress;
import org.hsqldb.ServerConstants;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.persist.HsqlProperties;

public final class ServerConfiguration
implements ServerConstants {
    private ServerConfiguration() {
    }

    public static int getDefaultPort(int n2, boolean bl) {
        switch (n2) {
            case 1: {
                return bl ? 554 : 9001;
            }
            case 0: {
                return bl ? 443 : 80;
            }
            case 2: {
                return bl ? -1 : 9101;
            }
        }
        return -1;
    }

    public static HsqlProperties getPropertiesFromFile(String string) {
        if (StringUtil.isEmpty(string)) {
            return null;
        }
        HsqlProperties hsqlProperties = new HsqlProperties(string);
        try {
            hsqlProperties.load();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hsqlProperties;
    }

    public static String[] listLocalInetAddressNames() {
        InetAddress[] inetAddressArray;
        InetAddress inetAddress;
        HashSet hashSet = new HashSet();
        try {
            int n2;
            inetAddress = InetAddress.getLocalHost();
            inetAddressArray = InetAddress.getAllByName(inetAddress.getHostAddress());
            for (n2 = 0; n2 < inetAddressArray.length; ++n2) {
                hashSet.add(inetAddressArray[n2].getHostAddress());
                hashSet.add(inetAddressArray[n2].getHostName());
            }
            inetAddressArray = InetAddress.getAllByName(inetAddress.getHostName());
            for (n2 = 0; n2 < inetAddressArray.length; ++n2) {
                hashSet.add(inetAddressArray[n2].getHostAddress());
                hashSet.add(inetAddressArray[n2].getHostName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            int n3;
            inetAddress = InetAddress.getByName(null);
            inetAddressArray = InetAddress.getAllByName(inetAddress.getHostAddress());
            for (n3 = 0; n3 < inetAddressArray.length; ++n3) {
                hashSet.add(inetAddressArray[n3].getHostAddress());
                hashSet.add(inetAddressArray[n3].getHostName());
            }
            inetAddressArray = InetAddress.getAllByName(inetAddress.getHostName());
            for (n3 = 0; n3 < inetAddressArray.length; ++n3) {
                hashSet.add(inetAddressArray[n3].getHostAddress());
                hashSet.add(inetAddressArray[n3].getHostName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            hashSet.add(InetAddress.getByName("loopback").getHostAddress());
            hashSet.add(InetAddress.getByName("loopback").getHostName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (String[])hashSet.toArray(new String[hashSet.size()]);
    }

    public static HsqlProperties newDefaultProperties(int n2) {
        HsqlProperties hsqlProperties = new HsqlProperties();
        hsqlProperties.setProperty("server.restart_on_shutdown", false);
        hsqlProperties.setProperty("server.address", "0.0.0.0");
        hsqlProperties.setProperty("server.no_system_exit", true);
        boolean bl = false;
        try {
            bl = System.getProperty("javax.net.ssl.keyStore") != null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        hsqlProperties.setProperty("server.port", ServerConfiguration.getDefaultPort(n2, bl));
        hsqlProperties.setProperty("server.silent", true);
        hsqlProperties.setProperty("server.tls", bl);
        hsqlProperties.setProperty("server.trace", false);
        hsqlProperties.setProperty("server.default_page", "index.html");
        hsqlProperties.setProperty("server.root", ".");
        return hsqlProperties;
    }

    public static void translateAddressProperty(HsqlProperties hsqlProperties) {
        if (hsqlProperties == null) {
            return;
        }
        String string = hsqlProperties.getProperty("server.address");
        if (StringUtil.isEmpty(string)) {
            hsqlProperties.setProperty("server.address", "0.0.0.0");
        }
    }

    public static void translateDefaultDatabaseProperty(HsqlProperties hsqlProperties) {
        if (hsqlProperties == null) {
            return;
        }
        if (!hsqlProperties.isPropertyTrue("server.remote_open")) {
            if (hsqlProperties.getProperty("server.database.0") == null) {
                String string = hsqlProperties.getProperty("server.database");
                if (string == null) {
                    string = "test";
                }
                hsqlProperties.setProperty("server.database.0", string);
                hsqlProperties.setProperty("server.dbname.0", "");
            }
            if (hsqlProperties.getProperty("server.dbname.0") == null) {
                hsqlProperties.setProperty("server.dbname.0", "");
            }
        }
    }

    public static void translateDefaultNoSystemExitProperty(HsqlProperties hsqlProperties) {
        if (hsqlProperties == null) {
            return;
        }
        hsqlProperties.setPropertyIfNotExists("server.no_system_exit", "false");
    }
}

