/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.Session;
import org.hsqldb.Trace;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.persist.Logger;

public class SequenceManager {
    HashMappedList sequenceMap = new HashMappedList();

    SequenceManager() {
    }

    void dropSequence(String string) throws HsqlException {
        boolean bl = this.sequenceMap.containsKey(string);
        Trace.check(bl, 191, string);
        this.sequenceMap.remove(string);
    }

    public NumberSequence getSequence(String string) {
        return (NumberSequence)this.sequenceMap.get(string);
    }

    NumberSequence createSequence(HsqlNameManager.HsqlName hsqlName, long l2, long l3, int n2) throws HsqlException {
        Trace.check(!this.sequenceMap.containsKey(hsqlName.name), 192);
        NumberSequence numberSequence = new NumberSequence(hsqlName, l2, l3, n2);
        this.sequenceMap.put(hsqlName.name, numberSequence);
        return numberSequence;
    }

    String logSequences(Session session, Logger logger) throws HsqlException {
        for (int i2 = 0; i2 < this.sequenceMap.size(); ++i2) {
            NumberSequence numberSequence = (NumberSequence)this.sequenceMap.get(i2);
            if (!numberSequence.wasUsed()) continue;
            logger.writeSequenceStatement(session, numberSequence);
            numberSequence.resetWasUsed();
        }
        return null;
    }
}

