/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.DataInput;
import java.io.IOException;
import java.io.OutputStream;
import java.util.NoSuchElementException;
import org.hsqldb.Column;
import org.hsqldb.HsqlException;
import org.hsqldb.Record;
import org.hsqldb.Session;
import org.hsqldb.Trace;
import org.hsqldb.lib.Iterator;
import org.hsqldb.rowio.RowInputBinary;
import org.hsqldb.rowio.RowOutputBinary;

public class Result {
    public Record rRoot;
    private Record rTail;
    private int size;
    private int significantColumns;
    public int mode;
    int databaseID;
    int sessionID;
    String mainString;
    String subString;
    String subSubString;
    private Throwable exception;
    int statementID;
    int updateCount;
    public ResultMetaData metaData;

    public Result(int n2) {
        this.mode = n2;
        if (n2 == 3 || n2 == 5 || n2 == 65548 || n2 == 6) {
            this.metaData = new ResultMetaData();
        }
    }

    Result(ResultMetaData resultMetaData) {
        this.mode = 3;
        this.significantColumns = resultMetaData.colTypes.length;
        this.metaData = resultMetaData;
    }

    Result(String string, String string2, int n2) {
        this.mode = 2;
        this.mainString = string;
        this.subString = string2;
        this.statementID = n2;
        this.subSubString = "";
    }

    Result(int n2, int n3) {
        this.metaData = new ResultMetaData();
        this.metaData.prepareData(n3);
        if (n2 == 5) {
            this.metaData.isParameterDescription = true;
            this.metaData.paramMode = new int[n3];
        }
        this.mode = n2;
        this.significantColumns = n3;
    }

    public Result(int n2, int[] nArray, int n3) {
        this.mode = n2;
        this.metaData = new ResultMetaData();
        this.metaData.colTypes = nArray;
        this.significantColumns = nArray.length;
        this.statementID = n3;
    }

    Result(RowInputBinary rowInputBinary) throws HsqlException {
        try {
            this.mode = rowInputBinary.readIntData();
            if (this.mode == 0) {
                this.readMultiResult(rowInputBinary);
                return;
            }
            this.databaseID = rowInputBinary.readIntData();
            this.sessionID = rowInputBinary.readIntData();
            switch (this.mode) {
                case 7: 
                case 10: 
                case 65545: 
                case 65610: {
                    break;
                }
                case 65555: {
                    this.setStatementType(rowInputBinary.readIntData());
                    this.mainString = rowInputBinary.readString();
                    break;
                }
                case 4: 
                case 65552: {
                    this.statementID = rowInputBinary.readIntData();
                    break;
                }
                case 65547: {
                    this.updateCount = rowInputBinary.readIntData();
                    this.statementID = rowInputBinary.readIntData();
                    this.mainString = rowInputBinary.readString();
                    break;
                }
                case 2: 
                case 65543: {
                    this.mainString = rowInputBinary.readString();
                    this.subString = rowInputBinary.readString();
                    this.subSubString = rowInputBinary.readString();
                    this.statementID = rowInputBinary.readIntData();
                    break;
                }
                case 1: {
                    this.updateCount = rowInputBinary.readIntData();
                    break;
                }
                case 66541: {
                    int n2 = rowInputBinary.readIntData();
                    this.setEndTranType(n2);
                    switch (n2) {
                        case 2: 
                        case 4: {
                            this.mainString = rowInputBinary.readString();
                        }
                    }
                    break;
                }
                case 6: 
                case 8: 
                case 9: 
                case 65548: {
                    int n3;
                    this.updateCount = rowInputBinary.readIntData();
                    this.statementID = rowInputBinary.readIntData();
                    int n4 = rowInputBinary.readIntData();
                    this.metaData = new ResultMetaData(n4);
                    this.significantColumns = n4;
                    for (n3 = 0; n3 < n4; ++n3) {
                        this.metaData.colTypes[n3] = rowInputBinary.readType();
                    }
                    n3 = rowInputBinary.readIntData();
                    while (n3-- > 0) {
                        this.add(rowInputBinary.readData(this.metaData.colTypes));
                    }
                    break;
                }
                case 3: 
                case 5: {
                    this.metaData = new ResultMetaData(rowInputBinary, this.mode);
                    this.significantColumns = this.metaData.colLabels.length;
                    int n5 = rowInputBinary.readIntData();
                    while (n5-- > 0) {
                        this.add(rowInputBinary.readData(this.metaData.colTypes));
                    }
                    break;
                }
                case 66552: {
                    int n6 = rowInputBinary.readIntData();
                    this.setConnectionAttrType(n6);
                    switch (n6) {
                        case 10027: {
                            this.mainString = rowInputBinary.readString();
                        }
                    }
                    break;
                }
                default: {
                    throw new HsqlException(Trace.getMessage(146, true, new Object[]{new Integer(this.mode)}), null, 0);
                }
            }
        }
        catch (IOException iOException) {
            throw Trace.error(19);
        }
    }

    static Result newSingleColumnResult(String string, int n2) {
        Result result = new Result(3, 1);
        result.metaData.colNames[0] = string;
        result.metaData.colLabels[0] = string;
        result.metaData.tableNames[0] = "";
        result.metaData.colTypes[0] = n2;
        return result;
    }

    static Result newPrepareResponse(int n2, Result result, Result result2) {
        Result result3 = new Result(0);
        Result result4 = new Result(4);
        result4.statementID = n2;
        result3.add(new Object[]{result4});
        result3.add(new Object[]{result});
        result3.add(new Object[]{result2});
        return result3;
    }

    static Result newParameterDescriptionResult(int n2) {
        Result result = new Result(5, n2);
        result.metaData.isParameterDescription = true;
        result.metaData.paramMode = new int[n2];
        return result;
    }

    public static Result newFreeStmtRequest(int n2) {
        Result result = new Result(65552);
        result.statementID = n2;
        return result;
    }

    static Result newExecuteDirectRequest(String string) {
        Result result = new Result(65547);
        result.setMainString(string);
        return result;
    }

    public static Result newReleaseSavepointRequest(String string) {
        Result result = new Result(66541);
        result.setMainString(string);
        result.setEndTranType(4);
        return result;
    }

    public static Result newRollbackToSavepointRequest(String string) {
        Result result = new Result(66541);
        result.setMainString(string);
        result.setEndTranType(2);
        return result;
    }

    public static Result newSetSavepointRequest(String string) {
        Result result = new Result(66552);
        result.setConnectionAttrType(10027);
        result.setMainString(string);
        return result;
    }

    public int getSize() {
        return this.size;
    }

    void setColumnCount(int n2) {
        this.significantColumns = n2;
    }

    public int getColumnCount() {
        return this.significantColumns;
    }

    void append(Result result) {
        if (result.rRoot == null) {
            return;
        }
        if (this.rRoot == null) {
            this.rRoot = result.rRoot;
        } else {
            this.rTail.next = result.rRoot;
        }
        this.rTail = result.rTail;
        this.size += result.size;
    }

    void addAll(Result result) {
        if (result == null) {
            return;
        }
        Record record = result.rRoot;
        while (record != null) {
            this.add(record.data);
            record = record.next;
        }
    }

    public void clear() {
        this.rRoot = null;
        this.rTail = null;
        this.size = 0;
    }

    public boolean isEmpty() {
        return this.rRoot == null;
    }

    void setRows(Result result) {
        if (result == null) {
            this.rRoot = null;
            this.rTail = null;
            this.size = 0;
        } else {
            this.rRoot = result.rRoot;
            this.rTail = result.rTail;
            this.size = result.size;
        }
    }

    public void add(Object[] objectArray) {
        Record record = new Record();
        record.data = objectArray;
        if (this.rRoot == null) {
            this.rRoot = record;
        } else {
            this.rTail.next = record;
        }
        this.rTail = record;
        ++this.size;
    }

    void trimResult(int n2, int n3) {
        int n4;
        Record record = this.rRoot;
        if (record == null) {
            return;
        }
        if (n2 >= this.size) {
            this.size = 0;
            this.rTail = null;
            this.rRoot = null;
            return;
        }
        this.size -= n2;
        for (n4 = 0; n4 < n2; ++n4) {
            record = record.next;
            if (record != null) continue;
            this.size = 0;
            this.rRoot = this.rTail = record;
            return;
        }
        this.rRoot = record;
        if (n3 == 0 || n3 >= this.size) {
            return;
        }
        for (n4 = 1; n4 < n3; ++n4) {
            record = record.next;
            if (record != null) continue;
            return;
        }
        this.size = n3;
        record.next = null;
        this.rTail = record;
    }

    void removeDuplicates(Session session) throws HsqlException {
        this.removeDuplicates(session, this.significantColumns);
    }

    void removeDuplicates(Session session, int n2) throws HsqlException {
        Record record;
        if (this.rRoot == null) {
            return;
        }
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = i2;
            nArray2[i2] = 1;
        }
        this.sortResult(session, nArray, nArray2);
        Record record2 = this.rRoot;
        while ((record = record2.next) != null) {
            if (this.compareRecord(session, record2.data, record.data, n2) == 0) {
                record2.next = record.next;
                --this.size;
                continue;
            }
            record2 = record;
        }
        this.rTail = record2;
    }

    void removeSecond(Session session, Result result, int n2) throws HsqlException {
        this.removeDuplicates(session, n2);
        result.removeDuplicates(session, n2);
        Record record = this.rRoot;
        Record record2 = this.rRoot;
        boolean bl = true;
        Record record3 = result.rRoot;
        int n3 = 0;
        while (record != null && record3 != null) {
            n3 = this.compareRecord(session, record.data, record3.data, n2);
            if (n3 == 0) {
                if (bl) {
                    this.rRoot = record2 = record.next;
                } else {
                    record2.next = record.next;
                }
                record = record.next;
                --this.size;
                continue;
            }
            if (n3 > 0) {
                record3 = record3.next;
                continue;
            }
            record2 = record;
            bl = false;
            record = record.next;
        }
        while (record != null) {
            record2 = record;
            record = record.next;
        }
        this.rTail = record2;
    }

    void removeDifferent(Session session, Result result, int n2) throws HsqlException {
        this.removeDuplicates(session, n2);
        result.removeDuplicates(session, n2);
        Record record = this.rRoot;
        Record record2 = this.rRoot;
        boolean bl = true;
        Record record3 = result.rRoot;
        int n3 = 0;
        this.size = 0;
        while (record != null && record3 != null) {
            n3 = this.compareRecord(session, record.data, record3.data, n2);
            if (n3 == 0) {
                if (bl) {
                    this.rRoot = record;
                } else {
                    record2.next = record;
                }
                bl = false;
                record2 = record;
                record = record.next;
                record3 = record3.next;
                ++this.size;
                continue;
            }
            if (n3 > 0) {
                record3 = record3.next;
                continue;
            }
            record = record.next;
        }
        if (bl) {
            this.rRoot = null;
            record2 = null;
        } else {
            record2.next = null;
        }
        this.rTail = record2;
    }

    void sortResult(Session session, int[] nArray, int[] nArray2) throws HsqlException {
        if (this.rRoot == null || this.rRoot.next == null) {
            return;
        }
        Record[] recordArray = new Record[2];
        Record[] recordArray2 = new Record[2];
        int n2 = 0;
        Record record = this.rRoot;
        while (record != null) {
            Record record2 = record.next;
            record.next = recordArray[n2];
            recordArray[n2] = record;
            record = record2;
            n2 ^= 1;
        }
        int n3 = 1;
        while (recordArray[1] != null) {
            Record record3 = recordArray[0];
            Record record4 = recordArray[1];
            recordArray2[1] = null;
            recordArray2[0] = null;
            recordArray[1] = null;
            recordArray[0] = null;
            n2 = 0;
            while (record3 != null) {
                int n4 = n3;
                int n5 = n3;
                while (true) {
                    if (n4 == 0 || record3 == null) {
                        if (n5 == 0 || record4 == null) break;
                        record = record4;
                        record4 = record4.next;
                        --n5;
                    } else if (n5 == 0 || record4 == null) {
                        record = record3;
                        record3 = record3.next;
                        --n4;
                    } else if (this.compareRecord(session, record3.data, record4.data, nArray, nArray2) > 0) {
                        record = record4;
                        record4 = record4.next;
                        --n5;
                    } else {
                        record = record3;
                        record3 = record3.next;
                        --n4;
                    }
                    if (recordArray[n2] == null) {
                        recordArray[n2] = record;
                    } else {
                        recordArray2[n2].next = record;
                    }
                    recordArray2[n2] = record;
                    record.next = null;
                }
                n2 ^= 1;
            }
            n3 <<= 1;
        }
        this.rRoot = recordArray[0];
        this.rTail = recordArray2[0];
    }

    private int compareRecord(Session session, Object[] objectArray, Object[] objectArray2, int[] nArray, int[] nArray2) throws HsqlException {
        int n2 = Column.compare(session.database.collation, objectArray[nArray[0]], objectArray2[nArray[0]], this.metaData.colTypes[nArray[0]]);
        if (n2 == 0) {
            for (int i2 = 1; i2 < nArray.length; ++i2) {
                n2 = Column.compare(session.database.collation, objectArray[nArray[i2]], objectArray2[nArray[i2]], this.metaData.colTypes[nArray[i2]]);
                if (n2 == 0) continue;
                return n2 * nArray2[i2];
            }
        }
        return n2 * nArray2[0];
    }

    private int compareRecord(Session session, Object[] objectArray, Object[] objectArray2, int n2) throws HsqlException {
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = Column.compare(session.database.collation, objectArray[i2], objectArray2[i2], this.metaData.colTypes[i2]);
            if (n3 == 0) continue;
            return n3;
        }
        return 0;
    }

    static Result newSessionAttributesResult() {
        Result result = new Result(3, 7);
        result.metaData.tableNames = new String[]{"", "", "", "", "", "", ""};
        result.metaData.colLabels = result.metaData.tableNames;
        result.metaData.colNames = result.metaData.tableNames;
        result.metaData.colTypes = new int[]{12, 12, 4, 4, 16, 16, 16};
        return result;
    }

    void write(RowOutputBinary rowOutputBinary) throws IOException, HsqlException {
        if (this.mode == 0) {
            this.writeMulti(rowOutputBinary);
            return;
        }
        int n2 = rowOutputBinary.size();
        rowOutputBinary.writeSize(0);
        rowOutputBinary.writeIntData(this.mode);
        rowOutputBinary.writeIntData(this.databaseID);
        rowOutputBinary.writeIntData(this.sessionID);
        switch (this.mode) {
            case 7: 
            case 10: 
            case 65545: 
            case 65610: {
                break;
            }
            case 65555: {
                rowOutputBinary.writeIntData(this.getStatementType());
                rowOutputBinary.writeString(this.mainString);
                break;
            }
            case 4: 
            case 65552: {
                rowOutputBinary.writeIntData(this.statementID);
                break;
            }
            case 65547: {
                rowOutputBinary.writeIntData(this.updateCount);
                rowOutputBinary.writeIntData(this.statementID);
                rowOutputBinary.writeString(this.mainString);
                break;
            }
            case 2: 
            case 65543: {
                rowOutputBinary.writeString(this.mainString);
                rowOutputBinary.writeString(this.subString);
                rowOutputBinary.writeString(this.subSubString);
                rowOutputBinary.writeIntData(this.statementID);
                break;
            }
            case 1: {
                rowOutputBinary.writeIntData(this.updateCount);
                break;
            }
            case 66541: {
                int n3 = this.getEndTranType();
                rowOutputBinary.writeIntData(n3);
                switch (n3) {
                    case 2: 
                    case 4: {
                        rowOutputBinary.writeString(this.mainString);
                    }
                }
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 65548: {
                rowOutputBinary.writeIntData(this.updateCount);
                rowOutputBinary.writeIntData(this.statementID);
                int n4 = this.significantColumns;
                rowOutputBinary.writeIntData(n4);
                for (int i2 = 0; i2 < n4; ++i2) {
                    rowOutputBinary.writeType(this.metaData.colTypes[i2]);
                }
                rowOutputBinary.writeIntData(this.size);
                Record record = this.rRoot;
                while (record != null) {
                    rowOutputBinary.writeData(n4, this.metaData.colTypes, record.data, null, null);
                    record = record.next;
                }
                break;
            }
            case 3: 
            case 5: {
                this.metaData.write(rowOutputBinary, this.significantColumns);
                rowOutputBinary.writeIntData(this.size);
                Record record = this.rRoot;
                while (record != null) {
                    rowOutputBinary.writeData(this.significantColumns, this.metaData.colTypes, record.data, null, null);
                    record = record.next;
                }
                break;
            }
            case 66552: {
                int n5 = this.getConnectionAttrType();
                rowOutputBinary.writeIntData(n5);
                switch (n5) {
                    case 10027: {
                        rowOutputBinary.writeString(this.mainString);
                    }
                }
                break;
            }
            default: {
                throw new HsqlException(Trace.getMessage(146, true, new Object[]{new Integer(this.mode)}), null, 0);
            }
        }
        rowOutputBinary.writeIntData(rowOutputBinary.size(), n2);
    }

    void readMultiResult(RowInputBinary rowInputBinary) throws HsqlException, IOException {
        this.mode = 0;
        this.databaseID = rowInputBinary.readIntData();
        this.sessionID = rowInputBinary.readIntData();
        int n2 = rowInputBinary.readIntData();
        for (int i2 = 0; i2 < n2; ++i2) {
            rowInputBinary.readIntData();
            this.add(new Object[]{new Result(rowInputBinary)});
        }
    }

    private void writeMulti(RowOutputBinary rowOutputBinary) throws IOException, HsqlException {
        int n2 = rowOutputBinary.size();
        rowOutputBinary.writeSize(0);
        rowOutputBinary.writeIntData(this.mode);
        rowOutputBinary.writeIntData(this.databaseID);
        rowOutputBinary.writeIntData(this.sessionID);
        rowOutputBinary.writeIntData(this.size);
        Record record = this.rRoot;
        while (record != null) {
            ((Result)record.data[0]).write(rowOutputBinary);
            record = record.next;
        }
        rowOutputBinary.writeIntData(rowOutputBinary.size(), n2);
    }

    public static void write(Result result, RowOutputBinary rowOutputBinary, OutputStream outputStream) throws IOException, HsqlException {
        rowOutputBinary.reset();
        result.write(rowOutputBinary);
        outputStream.write(rowOutputBinary.getOutputStream().getBuffer(), 0, rowOutputBinary.getOutputStream().size());
        outputStream.flush();
    }

    public static Result read(RowInputBinary rowInputBinary, DataInput dataInput) throws IOException, HsqlException {
        int n2 = dataInput.readInt();
        rowInputBinary.resetRow(0, n2);
        byte[] byArray = rowInputBinary.getBuffer();
        int n3 = 4;
        dataInput.readFully(byArray, n3, n2 - n3);
        return new Result(rowInputBinary);
    }

    public Result(Throwable throwable, String string) {
        this.mode = 2;
        this.exception = throwable;
        if (throwable instanceof HsqlException) {
            HsqlException hsqlException = (HsqlException)throwable;
            this.subString = hsqlException.getSQLState();
            this.mainString = hsqlException.getMessage();
            if (string != null) {
                this.mainString = this.mainString + " in statement [" + string + "]";
            }
            this.statementID = hsqlException.getErrorCode();
        } else if (throwable instanceof OutOfMemoryError) {
            System.gc();
            this.subString = "S1000";
            this.mainString = "out of memory";
            this.statementID = 72;
        } else {
            this.subString = "S1000";
            this.mainString = Trace.getMessage(40) + " " + throwable;
            if (string != null) {
                this.mainString = this.mainString + " in statement [" + string + "]";
            }
            this.statementID = 40;
        }
        this.subSubString = "";
    }

    public Throwable getException() {
        return this.exception;
    }

    public int getStatementID() {
        return this.statementID;
    }

    void setStatementID(int n2) {
        this.statementID = n2;
    }

    public String getMainString() {
        return this.mainString;
    }

    public void setMainString(String string) {
        this.mainString = string;
    }

    public String getSubString() {
        return this.subString;
    }

    public void setMaxRows(int n2) {
        this.updateCount = n2;
    }

    public int getUpdateCount() {
        return this.updateCount;
    }

    int getConnectionAttrType() {
        return this.updateCount;
    }

    void setConnectionAttrType(int n2) {
        this.updateCount = n2;
    }

    int getEndTranType() {
        return this.updateCount;
    }

    void setEndTranType(int n2) {
        this.updateCount = n2;
    }

    public int[] getUpdateCounts() {
        return this.metaData.colTypes;
    }

    Object[] getParameterData() {
        return this.rRoot == null ? null : this.rRoot.data;
    }

    public void setParameterData(Object[] objectArray) {
        if (this.rRoot == null) {
            this.rRoot = new Record();
        }
        this.rRoot.data = objectArray;
        this.rRoot.next = null;
        this.rTail = this.rRoot;
        this.size = 1;
    }

    public void setResultType(int n2) {
        this.mode = n2;
    }

    public void setStatementType(int n2) {
        this.updateCount = n2;
    }

    public int getStatementType() {
        return this.updateCount;
    }

    public int getType() {
        return this.mode;
    }

    public boolean isData() {
        return this.mode == 3;
    }

    public boolean isError() {
        return this.mode == 2;
    }

    public boolean isUpdateCount() {
        return this.mode == 1;
    }

    public Iterator iterator() {
        return new ResultIterator();
    }

    private class ResultIterator
    implements Iterator {
        boolean removed;
        int counter;
        Record current;
        Record last;

        private ResultIterator() {
            this.current = Result.this.rRoot;
        }

        public boolean hasNext() {
            return this.counter < Result.this.size;
        }

        public Object next() {
            if (this.hasNext()) {
                this.removed = false;
                if (this.counter != 0) {
                    this.last = this.current;
                    this.current = this.current.next;
                }
                ++this.counter;
                return this.current.data;
            }
            throw new NoSuchElementException();
        }

        public int nextInt() {
            throw new NoSuchElementException();
        }

        public long nextLong() {
            throw new NoSuchElementException();
        }

        public void remove() {
            if (this.counter <= Result.this.size && this.counter != 0 && !this.removed) {
                this.removed = true;
                if (this.current == Result.this.rTail) {
                    Result.this.rTail = this.last;
                }
                if (this.current == Result.this.rRoot) {
                    this.current = Result.this.rRoot = Result.this.rRoot.next;
                } else {
                    this.current = this.last;
                    this.last = null;
                    this.current.next = this.current.next.next;
                }
                Result.this.size--;
                --this.counter;
                return;
            }
            throw new NoSuchElementException();
        }
    }

    public static class ResultMetaData {
        public String[] colLabels;
        public String[] tableNames;
        public String[] colNames;
        public boolean[] isLabelQuoted;
        public int[] colTypes;
        public int[] colSizes;
        public int[] colScales;
        public String[] catalogNames;
        public String[] schemaNames;
        public int[] colNullable;
        public boolean[] isIdentity;
        public boolean[] isWritable;
        public int[] paramMode;
        public String[] classNames;
        boolean isParameterDescription;

        ResultMetaData() {
        }

        ResultMetaData(int n2) {
            this.prepareData(n2);
        }

        private void prepareData(int n2) {
            this.colLabels = new String[n2];
            this.tableNames = new String[n2];
            this.colNames = new String[n2];
            this.isLabelQuoted = new boolean[n2];
            this.colTypes = new int[n2];
            this.colSizes = new int[n2];
            this.colScales = new int[n2];
            this.catalogNames = new String[n2];
            this.schemaNames = new String[n2];
            this.colNullable = new int[n2];
            this.isIdentity = new boolean[n2];
            this.isWritable = new boolean[n2];
            this.classNames = new String[n2];
        }

        public int[] getParameterTypes() {
            return this.colTypes;
        }

        boolean isTableColumn(int n2) {
            return this.tableNames[n2] != null && this.tableNames[n2].length() > 0 && this.colNames[n2] != null && this.colNames[n2].length() > 0;
        }

        private void decodeTableColumnAttrs(int n2, int n3) {
            this.colNullable[n3] = n2 & 0xF;
            this.isIdentity[n3] = (n2 & 0x10) != 0;
            this.isWritable[n3] = (n2 & 0x20) != 0;
        }

        private void writeTableColumnAttrs(RowOutputBinary rowOutputBinary, int n2) throws IOException, HsqlException {
            rowOutputBinary.writeIntData(this.encodeTableColumnAttrs(n2));
            rowOutputBinary.writeString(this.catalogNames[n2] == null ? "" : this.catalogNames[n2]);
            rowOutputBinary.writeString(this.schemaNames[n2] == null ? "" : this.schemaNames[n2]);
        }

        private int encodeTableColumnAttrs(int n2) {
            int n3 = this.colNullable[n2];
            if (this.isIdentity[n2]) {
                n3 |= 0x10;
            }
            if (this.isWritable[n2]) {
                n3 |= 0x20;
            }
            return n3;
        }

        private void readTableColumnAttrs(RowInputBinary rowInputBinary, int n2) throws IOException, HsqlException {
            this.decodeTableColumnAttrs(rowInputBinary.readIntData(), n2);
            this.catalogNames[n2] = rowInputBinary.readString();
            this.schemaNames[n2] = rowInputBinary.readString();
        }

        ResultMetaData(RowInputBinary rowInputBinary, int n2) throws HsqlException, IOException {
            int n3 = rowInputBinary.readIntData();
            this.prepareData(n3);
            if (n2 == 5) {
                this.isParameterDescription = true;
                this.paramMode = new int[n3];
            }
            for (int i2 = 0; i2 < n3; ++i2) {
                this.colTypes[i2] = rowInputBinary.readType();
                this.colSizes[i2] = rowInputBinary.readIntData();
                this.colScales[i2] = rowInputBinary.readIntData();
                this.colLabels[i2] = rowInputBinary.readString();
                this.tableNames[i2] = rowInputBinary.readString();
                this.colNames[i2] = rowInputBinary.readString();
                this.classNames[i2] = rowInputBinary.readString();
                if (this.isTableColumn(i2)) {
                    this.readTableColumnAttrs(rowInputBinary, i2);
                }
                if (n2 != 5) continue;
                this.paramMode[i2] = rowInputBinary.readIntData();
            }
        }

        void write(RowOutputBinary rowOutputBinary, int n2) throws HsqlException, IOException {
            rowOutputBinary.writeIntData(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                rowOutputBinary.writeType(this.colTypes[i2]);
                rowOutputBinary.writeIntData(this.colSizes[i2]);
                rowOutputBinary.writeIntData(this.colScales[i2]);
                rowOutputBinary.writeString(this.colLabels[i2] == null ? "" : this.colLabels[i2]);
                rowOutputBinary.writeString(this.tableNames[i2] == null ? "" : this.tableNames[i2]);
                rowOutputBinary.writeString(this.colNames[i2] == null ? "" : this.colNames[i2]);
                rowOutputBinary.writeString(this.classNames[i2] == null ? "" : this.classNames[i2]);
                if (this.isTableColumn(i2)) {
                    this.writeTableColumnAttrs(rowOutputBinary, i2);
                }
                if (!this.isParameterDescription) continue;
                rowOutputBinary.writeIntData(this.paramMode[i2]);
            }
        }
    }
}

