/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Session;
import org.hsqldb.lib.StringUtil;

class Like {
    private char[] cLike;
    private int[] wildCardType;
    private int iLen;
    private boolean isIgnoreCase;
    private int iFirstWildCard;
    private boolean isNull;
    Character escapeChar;
    boolean hasCollation;
    boolean optimised;
    static final int UNDERSCORE_CHAR = 1;
    static final int PERCENT_CHAR = 2;

    Like(Character c2, boolean bl) {
        this.escapeChar = c2;
        this.hasCollation = bl;
    }

    void setParams(Session session, String string, boolean bl) {
        this.isIgnoreCase = bl;
        this.normalize(session, string);
        this.optimised = true;
    }

    void resetPattern(Session session, String string) {
        this.normalize(session, string);
    }

    private String getStartsWith() {
        int n2;
        if (this.iLen == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (n2 = 0; n2 < this.iLen && this.wildCardType[n2] == 0; ++n2) {
            stringBuffer.append(this.cLike[n2]);
        }
        if (n2 == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    Boolean compare(Session session, String string) {
        if (string == null) {
            return null;
        }
        if (this.isIgnoreCase) {
            string = session.database.collation.toUpperCase(string);
        }
        return this.compareAt(string, 0, 0, string.length()) ? Boolean.TRUE : Boolean.FALSE;
    }

    private boolean compareAt(String string, int n2, int n3, int n4) {
        while (n2 < this.iLen) {
            switch (this.wildCardType[n2]) {
                case 0: {
                    if (n3 < n4 && this.cLike[n2] == string.charAt(n3++)) break;
                    return false;
                }
                case 1: {
                    if (n3++ < n4) break;
                    return false;
                }
                case 2: {
                    if (++n2 >= this.iLen) {
                        return true;
                    }
                    while (n3 < n4) {
                        if (this.cLike[n2] == string.charAt(n3) && this.compareAt(string, n2, n3, n4)) {
                            return true;
                        }
                        ++n3;
                    }
                    return false;
                }
            }
            ++n2;
        }
        return n3 == n4;
    }

    private void normalize(Session session, String string) {
        int n2;
        boolean bl = this.isNull = string == null;
        if (!this.isNull && this.isIgnoreCase) {
            string = session.database.collation.toUpperCase(string);
        }
        this.iLen = 0;
        this.iFirstWildCard = -1;
        int n3 = string == null ? 0 : string.length();
        this.cLike = new char[n3];
        this.wildCardType = new int[n3];
        boolean bl2 = false;
        boolean bl3 = false;
        for (n2 = 0; n2 < n3; ++n2) {
            char c2 = string.charAt(n2);
            if (!bl2) {
                if (this.escapeChar != null && this.escapeChar.charValue() == c2) {
                    bl2 = true;
                    continue;
                }
                if (c2 == '_') {
                    this.wildCardType[this.iLen] = 1;
                    if (this.iFirstWildCard == -1) {
                        this.iFirstWildCard = this.iLen;
                    }
                } else if (c2 == '%') {
                    if (bl3) continue;
                    bl3 = true;
                    this.wildCardType[this.iLen] = 2;
                    if (this.iFirstWildCard == -1) {
                        this.iFirstWildCard = this.iLen;
                    }
                } else {
                    bl3 = false;
                }
            } else {
                bl3 = false;
                bl2 = false;
            }
            this.cLike[this.iLen++] = c2;
        }
        for (n2 = 0; n2 < this.iLen - 1; ++n2) {
            if (this.wildCardType[n2] != 2 || this.wildCardType[n2 + 1] != 1) continue;
            this.wildCardType[n2] = 1;
            this.wildCardType[n2 + 1] = 2;
        }
    }

    boolean hasWildcards() {
        return this.iFirstWildCard != -1;
    }

    boolean isEquivalentToFalsePredicate() {
        return this.isNull;
    }

    boolean isEquivalentToEqualsPredicate() {
        return this.iFirstWildCard == -1;
    }

    boolean isEquivalentToNotNullPredicate() {
        if (this.isNull || !this.hasWildcards()) {
            return false;
        }
        for (int i2 = 0; i2 < this.wildCardType.length; ++i2) {
            if (this.wildCardType[i2] == 2) continue;
            return false;
        }
        return true;
    }

    boolean isEquivalentToBetweenPredicate() {
        return this.iFirstWildCard > 0 && this.iFirstWildCard == this.wildCardType.length - 1 && this.cLike[this.iFirstWildCard] == '%';
    }

    boolean isEquivalentToBetweenPredicateAugmentedWithLike() {
        return this.iFirstWildCard > 0 && this.cLike[this.iFirstWildCard] == '%';
    }

    String getRangeLow() {
        return this.getStartsWith();
    }

    String getRangeHigh() {
        String string = this.getStartsWith();
        return string == null ? null : string.concat("\uffff");
    }

    public String describe(Session session) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString()).append("[\n");
        stringBuffer.append("escapeChar=").append(this.escapeChar).append('\n');
        stringBuffer.append("isNull=").append(this.isNull).append('\n');
        stringBuffer.append("optimised=").append(this.optimised).append('\n');
        stringBuffer.append("isIgnoreCase=").append(this.isIgnoreCase).append('\n');
        stringBuffer.append("iLen=").append(this.iLen).append('\n');
        stringBuffer.append("iFirstWildCard=").append(this.iFirstWildCard).append('\n');
        stringBuffer.append("cLike=");
        stringBuffer.append(StringUtil.arrayToString(this.cLike));
        stringBuffer.append('\n');
        stringBuffer.append("wildCardType=");
        stringBuffer.append(StringUtil.arrayToString(this.wildCardType));
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

