/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.util.NoSuchElementException;
import org.hsqldb.Collation;
import org.hsqldb.Column;
import org.hsqldb.Constraint;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Node;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.index.RowIterator;
import org.hsqldb.lib.ArrayUtil;

public class Index {
    static final int MEMORY_INDEX = 0;
    static final int DISK_INDEX = 1;
    static final int POINTER_INDEX = 2;
    private final HsqlNameManager.HsqlName indexName;
    final boolean[] colCheck;
    private final int[] colIndex;
    private final int[] colTypes;
    final int[] pkCols;
    final int[] pkTypes;
    private final boolean isUnique;
    private final boolean useRowId;
    final boolean isConstraint;
    final boolean isForward;
    final boolean isTemp;
    private Node root;
    private int depth;
    final Collation collation;
    static IndexRowIterator emptyIterator = new IndexRowIterator(null, null, null);
    IndexRowIterator updatableIterators;
    final boolean onCommitPreserve;
    final Table table;

    Index(Database database, HsqlNameManager.HsqlName hsqlName, Table table, int[] nArray, int[] nArray2, boolean bl, boolean bl2, boolean bl3, boolean bl4, int[] nArray3, int[] nArray4, boolean bl5) {
        this.table = table;
        this.indexName = hsqlName;
        this.colIndex = nArray;
        this.colTypes = nArray2;
        this.pkCols = nArray3;
        this.pkTypes = nArray4;
        this.isUnique = bl2;
        this.isConstraint = bl3;
        this.isForward = bl4;
        this.useRowId = !this.isUnique && this.pkCols.length == 0 || this.colIndex.length == 0;
        this.colCheck = table.getNewColumnCheckList();
        ArrayUtil.intIndexesToBooleanArray(this.colIndex, this.colCheck);
        this.updatableIterators.next = this.updatableIterators.last = (this.updatableIterators = new IndexRowIterator(null, null, null));
        this.collation = database.collation;
        this.isTemp = bl5;
        this.onCommitPreserve = table.onCommitPreserve;
    }

    HsqlNameManager.HsqlName getName() {
        return this.indexName;
    }

    void setName(String string, boolean bl) throws HsqlException {
        this.indexName.rename(string, bl);
    }

    int getVisibleColumns() {
        return this.colIndex.length;
    }

    boolean isUnique() {
        return this.isUnique;
    }

    boolean isConstraint() {
        return this.isConstraint;
    }

    int[] getColumns() {
        return this.colIndex;
    }

    int[] getColumnTypes() {
        return this.colTypes;
    }

    String getColumnNameList() {
        String string = "";
        for (int i2 = 0; i2 < this.colIndex.length; ++i2) {
            string = string + this.table.getColumn((int)this.colIndex[i2]).columnName.statementName;
            if (i2 >= this.colIndex.length - 1) continue;
            string = string + ",";
        }
        return string;
    }

    int size(Session session) throws HsqlException {
        int n2 = 0;
        RowIterator rowIterator = this.firstRow(session);
        while (rowIterator.hasNext()) {
            rowIterator.next();
            ++n2;
        }
        return n2;
    }

    boolean isEmpty(Session session) {
        return this.getRoot(session) == null;
    }

    public int sizeEstimate() throws HsqlException {
        this.firstRow(null);
        return (int)(1L << this.depth);
    }

    void clearAll(Session session) {
        this.setRoot(session, null);
        this.depth = 0;
        this.updatableIterators.next = this.updatableIterators.last = this.updatableIterators;
    }

    void clearIterators() {
        this.updatableIterators.next = this.updatableIterators.last = this.updatableIterators;
    }

    void setRoot(Session session, Node node) {
        if (this.isTemp) {
            session.setIndexRoot(this.indexName, this.onCommitPreserve, node);
        } else {
            this.root = node;
        }
    }

    int getRoot() {
        return this.root == null ? -1 : this.root.getKey();
    }

    private Node getRoot(Session session) {
        if (this.isTemp && session != null) {
            return session.getIndexRoot(this.indexName, this.onCommitPreserve);
        }
        return this.root;
    }

    void insert(Session session, Row row, int n2) throws HsqlException {
        Node node;
        Node node2 = node = this.getRoot(session);
        boolean bl = true;
        int n3 = -1;
        while (true) {
            if (node == null) {
                if (node2 == null) {
                    this.setRoot(session, row.getNode(n2));
                    return;
                }
                break;
            }
            n3 = this.compareRowForInsert(session, row, node.getRow());
            if (n3 == 0) {
                Constraint constraint;
                int n4 = 9;
                String string = this.indexName.statementName;
                if (this.isConstraint && (constraint = this.table.getUniqueOrPKConstraintForIndex(this)) != null) {
                    string = constraint.getName().name;
                    n4 = 104;
                }
                throw Trace.error(n4, new Object[]{string, this.getColumnNameList()});
            }
            bl = n3 < 0;
            node2 = node;
            node = this.child(node2, bl);
        }
        this.set(node2, bl, row.getNode(n2));
        this.balance(session, node2, bl);
    }

    private void balance(Session session, Node node, boolean bl) throws HsqlException {
        while (true) {
            int n2 = bl ? 1 : -1;
            node = node.getUpdatedNode();
            switch (node.getBalance() * n2) {
                case 1: {
                    node.setBalance(0);
                    return;
                }
                case 0: {
                    node.setBalance(-n2);
                    break;
                }
                case -1: {
                    Node node2 = this.child(node, bl);
                    if (node2.getBalance() == -n2) {
                        this.replace(session, node, node2);
                        this.set(node, bl, this.child(node2, !bl));
                        this.set(node2, !bl, node);
                        node = node.getUpdatedNode();
                        node.setBalance(0);
                        node2 = node2.getUpdatedNode();
                        node2.setBalance(0);
                    } else {
                        Node node3 = this.child(node2, !bl);
                        this.replace(session, node, node3);
                        this.set(node2, !bl, this.child(node3.getUpdatedNode(), bl));
                        this.set(node3, bl, node2);
                        this.set(node, bl, this.child(node3.getUpdatedNode(), !bl));
                        this.set(node3, !bl, node);
                        int n3 = node3.getUpdatedNode().getBalance();
                        node.getUpdatedNode().setBalance(n3 == -n2 ? n2 : 0);
                        node2.getUpdatedNode().setBalance(n3 == n2 ? -n2 : 0);
                        node3.getUpdatedNode().setBalance(0);
                    }
                    return;
                }
            }
            node = node.getUpdatedNode();
            if (node.isRoot()) {
                return;
            }
            bl = node.isFromLeft();
            node = node.getParent();
        }
    }

    void delete(Session session, Node object) throws HsqlException {
        Node node;
        Node node2;
        int n2;
        if (object == null) {
            return;
        }
        Object object2 = this.updatableIterators.next;
        while (object2 != this.updatableIterators) {
            ((IndexRowIterator)object2).updateForDelete((Node)object);
            object2 = ((IndexRowIterator)object2).next;
        }
        if (((Node)object).getLeft() == null) {
            object2 = ((Node)object).getRight();
        } else if (((Node)object).getRight() == null) {
            object2 = ((Node)object).getLeft();
        } else {
            Node node3 = object;
            object = ((Node)object).getLeft();
            Node node4 = object;
            while ((node4 = node4.getRight()) != null) {
                object = node4;
            }
            object2 = ((Node)object).getLeft();
            n2 = ((Node)object).getBalance();
            object = ((Node)object).getUpdatedNode();
            ((Node)object).setBalance(node3.getBalance());
            node3 = node3.getUpdatedNode();
            node3.setBalance(n2);
            node2 = ((Node)object).getParent();
            Node node5 = node3.getParent();
            object = ((Node)object).getUpdatedNode();
            if (node3.isRoot()) {
                this.setRoot(session, (Node)object);
            }
            ((Node)object).setParent(node5);
            if (node5 != null) {
                if ((node5 = node5.getUpdatedNode()).isRight(node3)) {
                    node5.setRight((Node)object);
                } else {
                    node5.setLeft((Node)object);
                }
            }
            if ((node3 = node3.getUpdatedNode()).equals(node2)) {
                node3.setParent((Node)object);
                if (node3.isLeft((Node)object)) {
                    object = ((Node)object).getUpdatedNode();
                    ((Node)object).setLeft(node3);
                    node = node3.getRight();
                    object = ((Node)object).getUpdatedNode();
                    ((Node)object).setRight(node);
                } else {
                    ((Node)object).setRight(node3);
                    node = node3.getLeft();
                    object = ((Node)object).getUpdatedNode();
                    ((Node)object).setLeft(node);
                }
            } else {
                node3.setParent(node2);
                node2 = node2.getUpdatedNode();
                node2.setRight(node3);
                node = node3.getLeft();
                Node node6 = node3.getRight();
                object = ((Node)object).getUpdatedNode();
                ((Node)object).setLeft(node);
                ((Node)object).setRight(node6);
            }
            ((Node)object).getRight().setParent((Node)object);
            ((Node)object).getLeft().setParent((Node)object);
            node3 = node3.getUpdatedNode();
            node3.setLeft((Node)object2);
            if (object2 != null) {
                object2 = ((Node)object2).getUpdatedNode();
                ((Node)object2).setParent(node3);
            }
            node3 = node3.getUpdatedNode();
            node3.setRight(null);
            object = node3;
        }
        boolean bl = ((Node)object).isFromLeft();
        this.replace(session, (Node)object, (Node)object2);
        object2 = ((Node)object).getParent();
        object = ((Node)object).getUpdatedNode();
        ((Node)object).delete();
        while (object2 != null) {
            object = object2;
            n2 = bl ? 1 : -1;
            object = ((Node)object).getUpdatedNode();
            switch (((Node)object).getBalance() * n2) {
                case -1: {
                    ((Node)object).setBalance(0);
                    break;
                }
                case 0: {
                    ((Node)object).setBalance(n2);
                    return;
                }
                case 1: {
                    node2 = this.child((Node)object, !bl);
                    int n3 = node2.getBalance();
                    if (n3 * n2 >= 0) {
                        this.replace(session, (Node)object, node2);
                        this.set((Node)object, !bl, this.child(node2, bl));
                        this.set(node2, bl, (Node)object);
                        if (n3 == 0) {
                            object = ((Node)object).getUpdatedNode();
                            ((Node)object).setBalance(n2);
                            node2 = node2.getUpdatedNode();
                            node2.setBalance(-n2);
                            return;
                        }
                        object = ((Node)object).getUpdatedNode();
                        ((Node)object).setBalance(0);
                        node2 = node2.getUpdatedNode();
                        node2.setBalance(0);
                        object = node2;
                        break;
                    }
                    node = this.child(node2, bl);
                    this.replace(session, (Node)object, node);
                    node = node.getUpdatedNode();
                    n3 = node.getBalance();
                    this.set(node2, bl, this.child(node, !bl));
                    this.set(node, !bl, node2);
                    this.set((Node)object, !bl, this.child(node, bl));
                    this.set(node, bl, (Node)object);
                    object = ((Node)object).getUpdatedNode();
                    ((Node)object).setBalance(n3 == n2 ? -n2 : 0);
                    node2 = node2.getUpdatedNode();
                    node2.setBalance(n3 == -n2 ? n2 : 0);
                    node = node.getUpdatedNode();
                    node.setBalance(0);
                    object = node;
                }
            }
            bl = ((Node)object).isFromLeft();
            object2 = ((Node)object).getParent();
        }
    }

    RowIterator findFirstRow(Session session, Object[] objectArray, int[] nArray) throws HsqlException {
        Node node = this.findNotNull(session, objectArray, nArray, true);
        return this.getIterator(session, node);
    }

    RowIterator findFirstRowForDelete(Session session, Object[] objectArray, int[] nArray) throws HsqlException {
        Node node = this.findNotNull(session, objectArray, nArray, true);
        IndexRowIterator indexRowIterator = this.getIterator(session, node);
        if (node != null) {
            this.updatableIterators.link(indexRowIterator);
        }
        return indexRowIterator;
    }

    Row findRow(Session session, Row row) throws HsqlException {
        Node node = this.search(session, row);
        return node == null ? null : node.getRow();
    }

    boolean exists(Session session, Object[] objectArray, int[] nArray) throws HsqlException {
        return this.findNotNull(session, objectArray, nArray, true) != null;
    }

    RowIterator emptyIterator() {
        return emptyIterator;
    }

    private Node findNotNull(Session session, Object[] objectArray, int[] nArray, boolean bl) throws HsqlException {
        Node node = this.getRoot(session);
        Node node2 = null;
        if (Index.isNull(objectArray, nArray)) {
            return null;
        }
        while (node != null) {
            Node node3;
            int n2 = this.compareRowNonUnique(session, objectArray, nArray, node.getData());
            if (n2 == 0) {
                if (!bl) {
                    node2 = node;
                    break;
                }
                if (node2 == node) break;
                node2 = node;
                node3 = node.getLeft();
            } else {
                node3 = n2 > 0 ? node.getRight() : node.getLeft();
            }
            if (node3 == null) break;
            node = node3;
        }
        return node2;
    }

    static boolean isNull(Object[] objectArray, int[] nArray) {
        int n2 = nArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (objectArray[nArray[i2]] != null) continue;
            return true;
        }
        return false;
    }

    boolean isNull(Object[] objectArray) {
        int n2 = this.colIndex.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = this.colIndex[i2];
            if (objectArray[n3] != null) continue;
            return true;
        }
        return false;
    }

    RowIterator findFirstRow(Session session, Object[] objectArray) throws HsqlException {
        boolean bl;
        Node node = this.getRoot(session);
        Node node2 = null;
        boolean bl2 = bl = this.isUnique && !this.isNull(objectArray);
        while (node != null) {
            int n2 = this.compareRowNonUnique(session, objectArray, this.colIndex, node.getData());
            if (n2 == 0) {
                node2 = node;
                if (bl) break;
                node = node.getLeft();
                continue;
            }
            if (n2 < 0) {
                node = node.getLeft();
                continue;
            }
            node = node.getRight();
        }
        return this.getIterator(session, node2);
    }

    RowIterator findFirstRow(Session session, Object object, int n2) throws HsqlException {
        boolean bl = n2 == 21 || n2 == 34;
        Node node = this.getRoot(session);
        int n3 = 1;
        if (n2 == 23) {
            n3 = 0;
        }
        if (object == null && !bl) {
            return emptyIterator;
        }
        while (node != null) {
            Node node2;
            boolean bl2;
            boolean bl3 = bl2 = Column.compare(this.collation, object, node.getData()[this.colIndex[0]], this.colTypes[0]) >= n3;
            if (bl2) {
                node2 = node.getRight();
                if (node2 == null) break;
                node = node2;
                continue;
            }
            node2 = node.getLeft();
            if (node2 == null) break;
            node = node2;
        }
        while (node != null) {
            Object object2 = node.getData()[this.colIndex[0]];
            int n4 = Column.compare(this.collation, object, object2, this.colTypes[0]);
            if (n4 >= n3) {
                node = this.next(node);
                continue;
            }
            if (bl) {
                if (n4 == 0) break;
                node = null;
                break;
            }
            if (object2 != null) break;
            node = this.next(node);
        }
        return this.getIterator(session, node);
    }

    RowIterator findFirstRowNotNull(Session session) throws HsqlException {
        Object object;
        Node node = this.getRoot(session);
        while (node != null) {
            Node node2;
            boolean bl;
            boolean bl2 = bl = Column.compare(this.collation, null, node.getData()[this.colIndex[0]], this.colTypes[0]) >= 0;
            if (bl) {
                node2 = node.getRight();
                if (node2 == null) break;
                node = node2;
                continue;
            }
            node2 = node.getLeft();
            if (node2 == null) break;
            node = node2;
        }
        while (node != null && (object = node.getData()[this.colIndex[0]]) == null) {
            node = this.next(node);
        }
        return this.getIterator(session, node);
    }

    RowIterator firstRow(Session session) throws HsqlException {
        Node node;
        this.depth = 0;
        Node node2 = node = this.getRoot(session);
        while (node2 != null) {
            node = node2;
            node2 = node.getLeft();
            ++this.depth;
        }
        return this.getIterator(session, node);
    }

    Row lastRow(Session session) throws HsqlException {
        Node node;
        Node node2 = node = this.getRoot(session);
        while (node2 != null) {
            node = node2;
            node2 = node.getRight();
        }
        return node == null ? null : node.getRow();
    }

    Node next(Node node) throws HsqlException {
        if (node == null) {
            return null;
        }
        Node node2 = node.getRight();
        if (node2 != null) {
            node = node2;
            Node node3 = node.getLeft();
            while (node3 != null) {
                node = node3;
                node3 = node.getLeft();
            }
            return node;
        }
        Node node4 = node;
        for (node = node.getParent(); node != null && node4.equals(node.getRight()); node = node.getParent()) {
            node4 = node;
        }
        return node;
    }

    private Node child(Node node, boolean bl) throws HsqlException {
        return bl ? node.getLeft() : node.getRight();
    }

    private void replace(Session session, Node node, Node node2) throws HsqlException {
        if (node.isRoot()) {
            if (node2 != null) {
                node2 = node2.getUpdatedNode();
                node2.setParent(null);
            }
            this.setRoot(session, node2);
        } else {
            this.set(node.getParent(), node.isFromLeft(), node2);
        }
    }

    private void set(Node node, boolean bl, Node node2) throws HsqlException {
        node = node.getUpdatedNode();
        if (bl) {
            node.setLeft(node2);
        } else {
            node.setRight(node2);
        }
        if (node2 != null) {
            node2 = node2.getUpdatedNode();
            node2.setParent(node);
        }
    }

    private Node search(Session session, Row row) throws HsqlException {
        Object[] objectArray = row.getData();
        Node node = this.getRoot(session);
        while (node != null) {
            int n2 = this.compareRowForInsert(session, row, node.getRow());
            if (n2 == 0) {
                return node;
            }
            if (n2 < 0) {
                node = node.getLeft();
                continue;
            }
            node = node.getRight();
        }
        return null;
    }

    int compareRowNonUnique(Session session, Object[] objectArray, int[] nArray, Object[] objectArray2) throws HsqlException {
        int n2 = Column.compare(this.collation, objectArray[nArray[0]], objectArray2[this.colIndex[0]], this.colTypes[0]);
        if (n2 != 0) {
            return n2;
        }
        int n3 = nArray.length;
        for (int i2 = 1; i2 < n3; ++i2) {
            n2 = Column.compare(this.collation, objectArray[nArray[i2]], objectArray2[this.colIndex[i2]], this.colTypes[i2]);
            if (n2 == 0) continue;
            return n2;
        }
        return 0;
    }

    static int compareRows(Session session, Object[] objectArray, Object[] objectArray2, int[] nArray, int[] nArray2) throws HsqlException {
        int n2 = nArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = Column.compare(session.database.collation, objectArray[nArray[i2]], objectArray2[nArray[i2]], nArray2[nArray[i2]]);
            if (n3 == 0) continue;
            return n3;
        }
        return 0;
    }

    private int compareRowForInsert(Session session, Row row, Row row2) throws HsqlException {
        int n2;
        Object object;
        int n3;
        Object[] objectArray = row.getData();
        Object[] objectArray2 = row2.getData();
        boolean bl = false;
        for (n3 = 0; n3 < this.colIndex.length; ++n3) {
            object = objectArray[this.colIndex[n3]];
            n2 = Column.compare(this.collation, object, objectArray2[this.colIndex[n3]], this.colTypes[n3]);
            if (n2 != 0) {
                return n2;
            }
            if (object != null) continue;
            bl = true;
        }
        if (this.isUnique && !this.useRowId && !bl) {
            return 0;
        }
        for (n3 = 0; n3 < this.pkCols.length; ++n3) {
            object = objectArray[this.pkCols[n3]];
            n2 = Column.compare(this.collation, object, objectArray2[this.pkCols[n3]], this.pkTypes[n3]);
            if (n2 == 0) continue;
            return n2;
        }
        if (this.useRowId) {
            int n4 = row.getPos() - row2.getPos();
            if (n4 < 0) {
                n4 = -1;
            } else if (n4 > 0) {
                n4 = 1;
            }
            return n4;
        }
        return 0;
    }

    int getIndexOrderValue() {
        boolean bl = false;
        if (this.isConstraint) {
            return this.isForward ? 4 : (this.isUnique ? 0 : 1);
        }
        return 2;
    }

    private IndexRowIterator getIterator(Session session, Node node) {
        if (node == null) {
            return emptyIterator;
        }
        IndexRowIterator indexRowIterator = new IndexRowIterator(session, this, node);
        return indexRowIterator;
    }

    static class IndexRowIterator
    implements RowIterator {
        Session session;
        Index index;
        Node nextnode;
        protected IndexRowIterator last;
        protected IndexRowIterator next;

        private IndexRowIterator(Session session, Index index, Node node) {
            if (index == null) {
                return;
            }
            this.session = session;
            this.index = index;
            this.nextnode = node;
        }

        public boolean hasNext() {
            return this.nextnode != null;
        }

        public Row next() {
            if (this.hasNext()) {
                try {
                    Row row = this.nextnode.getRow();
                    this.nextnode = this.index.next(this.nextnode);
                    return row;
                }
                catch (Exception exception) {
                    throw new NoSuchElementException(exception.getMessage());
                }
            }
            return null;
        }

        void updateForDelete(Node node) {
            try {
                if (node.equals(this.nextnode)) {
                    this.nextnode = this.index.next(node);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        void link(IndexRowIterator indexRowIterator) {
            indexRowIterator.next = this.next;
            indexRowIterator.last = this;
            this.next.last = indexRowIterator;
            this.next = indexRowIterator;
        }

        public void release() {
            if (this.last != null) {
                this.last.next = this.next;
            }
            if (this.next != null) {
                this.next.last = this.last;
            }
        }
    }
}

