/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.hsqldb.HsqlException;
import org.hsqldb.Trace;

public class HsqlDateTime {
    private static Calendar today = new GregorianCalendar();
    private static Calendar tempCal = new GregorianCalendar();
    private static Calendar tempCalDefault = new GregorianCalendar();
    private static Calendar tempCalGMT = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
    private static java.sql.Date tempDate = new java.sql.Date(0L);
    private static java.sql.Date currentDate;
    static final String zerodatetime = "1970-01-01 00:00:00.000000000";
    static final String zeronanos = "000000000";
    private static final String sdftPattern = "HH:mm:ss";
    private static final String sdfdPattern = "yyyy-MM-dd";
    private static final String sdftsPattern = "yyyy-MM-dd HH:mm:ss.";
    private static final String sdftsSysPattern = "yyyy-MM-dd HH:mm:ss.SSS";
    static SimpleDateFormat sdfd;
    static SimpleDateFormat sdft;
    static SimpleDateFormat sdfts;
    static SimpleDateFormat sdftsSys;
    private static Date sysDate;
    private static final char[][] dateTokens;
    private static final String[] javaDateTokens;
    public static final char e = '\uffff';

    public static Timestamp timestampValue(String string) throws HsqlException {
        if (string == null) {
            throw Trace.error(131);
        }
        if (string.length() > zerodatetime.length()) {
            throw Trace.error(124);
        }
        string = string + zerodatetime.substring(string.length());
        return Timestamp.valueOf(string);
    }

    public static Timestamp simpleTimestampValue(String string) {
        return Timestamp.valueOf(string);
    }

    public static Timestamp timestampValue(long l2, int n2) {
        Timestamp timestamp = new Timestamp(l2);
        timestamp.setNanos(n2);
        return timestamp;
    }

    public static java.sql.Date dateValue(String string) throws HsqlException {
        if (string == null) {
            throw Trace.error(131);
        }
        if (string.length() > sdfdPattern.length()) {
            string = string.substring(0, sdfdPattern.length());
        }
        return java.sql.Date.valueOf(string);
    }

    public static Time timeValue(String string) {
        if (string == null) {
            throw new IllegalArgumentException(Trace.getMessage(131));
        }
        return Time.valueOf(string);
    }

    static int compare(java.sql.Date date, java.sql.Date date2) {
        long l2;
        long l3 = date.getTime();
        if (l3 == (l2 = date2.getTime())) {
            return 0;
        }
        return l3 > l2 ? 1 : -1;
    }

    static int compare(Time time, Time time2) {
        long l2;
        long l3 = time.getTime();
        if (l3 == (l2 = time2.getTime())) {
            return 0;
        }
        return l3 > l2 ? 1 : -1;
    }

    static int compare(Timestamp timestamp, Timestamp timestamp2) {
        long l2;
        long l3 = timestamp.getTime();
        if (l3 == (l2 = timestamp2.getTime())) {
            if (timestamp.getNanos() == timestamp2.getNanos()) {
                return 0;
            }
            return timestamp.getNanos() > timestamp2.getNanos() ? 1 : -1;
        }
        return l3 > l2 ? 1 : -1;
    }

    public static synchronized java.sql.Date getCurrentDate(long l2) {
        HsqlDateTime.getToday(l2);
        return currentDate;
    }

    public static Timestamp getTimestamp(long l2) {
        return new Timestamp(l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTimestampString(Timestamp timestamp) {
        SimpleDateFormat simpleDateFormat = sdfts;
        synchronized (simpleDateFormat) {
            sdfts.setCalendar(tempCalDefault);
            String string = String.valueOf(timestamp.getNanos());
            return sdfts.format(timestamp) + zeronanos.substring(string.length()) + string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTimestampString(Timestamp timestamp, Calendar calendar) {
        SimpleDateFormat simpleDateFormat = sdfts;
        synchronized (simpleDateFormat) {
            sdfts.setCalendar(calendar == null ? tempCalDefault : calendar);
            String string = String.valueOf(timestamp.getNanos());
            return sdfts.format(timestamp) + zeronanos.substring(string.length()) + string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSytemTimeString() {
        SimpleDateFormat simpleDateFormat = sdftsSys;
        synchronized (simpleDateFormat) {
            sysDate.setTime(System.currentTimeMillis());
            return sdftsSys.format(sysDate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTimestampString(long l2) {
        SimpleDateFormat simpleDateFormat = sdftsSys;
        synchronized (simpleDateFormat) {
            sysDate.setTime(l2);
            return sdftsSys.format(sysDate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTimeString(Date date, Calendar calendar) {
        SimpleDateFormat simpleDateFormat = sdft;
        synchronized (simpleDateFormat) {
            sdft.setCalendar(calendar == null ? tempCalDefault : calendar);
            return sdft.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDateString(Date date, Calendar calendar) {
        SimpleDateFormat simpleDateFormat = sdfd;
        synchronized (simpleDateFormat) {
            sdfd.setCalendar(calendar == null ? tempCalDefault : calendar);
            return sdfd.format(date);
        }
    }

    static synchronized Calendar getToday(long l2) {
        if (l2 - HsqlDateTime.getTimeInMillis(today) >= 86400000L) {
            HsqlDateTime.resetToday(l2);
        }
        return today;
    }

    public static void resetToDate(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
    }

    public static void resetToTime(Calendar calendar) {
        calendar.set(1, 1970);
        calendar.set(2, 0);
        calendar.set(5, 1);
        calendar.set(14, 0);
    }

    private static synchronized void resetToday(long l2) {
        today.setTimeInMillis(l2);
        HsqlDateTime.resetToDate(today);
        currentDate = new java.sql.Date(HsqlDateTime.getTimeInMillis(today));
    }

    private static void setTimeInMillis(Calendar calendar, long l2) {
        calendar.setTimeInMillis(l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getTimeInMillis(Date date, Calendar calendar, Calendar calendar2) {
        if (calendar == null) {
            calendar = tempCalDefault;
        }
        if (calendar2 == null) {
            calendar2 = tempCalDefault;
        }
        Calendar calendar3 = tempCal;
        synchronized (calendar3) {
            tempCal.setTimeZone(calendar.getTimeZone());
            tempCal.setTime(date);
            tempCal.setTimeZone(calendar2.getTimeZone());
            return HsqlDateTime.getTimeInMillis(tempCal);
        }
    }

    public static long getTimeInMillis(Calendar calendar) {
        return calendar.getTimeInMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getNormalisedTime(long l2) {
        Calendar calendar = tempCalDefault;
        synchronized (calendar) {
            HsqlDateTime.setTimeInMillis(tempCalDefault, l2);
            HsqlDateTime.resetToTime(tempCalDefault);
            return HsqlDateTime.getTimeInMillis(tempCalDefault);
        }
    }

    public static Time getNormalisedTime(Time time) {
        return new Time(HsqlDateTime.getNormalisedTime(time.getTime()));
    }

    public static Time getNormalisedTime(Timestamp timestamp) {
        return new Time(HsqlDateTime.getNormalisedTime(timestamp.getTime()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getNormalisedDate(long l2) {
        Calendar calendar = tempCalDefault;
        synchronized (calendar) {
            HsqlDateTime.setTimeInMillis(tempCalDefault, l2);
            HsqlDateTime.resetToDate(tempCalDefault);
            return HsqlDateTime.getTimeInMillis(tempCalDefault);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static java.sql.Date getNormalisedDate(Timestamp timestamp) {
        Calendar calendar = tempCalDefault;
        synchronized (calendar) {
            HsqlDateTime.setTimeInMillis(tempCalDefault, timestamp.getTime());
            HsqlDateTime.resetToDate(tempCalDefault);
            long l2 = HsqlDateTime.getTimeInMillis(tempCalDefault);
            return new java.sql.Date(l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static java.sql.Date getNormalisedDate(java.sql.Date date) {
        Calendar calendar = tempCalDefault;
        synchronized (calendar) {
            HsqlDateTime.setTimeInMillis(tempCalDefault, date.getTime());
            HsqlDateTime.resetToDate(tempCalDefault);
            long l2 = HsqlDateTime.getTimeInMillis(tempCalDefault);
            return new java.sql.Date(l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Timestamp getNormalisedTimestamp(Time time) {
        Calendar calendar = tempCalDefault;
        synchronized (calendar) {
            HsqlDateTime.setTimeInMillis(tempCalDefault, System.currentTimeMillis());
            HsqlDateTime.resetToDate(tempCalDefault);
            long l2 = HsqlDateTime.getTimeInMillis(tempCalDefault) + time.getTime();
            return new Timestamp(l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Timestamp getNormalisedTimestamp(java.sql.Date date) {
        Calendar calendar = tempCalDefault;
        synchronized (calendar) {
            HsqlDateTime.setTimeInMillis(tempCalDefault, date.getTime());
            HsqlDateTime.resetToDate(tempCalDefault);
            long l2 = HsqlDateTime.getTimeInMillis(tempCalDefault);
            return new Timestamp(l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getDateTimePart(Date date, int n2) {
        Calendar calendar = tempCalDefault;
        synchronized (calendar) {
            tempCalDefault.setTime(date);
            return tempCalDefault.get(n2);
        }
    }

    public static String toJavaDatePattern(String string) {
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n2);
        Tokenizer tokenizer = new Tokenizer();
        for (int i2 = 0; i2 <= n2; ++i2) {
            char c2;
            char c3 = c2 = i2 == n2 ? (char)'\uffff' : (char)string.charAt(i2);
            if (!tokenizer.next(c2, dateTokens)) {
                int n3 = tokenizer.getLastMatch();
                if (n3 >= 0) {
                    stringBuffer.setLength(stringBuffer.length() - tokenizer.length());
                    stringBuffer.append(javaDateTokens[n3]);
                }
                tokenizer.reset();
                if (tokenizer.isConsumed()) continue;
            }
            stringBuffer.append(c2);
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    static {
        HsqlDateTime.resetToday(System.currentTimeMillis());
        sdfd = new SimpleDateFormat(sdfdPattern);
        sdft = new SimpleDateFormat(sdftPattern);
        sdfts = new SimpleDateFormat(sdftsPattern);
        sdftsSys = new SimpleDateFormat(sdftsSysPattern);
        sysDate = new Date();
        dateTokens = new char[][]{{'R', 'R', 'R', 'R'}, {'I', 'Y', 'Y', 'Y'}, {'Y', 'Y', 'Y', 'Y'}, {'I', 'Y'}, {'Y', 'Y'}, {'B', 'C'}, {'B', '.', 'C', '.'}, {'A', 'D'}, {'A', '.', 'D', '.'}, {'M', 'O', 'N'}, {'M', 'O', 'N', 'T', 'H'}, {'D'}, {'I', 'W'}, {'D', 'D'}, {'D', 'D', 'D'}, {'H', 'H', '2', '4'}, {'H', 'H', '1', '2'}, {'H', 'H'}, {'M', 'I'}, {'S', 'S'}, {'A', 'M'}, {'P', 'M'}, {'A', '.', 'M', '.'}, {'P', '.', 'M', '.'}};
        javaDateTokens = new String[]{"yyyy", "yyyy", "yyyy", "yy", "yy", "G", "G", "G", "G", "MMM", "MMMMM", "E", "w", "dd", "D", "k", "K", "K", "mm", "ss", "aaa", "aaa", "aaa", "aaa"};
    }

    static class Tokenizer {
        private int last;
        private int offset;
        private long state;
        private boolean consumed;

        public Tokenizer() {
            this.reset();
        }

        public void reset() {
            this.last = -1;
            this.offset = -1;
            this.state = 0L;
        }

        public int length() {
            return this.offset;
        }

        public int getLastMatch() {
            return this.last;
        }

        public boolean isConsumed() {
            return this.consumed;
        }

        private boolean isZeroBit(int n2) {
            return (this.state & 1L << n2) == 0L;
        }

        private void setBit(int n2) {
            this.state |= 1L << n2;
        }

        public boolean next(char c2, char[][] cArray) {
            int n2 = ++this.offset;
            int n3 = this.offset + 1;
            int n4 = 0;
            this.consumed = false;
            int n5 = cArray.length;
            while (--n5 >= 0) {
                if (!this.isZeroBit(n5)) continue;
                if (cArray[n5][n2] == c2) {
                    this.consumed = true;
                    if (cArray[n5].length == n3) {
                        this.setBit(n5);
                        this.last = n5;
                        continue;
                    }
                    ++n4;
                    continue;
                }
                this.setBit(n5);
            }
            return n4 > 0;
        }
    }
}

