/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.util.Locale;
import org.hsqldb.persist.HsqlProperties;

public class DatabaseURL {
    static final String S_DOT = ".";
    public static final String S_MEM = "mem:";
    public static final String S_FILE = "file:";
    public static final String S_RES = "res:";
    public static final String S_ALIAS = "alias:";
    public static final String S_HSQL = "hsql://";
    public static final String S_HSQLS = "hsqls://";
    public static final String S_HTTP = "http://";
    public static final String S_HTTPS = "https://";
    public static final String S_URL_PREFIX = "jdbc:hsqldb:";

    public static boolean isFileBasedDatabaseType(String string) {
        return string == S_FILE || string == S_RES;
    }

    public static boolean isInProcessDatabaseType(String string) {
        return string == S_FILE || string == S_RES || string == S_MEM;
    }

    public static HsqlProperties parseURL(String string, boolean bl) {
        String string2;
        String string3 = string.toLowerCase(Locale.ENGLISH);
        HsqlProperties hsqlProperties = new HsqlProperties();
        HsqlProperties hsqlProperties2 = null;
        String string4 = null;
        int n2 = 0;
        if (bl) {
            if (string3.startsWith(S_URL_PREFIX)) {
                n2 = S_URL_PREFIX.length();
            } else {
                return hsqlProperties;
            }
        }
        String string5 = null;
        int n3 = 0;
        boolean bl2 = false;
        hsqlProperties.setProperty("url", string);
        int n4 = string.indexOf(59, n2);
        if (n4 < 0) {
            n4 = string.length();
        } else {
            string4 = string3.substring(n4 + 1, string3.length());
            hsqlProperties2 = HsqlProperties.delimitedArgPairsToProps(string4, "=", ";", null);
            hsqlProperties.addProperties(hsqlProperties2);
        }
        if (n4 == n2 + 1 && string3.startsWith(S_DOT, n2)) {
            string5 = S_DOT;
        } else if (string3.startsWith(S_MEM, n2)) {
            string5 = S_MEM;
        } else if (string3.startsWith(S_FILE, n2)) {
            string5 = S_FILE;
        } else if (string3.startsWith(S_RES, n2)) {
            string5 = S_RES;
        } else if (string3.startsWith(S_ALIAS, n2)) {
            string5 = S_ALIAS;
        } else if (string3.startsWith(S_HSQL, n2)) {
            string5 = S_HSQL;
            n3 = 9001;
            bl2 = true;
        } else if (string3.startsWith(S_HSQLS, n2)) {
            string5 = S_HSQLS;
            n3 = 554;
            bl2 = true;
        } else if (string3.startsWith(S_HTTP, n2)) {
            string5 = S_HTTP;
            n3 = 80;
            bl2 = true;
        } else if (string3.startsWith(S_HTTPS, n2)) {
            string5 = S_HTTPS;
            n3 = 443;
            bl2 = true;
        }
        if (string5 == null) {
            string5 = S_FILE;
        } else if (string5 == S_DOT) {
            string5 = S_MEM;
        } else {
            n2 += string5.length();
        }
        hsqlProperties.setProperty("connection_type", string5);
        if (bl2) {
            String string6;
            String string7;
            int n5;
            int n6 = string.indexOf(47, n2);
            if (n6 < n2 || n6 > n4) {
                n6 = n4;
            }
            if ((n5 = string.indexOf(58, n2)) < n2 || n5 > n6) {
                n5 = n6;
            } else {
                try {
                    n3 = Integer.parseInt(string.substring(n5 + 1, n6));
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            }
            String string8 = string3.substring(n2, n5);
            int n7 = string.lastIndexOf(47, n4);
            if (n7 < n2) {
                string7 = "/";
                string2 = "";
            } else if (n7 == n6) {
                string7 = "/";
                string2 = string3.substring(n7 + 1, n4);
            } else {
                string7 = string.substring(n6, n7);
                string2 = string3.substring(n7 + 1, n4);
            }
            hsqlProperties.setProperty("port", n3);
            hsqlProperties.setProperty("host", string8);
            hsqlProperties.setProperty("path", string7);
            if (hsqlProperties2 != null && (string6 = hsqlProperties2.getProperty("filepath")) != null && string2.length() != 0) {
                string2 = string2 + ";" + string6;
            }
        } else {
            if (string5 == S_MEM || string5 == S_RES) {
                string2 = string3.substring(n2, n4).toLowerCase();
                if (string5 == S_RES && string2.indexOf(47) != 0) {
                    string2 = '/' + string2;
                }
            } else {
                string2 = string.substring(n2, n4);
            }
            if (string2.length() == 0) {
                return null;
            }
        }
        hsqlProperties.setProperty("database", string2);
        return hsqlProperties;
    }
}

