/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.Locale;
import org.hsqldb.Column;
import org.hsqldb.CompiledStatement;
import org.hsqldb.Constraint;
import org.hsqldb.Database;
import org.hsqldb.DatabaseScript;
import org.hsqldb.Expression;
import org.hsqldb.GranteeManager;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.Parser;
import org.hsqldb.Result;
import org.hsqldb.Select;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TableWorks;
import org.hsqldb.TextTable;
import org.hsqldb.Token;
import org.hsqldb.Tokenizer;
import org.hsqldb.Trace;
import org.hsqldb.TriggerDef;
import org.hsqldb.Types;
import org.hsqldb.User;
import org.hsqldb.View;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.persist.HsqlDatabaseProperties;
import org.hsqldb.scriptio.ScriptWriterBase;
import org.hsqldb.scriptio.ScriptWriterText;

class DatabaseCommandInterpreter {
    private Tokenizer tokenizer = new Tokenizer();
    private Database database;
    private Session session;
    static final String oldLib = "org.hsql.Library.";
    static final int oldLibLen = "org.hsql.Library.".length();
    static final String newLib = "org.hsqldb.Library.";

    DatabaseCommandInterpreter(Session session) {
        this.session = session;
        this.database = session.getDatabase();
    }

    Result execute(String string) {
        JavaSystem.gc();
        Result result = null;
        int n2 = -1;
        try {
            this.tokenizer.reset(string);
            while (true) {
                this.tokenizer.setPartMarker();
                this.session.setScripting(false);
                String string2 = this.tokenizer.getSimpleToken();
                if (string2.length() == 0) {
                    this.session.endSchemaDefinition();
                    break;
                }
                n2 = Token.get(string2);
                if (n2 == 323) {
                    this.session.endSchemaDefinition();
                    continue;
                }
                result = this.executePart(n2, string2);
                if (result.isError()) {
                    this.session.endSchemaDefinition();
                    break;
                }
                if (!this.session.getScripting()) continue;
                this.database.logger.writeToLog(this.session, this.tokenizer.getLastPart());
            }
        }
        catch (Throwable throwable) {
            try {
                if (this.session.isSchemaDefintion()) {
                    HsqlNameManager.HsqlName hsqlName = this.session.getSchemaHsqlName(null);
                    this.database.schemaManager.dropSchema(hsqlName.name, true);
                    this.database.logger.writeToLog(this.session, "DROP SCHEMA " + hsqlName.statementName + ' ' + "CASCADE");
                    this.session.endSchemaDefinition();
                }
            }
            catch (HsqlException hsqlException) {
                // empty catch block
            }
            result = new Result(throwable, this.tokenizer.getLastPart());
        }
        return result == null ? Session.emptyUpdateCount : result;
    }

    private Result executePart(int n2, String string) throws Throwable {
        Result result = Session.emptyUpdateCount;
        int n3 = 0;
        if (this.session.isSchemaDefintion()) {
            switch (n2) {
                case 41: 
                case 96: {
                    break;
                }
                default: {
                    throw Trace.error(74, 250, new Object[]{string});
                }
            }
        }
        switch (n2) {
            case 313: {
                Parser parser = new Parser(this.session, this.database, this.tokenizer);
                n3 = parser.parseOpenBracketsSelect() + 1;
            }
            case 193: {
                Parser parser = new Parser(this.session, this.database, this.tokenizer);
                CompiledStatement compiledStatement = parser.compileSelectStatement(n3);
                if (compiledStatement.parameters.length != 0) {
                    Trace.doAssert(false, Trace.getMessage(165));
                }
                result = this.session.sqlExecuteCompiledNoPreChecks(compiledStatement, null);
                break;
            }
            case 112: {
                Parser parser = new Parser(this.session, this.database, this.tokenizer);
                CompiledStatement compiledStatement = parser.compileInsertStatement();
                if (compiledStatement.parameters.length != 0) {
                    Trace.doAssert(false, Trace.getMessage(165));
                }
                result = this.session.sqlExecuteCompiledNoPreChecks(compiledStatement, null);
                break;
            }
            case 222: {
                Parser parser = new Parser(this.session, this.database, this.tokenizer);
                CompiledStatement compiledStatement = parser.compileUpdateStatement();
                if (compiledStatement.parameters.length != 0) {
                    Trace.doAssert(false, Trace.getMessage(165));
                }
                result = this.session.sqlExecuteCompiledNoPreChecks(compiledStatement, null);
                break;
            }
            case 62: {
                Parser parser = new Parser(this.session, this.database, this.tokenizer);
                CompiledStatement compiledStatement = parser.compileDeleteStatement();
                if (compiledStatement.parameters.length != 0) {
                    Trace.doAssert(false, Trace.getMessage(165));
                }
                result = this.session.sqlExecuteCompiledNoPreChecks(compiledStatement, null);
                break;
            }
            case 23: {
                Parser parser = new Parser(this.session, this.database, this.tokenizer);
                CompiledStatement compiledStatement = parser.compileCallStatement();
                if (compiledStatement.parameters.length != 0) {
                    Trace.doAssert(false, Trace.getMessage(165));
                }
                result = this.session.sqlExecuteCompiledNoPreChecks(compiledStatement, null);
                break;
            }
            case 196: {
                this.processSet();
                break;
            }
            case 35: {
                this.processCommit();
                break;
            }
            case 184: {
                this.processRollback();
                break;
            }
            case 188: {
                this.processSavepoint();
                break;
            }
            case 176: {
                this.processReleaseSavepoint();
                break;
            }
            case 41: {
                this.processCreate();
                this.database.setMetaDirty(false);
                break;
            }
            case 4: {
                this.processAlter();
                this.database.setMetaDirty(true);
                break;
            }
            case 70: {
                this.processDrop();
                this.database.setMetaDirty(true);
                break;
            }
            case 96: {
                this.processGrantOrRevoke(true);
                this.database.setMetaDirty(false);
                break;
            }
            case 182: {
                this.processGrantOrRevoke(false);
                this.database.setMetaDirty(true);
                break;
            }
            case 37: {
                this.processConnect();
                this.database.setMetaDirty(false);
                this.session.setScripting(false);
                break;
            }
            case 66: {
                this.processDisconnect();
                this.session.setScripting(true);
                break;
            }
            case 321: {
                result = this.processScript();
                break;
            }
            case 325: {
                this.processShutdown();
                break;
            }
            case 303: {
                this.processCheckpoint();
                break;
            }
            case 304: {
                result = this.processExplainPlan();
                break;
            }
            default: {
                throw Trace.error(11, string);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result processScript() throws IOException, HsqlException {
        String string = this.tokenizer.getString();
        ScriptWriterBase scriptWriterBase = null;
        this.session.checkAdmin();
        try {
            if (this.tokenizer.wasValue()) {
                if (this.tokenizer.getType() != 12) {
                    throw Trace.error(74);
                }
                scriptWriterBase = new ScriptWriterText(this.database, string, true, true, true);
                scriptWriterBase.writeAll();
                Result result = new Result(1);
                return result;
            }
            this.tokenizer.back();
            Result result = DatabaseScript.getScript(this.database, false);
            return result;
        }
        finally {
            if (scriptWriterBase != null) {
                scriptWriterBase.close();
            }
        }
    }

    private void processCreate() throws HsqlException {
        boolean bl = false;
        boolean bl2 = false;
        this.session.checkAdmin();
        this.session.checkDDLWrite();
        this.session.setScripting(true);
        if (this.tokenizer.isGetThis("GLOBAL")) {
            this.tokenizer.getThis("TEMPORARY");
            bl2 = true;
        } else if (this.tokenizer.isGetThis("TEMP")) {
            bl2 = true;
        } else if (this.tokenizer.isGetThis("TEMPORARY")) {
            bl2 = true;
        }
        String string = this.tokenizer.getSimpleToken();
        switch (Token.get(string)) {
            case 310: {
                this.tokenizer.getThis("TABLE");
            }
            case 213: {
                int n2 = bl2 ? 2 : this.database.getDefaultTableType();
                this.processCreateTable(n2);
                return;
            }
            case 302: {
                if (bl2) {
                    throw Trace.error(11, string);
                }
                this.tokenizer.getThis("TABLE");
                this.processCreateTable(4);
                return;
            }
            case 328: {
                if (bl2) {
                    throw Trace.error(11, string);
                }
                this.tokenizer.getThis("TABLE");
                this.processCreateTable(6);
                return;
            }
        }
        if (bl2) {
            throw Trace.error(11, string);
        }
        switch (Token.get(string)) {
            case 300: {
                this.processCreateAlias();
                break;
            }
            case 324: {
                this.processCreateSequence();
                break;
            }
            case 338: {
                this.session.setScripting(false);
                this.processCreateSchema();
                break;
            }
            case 224: {
                this.processCreateTrigger();
                break;
            }
            case 223: {
                this.processCreateUser();
                break;
            }
            case 339: {
                this.database.getGranteeManager().addRole(this.getUserIdentifier());
                break;
            }
            case 329: {
                this.processCreateView();
                break;
            }
            case 228: {
                bl = true;
                this.tokenizer.getThis("INDEX");
            }
            case 306: {
                this.processCreateIndex(bl);
                break;
            }
            default: {
                throw Trace.error(11, string);
            }
        }
    }

    private int[] processColumnList(Table table, boolean bl) throws HsqlException {
        HashMappedList hashMappedList = Parser.processColumnList(this.tokenizer, bl);
        int n2 = hashMappedList.size();
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = table.getColumnNr((String)hashMappedList.getKey(i2));
        }
        return nArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processCreateTrigger() throws HsqlException {
        String string = this.tokenizer.getName();
        String string2 = this.tokenizer.getLongNameFirst();
        this.database.schemaManager.checkTriggerExists(string, this.session.getSchemaNameForWrite(string2), false);
        boolean bl = this.tokenizer.wasQuotedIdentifier();
        boolean bl2 = false;
        boolean bl3 = false;
        int n2 = TriggerDef.getDefaultQueueSize();
        String string3 = this.tokenizer.getSimpleToken();
        String string4 = this.tokenizer.getSimpleToken();
        this.tokenizer.getThis("ON");
        String string5 = this.tokenizer.getName();
        if (string2 == null) {
            string2 = this.session.getSchemaNameForWrite(this.tokenizer.getLongNameFirst());
        } else if (!string2.equals(this.session.getSchemaNameForWrite(this.tokenizer.getLongNameFirst()))) {
            throw Trace.error(227);
        }
        Table table = this.database.schemaManager.getUserTable(this.session, string5, string2);
        if (table.isView()) {
            throw Trace.error(55);
        }
        this.session.setScripting(true);
        String string6 = this.tokenizer.getSimpleToken();
        if (string6.equals("FOR")) {
            string6 = this.tokenizer.getSimpleToken();
            if (!string6.equals("EACH")) throw Trace.error(12, string6);
            string6 = this.tokenizer.getSimpleToken();
            if (!string6.equals("ROW")) throw Trace.error(12, string6);
            bl2 = true;
            string6 = this.tokenizer.getSimpleToken();
        }
        if (string6.equals("NOWAIT")) {
            bl3 = true;
            string6 = this.tokenizer.getSimpleToken();
        }
        if (string6.equals("QUEUE")) {
            n2 = this.tokenizer.getInt();
            string6 = this.tokenizer.getSimpleToken();
        }
        if (!string6.equals("CALL")) {
            throw Trace.error(12, string6);
        }
        String string7 = this.tokenizer.getSimpleName();
        if (!this.tokenizer.wasQuotedIdentifier()) {
            throw Trace.error(12, string7);
        }
        HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newHsqlName(string, bl);
        TriggerDef triggerDef = new TriggerDef(hsqlName, string3, string4, bl2, table, string7, bl3, n2, this.database.classLoader);
        table.addTrigger(triggerDef);
        if (triggerDef.isValid()) {
            try {
                triggerDef.start();
            }
            catch (Exception exception) {
                throw Trace.error(13, exception.toString());
            }
        }
        this.database.schemaManager.registerTriggerName(string, table.getName());
    }

    private Column processCreateColumn() throws HsqlException {
        String string = this.tokenizer.getSimpleName();
        boolean bl = this.tokenizer.wasQuotedIdentifier();
        HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newHsqlName(string, bl);
        return this.processCreateColumn(hsqlName);
    }

    private Column processCreateColumn(HsqlNameManager.HsqlName hsqlName) throws HsqlException {
        boolean bl = false;
        long l2 = this.database.firstIdentity;
        long l3 = 1L;
        boolean bl2 = false;
        int n2 = 0;
        int n3 = 0;
        boolean bl3 = false;
        boolean bl4 = true;
        Expression expression = null;
        String string = this.tokenizer.getSimpleToken();
        int n4 = Types.getTypeNr(string);
        if (n4 == 1 && this.tokenizer.isGetThis("VARYING")) {
            n4 = 12;
        }
        if (string.equals("IDENTITY")) {
            bl = true;
            bl2 = true;
        }
        if (n4 == 8) {
            this.tokenizer.isGetThis("PRECISION");
        }
        if (this.tokenizer.isGetThis("(")) {
            bl3 = true;
            n2 = this.tokenizer.getInt();
            Trace.check(Types.acceptsPrecisionCreateParam(n4), 11);
            if (n4 != 93 && n4 != 92 && n2 == 0) {
                throw Trace.error(254);
            }
            if (this.tokenizer.isGetThis(",")) {
                Trace.check(Types.acceptsScaleCreateParam(n4), 11);
                n3 = this.tokenizer.getInt();
            }
            this.tokenizer.getThis(")");
        } else if (n4 == 1 && this.database.sqlEnforceStrictSize) {
            n2 = 1;
        } else if (n4 == 12 && this.database.sqlEnforceStrictSize) {
            throw Trace.error(253);
        }
        if (n4 == 12 && this.database.isIgnoreCase()) {
            n4 = 100;
        }
        if (n4 == 6 && n2 > 53) {
            throw Trace.error(65);
        }
        if (n4 == 93) {
            if (!bl3) {
                n2 = 6;
            } else if (n2 != 0 && n2 != 6) {
                throw Trace.error(65);
            }
        }
        if (n4 == 92 && n2 != 0) {
            throw Trace.error(65);
        }
        String string2 = this.tokenizer.getSimpleToken();
        if (string2.equals("DEFAULT")) {
            expression = this.processCreateDefaultExpression(n4, n2, n3);
            string2 = this.tokenizer.getSimpleToken();
        } else if (string2.equals("GENERATED")) {
            this.tokenizer.getThis("BY");
            this.tokenizer.getThis("DEFAULT");
            this.tokenizer.getThis("AS");
            this.tokenizer.getThis("IDENTITY");
            if (this.tokenizer.isGetThis("(")) {
                this.tokenizer.getThis("START");
                this.tokenizer.getThis("WITH");
                l2 = this.tokenizer.getBigint();
                if (this.tokenizer.isGetThis(",")) {
                    this.tokenizer.getThis("INCREMENT");
                    this.tokenizer.getThis("BY");
                    l3 = this.tokenizer.getBigint();
                }
                this.tokenizer.getThis(")");
            }
            bl = true;
            bl2 = true;
            string2 = this.tokenizer.getSimpleToken();
        }
        if (string2.equals("IDENTITY")) {
            bl = true;
            bl2 = true;
            string2 = this.tokenizer.getSimpleToken();
        }
        if (string2.equals("NULL")) {
            string2 = this.tokenizer.getSimpleToken();
        } else if (string2.equals("NOT")) {
            this.tokenizer.getThis("NULL");
            bl4 = false;
            string2 = this.tokenizer.getSimpleToken();
        }
        if (string2.equals("IDENTITY")) {
            if (bl) {
                throw Trace.error(24, "IDENTITY");
            }
            bl = true;
            bl2 = true;
            string2 = this.tokenizer.getSimpleToken();
        }
        if (string2.equals("PRIMARY")) {
            this.tokenizer.getThis("KEY");
            bl2 = true;
        } else {
            this.tokenizer.back();
        }
        if (bl && expression != null) {
            throw Trace.error(11, "DEFAULT");
        }
        Column column = new Column(hsqlName, bl4, n4, n2, n3, bl2, expression);
        column.setIdentity(bl, l2, l3);
        return column;
    }

    private Expression processCreateDefaultExpression(int n2, int n3, int n4) throws HsqlException {
        if (n2 == 1111) {
            throw Trace.error(46);
        }
        Parser parser = new Parser(this.session, this.database, this.tokenizer);
        Expression expression = parser.readDefaultClause(n2);
        expression.resolveTypes(this.session);
        int n5 = expression.getType();
        if (n5 == 1 || n5 == 4 || n5 == -4 || n5 == 7 && expression.function.isSimple) {
            Object object;
            try {
                object = expression.getValue(this.session, n2);
            }
            catch (HsqlException hsqlException) {
                throw Trace.error(46);
            }
            if (object != null && this.database.sqlEnforceStrictSize) {
                try {
                    Column.enforceSize(object, n2, n3, n4, true);
                }
                catch (HsqlException hsqlException) {
                    throw Trace.error(46);
                }
            }
            return expression;
        }
        throw Trace.error(46);
    }

    public static void checkBooleanDefault(String string, int n2) throws HsqlException {
        if (n2 != 16 || string == null) {
            return;
        }
        if ((string = string.toUpperCase()).equals("TRUE") || string.equals("FALSE")) {
            return;
        }
        if (string.equals("0") || string.equals("1")) {
            return;
        }
        throw Trace.error(46, string);
    }

    private HsqlArrayList processCreateConstraints(Table table, boolean bl, int[] nArray) throws HsqlException {
        String string;
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        Constraint constraint = new Constraint(null, nArray, null, null, 1, 3, 3);
        HsqlNameManager.HsqlName hsqlName = null;
        hsqlArrayList.add(constraint);
        if (!bl) {
            return hsqlArrayList;
        }
        do {
            Object object;
            HsqlNameManager.HsqlName hsqlName2 = null;
            if (this.tokenizer.isGetThis("CONSTRAINT")) {
                string = this.tokenizer.getName();
                object = this.tokenizer.getLongNameFirst();
                if (object != null) {
                    object = this.session.getSchemaNameForWrite(this.tokenizer.getLongNameFirst());
                    if (!table.getSchemaName().equals(object)) {
                        throw Trace.error(227, object);
                    }
                }
                hsqlName2 = this.database.nameManager.newHsqlName(string, this.tokenizer.wasQuotedIdentifier());
            }
            string = this.tokenizer.getSimpleToken();
            switch (Token.get(string)) {
                case 167: {
                    this.tokenizer.getThis("KEY");
                    hsqlName = hsqlName2;
                    object = this.processColumnList(table, false);
                    Constraint constraint2 = (Constraint)hsqlArrayList.get(0);
                    if (constraint2.core.mainColArray != null && !ArrayUtil.areEqual(constraint2.core.mainColArray, (int[])object, ((Object)object).length, true)) {
                        throw Trace.error(24);
                    }
                    constraint2.core.mainColArray = (int[])object;
                    constraint2.constName = hsqlName;
                    break;
                }
                case 228: {
                    object = this.processColumnList(table, false);
                    if (hsqlName2 == null) {
                        hsqlName2 = this.database.nameManager.newAutoName("CT");
                    }
                    constraint = new Constraint(hsqlName2, (int[])object, null, null, 2, 3, 3);
                    hsqlArrayList.add(constraint);
                    break;
                }
                case 89: {
                    this.tokenizer.getThis("KEY");
                    constraint = this.processCreateFK(table, hsqlName2);
                    if (constraint.core.refColArray == null) {
                        object = (Constraint)hsqlArrayList.get(0);
                        constraint.core.refColArray = ((Constraint)object).core.mainColArray;
                        if (constraint.core.refColArray == null) {
                            throw Trace.error(61, 103);
                        }
                    }
                    this.checkFKColumnDefaults(table, constraint);
                    table.checkColumnsMatch(constraint.core.mainColArray, constraint.core.refTable, constraint.core.refColArray);
                    hsqlArrayList.add(constraint);
                    break;
                }
                case 30: {
                    if (hsqlName2 == null) {
                        hsqlName2 = this.database.nameManager.newAutoName("CT");
                    }
                    constraint = new Constraint(hsqlName2, null, null, null, 3, 3, 3);
                    this.processCreateCheckConstraintCondition(constraint);
                    hsqlArrayList.add(constraint);
                }
            }
        } while ((string = this.tokenizer.getSimpleToken()).equals(","));
        if (!string.equals(")")) {
            throw Trace.error(11, string);
        }
        return hsqlArrayList;
    }

    private void processCreateCheckConstraintCondition(Constraint constraint) throws HsqlException {
        this.tokenizer.getThis("(");
        Parser parser = new Parser(this.session, this.database, this.tokenizer);
        Expression expression = parser.parseExpression();
        this.tokenizer.getThis(")");
        constraint.core.check = expression;
    }

    private void processCreateTable(int n2) throws HsqlException {
        Object object;
        Table table;
        boolean bl;
        int[] nArray;
        String string;
        block18: {
            string = this.tokenizer.getName();
            HsqlNameManager.HsqlName hsqlName = this.session.getSchemaHsqlNameForWrite(this.tokenizer.getLongNameFirst());
            this.database.schemaManager.checkUserTableNotExists(this.session, string, hsqlName.name);
            boolean bl2 = this.tokenizer.wasQuotedIdentifier();
            nArray = null;
            int n3 = 0;
            bl = false;
            table = this.newTable(n2, string, bl2, hsqlName);
            this.tokenizer.getThis("(");
            while (true) {
                string = this.tokenizer.getString();
                switch (Token.get(string)) {
                    case 30: 
                    case 38: 
                    case 89: 
                    case 167: 
                    case 228: {
                        bl = !this.tokenizer.wasQuotedIdentifier() && !this.tokenizer.wasLongName();
                    }
                }
                this.tokenizer.back();
                if (bl) break block18;
                object = this.processCreateColumn();
                table.addColumn((Column)object);
                if (((Column)object).isPrimaryKey()) {
                    Trace.check(nArray == null, 24, ((Column)object).columnName.name);
                    nArray = new int[]{n3};
                }
                if (!(string = this.tokenizer.getSimpleToken()).equals(",")) break;
                ++n3;
            }
            if (!string.equals(")")) {
                throw Trace.error(11, string);
            }
        }
        object = this.processCreateConstraints(table, bl, nArray);
        if (this.tokenizer.isGetThis("ON")) {
            if (!table.isTemp) {
                throw Trace.error(11, "ON");
            }
            this.tokenizer.getThis("COMMIT");
            string = this.tokenizer.getSimpleToken();
            if (!string.equals("DELETE")) {
                if (string.equals("PRESERVE")) {
                    table.onCommitPreserve = true;
                } else {
                    throw Trace.error(11, string);
                }
            }
            this.tokenizer.getThis("ROWS");
        }
        try {
            this.session.commit();
            Constraint constraint = (Constraint)((HsqlArrayList)object).get(0);
            table.createPrimaryKey(null, constraint.core.mainColArray, true);
            if (constraint.core.mainColArray != null) {
                if (constraint.constName == null) {
                    constraint.constName = table.makeSysPKName();
                }
                Constraint constraint2 = new Constraint(constraint.constName, table, table.getPrimaryIndex(), 4);
                table.addConstraint(constraint2);
                this.database.schemaManager.registerConstraintName(constraint.constName.name, table.getName());
            }
            for (int i2 = 1; i2 < ((HsqlArrayList)object).size(); ++i2) {
                TableWorks tableWorks;
                Constraint constraint3 = (Constraint)((HsqlArrayList)object).get(i2);
                if (constraint3.constType == 2) {
                    tableWorks = new TableWorks(this.session, table);
                    tableWorks.createUniqueConstraint(constraint3.core.mainColArray, constraint3.constName);
                    table = tableWorks.getTable();
                }
                if (constraint3.constType == 0) {
                    tableWorks = new TableWorks(this.session, table);
                    tableWorks.createForeignKey(constraint3.core.mainColArray, constraint3.core.refColArray, constraint3.constName, constraint3.core.refTable, constraint3.core.deleteAction, constraint3.core.updateAction);
                    table = tableWorks.getTable();
                }
                if (constraint3.constType != 3) continue;
                tableWorks = new TableWorks(this.session, table);
                tableWorks.createCheckConstraint(constraint3, constraint3.constName);
                table = tableWorks.getTable();
            }
            this.database.schemaManager.linkTable(table);
        }
        catch (HsqlException hsqlException) {
            this.database.schemaManager.removeExportedKeys(table);
            this.database.schemaManager.removeIndexNames(table.tableName);
            this.database.schemaManager.removeConstraintNames(table.tableName);
            throw hsqlException;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Constraint processCreateFK(Table table, HsqlNameManager.HsqlName hsqlName) throws HsqlException {
        int[] nArray = this.processColumnList(table, false);
        this.tokenizer.getThis("REFERENCES");
        String string = this.tokenizer.getName();
        String string2 = this.tokenizer.getLongNameFirst();
        if (string2 != null) {
            string2 = this.session.getSchemaNameForWrite(this.tokenizer.getLongNameFirst());
            if (!table.getSchemaName().equals(string2)) {
                throw Trace.error(227, string2);
            }
        }
        Table table2 = table.getName().name.equals(string) ? table : this.database.schemaManager.getTable(this.session, string, table.getSchemaName());
        int[] nArray2 = null;
        String string3 = this.tokenizer.getSimpleToken();
        this.tokenizer.back();
        if (string3.equals("(")) {
            nArray2 = this.processColumnList(table2, false);
        } else if (table2.getPrimaryKey() == null) {
            Trace.check(table == table2, 103);
        } else {
            if (!table2.hasPrimaryKey()) throw Trace.error(61, 103);
            nArray2 = table2.getPrimaryKey();
        }
        string3 = this.tokenizer.getSimpleToken();
        int n2 = 3;
        int n3 = 3;
        while (string3.equals("ON")) {
            string3 = this.tokenizer.getSimpleToken();
            if (n2 == 3 && string3.equals("DELETE")) {
                string3 = this.tokenizer.getSimpleToken();
                if (string3.equals("SET")) {
                    string3 = this.tokenizer.getSimpleToken();
                    if (string3.equals("DEFAULT")) {
                        n2 = 4;
                    } else {
                        if (!string3.equals("NULL")) throw Trace.error(11, string3);
                        n2 = 2;
                    }
                } else if (string3.equals("CASCADE")) {
                    n2 = 0;
                } else if (!string3.equals("RESTRICT")) {
                    this.tokenizer.matchThis("NO");
                    this.tokenizer.getThis("ACTION");
                }
            } else {
                if (n3 != 3 || !string3.equals("UPDATE")) throw Trace.error(11, string3);
                string3 = this.tokenizer.getSimpleToken();
                if (string3.equals("SET")) {
                    string3 = this.tokenizer.getSimpleToken();
                    if (string3.equals("DEFAULT")) {
                        n3 = 4;
                    } else {
                        if (!string3.equals("NULL")) throw Trace.error(11, string3);
                        n3 = 2;
                    }
                } else if (string3.equals("CASCADE")) {
                    n3 = 0;
                } else if (!string3.equals("RESTRICT")) {
                    this.tokenizer.matchThis("NO");
                    this.tokenizer.getThis("ACTION");
                }
            }
            string3 = this.tokenizer.getSimpleToken();
        }
        this.tokenizer.back();
        if (hsqlName != null) return new Constraint(hsqlName, nArray, table2, nArray2, 0, n2, n3);
        hsqlName = this.database.nameManager.newAutoName("FK");
        return new Constraint(hsqlName, nArray, table2, nArray2, 0, n2, n3);
    }

    private void processCreateView() throws HsqlException {
        Object object;
        String string = this.tokenizer.getName();
        HsqlNameManager.HsqlName hsqlName = this.session.getSchemaHsqlNameForWrite(this.tokenizer.getLongNameFirst());
        int n2 = this.tokenizer.getPartMarker();
        this.database.schemaManager.checkUserViewNotExists(this.session, string, hsqlName.name);
        HsqlNameManager.HsqlName hsqlName2 = this.database.nameManager.newHsqlName(string, this.tokenizer.wasQuotedIdentifier());
        hsqlName2.schema = hsqlName;
        HsqlNameManager.HsqlName[] hsqlNameArray = null;
        if (this.tokenizer.isGetThis("(")) {
            try {
                object = Parser.getColumnNames(this.database, null, this.tokenizer, true);
                hsqlNameArray = new HsqlNameManager.HsqlName[((HsqlArrayList)object).size()];
                hsqlNameArray = (HsqlNameManager.HsqlName[])((HsqlArrayList)object).toArray(hsqlNameArray);
            }
            catch (HsqlException hsqlException) {
                if (this.database.isStoredFileAccess() && this.session.isProcessingScript()) {
                    String string2;
                    while (!(string2 = this.tokenizer.getString()).equals(")") && !string2.equals("")) {
                    }
                }
                throw hsqlException;
            }
        }
        this.tokenizer.getThis("AS");
        this.tokenizer.setPartMarker();
        object = new Parser(this.session, this.database, this.tokenizer);
        int n3 = ((Parser)object).parseOpenBracketsSelect();
        Select select = ((Parser)object).parseSelect(n3, true, false, true, true);
        if (select.sIntoTable != null) {
            throw Trace.error(74, 117);
        }
        select.prepareResult(this.session);
        View view = new View(this.session, this.database, hsqlName2, this.tokenizer.getLastPart(), hsqlNameArray);
        this.session.commit();
        this.database.schemaManager.linkTable(view);
        this.tokenizer.setPartMarker(n2);
    }

    private void processAlterTableRename(Table table) throws HsqlException {
        String string = table.getSchemaName();
        this.tokenizer.getThis("TO");
        String string2 = this.tokenizer.getName();
        String string3 = this.tokenizer.getLongNameFirst();
        boolean bl = this.tokenizer.wasQuotedIdentifier();
        String string4 = string3 = string3 == null ? string : this.session.getSchemaNameForWrite(string3);
        if (!string.equals(string3)) {
            throw Trace.error(227);
        }
        this.database.schemaManager.checkUserTableNotExists(this.session, string2, string);
        this.session.commit();
        this.session.setScripting(true);
        this.database.schemaManager.renameTable(this.session, table, string2, bl);
    }

    private void processAlter() throws HsqlException {
        this.session.checkAdmin();
        this.session.checkDDLWrite();
        this.session.setScripting(true);
        String string = this.tokenizer.getSimpleToken();
        switch (Token.get(string)) {
            case 306: {
                this.processAlterIndex();
                break;
            }
            case 338: {
                this.processAlterSchema();
                break;
            }
            case 324: {
                this.processAlterSequence();
                break;
            }
            case 213: {
                this.processAlterTable();
                break;
            }
            case 223: {
                this.processAlterUser();
                break;
            }
            default: {
                throw Trace.error(11, string);
            }
        }
    }

    private void processAlterTable() throws HsqlException {
        String string;
        String string2 = this.tokenizer.getName();
        Table table = this.database.schemaManager.getUserTable(this.session, string2, string = this.session.getSchemaNameForWrite(this.tokenizer.getLongNameFirst()));
        if (table.isView()) {
            throw Trace.error(55);
        }
        this.session.setScripting(true);
        String string3 = this.tokenizer.getSimpleToken();
        switch (Token.get(string3)) {
            case 319: {
                this.processAlterTableRename(table);
                return;
            }
            case 1: {
                HsqlNameManager.HsqlName hsqlName = null;
                if (this.tokenizer.isGetThis("CONSTRAINT")) {
                    string3 = this.tokenizer.getName();
                    String string4 = this.tokenizer.getLongNameFirst();
                    if (string4 != null) {
                        string4 = this.session.getSchemaNameForWrite(this.tokenizer.getLongNameFirst());
                        if (!table.getSchemaName().equals(string4)) {
                            throw Trace.error(227, string4);
                        }
                    }
                    hsqlName = this.database.nameManager.newHsqlName(string3, this.tokenizer.wasQuotedIdentifier());
                }
                string3 = this.tokenizer.getString();
                if (this.tokenizer.wasQuotedIdentifier() && this.tokenizer.wasSimpleName()) {
                    this.tokenizer.back();
                    this.processAlterTableAddColumn(table);
                    return;
                }
                if (!this.tokenizer.wasSimpleToken()) {
                    throw Trace.error(11, string3);
                }
                switch (Token.get(string3)) {
                    case 89: {
                        this.tokenizer.getThis("KEY");
                        this.processAlterTableAddForeignKeyConstraint(table, hsqlName);
                        return;
                    }
                    case 228: {
                        this.processAlterTableAddUniqueConstraint(table, hsqlName);
                        return;
                    }
                    case 30: {
                        this.processAlterTableAddCheckConstraint(table, hsqlName);
                        return;
                    }
                    case 167: {
                        this.tokenizer.getThis("KEY");
                        this.processAlterTableAddPrimaryKey(table, hsqlName);
                        return;
                    }
                    default: {
                        if (hsqlName != null) {
                            throw Trace.error(11, string3);
                        }
                        this.tokenizer.back();
                    }
                    case 34: 
                }
                this.processAlterTableAddColumn(table);
                return;
            }
            case 70: {
                string3 = this.tokenizer.getString();
                if (this.tokenizer.wasQuotedIdentifier() && this.tokenizer.wasSimpleName()) {
                    this.tokenizer.back();
                    this.processAlterTableDropColumn(table);
                    return;
                }
                if (!this.tokenizer.wasSimpleToken()) {
                    throw Trace.error(11, string3);
                }
                switch (Token.get(string3)) {
                    case 167: {
                        this.tokenizer.getThis("KEY");
                        if (!table.hasPrimaryKey()) {
                            throw Trace.error(61, 103, new Object[]{"PRIMARY KEY", table.getName().name});
                        }
                        this.processAlterTableDropConstraint(table, table.getPrimaryConstraint().getName().name);
                        return;
                    }
                    case 38: {
                        this.processAlterTableDropConstraint(table);
                        return;
                    }
                    default: {
                        this.tokenizer.back();
                    }
                    case 34: 
                }
                this.processAlterTableDropColumn(table);
                return;
            }
            case 4: {
                this.tokenizer.isGetThis("COLUMN");
                this.processAlterColumn(table);
                return;
            }
        }
        throw Trace.error(11, string3);
    }

    private void processAlterColumn(Table table) throws HsqlException {
        String string = this.tokenizer.getSimpleName();
        int n2 = table.getColumnNr(string);
        Column column = table.getColumn(n2);
        String string2 = this.tokenizer.getSimpleToken();
        switch (Token.get(string2)) {
            case 319: {
                this.tokenizer.getThis("TO");
                this.processAlterColumnRename(table, column);
                return;
            }
            case 70: {
                this.tokenizer.getThis("DEFAULT");
                TableWorks tableWorks = new TableWorks(this.session, table);
                tableWorks.setColDefaultExpression(n2, null);
                return;
            }
            case 196: {
                string2 = this.tokenizer.getSimpleToken();
                if (string2.equals("NOT")) {
                    this.tokenizer.getThis("NULL");
                    TableWorks tableWorks = new TableWorks(this.session, table);
                    tableWorks.setColNullability(column, false);
                } else if (string2.equals("NULL")) {
                    TableWorks tableWorks = new TableWorks(this.session, table);
                    tableWorks.setColNullability(column, true);
                } else if (string2.equals("DEFAULT")) {
                    TableWorks tableWorks = new TableWorks(this.session, table);
                    int n3 = column.getType();
                    int n4 = column.getSize();
                    int n5 = column.getScale();
                    Expression expression = this.processCreateDefaultExpression(n3, n4, n5);
                    tableWorks.setColDefaultExpression(n2, expression);
                } else {
                    throw Trace.error(11, string2);
                }
                return;
            }
            case 320: {
                this.tokenizer.getThis("WITH");
                long l2 = this.tokenizer.getBigint();
                int n6 = table.getIdentityColumn();
                if (n6 == -1) {
                    throw Trace.error(73);
                }
                table.identitySequence.reset(l2);
                return;
            }
        }
        this.tokenizer.back();
        this.processAlterColumnType(table, column);
    }

    private void processAlterColumnType(Table table, Column column) throws HsqlException {
        Column column2 = this.processCreateColumn(column.columnName);
        TableWorks tableWorks = new TableWorks(this.session, table);
        tableWorks.reTypeColumn(column, column2);
    }

    private void processAlterColumnRename(Table table, Column column) throws HsqlException {
        String string = this.tokenizer.getSimpleName();
        boolean bl = this.tokenizer.wasQuotedIdentifier();
        if (table.findColumn(string) > -1) {
            throw Trace.error(27, string);
        }
        table.database.schemaManager.checkColumnIsInView(table, column.columnName.name);
        this.session.commit();
        this.session.setScripting(true);
        table.renameColumn(column, string, bl);
    }

    private void processAlterIndex() throws HsqlException {
        this.processAlterIndexRename();
    }

    private void processAlterSchema() throws HsqlException {
        this.processAlterSchemaRename();
    }

    private void processDrop() throws HsqlException {
        this.session.checkReadWrite();
        this.session.checkAdmin();
        this.session.setScripting(true);
        String string = this.tokenizer.getSimpleToken();
        boolean bl = false;
        switch (Token.get(string)) {
            case 306: {
                this.processDropIndex();
                break;
            }
            case 338: {
                this.processDropSchema();
                break;
            }
            case 324: {
                this.processDropSequence();
                break;
            }
            case 224: {
                this.processDropTrigger();
                break;
            }
            case 223: {
                this.processDropUser();
                break;
            }
            case 339: {
                this.database.getGranteeManager().dropRole(this.tokenizer.getSimpleName());
                break;
            }
            case 329: {
                bl = true;
            }
            case 213: {
                this.processDropTable(bl);
                break;
            }
            default: {
                throw Trace.error(11, string);
            }
        }
    }

    private void processGrantOrRevoke(boolean bl) throws HsqlException {
        Object object;
        this.session.checkAdmin();
        this.session.checkDDLWrite();
        this.session.setScripting(true);
        int n2 = 0;
        String string = this.tokenizer.getSimpleToken();
        this.tokenizer.back();
        if (!GranteeManager.validRightString(string)) {
            this.processRoleGrantOrRevoke(bl);
            return;
        }
        do {
            string = this.tokenizer.getSimpleToken();
            n2 |= GranteeManager.getCheckRight(string);
        } while (this.tokenizer.isGetThis(","));
        this.tokenizer.getThis("ON");
        Object object2 = null;
        if (this.tokenizer.isGetThis("CLASS")) {
            object2 = this.tokenizer.getSimpleName();
            if (!this.tokenizer.wasQuotedIdentifier()) {
                throw Trace.error(125);
            }
        } else {
            string = this.tokenizer.getName();
            object = this.session.getSchemaName(this.tokenizer.getLongNameFirst());
            Table table = this.database.schemaManager.getTable(this.session, string, (String)object);
            object2 = table.getName();
            this.session.setScripting(true);
        }
        this.tokenizer.getThis(bl ? "TO" : "FROM");
        string = this.getUserIdentifier();
        object = this.database.getGranteeManager();
        if (bl) {
            ((GranteeManager)object).grant(string, object2, n2);
        } else {
            ((GranteeManager)object).revoke(string, object2, n2);
        }
    }

    private void processConnect() throws HsqlException {
        this.tokenizer.getThis("USER");
        String string = this.getUserIdentifier();
        if (this.tokenizer.isGetThis("PASSWORD")) {
            String string2 = this.getPassword();
            User user = this.database.getUserManager().getUser(string, string2);
            this.session.commit();
            this.session.setUser(user);
            this.database.logger.logConnectUser(this.session);
        } else if (this.session.isProcessingLog) {
            this.session.commit();
        } else {
            this.tokenizer.getThis("PASSWORD");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processSet() throws HsqlException {
        this.session.setScripting(true);
        String string = this.tokenizer.getSimpleToken();
        switch (Token.get(string)) {
            case 316: {
                this.session.checkAdmin();
                string = this.tokenizer.getSimpleName();
                if (!this.tokenizer.wasQuotedIdentifier()) {
                    throw Trace.error(125);
                }
                HsqlDatabaseProperties hsqlDatabaseProperties = this.database.getProperties();
                boolean bl = hsqlDatabaseProperties.isBoolean(string);
                boolean bl2 = hsqlDatabaseProperties.isIntegral(string);
                boolean bl3 = hsqlDatabaseProperties.isString(string);
                Trace.check(bl || bl2 || bl3, 33, string);
                int n2 = bl ? 16 : (bl2 ? 4 : 12);
                Object object = this.tokenizer.getInType(n2);
                if ("hsqldb.cache_file_scale".equals(string) && (this.database.logger.hasCache() || (Integer)object != 8)) {
                    Trace.throwerror(33, string);
                }
                hsqlDatabaseProperties.setDatabaseProperty(string, object.toString().toLowerCase());
                hsqlDatabaseProperties.setDatabaseVariables();
                return;
            }
            case 338: {
                this.session.setScripting(false);
                this.session.setSchema(this.tokenizer.getSimpleName());
                return;
            }
            case 314: {
                this.session.checkDDLWrite();
                this.session.getUser().setPassword(this.getPassword());
                return;
            }
            case 317: {
                this.session.commit();
                this.session.setReadOnly(this.processTrueOrFalse());
                return;
            }
            case 307: {
                this.session.checkAdmin();
                this.session.checkDDLWrite();
                int n3 = this.tokenizer.getInt();
                this.database.logger.setLogSize(n3);
                return;
            }
            case 322: {
                this.session.checkAdmin();
                this.session.checkDDLWrite();
                this.session.setScripting(false);
                string = this.tokenizer.getSimpleToken();
                int n4 = ArrayUtil.find(ScriptWriterBase.LIST_SCRIPT_FORMATS, string);
                if (n4 != 0 && n4 != 1) {
                    if (n4 != 3) throw Trace.error(11, string);
                }
                this.database.logger.setScriptType(n4);
                return;
            }
            case 305: {
                this.session.checkAdmin();
                this.session.checkDDLWrite();
                this.database.setIgnoreCase(this.processTrueOrFalse());
                return;
            }
            case 309: {
                this.session.setScripting(false);
                int n5 = this.tokenizer.getInt();
                this.session.setSQLMaxRows(n5);
                return;
            }
            case 301: {
                this.session.setAutoCommit(this.processTrueOrFalse());
                return;
            }
            case 213: {
                this.session.checkAdmin();
                this.session.checkDDLWrite();
                string = this.tokenizer.getName();
                String string2 = this.session.getSchemaNameForWrite(this.tokenizer.getLongNameFirst());
                Table table = this.database.schemaManager.getTable(this.session, string, string2);
                string = this.tokenizer.getSimpleToken();
                this.session.setScripting(true);
                switch (Token.get(string)) {
                    default: {
                        throw Trace.error(11, string);
                    }
                    case 326: {
                        this.session.checkAdmin();
                        if (this.tokenizer.isGetThis("HEADER")) {
                            string = this.tokenizer.getString();
                            if (!this.tokenizer.wasQuotedIdentifier()) {
                                throw Trace.error(75);
                            }
                            try {
                                table.setHeader(string);
                                return;
                            }
                            catch (Throwable throwable) {
                                if (!this.session.isProcessingLog() && !this.session.isProcessingScript()) {
                                    if (!(throwable instanceof HsqlException)) throw Trace.error(98, throwable.getMessage());
                                    throw (HsqlException)throwable;
                                }
                                HsqlException hsqlException = Trace.error(98, throwable.getMessage());
                                this.session.addWarning(hsqlException);
                                return;
                            }
                        }
                        if (this.tokenizer.isGetThis("ON")) {
                            table.connect(this.session);
                            this.database.setMetaDirty(false);
                            return;
                        }
                        if (this.tokenizer.isGetThis("OFF")) {
                            table.disconnect(this.session);
                            this.database.setMetaDirty(false);
                            return;
                        }
                        string = this.tokenizer.getString();
                        if (!this.tokenizer.wasQuotedIdentifier()) {
                            throw Trace.error(75);
                        }
                        boolean bl = false;
                        bl = this.tokenizer.isGetThis("DESC");
                        try {
                            table.setDataSource(this.session, string, bl, false);
                            return;
                        }
                        catch (Throwable throwable) {
                            if (!this.session.isProcessingLog() && !this.session.isProcessingScript()) {
                                if (!(throwable instanceof HsqlException)) throw Trace.error(98, throwable.getMessage());
                                throw (HsqlException)throwable;
                            }
                            HsqlException hsqlException = Trace.error(98, throwable.getMessage());
                            this.session.addWarning(hsqlException);
                            return;
                        }
                    }
                    case 317: {
                        this.session.checkAdmin();
                        table.setDataReadOnly(this.processTrueOrFalse());
                        this.database.setMetaDirty(false);
                        return;
                    }
                    case 306: 
                }
                this.session.checkAdmin();
                String string3 = (String)this.tokenizer.getInType(12);
                table.setIndexRoots(string3);
                return;
            }
            case 318: {
                this.session.checkAdmin();
                this.session.checkDDLWrite();
                this.session.setScripting(false);
                this.database.setReferentialIntegrity(this.processTrueOrFalse());
                return;
            }
            case 303: {
                this.session.checkAdmin();
                this.session.checkDDLWrite();
                this.tokenizer.getThis("DEFRAG");
                int n6 = this.tokenizer.getInt();
                this.database.getProperties().setProperty("hsqldb.defrag_limit", n6);
                return;
            }
            case 330: {
                this.session.checkAdmin();
                this.session.checkDDLWrite();
                int n7 = 0;
                this.tokenizer.getString();
                Object object = this.tokenizer.getAsValue();
                if (this.tokenizer.getType() == 4) {
                    n7 = (Integer)object;
                } else if (Boolean.TRUE.equals(object)) {
                    n7 = this.database.getProperties().getDefaultWriteDelay();
                } else {
                    if (!Boolean.FALSE.equals(object)) throw Trace.error(11);
                    n7 = 0;
                }
                if (!this.tokenizer.isGetThis("MILLIS")) {
                    n7 *= 1000;
                }
                this.database.logger.setWriteDelay(n7);
                return;
            }
            case 337: {
                this.session.checkAdmin();
                this.session.checkDDLWrite();
                this.tokenizer.getThis("COLLATION");
                String string4 = this.tokenizer.getSimpleName();
                if (!this.tokenizer.wasQuotedIdentifier()) {
                    throw Trace.error(74);
                }
                this.database.collation.setCollation(string4);
                return;
            }
        }
        throw Trace.error(11, string);
    }

    private boolean processTrueOrFalse() throws HsqlException {
        String string = this.tokenizer.getSimpleToken();
        if (string.equals("TRUE")) {
            return true;
        }
        if (string.equals("FALSE")) {
            return false;
        }
        throw Trace.error(11, string);
    }

    private void processCommit() throws HsqlException {
        this.tokenizer.isGetThis("WORK");
        this.session.commit();
    }

    private void processRollback() throws HsqlException {
        String string = this.tokenizer.getSimpleToken();
        boolean bl = false;
        if (!string.equals("WORK")) {
            if (string.equals("TO")) {
                this.tokenizer.getThis("SAVEPOINT");
                string = this.tokenizer.getSimpleName();
                bl = true;
            } else {
                this.tokenizer.back();
            }
        }
        if (bl) {
            this.session.rollbackToSavepoint(string);
        } else {
            this.session.rollback();
        }
    }

    private void processSavepoint() throws HsqlException {
        String string = this.tokenizer.getSimpleName();
        this.session.savepoint(string);
    }

    private void processShutdown() throws HsqlException {
        if (!this.session.isClosed()) {
            this.session.checkAdmin();
        }
        int n2 = 0;
        String string = this.tokenizer.getSimpleToken();
        if (string.equals("IMMEDIATELY")) {
            n2 = -1;
        } else if (string.equals("COMPACT")) {
            n2 = 1;
        } else if (string.equals("SCRIPT")) {
            n2 = 2;
        } else if (!string.equals(";") && string.length() != 0) {
            throw Trace.error(11, string);
        }
        this.database.close(n2);
    }

    private void processCheckpoint() throws HsqlException {
        this.session.checkAdmin();
        this.session.checkDDLWrite();
        boolean bl = false;
        String string = this.tokenizer.getSimpleToken();
        if (string.equals("DEFRAG")) {
            bl = true;
        } else if (!string.equals(";") && string.length() != 0) {
            throw Trace.error(11, string);
        }
        this.database.logger.checkpoint(bl);
    }

    private HsqlNameManager.HsqlName newIndexHsqlName(String string, boolean bl) throws HsqlException {
        return HsqlNameManager.HsqlName.isReservedName(string) ? this.database.nameManager.newAutoName("USER", string) : this.database.nameManager.newHsqlName(string, bl);
    }

    private Table newTable(int n2, String string, boolean bl, HsqlNameManager.HsqlName hsqlName) throws HsqlException {
        HsqlNameManager.HsqlName hsqlName2 = this.database.nameManager.newHsqlName(string, bl);
        hsqlName2.schema = hsqlName;
        switch (n2) {
            case 5: 
            case 6: {
                return new TextTable(this.database, hsqlName2, n2);
            }
        }
        return new Table(this.database, hsqlName2, n2);
    }

    private void checkAddColumn(Table table, Column column) throws HsqlException {
        boolean bl = true;
        if (table.findColumn(column.columnName.name) != -1) {
            throw Trace.error(27, column.columnName.name);
        }
        if (column.isPrimaryKey() && table.hasPrimaryKey()) {
            bl = false;
        }
        if (bl && !table.isEmpty(this.session)) {
            boolean bl2 = bl = column.isNullable() || column.getDefaultExpression() != null;
        }
        if (!bl) {
            throw Trace.error(58);
        }
    }

    private void checkFKColumnDefaults(Table table, Constraint constraint) throws HsqlException {
        boolean bl = constraint.core.updateAction == 4;
        boolean bl2 = bl = bl || constraint.core.deleteAction == 4;
        if (bl) {
            int[] nArray = constraint.core.mainColArray;
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                Column column = table.getColumn(nArray[i2]);
                Expression expression = column.getDefaultExpression();
                if (expression != null) continue;
                String string = column.columnName.name;
                throw Trace.error(105, new Object[]{string});
            }
        }
    }

    private void processAlterSequence() throws HsqlException {
        String string = this.tokenizer.getName();
        String string2 = this.tokenizer.getLongNameFirst();
        string2 = this.session.getSchemaNameForWrite(string2);
        this.tokenizer.getThis("RESTART");
        this.tokenizer.getThis("WITH");
        long l2 = this.tokenizer.getBigint();
        NumberSequence numberSequence = this.database.schemaManager.getSequence(string, string2);
        numberSequence.reset(l2);
    }

    private void processAlterIndexRename() throws HsqlException {
        String string = this.tokenizer.getName();
        String string2 = this.session.getSchemaNameForWrite(this.tokenizer.getLongNameFirst());
        this.tokenizer.getThis("RENAME");
        this.tokenizer.getThis("TO");
        String string3 = this.tokenizer.getName();
        String string4 = this.tokenizer.getLongNameFirst();
        string4 = string4 == null ? string2 : this.session.getSchemaNameForWrite(string4);
        boolean bl = this.tokenizer.wasQuotedIdentifier();
        if (!string2.equals(string4)) {
            throw Trace.error(227);
        }
        Table table = this.database.schemaManager.findUserTableForIndex(this.session, string, string2);
        if (table == null) {
            throw Trace.error(26, string);
        }
        this.database.schemaManager.checkIndexExists(string, table.getSchemaName(), true);
        if (HsqlNameManager.HsqlName.isReservedName(string)) {
            throw Trace.error(56, string);
        }
        if (HsqlNameManager.HsqlName.isReservedName(string3)) {
            throw Trace.error(49, string3);
        }
        this.session.setScripting(true);
        this.session.commit();
        table.getIndex(string).setName(string3, bl);
        this.database.schemaManager.renameIndex(string, string3, table.getName());
    }

    private void processAlterSchemaRename() throws HsqlException {
        String string = this.tokenizer.getSimpleName();
        this.tokenizer.getThis("RENAME");
        this.tokenizer.getThis("TO");
        String string2 = this.tokenizer.getSimpleName();
        boolean bl = this.tokenizer.wasQuotedIdentifier();
        this.database.schemaManager.renameSchema(string, string2, bl);
    }

    private void processAlterTableAddColumn(Table table) throws HsqlException {
        int n2 = table.getColumnCount();
        Column column = this.processCreateColumn();
        this.checkAddColumn(table, column);
        if (this.tokenizer.isGetThis("BEFORE")) {
            String string = this.tokenizer.getSimpleName();
            n2 = table.getColumnNr(string);
        }
        this.session.commit();
        TableWorks tableWorks = new TableWorks(this.session, table);
        tableWorks.addColumn(column, n2);
    }

    private void processAlterTableDropColumn(Table table) throws HsqlException {
        String string = this.tokenizer.getName();
        int n2 = table.getColumnNr(string);
        this.session.commit();
        TableWorks tableWorks = new TableWorks(this.session, table);
        tableWorks.dropColumn(n2);
    }

    private void processAlterTableDropConstraint(Table table) throws HsqlException {
        this.processAlterTableDropConstraint(table, this.tokenizer.getName());
    }

    private void processAlterTableDropConstraint(Table table, String string) throws HsqlException {
        this.session.commit();
        TableWorks tableWorks = new TableWorks(this.session, table);
        tableWorks.dropConstraint(string);
    }

    private void processCreateAlias() throws HsqlException {
        String string;
        try {
            string = this.tokenizer.getSimpleName();
        }
        catch (HsqlException hsqlException) {
            if (this.session.isProcessingScript()) {
                string = null;
            }
            throw hsqlException;
        }
        this.tokenizer.getThis("FOR");
        String string2 = DatabaseCommandInterpreter.upgradeMethodFQN(this.tokenizer.getSimpleName());
        if (string != null) {
            this.database.getAliasMap().put(string, string2);
        }
    }

    private void processCreateIndex(boolean bl) throws HsqlException {
        String string = this.tokenizer.getName();
        String string2 = this.tokenizer.getLongNameFirst();
        boolean bl2 = this.tokenizer.wasQuotedIdentifier();
        this.tokenizer.getThis("ON");
        String string3 = this.tokenizer.getName();
        String string4 = this.session.getSchemaNameForWrite(this.tokenizer.getLongNameFirst());
        if (string2 != null && !string2.equals(string4)) {
            throw Trace.error(227);
        }
        Table table = this.database.schemaManager.getTable(this.session, string3, string4);
        this.database.schemaManager.checkIndexExists(string, table.getSchemaName(), false);
        HsqlNameManager.HsqlName hsqlName = this.newIndexHsqlName(string, bl2);
        int[] nArray = this.processColumnList(table, true);
        String string5 = this.tokenizer.getSimpleToken();
        if (!"DESC".equals(string5) && !"ASC".equals(string5)) {
            this.tokenizer.back();
        }
        this.session.commit();
        this.session.setScripting(true);
        TableWorks tableWorks = new TableWorks(this.session, table);
        tableWorks.createIndex(nArray, hsqlName, bl, false, false);
    }

    private void processCreateSequence() throws HsqlException {
        Object object;
        int n2 = 4;
        long l2 = 1L;
        long l3 = 0L;
        String string = this.tokenizer.getName();
        boolean bl = this.tokenizer.wasQuotedIdentifier();
        HsqlNameManager.HsqlName hsqlName = this.session.getSchemaHsqlNameForWrite(this.tokenizer.getLongNameFirst());
        if (this.tokenizer.isGetThis("AS")) {
            object = this.tokenizer.getSimpleToken();
            n2 = Types.getTypeNr((String)object);
            Trace.check(n2 == 4 || n2 == -5, 16);
        }
        if (this.tokenizer.isGetThis("START")) {
            this.tokenizer.getThis("WITH");
            l3 = this.tokenizer.getBigint();
        }
        if (this.tokenizer.isGetThis("INCREMENT")) {
            this.tokenizer.getThis("BY");
            l2 = this.tokenizer.getBigint();
        }
        object = this.database.nameManager.newHsqlName(string, bl);
        ((HsqlNameManager.HsqlName)object).schema = hsqlName;
        this.database.schemaManager.createSequence((HsqlNameManager.HsqlName)object, l3, l2, n2);
    }

    private void processCreateSchema() throws HsqlException {
        String string = this.tokenizer.getSimpleName();
        boolean bl = this.tokenizer.wasQuotedIdentifier();
        if (this.session.isSchemaDefintion()) {
            throw Trace.error(74);
        }
        this.tokenizer.getThis("AUTHORIZATION");
        this.tokenizer.getThis("DBA");
        if (this.database.schemaManager.schemaExists(string)) {
            if (!this.session.isProcessingScript) {
                throw Trace.error(227);
            }
        } else {
            this.database.schemaManager.createSchema(string, bl);
        }
        HsqlNameManager.HsqlName hsqlName = this.database.schemaManager.getSchemaHsqlName(string);
        this.database.logger.writeToLog(this.session, DatabaseScript.getSchemaCreateDDL(this.database, hsqlName));
        this.database.logger.writeToLog(this.session, "SET SCHEMA " + hsqlName.statementName);
        this.session.startSchemaDefinition(string);
        this.session.loggedSchema = this.session.currentSchema;
    }

    private void processCreateUser() throws HsqlException {
        String string = this.getUserIdentifier();
        this.tokenizer.getThis("PASSWORD");
        String string2 = this.getPassword();
        boolean bl = this.tokenizer.isGetThis("ADMIN");
        this.database.getUserManager().createUser(string, string2);
        if (bl) {
            this.database.getGranteeManager().grant(string, "DBA");
        }
    }

    private void processDisconnect() throws HsqlException {
        this.session.close();
    }

    private void processDropTable(boolean bl) throws HsqlException {
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.tokenizer.isGetThis("IF")) {
            this.tokenizer.getThis("EXISTS");
            bl2 = true;
        }
        String string = this.tokenizer.getName();
        String string2 = this.tokenizer.getLongNameFirst();
        if (this.tokenizer.isGetThis("IF")) {
            this.tokenizer.getThis("EXISTS");
            bl2 = true;
        }
        if (!(bl3 = this.tokenizer.isGetThis("CASCADE"))) {
            this.tokenizer.isGetThis("RESTRICT");
        }
        if (bl2 && string2 != null && !this.database.schemaManager.schemaExists(string2)) {
            return;
        }
        string2 = this.session.getSchemaNameForWrite(string2);
        this.database.schemaManager.dropTable(this.session, string, string2, bl2, bl, bl3);
    }

    private void processDropUser() throws HsqlException {
        this.session.checkAdmin();
        this.session.checkDDLWrite();
        String string = this.getPassword();
        if (this.database.getSessionManager().isUserActive(string)) {
            throw Trace.error(33);
        }
        this.database.getUserManager().dropUser(string);
    }

    private void processDropSequence() throws HsqlException {
        NumberSequence numberSequence;
        boolean bl;
        boolean bl2 = false;
        this.session.checkAdmin();
        this.session.checkDDLWrite();
        String string = this.tokenizer.getName();
        String string2 = this.session.getSchemaNameForWrite(this.tokenizer.getLongNameFirst());
        if (this.tokenizer.isGetThis("IF")) {
            this.tokenizer.getThis("EXISTS");
            bl2 = true;
        }
        if (!(bl = this.tokenizer.isGetThis("CASCADE"))) {
            this.tokenizer.isGetThis("RESTRICT");
        }
        if ((numberSequence = this.database.schemaManager.findSequence(string, string2)) == null) {
            if (bl2) {
                return;
            }
            throw Trace.error(191);
        }
        this.database.schemaManager.checkCascadeDropViews(numberSequence, bl);
        this.database.schemaManager.dropSequence(numberSequence);
    }

    private void processDropTrigger() throws HsqlException {
        this.session.checkAdmin();
        this.session.checkDDLWrite();
        String string = this.tokenizer.getName();
        String string2 = this.session.getSchemaNameForWrite(this.tokenizer.getLongNameFirst());
        this.database.schemaManager.dropTrigger(this.session, string, string2);
    }

    private void processDropIndex() throws HsqlException {
        String string = this.tokenizer.getName();
        String string2 = this.session.getSchemaNameForWrite(this.tokenizer.getLongNameFirst());
        boolean bl = false;
        if (this.tokenizer.isGetThis("ON")) {
            this.tokenizer.getName();
        }
        if (this.tokenizer.isGetThis("IF")) {
            this.tokenizer.getThis("EXISTS");
            bl = true;
        }
        this.session.checkAdmin();
        this.session.checkDDLWrite();
        this.database.schemaManager.dropIndex(this.session, string, string2, bl);
    }

    private void processDropSchema() throws HsqlException {
        String string = this.tokenizer.getSimpleName();
        boolean bl = this.tokenizer.isGetThis("CASCADE");
        if (!bl) {
            this.tokenizer.isGetThis("RESTRICT");
        }
        this.processDropSchema(string, bl);
    }

    private void processDropSchema(String string, boolean bl) throws HsqlException {
        if (!this.database.schemaManager.schemaExists(string)) {
            throw Trace.error(227);
        }
        this.database.schemaManager.dropSchema(string, bl);
        if (string.equals(this.session.getSchemaName(null))) {
            this.session.setSchema(this.database.schemaManager.getDefaultSchemaName());
        }
    }

    private Result processExplainPlan() throws IOException, HsqlException {
        String string;
        CompiledStatement compiledStatement;
        this.tokenizer.getThis("PLAN");
        this.tokenizer.getThis("FOR");
        Parser parser = new Parser(this.session, this.database, this.tokenizer);
        String string2 = this.tokenizer.getSimpleToken();
        int n2 = Token.get(string2);
        Result result = Result.newSingleColumnResult("OPERATION", 12);
        int n3 = 0;
        switch (n2) {
            case 313: {
                n3 = parser.parseOpenBracketsSelect() + 1;
            }
            case 193: {
                compiledStatement = parser.compileSelectStatement(n3);
                break;
            }
            case 112: {
                compiledStatement = parser.compileInsertStatement();
                break;
            }
            case 222: {
                compiledStatement = parser.compileUpdateStatement();
                break;
            }
            case 62: {
                compiledStatement = parser.compileDeleteStatement();
                break;
            }
            case 23: {
                compiledStatement = parser.compileCallStatement();
                break;
            }
            default: {
                return result;
            }
        }
        LineNumberReader lineNumberReader = new LineNumberReader(new StringReader(compiledStatement.describe(this.session)));
        while (null != (string = lineNumberReader.readLine())) {
            result.add(new Object[]{string});
        }
        return result;
    }

    private static String upgradeMethodFQN(String string) {
        if (string.startsWith(oldLib)) {
            string = newLib + string.substring(oldLibLen);
        } else if (string.equals("java.lang.Math.abs")) {
            string = "org.hsqldb.Library.abs";
        }
        return string;
    }

    Result processSelectInto(Result result, HsqlNameManager.HsqlName hsqlName, int n2) throws HsqlException {
        Object object;
        int n3 = result.getColumnCount();
        for (int i2 = 0; i2 < n3; ++i2) {
            if (result.metaData.colLabels[i2].length() != 0) continue;
            throw Trace.error(45);
        }
        Table table = n2 == 6 ? new TextTable(this.database, hsqlName, n2) : new Table(this.database, hsqlName, n2);
        table.addColumns(result.metaData, result.getColumnCount());
        table.createPrimaryKey();
        this.database.schemaManager.linkTable(table);
        if (n2 == 6) {
            try {
                object = StringUtil.toLowerSubset(hsqlName.name, '_') + ".csv";
                table.setDataSource(this.session, (String)object, false, true);
                this.logTableDDL(table);
                table.insertIntoTable(this.session, result);
            }
            catch (HsqlException hsqlException) {
                this.database.schemaManager.dropTable(this.session, hsqlName.name, null, false, false, false);
                throw hsqlException;
            }
        } else {
            this.logTableDDL(table);
            table.insertIntoTable(this.session, result);
        }
        object = new Result(1);
        ((Result)object).updateCount = result.getSize();
        return object;
    }

    private void logTableDDL(Table table) throws HsqlException {
        StringBuffer stringBuffer = new StringBuffer();
        DatabaseScript.getTableDDL(this.database, table, 0, null, true, stringBuffer);
        String string = DatabaseScript.getDataSource(table);
        this.database.logger.writeToLog(this.session, stringBuffer.toString());
        if (string != null) {
            this.database.logger.writeToLog(this.session, string);
        }
    }

    private void processAlterTableAddUniqueConstraint(Table table, HsqlNameManager.HsqlName hsqlName) throws HsqlException {
        int[] nArray = this.processColumnList(table, false);
        if (hsqlName == null) {
            hsqlName = this.database.nameManager.newAutoName("CT");
        }
        this.session.commit();
        TableWorks tableWorks = new TableWorks(this.session, table);
        tableWorks.createUniqueConstraint(nArray, hsqlName);
    }

    private void processAlterTableAddForeignKeyConstraint(Table table, HsqlNameManager.HsqlName hsqlName) throws HsqlException {
        if (hsqlName == null) {
            hsqlName = this.database.nameManager.newAutoName("FK");
        }
        Constraint constraint = this.processCreateFK(table, hsqlName);
        this.checkFKColumnDefaults(table, constraint);
        table.checkColumnsMatch(constraint.core.mainColArray, constraint.core.refTable, constraint.core.refColArray);
        this.session.commit();
        TableWorks tableWorks = new TableWorks(this.session, table);
        tableWorks.createForeignKey(constraint.core.mainColArray, constraint.core.refColArray, constraint.constName, constraint.core.refTable, constraint.core.deleteAction, constraint.core.updateAction);
    }

    private void processAlterTableAddCheckConstraint(Table table, HsqlNameManager.HsqlName hsqlName) throws HsqlException {
        if (hsqlName == null) {
            hsqlName = this.database.nameManager.newAutoName("CT");
        }
        Constraint constraint = new Constraint(hsqlName, null, null, null, 3, 3, 3);
        this.processCreateCheckConstraintCondition(constraint);
        this.session.commit();
        TableWorks tableWorks = new TableWorks(this.session, table);
        tableWorks.createCheckConstraint(constraint, hsqlName);
    }

    private void processAlterTableAddPrimaryKey(Table table, HsqlNameManager.HsqlName hsqlName) throws HsqlException {
        int[] nArray = this.processColumnList(table, false);
        this.session.commit();
        TableWorks tableWorks = new TableWorks(this.session, table);
        tableWorks.addPrimaryKey(nArray, hsqlName);
    }

    private void processReleaseSavepoint() throws HsqlException {
        this.tokenizer.getThis("SAVEPOINT");
        String string = this.tokenizer.getSimpleName();
        this.session.releaseSavepoint(string);
    }

    private void processAlterUser() throws HsqlException {
        String string = this.getUserIdentifier();
        User user = (User)this.database.getUserManager().getUsers().get(string);
        Trace.check(user != null, 37, string);
        this.tokenizer.getThis("SET");
        this.tokenizer.getThis("PASSWORD");
        String string2 = this.getPassword();
        user.setPassword(string2);
        this.database.logger.writeToLog(this.session, user.getAlterUserDDL());
        this.session.setScripting(false);
    }

    private String getUserIdentifier() throws HsqlException {
        String string = this.tokenizer.getString();
        Tokenizer tokenizer = new Tokenizer(string);
        return tokenizer.getSimpleName();
    }

    private String getPassword() throws HsqlException {
        String string = this.tokenizer.getString();
        return string.toUpperCase(Locale.ENGLISH);
    }

    private void processRoleGrantOrRevoke(boolean bl) throws HsqlException {
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        GranteeManager granteeManager = this.database.getGranteeManager();
        do {
            String string = this.tokenizer.getSimpleToken();
            Trace.check(granteeManager.isRole(string), bl ? 229 : 230);
            hsqlArrayList.add(string);
        } while (this.tokenizer.isGetThis(","));
        this.tokenizer.getThis(bl ? "TO" : "FROM");
        String string = this.getUserIdentifier();
        GranteeManager granteeManager2 = this.database.getGranteeManager();
        for (int i2 = 0; i2 < hsqlArrayList.size(); ++i2) {
            if (bl) {
                granteeManager2.grant(string, (String)hsqlArrayList.get(i2));
                continue;
            }
            granteeManager2.revoke(string, (String)hsqlArrayList.get(i2));
        }
    }
}

