/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.util.Locale;
import org.hsqldb.Column;
import org.hsqldb.DITypeInfo;
import org.hsqldb.Table;
import org.hsqldb.Types;
import org.hsqldb.resources.BundleHandler;
import org.hsqldb.store.ValuePool;

final class DITableInfo {
    int bestRowTemporary = 0;
    int bestRowTransaction = 1;
    int bestRowSession = 2;
    int bestRowUnknown = 0;
    int bestRowNotPseudo = 1;
    static final short tableIndexOther = 3;
    private static final int HALF_MAX_INT = 0x3FFFFFFF;
    private int hnd_column_remarks = -1;
    private int hnd_table_remarks = -1;
    private Table table;
    private static final DITypeInfo ti = new DITypeInfo();
    static /* synthetic */ Class class$org$hsqldb$resources$BundleHandler;

    DITableInfo() {
        this.setLocale(Locale.getDefault());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setLocale(Locale locale) {
        Class clazz = class$org$hsqldb$resources$BundleHandler == null ? (class$org$hsqldb$resources$BundleHandler = DITableInfo.class$("org.hsqldb.resources.BundleHandler")) : class$org$hsqldb$resources$BundleHandler;
        synchronized (clazz) {
            Locale locale2 = BundleHandler.getLocale();
            BundleHandler.setLocale(locale);
            this.hnd_column_remarks = BundleHandler.getBundleHandle("column-remarks", null);
            this.hnd_table_remarks = BundleHandler.getBundleHandle("table-remarks", null);
            BundleHandler.setLocale(locale2);
        }
    }

    Integer getBRIPseudo() {
        return ValuePool.getInt(this.bestRowNotPseudo);
    }

    Integer getBRIScope() {
        return this.table.isWritable() ? ValuePool.getInt(this.bestRowTemporary) : ValuePool.getInt(this.bestRowSession);
    }

    Integer getColBufLen(int n2) {
        int n3;
        Column column = this.table.getColumn(n2);
        int n4 = column.getDIType();
        switch (n4) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                n3 = column.getSize();
                if (n3 == 0) break;
                if (n3 > 0x3FFFFFFF) {
                    n3 = 0;
                    break;
                }
                n3 = 2 * n3;
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                n3 = column.getSize();
                break;
            }
            case -5: 
            case 6: 
            case 7: 
            case 8: 
            case 91: 
            case 92: {
                n3 = 8;
                break;
            }
            case 93: {
                n3 = 12;
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                n3 = 4;
                break;
            }
            case 16: {
                n3 = 1;
                break;
            }
            default: {
                n3 = 0;
            }
        }
        return n3 > 0 ? ValuePool.getInt(n3) : null;
    }

    Integer getColCharOctLen(int n2) {
        int n3;
        Column column = this.table.getColumn(n2);
        int n4 = column.getDIType();
        switch (n4) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                n3 = column.getSize();
                if (n3 == 0) break;
                if (n3 > 0x3FFFFFFF) {
                    n3 = 0;
                    break;
                }
                n3 = 2 * n3;
                break;
            }
            default: {
                n3 = 0;
            }
        }
        return n3 == 0 ? null : ValuePool.getInt(n3);
    }

    Integer getColDataType(int n2) {
        return ValuePool.getInt(this.table.getColumn(n2).getDIType());
    }

    String getColDataTypeName(int n2) {
        Column column = this.table.getColumn(n2);
        ti.setTypeCode(column.getDIType());
        ti.setTypeSub(column.getDITypeSub());
        return ti.getTypeName();
    }

    Integer getColDataTypeSub(int n2) {
        return ValuePool.getInt(this.table.getColumn(n2).getDITypeSub());
    }

    String getColDefault(int n2) {
        return this.table.getColumn(n2).getDefaultDDL();
    }

    Boolean getColIsIdentity(int n2) {
        return ValuePool.getBoolean(this.table.getColumn(n2).isIdentity());
    }

    String getColIsNullable(int n2) {
        Column column = this.table.getColumn(n2);
        return column.isNullable() && !column.isIdentity() ? "YES" : "NO";
    }

    String getColName(int n2) {
        return this.table.getColumn((int)n2).columnName.name;
    }

    Integer getColNullability(int n2) {
        Column column = this.table.getColumn(n2);
        return column.isNullable() && !column.isIdentity() ? ValuePool.getInt(1) : ValuePool.getInt(0);
    }

    Integer getColPrecRadix(int n2) {
        ti.setTypeCode(this.table.getColumn(n2).getDIType());
        return ti.getNumPrecRadix();
    }

    String getColRemarks(int n2) {
        if (this.table.getTableType() != 0) {
            return null;
        }
        String string = this.getName() + "_" + this.getColName(n2);
        return BundleHandler.getString(this.hnd_column_remarks, string);
    }

    Integer getColScale(int n2) {
        Column column = this.table.getColumn(n2);
        int n3 = column.getDIType();
        return Types.acceptsScaleCreateParam(n3) ? ValuePool.getInt(column.getScale()) : null;
    }

    String getColScopeCat(int n2) {
        return null;
    }

    String getColScopeSchem(int n2) {
        return null;
    }

    String getColScopeTable(int n2) {
        return null;
    }

    Integer getColSize(int n2) {
        Column column = this.table.getColumn(n2);
        int n3 = column.getDIType();
        if (!Types.acceptsPrecisionCreateParam(n3)) {
            return null;
        }
        int n4 = column.getSize();
        if (n4 > 0) {
            return ValuePool.getInt(n4);
        }
        ti.setTypeCode(n3);
        return ti.getPrecision();
    }

    Integer getColSqlDataType(int n2) {
        ti.setTypeCode(this.table.getColumn(n2).getDIType());
        return ti.getSqlDataType();
    }

    Integer getColSqlDateTimeSub(int n2) {
        ti.setTypeCode(this.table.getColumn(n2).getDIType());
        return ti.getSqlDateTimeSub();
    }

    String getDataSource() {
        return this.table.getDataSource();
    }

    String getHsqlType() {
        switch (this.table.getTableType()) {
            case 0: 
            case 2: 
            case 3: {
                return "MEMORY";
            }
            case 4: {
                return "CACHED";
            }
            case 5: 
            case 6: {
                return "TEXT";
            }
        }
        return null;
    }

    Integer getIndexCardinality(int n2) {
        return null;
    }

    String getIndexColDirection(int n2, int n3) {
        return "A";
    }

    int[] getIndexColumns(int n2) {
        return this.table.getIndex(n2).getColumns();
    }

    String getIndexName(int n2) {
        return this.table.getIndex((int)n2).getName().name;
    }

    Integer getIndexRowCardinality(int n2) {
        return null;
    }

    Integer getIndexType(int n2) {
        return ValuePool.getInt(3);
    }

    int getIndexVisibleColumns(int n2) {
        return this.table.getIndex(n2).getVisibleColumns();
    }

    String getName() {
        return this.table.getName().name;
    }

    Long getNextIdentity() {
        if (this.table.identityColumn < 0) {
            return null;
        }
        return ValuePool.getLong(this.table.identitySequence.peek());
    }

    String getRemark() {
        return this.table.getTableType() == 0 ? BundleHandler.getString(this.hnd_table_remarks, this.getName()) : null;
    }

    String getStandardType() {
        switch (this.table.getTableType()) {
            case 7: {
                return "VIEW";
            }
            case 2: 
            case 5: {
                return "GLOBAL TEMPORARY";
            }
            case 0: {
                return "SYSTEM TABLE";
            }
        }
        return "TABLE";
    }

    Table getTable() {
        return this.table;
    }

    Boolean isDataSourceDescending() {
        return ValuePool.getBoolean(this.table.isDescDataSource());
    }

    Boolean isIndexNonUnique(int n2) {
        return ValuePool.getBoolean(!this.table.getIndex(n2).isUnique());
    }

    Boolean isReadOnly() {
        return ValuePool.getBoolean(this.table.isDataReadOnly());
    }

    void setTable(Table table) {
        this.table = table;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

