/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.CompiledStatement;
import org.hsqldb.Database;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Session;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.lib.IntKeyIntValueHashMap;
import org.hsqldb.lib.IntValueHashMap;
import org.hsqldb.lib.Iterator;

final class CompiledStatementManager {
    private Database database;
    private IntKeyHashMap schemaMap;
    private IntKeyHashMap sqlLookup;
    private IntKeyHashMap csidMap;
    private IntKeyHashMap sessionUseMap;
    private IntKeyIntValueHashMap useMap;
    private int next_cs_id;

    CompiledStatementManager(Database database) {
        this.database = database;
        this.schemaMap = new IntKeyHashMap();
        this.sqlLookup = new IntKeyHashMap();
        this.csidMap = new IntKeyHashMap();
        this.sessionUseMap = new IntKeyHashMap();
        this.useMap = new IntKeyIntValueHashMap();
        this.next_cs_id = 0;
    }

    synchronized void reset() {
        this.schemaMap.clear();
        this.sqlLookup.clear();
        this.csidMap.clear();
        this.sessionUseMap.clear();
        this.useMap.clear();
        this.next_cs_id = 0;
    }

    synchronized void resetStatements() {
        Iterator iterator = this.csidMap.values().iterator();
        while (iterator.hasNext()) {
            CompiledStatement compiledStatement = (CompiledStatement)iterator.next();
            compiledStatement.clearVariables();
        }
    }

    private int nextID() {
        ++this.next_cs_id;
        return this.next_cs_id;
    }

    private int getStatementID(HsqlNameManager.HsqlName hsqlName, String string) {
        IntValueHashMap intValueHashMap = (IntValueHashMap)this.schemaMap.get(hsqlName.hashCode());
        if (intValueHashMap == null) {
            return -1;
        }
        return intValueHashMap.get((Object)string, -1);
    }

    synchronized CompiledStatement getStatement(Session session, int n2) {
        CompiledStatement compiledStatement = (CompiledStatement)this.csidMap.get(n2);
        if (compiledStatement == null) {
            return null;
        }
        if (!compiledStatement.isValid) {
            String string = (String)this.sqlLookup.get(n2);
            try {
                compiledStatement = this.compileSql(session, string, compiledStatement.schemaHsqlName.name);
                compiledStatement.id = n2;
                this.csidMap.put(n2, compiledStatement);
            }
            catch (Throwable throwable) {
                this.freeStatement(n2, session.getId(), true);
                return null;
            }
        }
        return compiledStatement;
    }

    private void linkSession(int n2, int n3) {
        IntKeyIntValueHashMap intKeyIntValueHashMap = (IntKeyIntValueHashMap)this.sessionUseMap.get(n3);
        if (intKeyIntValueHashMap == null) {
            intKeyIntValueHashMap = new IntKeyIntValueHashMap();
            this.sessionUseMap.put(n3, intKeyIntValueHashMap);
        }
        int n4 = intKeyIntValueHashMap.get(n2, 0);
        intKeyIntValueHashMap.put(n2, n4 + 1);
        if (n4 == 0) {
            this.useMap.put(n2, this.useMap.get(n2, 0) + 1);
        }
    }

    private int registerStatement(int n2, CompiledStatement compiledStatement) {
        if (n2 < 0) {
            n2 = this.nextID();
            int n3 = compiledStatement.schemaHsqlName.hashCode();
            IntValueHashMap intValueHashMap = (IntValueHashMap)this.schemaMap.get(n3);
            if (intValueHashMap == null) {
                intValueHashMap = new IntValueHashMap();
                this.schemaMap.put(n3, intValueHashMap);
            }
            intValueHashMap.put(compiledStatement.sql, n2);
            this.sqlLookup.put(n2, compiledStatement.sql);
        }
        compiledStatement.id = n2;
        this.csidMap.put(n2, compiledStatement);
        return n2;
    }

    void freeStatement(int n2, int n3, boolean bl) {
        if (n2 == -1) {
            return;
        }
        IntKeyIntValueHashMap intKeyIntValueHashMap = (IntKeyIntValueHashMap)this.sessionUseMap.get(n3);
        if (intKeyIntValueHashMap == null) {
            return;
        }
        int n4 = intKeyIntValueHashMap.get(n2, 0);
        if (n4 != 0) {
            if (n4 == 1 || bl) {
                intKeyIntValueHashMap.remove(n2);
                int n5 = this.useMap.get(n2, 0);
                if (n5 != 0) {
                    if (n5 == 1) {
                        CompiledStatement compiledStatement = (CompiledStatement)this.csidMap.remove(n2);
                        if (compiledStatement != null) {
                            int n6 = compiledStatement.schemaHsqlName.hashCode();
                            IntValueHashMap intValueHashMap = (IntValueHashMap)this.schemaMap.get(n6);
                            String string = (String)this.sqlLookup.remove(n2);
                            intValueHashMap.remove(string);
                        }
                        this.useMap.remove(n2);
                    } else {
                        this.useMap.put(n2, n5 - 1);
                    }
                }
            } else {
                intKeyIntValueHashMap.put(n2, n4 - 1);
            }
        }
    }

    synchronized void removeSession(int n2) {
        IntKeyIntValueHashMap intKeyIntValueHashMap = (IntKeyIntValueHashMap)this.sessionUseMap.remove(n2);
        if (intKeyIntValueHashMap == null) {
            return;
        }
        Iterator iterator = intKeyIntValueHashMap.keySet().iterator();
        while (iterator.hasNext()) {
            int n3 = iterator.nextInt();
            int n4 = this.useMap.get(n3, 1) - 1;
            if (n4 == 0) {
                CompiledStatement compiledStatement = (CompiledStatement)this.csidMap.remove(n3);
                if (compiledStatement != null) {
                    int n5 = compiledStatement.schemaHsqlName.hashCode();
                    IntValueHashMap intValueHashMap = (IntValueHashMap)this.schemaMap.get(n5);
                    String string = (String)this.sqlLookup.remove(n3);
                    intValueHashMap.remove(string);
                }
                this.useMap.remove(n3);
                continue;
            }
            this.useMap.put(n3, n4);
        }
    }

    synchronized CompiledStatement compile(Session session, String string) throws Throwable {
        int n2 = this.getStatementID(session.currentSchema, string);
        CompiledStatement compiledStatement = (CompiledStatement)this.csidMap.get(n2);
        if (compiledStatement == null || !compiledStatement.isValid || !session.isAdmin()) {
            compiledStatement = this.compileSql(session, string, session.currentSchema.name);
            n2 = this.registerStatement(n2, compiledStatement);
        }
        this.linkSession(n2, session.getId());
        return compiledStatement;
    }

    private CompiledStatement compileSql(Session session, String string, String string2) throws Throwable {
        Session session2 = this.database.sessionManager.getSysSession(string2, session.getUser());
        return session2.sqlCompileStatement(string);
    }
}

