/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Column;
import org.hsqldb.CompiledStatement;
import org.hsqldb.Expression;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlInternalException;
import org.hsqldb.Record;
import org.hsqldb.Result;
import org.hsqldb.Row;
import org.hsqldb.Select;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TableFilter;
import org.hsqldb.Trace;
import org.hsqldb.jdbc.jdbcResultSet;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.java.JavaSystem;

final class CompiledStatementExecutor {
    private Session session;
    private Result updateResult;
    private static Result emptyZeroResult = new Result(1);
    private static Result updateOneResult = new Result(1);

    CompiledStatementExecutor(Session session) {
        this.session = session;
        this.updateResult = new Result(1);
    }

    Result execute(CompiledStatement compiledStatement, Object[] objectArray) {
        Result result = null;
        JavaSystem.gc();
        for (int i2 = 0; i2 < compiledStatement.parameters.length; ++i2) {
            compiledStatement.parameters[i2].bind(objectArray[i2]);
        }
        try {
            compiledStatement.materializeSubQueries(this.session);
            result = this.executeImpl(compiledStatement);
        }
        catch (Throwable throwable) {
            result = new Result(throwable, compiledStatement.sql);
        }
        compiledStatement.dematerializeSubQueries(this.session);
        if (result == null) {
            result = emptyZeroResult;
        }
        return result;
    }

    private Result executeImpl(CompiledStatement compiledStatement) throws HsqlException {
        switch (compiledStatement.type) {
            case 5: {
                return this.executeSelectStatement(compiledStatement);
            }
            case 2: {
                return this.executeInsertSelectStatement(compiledStatement);
            }
            case 1: {
                return this.executeInsertValuesStatement(compiledStatement);
            }
            case 3: {
                return this.executeUpdateStatement(compiledStatement);
            }
            case 4: {
                return this.executeDeleteStatement(compiledStatement);
            }
            case 7: {
                return this.executeCallStatement(compiledStatement);
            }
            case 9: {
                return this.executeDDLStatement(compiledStatement);
            }
        }
        throw Trace.runtimeError(201, "CompiledStatementExecutor.executeImpl()");
    }

    private Result executeCallStatement(CompiledStatement compiledStatement) throws HsqlException {
        Expression expression = compiledStatement.expression;
        Object object = expression.getValue(this.session);
        if (object instanceof Result) {
            return (Result)object;
        }
        if (object instanceof jdbcResultSet) {
            return ((jdbcResultSet)object).rResult;
        }
        Result result = Result.newSingleColumnResult("@p0", expression.getDataType());
        Object[] objectArray = new Object[]{object};
        result.metaData.classNames[0] = expression.getValueClassName();
        result.add(objectArray);
        return result;
    }

    private Result executeDeleteStatement(CompiledStatement compiledStatement) throws HsqlException {
        Table table = compiledStatement.targetTable;
        TableFilter tableFilter = compiledStatement.targetFilter;
        int n2 = 0;
        if (tableFilter.findFirst(this.session)) {
            Expression expression = compiledStatement.condition;
            HsqlArrayList hsqlArrayList = new HsqlArrayList();
            do {
                if (expression != null && !expression.testCondition(this.session)) continue;
                hsqlArrayList.add(tableFilter.currentRow);
            } while (tableFilter.next(this.session));
            n2 = table.delete(this.session, hsqlArrayList);
        }
        this.updateResult.updateCount = n2;
        return this.updateResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result executeInsertSelectStatement(CompiledStatement compiledStatement) throws HsqlException {
        int n2;
        Table table = compiledStatement.targetTable;
        Select select = compiledStatement.select;
        int[] nArray = table.getColumnTypes();
        Result result = select.getResult(this.session, Integer.MAX_VALUE);
        Record record = result.rRoot;
        int[] nArray2 = compiledStatement.columnMap;
        boolean[] blArray = compiledStatement.checkColumns;
        int n3 = nArray2.length;
        boolean bl = false;
        this.session.beginNestedTransaction();
        try {
            while (record != null) {
                Object[] objectArray = table.getNewRowData(this.session, blArray);
                for (int i2 = 0; i2 < n3; ++i2) {
                    int n4 = nArray2[i2];
                    objectArray[n4] = nArray[n4] != result.metaData.colTypes[i2] ? Column.convertObject(record.data[i2], nArray[n4]) : record.data[i2];
                }
                record.data = objectArray;
                record = record.next;
            }
            n2 = table.insert(this.session, result);
            bl = true;
            this.session.endNestedTransaction(!bl);
        }
        catch (Throwable throwable) {
            this.session.endNestedTransaction(!bl);
            throw throwable;
        }
        this.updateResult.updateCount = n2;
        return this.updateResult;
    }

    private Result executeInsertValuesStatement(CompiledStatement compiledStatement) throws HsqlException {
        Table table = compiledStatement.targetTable;
        Object[] objectArray = table.getNewRowData(this.session, compiledStatement.checkColumns);
        int[] nArray = compiledStatement.columnMap;
        Expression[] expressionArray = compiledStatement.columnValues;
        int[] nArray2 = table.getColumnTypes();
        int n2 = expressionArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Expression expression = expressionArray[i2];
            int n3 = nArray[i2];
            objectArray[n3] = expression.getValue(this.session, nArray2[n3]);
        }
        table.insert(this.session, objectArray);
        return updateOneResult;
    }

    private Result executeSelectStatement(CompiledStatement compiledStatement) throws HsqlException {
        Result result;
        Select select = compiledStatement.select;
        if (select.sIntoTable != null) {
            boolean bl;
            this.session.checkDDLWrite();
            boolean bl2 = bl = this.session.database.schemaManager.findUserTable(this.session, select.sIntoTable.name, select.sIntoTable.schema.name) != null;
            if (bl) {
                throw Trace.error(21, select.sIntoTable.name);
            }
            result = select.getResult(this.session, Integer.MAX_VALUE);
            result = this.session.dbCommandInterpreter.processSelectInto(result, select.sIntoTable, select.intoType);
            this.session.getDatabase().setMetaDirty(false);
        } else {
            result = select.getResult(this.session, this.session.getMaxRows());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result executeUpdateStatement(CompiledStatement compiledStatement) throws HsqlException {
        Table table = compiledStatement.targetTable;
        TableFilter tableFilter = compiledStatement.targetFilter;
        int n2 = 0;
        if (tableFilter.findFirst(this.session)) {
            int[] nArray = compiledStatement.columnMap;
            Expression[] expressionArray = compiledStatement.columnValues;
            Expression expression = compiledStatement.condition;
            int n3 = expressionArray.length;
            HashMappedList hashMappedList = new HashMappedList();
            int n4 = table.getColumnCount();
            int[] nArray2 = table.getColumnTypes();
            boolean bl = false;
            do {
                if (expression != null && !expression.testCondition(this.session)) continue;
                try {
                    Row row = tableFilter.currentRow;
                    Object[] objectArray = table.getEmptyRowData();
                    System.arraycopy(row.getData(), 0, objectArray, 0, n4);
                    for (int i2 = 0; i2 < n3; ++i2) {
                        int n5 = nArray[i2];
                        objectArray[n5] = expressionArray[i2].getValue(this.session, nArray2[n5]);
                    }
                    hashMappedList.add(row, objectArray);
                }
                catch (HsqlInternalException hsqlInternalException) {
                    // empty catch block
                }
            } while (tableFilter.next(this.session));
            this.session.beginNestedTransaction();
            try {
                n2 = table.update(this.session, hashMappedList, nArray);
                bl = true;
                this.session.endNestedTransaction(!bl);
            }
            catch (Throwable throwable) {
                this.session.endNestedTransaction(!bl);
                throw throwable;
            }
        }
        this.updateResult.updateCount = n2;
        return this.updateResult;
    }

    private Result executeDDLStatement(CompiledStatement compiledStatement) throws HsqlException {
        return this.session.sqlExecuteDirectNoPreChecks(compiledStatement.sql);
    }

    static {
        CompiledStatementExecutor.updateOneResult.updateCount = 1;
    }
}

