/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.nio.ByteBuffer;
import org.eclipse.jetty.util.Utf8StringBuilder;

public class Utf8LineParser {
    private State state = State.START;
    private Utf8StringBuilder utf;

    public String parse(ByteBuffer buf) {
        while (buf.remaining() > 0) {
            byte b2 = buf.get();
            if (!this.parseByte(b2)) continue;
            this.state = State.START;
            return this.utf.toString();
        }
        return null;
    }

    private boolean parseByte(byte b2) {
        switch (this.state) {
            case START: {
                this.utf = new Utf8StringBuilder();
                this.state = State.PARSE;
                return this.parseByte(b2);
            }
            case PARSE: {
                if (this.utf.isUtf8SequenceComplete() && (b2 == 13 || b2 == 10)) {
                    this.state = State.END;
                    return this.parseByte(b2);
                }
                this.utf.append(b2);
                break;
            }
            case END: {
                if (b2 != 10) break;
                this.state = State.START;
                return true;
            }
        }
        return false;
    }

    private static enum State {
        START,
        PARSE,
        END;

    }
}

