/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jetty.util.ArrayTrie;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.Trie;
import org.eclipse.jetty.util.TypeUtil;

public class StringUtil {
    private static final Trie<String> CHARSETS = new ArrayTrie<String>(256);
    public static final String ALL_INTERFACES = "0.0.0.0";
    public static final String CRLF = "\r\n";
    @Deprecated
    public static final String __LINE_SEPARATOR = System.lineSeparator();
    public static final String __ISO_8859_1 = "iso-8859-1";
    public static final String __UTF8 = "utf-8";
    public static final String __UTF16 = "utf-16";
    public static final char[] lowercases;

    public static String normalizeCharset(String s2) {
        String n2 = CHARSETS.get(s2);
        return n2 == null ? s2 : n2;
    }

    public static String normalizeCharset(String s2, int offset, int length) {
        String n2 = CHARSETS.get(s2, offset, length);
        return n2 == null ? s2.substring(offset, offset + length) : n2;
    }

    public static String asciiToLowerCase(String s2) {
        if (s2 == null) {
            return null;
        }
        char[] c2 = null;
        int i2 = s2.length();
        while (i2-- > 0) {
            char c22;
            char c1 = s2.charAt(i2);
            if (c1 > '\u007f' || c1 == (c22 = lowercases[c1])) continue;
            c2 = s2.toCharArray();
            c2[i2] = c22;
            break;
        }
        while (i2-- > 0) {
            if (c2[i2] > 127) continue;
            c2[i2] = lowercases[c2[i2]];
        }
        return c2 == null ? s2 : new String(c2);
    }

    public static String sanitizeFileSystemName(String str) {
        if (str == null) {
            return null;
        }
        char[] chars = str.toCharArray();
        int len = chars.length;
        for (int i2 = 0; i2 < len; ++i2) {
            char c2 = chars[i2];
            if (c2 > '\u001f' && c2 < '\u007f' && c2 != '|' && c2 != '>' && c2 != '<' && c2 != '/' && c2 != '&' && c2 != '\\' && c2 != '.' && c2 != ':' && c2 != '=' && c2 != '\"' && c2 != ',' && c2 != '*' && c2 != '?' && c2 != '!' && c2 != ' ') continue;
            chars[i2] = 95;
        }
        return String.valueOf(chars);
    }

    public static boolean startsWithIgnoreCase(String s2, String w2) {
        if (w2 == null) {
            return true;
        }
        if (s2 == null || s2.length() < w2.length()) {
            return false;
        }
        for (int i2 = 0; i2 < w2.length(); ++i2) {
            char c2;
            char c1 = s2.charAt(i2);
            if (c1 == (c2 = w2.charAt(i2))) continue;
            if (c1 <= '\u007f') {
                c1 = lowercases[c1];
            }
            if (c2 <= '\u007f') {
                c2 = lowercases[c2];
            }
            if (c1 == c2) continue;
            return false;
        }
        return true;
    }

    public static boolean endsWithIgnoreCase(String s2, String w2) {
        int wl;
        if (w2 == null) {
            return true;
        }
        if (s2 == null) {
            return false;
        }
        int sl = s2.length();
        if (sl < (wl = w2.length())) {
            return false;
        }
        int i2 = wl;
        while (i2-- > 0) {
            char c2;
            char c1;
            if ((c1 = s2.charAt(--sl)) == (c2 = w2.charAt(i2))) continue;
            if (c1 <= '\u007f') {
                c1 = lowercases[c1];
            }
            if (c2 <= '\u007f') {
                c2 = lowercases[c2];
            }
            if (c1 == c2) continue;
            return false;
        }
        return true;
    }

    public static int indexFrom(String s2, String chars) {
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            if (chars.indexOf(s2.charAt(i2)) < 0) continue;
            return i2;
        }
        return -1;
    }

    public static String replace(String str, char find, char with) {
        if (str == null) {
            return null;
        }
        if (find == with) {
            return str;
        }
        int c2 = 0;
        int idx = str.indexOf(find, c2);
        if (idx == -1) {
            return str;
        }
        char[] chars = str.toCharArray();
        int len = chars.length;
        for (int i2 = idx; i2 < len; ++i2) {
            if (chars[i2] != find) continue;
            chars[i2] = with;
        }
        return String.valueOf(chars);
    }

    public static String replace(String s2, String sub, String with) {
        if (s2 == null) {
            return null;
        }
        int c2 = 0;
        int i2 = s2.indexOf(sub, c2);
        if (i2 == -1) {
            return s2;
        }
        StringBuilder buf = new StringBuilder(s2.length() + with.length());
        do {
            buf.append(s2, c2, i2);
            buf.append(with);
        } while ((i2 = s2.indexOf(sub, c2 = i2 + sub.length())) != -1);
        if (c2 < s2.length()) {
            buf.append(s2.substring(c2));
        }
        return buf.toString();
    }

    public static String replaceFirst(String original, String target, String replacement) {
        int idx = original.indexOf(target);
        if (idx == -1) {
            return original;
        }
        int offset = 0;
        int originalLen = original.length();
        StringBuilder buf = new StringBuilder(originalLen + replacement.length());
        buf.append(original, offset, idx);
        buf.append(replacement);
        buf.append(original, offset += idx + target.length(), originalLen);
        return buf.toString();
    }

    @Deprecated
    public static String unquote(String s2) {
        return QuotedStringTokenizer.unquote(s2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void append(StringBuilder buf, String s2, int offset, int length) {
        StringBuilder stringBuilder = buf;
        synchronized (stringBuilder) {
            int end = offset + length;
            for (int i2 = offset; i2 < end && i2 < s2.length(); ++i2) {
                buf.append(s2.charAt(i2));
            }
        }
    }

    public static void append(StringBuilder buf, byte b2, int base) {
        int bi = 0xFF & b2;
        int c2 = 48 + bi / base % base;
        if (c2 > 57) {
            c2 = 97 + (c2 - 48 - 10);
        }
        buf.append((char)c2);
        c2 = 48 + bi % base;
        if (c2 > 57) {
            c2 = 97 + (c2 - 48 - 10);
        }
        buf.append((char)c2);
    }

    public static void append2digits(StringBuffer buf, int i2) {
        if (i2 < 100) {
            buf.append((char)(i2 / 10 + 48));
            buf.append((char)(i2 % 10 + 48));
        }
    }

    public static void append2digits(StringBuilder buf, int i2) {
        if (i2 < 100) {
            buf.append((char)(i2 / 10 + 48));
            buf.append((char)(i2 % 10 + 48));
        }
    }

    public static String nonNull(String s2) {
        if (s2 == null) {
            return "";
        }
        return s2;
    }

    public static boolean equals(String s2, char[] buf, int offset, int length) {
        if (s2.length() != length) {
            return false;
        }
        for (int i2 = 0; i2 < length; ++i2) {
            if (buf[offset + i2] == s2.charAt(i2)) continue;
            return false;
        }
        return true;
    }

    public static String toUTF8String(byte[] b2, int offset, int length) {
        return new String(b2, offset, length, StandardCharsets.UTF_8);
    }

    public static String toString(byte[] b2, int offset, int length, String charset) {
        try {
            return new String(b2, offset, length, charset);
        }
        catch (UnsupportedEncodingException e2) {
            throw new IllegalArgumentException(e2);
        }
    }

    public static int indexOfControlChars(String str) {
        if (str == null) {
            return -1;
        }
        int len = str.length();
        for (int i2 = 0; i2 < len; ++i2) {
            if (!Character.isISOControl(str.codePointAt(i2))) continue;
            return i2;
        }
        return -1;
    }

    public static boolean isBlank(String str) {
        if (str == null) {
            return true;
        }
        int len = str.length();
        for (int i2 = 0; i2 < len; ++i2) {
            if (Character.isWhitespace(str.codePointAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static boolean isNotBlank(String str) {
        if (str == null) {
            return false;
        }
        int len = str.length();
        for (int i2 = 0; i2 < len; ++i2) {
            if (Character.isWhitespace(str.codePointAt(i2))) continue;
            return true;
        }
        return false;
    }

    public static boolean isUTF8(String charset) {
        return __UTF8.equalsIgnoreCase(charset) || __UTF8.equalsIgnoreCase(StringUtil.normalizeCharset(charset));
    }

    public static boolean isHex(String str, int offset, int length) {
        if (offset + length > str.length()) {
            return false;
        }
        for (int i2 = offset; i2 < offset + length; ++i2) {
            char c2 = str.charAt(i2);
            if (c2 >= 'a' && c2 <= 'f' || c2 >= 'A' && c2 <= 'F' || c2 >= '0' && c2 <= '9') continue;
            return false;
        }
        return true;
    }

    public static String printable(String name) {
        if (name == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder(name.length());
        for (int i2 = 0; i2 < name.length(); ++i2) {
            char c2 = name.charAt(i2);
            if (Character.isISOControl(c2)) continue;
            buf.append(c2);
        }
        return buf.toString();
    }

    public static String printable(byte[] b2) {
        StringBuilder buf = new StringBuilder();
        for (int i2 = 0; i2 < b2.length; ++i2) {
            char c2 = (char)b2[i2];
            if (Character.isWhitespace(c2) || c2 > ' ' && c2 < '\u007f') {
                buf.append(c2);
                continue;
            }
            buf.append("0x");
            TypeUtil.toHex(b2[i2], (Appendable)buf);
        }
        return buf.toString();
    }

    public static byte[] getBytes(String s2) {
        return s2.getBytes(StandardCharsets.ISO_8859_1);
    }

    public static byte[] getUtf8Bytes(String s2) {
        return s2.getBytes(StandardCharsets.UTF_8);
    }

    public static byte[] getBytes(String s2, String charset) {
        try {
            return s2.getBytes(charset);
        }
        catch (Exception e2) {
            return s2.getBytes();
        }
    }

    @Deprecated
    public static String sidBytesToString(byte[] sidBytes) {
        StringBuilder sidString = new StringBuilder();
        sidString.append("S-");
        sidString.append(sidBytes[0]).append('-');
        StringBuilder tmpBuilder = new StringBuilder();
        for (int i2 = 2; i2 <= 7; ++i2) {
            tmpBuilder.append(Integer.toHexString(sidBytes[i2] & 0xFF));
        }
        sidString.append(Long.parseLong(tmpBuilder.toString(), 16));
        int subAuthorityCount = sidBytes[1];
        for (int i3 = 0; i3 < subAuthorityCount; ++i3) {
            int offset = i3 * 4;
            tmpBuilder.setLength(0);
            tmpBuilder.append(String.format("%02X%02X%02X%02X", sidBytes[11 + offset] & 0xFF, sidBytes[10 + offset] & 0xFF, sidBytes[9 + offset] & 0xFF, sidBytes[8 + offset] & 0xFF));
            sidString.append('-').append(Long.parseLong(tmpBuilder.toString(), 16));
        }
        return sidString.toString();
    }

    @Deprecated
    public static byte[] sidStringToBytes(String sidString) {
        int i2;
        String[] sidTokens = sidString.split("-");
        int subAuthorityCount = sidTokens.length - 3;
        int byteCount = 0;
        byte[] sidBytes = new byte[8 + 4 * subAuthorityCount];
        sidBytes[byteCount++] = (byte)Integer.parseInt(sidTokens[1]);
        sidBytes[byteCount++] = (byte)subAuthorityCount;
        String hexStr = Long.toHexString(Long.parseLong(sidTokens[2]));
        while (hexStr.length() < 12) {
            hexStr = "0" + hexStr;
        }
        for (i2 = 0; i2 < hexStr.length(); i2 += 2) {
            sidBytes[byteCount++] = (byte)Integer.parseInt(hexStr.substring(i2, i2 + 2), 16);
        }
        for (i2 = 3; i2 < sidTokens.length; ++i2) {
            hexStr = Long.toHexString(Long.parseLong(sidTokens[i2]));
            while (hexStr.length() < 8) {
                hexStr = "0" + hexStr;
            }
            for (int j2 = hexStr.length(); j2 > 0; j2 -= 2) {
                sidBytes[byteCount++] = (byte)Integer.parseInt(hexStr.substring(j2 - 2, j2), 16);
            }
        }
        return sidBytes;
    }

    public static int toInt(String string, int from) {
        int val = 0;
        boolean started = false;
        boolean minus = false;
        for (int i2 = from; i2 < string.length(); ++i2) {
            char b2 = string.charAt(i2);
            if (b2 <= ' ') {
                if (!started) continue;
                break;
            }
            if (b2 >= '0' && b2 <= '9') {
                val = val * 10 + (b2 - 48);
                started = true;
                continue;
            }
            if (b2 != '-' || started) break;
            minus = true;
        }
        if (started) {
            return minus ? -val : val;
        }
        throw new NumberFormatException(string);
    }

    public static long toLong(String string) {
        long val = 0L;
        boolean started = false;
        boolean minus = false;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char b2 = string.charAt(i2);
            if (b2 <= ' ') {
                if (!started) continue;
                break;
            }
            if (b2 >= '0' && b2 <= '9') {
                val = val * 10L + (long)(b2 - 48);
                started = true;
                continue;
            }
            if (b2 != '-' || started) break;
            minus = true;
        }
        if (started) {
            return minus ? -val : val;
        }
        throw new NumberFormatException(string);
    }

    public static String truncate(String str, int maxSize) {
        if (str == null) {
            return null;
        }
        if (str.length() <= maxSize) {
            return str;
        }
        return str.substring(0, maxSize);
    }

    public static String[] arrayFromString(String s2) {
        if (s2 == null) {
            return new String[0];
        }
        if (!s2.startsWith("[") || !s2.endsWith("]")) {
            throw new IllegalArgumentException();
        }
        if (s2.length() == 2) {
            return new String[0];
        }
        return StringUtil.csvSplit(s2, 1, s2.length() - 2);
    }

    public static String[] csvSplit(String s2) {
        if (s2 == null) {
            return null;
        }
        return StringUtil.csvSplit(s2, 0, s2.length());
    }

    public static String[] csvSplit(String s2, int off, int len) {
        if (s2 == null) {
            return null;
        }
        if (off < 0 || len < 0 || off > s2.length()) {
            throw new IllegalArgumentException();
        }
        ArrayList<String> list = new ArrayList<String>();
        StringUtil.csvSplit(list, s2, off, len);
        return list.toArray(new String[list.size()]);
    }

    public static List<String> csvSplit(List<String> list, String s2, int off, int len) {
        if (list == null) {
            list = new ArrayList<String>();
        }
        CsvSplitState state = CsvSplitState.PRE_DATA;
        StringBuilder out = new StringBuilder();
        int last = -1;
        block13: while (len > 0) {
            char ch = s2.charAt(off++);
            --len;
            switch (state) {
                case PRE_DATA: {
                    if (Character.isWhitespace(ch)) continue block13;
                    if ('\"' == ch) {
                        state = CsvSplitState.QUOTE;
                        continue block13;
                    }
                    if (',' == ch) {
                        list.add("");
                        continue block13;
                    }
                    state = CsvSplitState.DATA;
                    out.append(ch);
                    continue block13;
                }
                case DATA: {
                    if (Character.isWhitespace(ch)) {
                        last = out.length();
                        out.append(ch);
                        state = CsvSplitState.WHITE;
                        continue block13;
                    }
                    if (',' == ch) {
                        list.add(out.toString());
                        out.setLength(0);
                        state = CsvSplitState.PRE_DATA;
                        continue block13;
                    }
                    out.append(ch);
                    continue block13;
                }
                case WHITE: {
                    if (Character.isWhitespace(ch)) {
                        out.append(ch);
                        continue block13;
                    }
                    if (',' == ch) {
                        out.setLength(last);
                        list.add(out.toString());
                        out.setLength(0);
                        state = CsvSplitState.PRE_DATA;
                        continue block13;
                    }
                    state = CsvSplitState.DATA;
                    out.append(ch);
                    last = -1;
                    continue block13;
                }
                case QUOTE: {
                    if ('\\' == ch) {
                        state = CsvSplitState.SLOSH;
                        continue block13;
                    }
                    if ('\"' == ch) {
                        list.add(out.toString());
                        out.setLength(0);
                        state = CsvSplitState.POST_DATA;
                        continue block13;
                    }
                    out.append(ch);
                    continue block13;
                }
                case SLOSH: {
                    out.append(ch);
                    state = CsvSplitState.QUOTE;
                    continue block13;
                }
                case POST_DATA: {
                    if (',' != ch) continue block13;
                    state = CsvSplitState.PRE_DATA;
                    continue block13;
                }
            }
        }
        switch (state) {
            case PRE_DATA: 
            case POST_DATA: {
                break;
            }
            case DATA: 
            case QUOTE: 
            case SLOSH: {
                list.add(out.toString());
                break;
            }
            case WHITE: {
                out.setLength(last);
                list.add(out.toString());
            }
        }
        return list;
    }

    public static String sanitizeXmlString(String html) {
        int i2;
        if (html == null) {
            return null;
        }
        block10: for (i2 = 0; i2 < html.length(); ++i2) {
            char c2 = html.charAt(i2);
            switch (c2) {
                case '\"': 
                case '&': 
                case '\'': 
                case '<': 
                case '>': {
                    break block10;
                }
                default: {
                    if (Character.isISOControl(c2) && !Character.isWhitespace(c2)) break block10;
                    continue block10;
                }
            }
        }
        if (i2 == html.length()) {
            return html;
        }
        StringBuilder out = new StringBuilder(html.length() * 4 / 3);
        out.append(html, 0, i2);
        while (i2 < html.length()) {
            char c3 = html.charAt(i2);
            switch (c3) {
                case '&': {
                    out.append("&amp;");
                    break;
                }
                case '<': {
                    out.append("&lt;");
                    break;
                }
                case '>': {
                    out.append("&gt;");
                    break;
                }
                case '\'': {
                    out.append("&apos;");
                    break;
                }
                case '\"': {
                    out.append("&quot;");
                    break;
                }
                default: {
                    if (Character.isISOControl(c3) && !Character.isWhitespace(c3)) {
                        out.append('?');
                        break;
                    }
                    out.append(c3);
                }
            }
            ++i2;
        }
        return out.toString();
    }

    public static String strip(String str, String find) {
        return StringUtil.replace(str, find, "");
    }

    public static String valueOf(Object object) {
        return object == null ? null : String.valueOf(object);
    }

    static {
        CHARSETS.put(__UTF8, __UTF8);
        CHARSETS.put("utf8", __UTF8);
        CHARSETS.put(__UTF16, __UTF16);
        CHARSETS.put("utf16", __UTF16);
        CHARSETS.put(__ISO_8859_1, __ISO_8859_1);
        CHARSETS.put("iso_8859_1", __ISO_8859_1);
        lowercases = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u007f'};
    }

    static enum CsvSplitState {
        PRE_DATA,
        QUOTE,
        SLOSH,
        DATA,
        WHITE,
        POST_DATA;

    }
}

