/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.eclipse.jetty.util.Trie;

public abstract class AbstractTrie<V>
implements Trie<V> {
    final boolean _caseInsensitive;

    protected AbstractTrie(boolean insensitive) {
        this._caseInsensitive = insensitive;
    }

    @Override
    public boolean put(V v2) {
        return this.put(v2.toString(), v2);
    }

    @Override
    public V remove(String s2) {
        V o2 = this.get(s2);
        this.put(s2, null);
        return o2;
    }

    @Override
    public V get(String s2) {
        return this.get(s2, 0, s2.length());
    }

    @Override
    public V get(ByteBuffer b2) {
        return this.get(b2, 0, b2.remaining());
    }

    @Override
    public V getBest(String s2) {
        return this.getBest(s2, 0, s2.length());
    }

    @Override
    public V getBest(byte[] b2, int offset, int len) {
        return this.getBest(new String(b2, offset, len, StandardCharsets.ISO_8859_1));
    }

    @Override
    public boolean isCaseInsensitive() {
        return this._caseInsensitive;
    }
}

