/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax2.ri.typed;

import org.codehaus.stax2.ri.typed.AsciiValueEncoder;
import org.codehaus.stax2.ri.typed.NumberUtil;
import org.codehaus.stax2.typed.Base64Variant;

public final class ValueEncoderFactory {
    static final byte BYTE_SPACE = 32;
    protected TokenEncoder _tokenEncoder = null;
    protected IntEncoder _intEncoder = null;
    protected LongEncoder _longEncoder = null;
    protected FloatEncoder _floatEncoder = null;
    protected DoubleEncoder _doubleEncoder = null;

    public ScalarEncoder getScalarEncoder(String string) {
        if (string.length() > 64) {
            if (this._tokenEncoder == null) {
                this._tokenEncoder = new TokenEncoder();
            }
            this._tokenEncoder.reset(string);
            return this._tokenEncoder;
        }
        return new StringEncoder(string);
    }

    public ScalarEncoder getEncoder(boolean bl) {
        return this.getScalarEncoder(bl ? "true" : "false");
    }

    public IntEncoder getEncoder(int n2) {
        if (this._intEncoder == null) {
            this._intEncoder = new IntEncoder();
        }
        this._intEncoder.reset(n2);
        return this._intEncoder;
    }

    public LongEncoder getEncoder(long l2) {
        if (this._longEncoder == null) {
            this._longEncoder = new LongEncoder();
        }
        this._longEncoder.reset(l2);
        return this._longEncoder;
    }

    public FloatEncoder getEncoder(float f2) {
        if (this._floatEncoder == null) {
            this._floatEncoder = new FloatEncoder();
        }
        this._floatEncoder.reset(f2);
        return this._floatEncoder;
    }

    public DoubleEncoder getEncoder(double d2) {
        if (this._doubleEncoder == null) {
            this._doubleEncoder = new DoubleEncoder();
        }
        this._doubleEncoder.reset(d2);
        return this._doubleEncoder;
    }

    public IntArrayEncoder getEncoder(int[] nArray, int n2, int n3) {
        return new IntArrayEncoder(nArray, n2, n2 + n3);
    }

    public LongArrayEncoder getEncoder(long[] lArray, int n2, int n3) {
        return new LongArrayEncoder(lArray, n2, n2 + n3);
    }

    public FloatArrayEncoder getEncoder(float[] fArray, int n2, int n3) {
        return new FloatArrayEncoder(fArray, n2, n2 + n3);
    }

    public DoubleArrayEncoder getEncoder(double[] dArray, int n2, int n3) {
        return new DoubleArrayEncoder(dArray, n2, n2 + n3);
    }

    public Base64Encoder getEncoder(Base64Variant base64Variant, byte[] byArray, int n2, int n3) {
        return new Base64Encoder(base64Variant, byArray, n2, n2 + n3);
    }

    static final class Base64Encoder
    extends AsciiValueEncoder {
        static final char PAD_CHAR = '=';
        static final byte PAD_BYTE = 61;
        static final byte LF_CHAR = 10;
        static final byte LF_BYTE = 10;
        final Base64Variant _variant;
        final byte[] _input;
        int _inputPtr;
        final int _inputEnd;
        int _chunksBeforeLf;

        protected Base64Encoder(Base64Variant base64Variant, byte[] byArray, int n2, int n3) {
            this._variant = base64Variant;
            this._input = byArray;
            this._inputPtr = n2;
            this._inputEnd = n3;
            this._chunksBeforeLf = this._variant.getMaxLineLength() >> 2;
        }

        public boolean isCompleted() {
            return this._inputPtr >= this._inputEnd;
        }

        public int encodeMore(char[] cArray, int n2, int n3) {
            int n4;
            int n5 = this._inputEnd - 3;
            n3 -= 5;
            while (this._inputPtr <= n5) {
                if (n2 > n3) {
                    return n2;
                }
                n4 = this._input[this._inputPtr++] << 8;
                n4 |= this._input[this._inputPtr++] & 0xFF;
                n4 = n4 << 8 | this._input[this._inputPtr++] & 0xFF;
                n2 = this._variant.encodeBase64Chunk(n4, cArray, n2);
                if (--this._chunksBeforeLf > 0) continue;
                cArray[n2++] = 10;
                this._chunksBeforeLf = this._variant.getMaxLineLength() >> 2;
            }
            n4 = this._inputEnd - this._inputPtr;
            if (n4 > 0 && n2 <= n3) {
                int n6 = this._input[this._inputPtr++] << 16;
                if (n4 == 2) {
                    n6 |= (this._input[this._inputPtr++] & 0xFF) << 8;
                }
                n2 = this._variant.encodeBase64Partial(n6, n4, cArray, n2);
            }
            return n2;
        }

        public int encodeMore(byte[] byArray, int n2, int n3) {
            int n4;
            int n5 = this._inputEnd - 3;
            n3 -= 5;
            while (this._inputPtr <= n5) {
                if (n2 > n3) {
                    return n2;
                }
                n4 = this._input[this._inputPtr++] << 8;
                n4 |= this._input[this._inputPtr++] & 0xFF;
                n4 = n4 << 8 | this._input[this._inputPtr++] & 0xFF;
                n2 = this._variant.encodeBase64Chunk(n4, byArray, n2);
                if (--this._chunksBeforeLf > 0) continue;
                byArray[n2++] = 10;
                this._chunksBeforeLf = this._variant.getMaxLineLength() >> 2;
            }
            n4 = this._inputEnd - this._inputPtr;
            if (n4 > 0 && n2 <= n3) {
                int n6 = this._input[this._inputPtr++] << 16;
                if (n4 == 2) {
                    n6 |= (this._input[this._inputPtr++] & 0xFF) << 8;
                }
                n2 = this._variant.encodeBase64Partial(n6, n4, byArray, n2);
            }
            return n2;
        }
    }

    static final class DoubleArrayEncoder
    extends ArrayEncoder {
        final double[] _values;

        protected DoubleArrayEncoder(double[] dArray, int n2, int n3) {
            super(n2, n3);
            this._values = dArray;
        }

        public int encodeMore(char[] cArray, int n2, int n3) {
            int n4 = n3 - 33;
            while (n2 <= n4 && this._ptr < this._end) {
                cArray[n2++] = 32;
                n2 = NumberUtil.writeDouble(this._values[this._ptr++], cArray, n2);
            }
            return n2;
        }

        public int encodeMore(byte[] byArray, int n2, int n3) {
            int n4 = n3 - 33;
            while (n2 <= n4 && this._ptr < this._end) {
                byArray[n2++] = 32;
                n2 = NumberUtil.writeDouble(this._values[this._ptr++], byArray, n2);
            }
            return n2;
        }
    }

    static final class FloatArrayEncoder
    extends ArrayEncoder {
        final float[] _values;

        protected FloatArrayEncoder(float[] fArray, int n2, int n3) {
            super(n2, n3);
            this._values = fArray;
        }

        public int encodeMore(char[] cArray, int n2, int n3) {
            int n4 = n3 - 33;
            while (n2 <= n4 && this._ptr < this._end) {
                cArray[n2++] = 32;
                n2 = NumberUtil.writeFloat(this._values[this._ptr++], cArray, n2);
            }
            return n2;
        }

        public int encodeMore(byte[] byArray, int n2, int n3) {
            int n4 = n3 - 33;
            while (n2 <= n4 && this._ptr < this._end) {
                byArray[n2++] = 32;
                n2 = NumberUtil.writeFloat(this._values[this._ptr++], byArray, n2);
            }
            return n2;
        }
    }

    static final class LongArrayEncoder
    extends ArrayEncoder {
        final long[] _values;

        protected LongArrayEncoder(long[] lArray, int n2, int n3) {
            super(n2, n3);
            this._values = lArray;
        }

        public int encodeMore(char[] cArray, int n2, int n3) {
            int n4 = n3 - 22;
            while (n2 <= n4 && this._ptr < this._end) {
                cArray[n2++] = 32;
                n2 = NumberUtil.writeLong(this._values[this._ptr++], cArray, n2);
            }
            return n2;
        }

        public int encodeMore(byte[] byArray, int n2, int n3) {
            int n4 = n3 - 22;
            while (n2 <= n4 && this._ptr < this._end) {
                byArray[n2++] = 32;
                n2 = NumberUtil.writeLong(this._values[this._ptr++], byArray, n2);
            }
            return n2;
        }
    }

    static final class IntArrayEncoder
    extends ArrayEncoder {
        final int[] _values;

        protected IntArrayEncoder(int[] nArray, int n2, int n3) {
            super(n2, n3);
            this._values = nArray;
        }

        public int encodeMore(char[] cArray, int n2, int n3) {
            int n4 = n3 - 12;
            while (n2 <= n4 && this._ptr < this._end) {
                cArray[n2++] = 32;
                n2 = NumberUtil.writeInt(this._values[this._ptr++], cArray, n2);
            }
            return n2;
        }

        public int encodeMore(byte[] byArray, int n2, int n3) {
            int n4 = n3 - 12;
            while (n2 <= n4 && this._ptr < this._end) {
                byArray[n2++] = 32;
                n2 = NumberUtil.writeInt(this._values[this._ptr++], byArray, n2);
            }
            return n2;
        }
    }

    static abstract class ArrayEncoder
    extends AsciiValueEncoder {
        int _ptr;
        final int _end;

        protected ArrayEncoder(int n2, int n3) {
            this._ptr = n2;
            this._end = n3;
        }

        public final boolean isCompleted() {
            return this._ptr >= this._end;
        }

        public abstract int encodeMore(char[] var1, int var2, int var3);
    }

    static final class DoubleEncoder
    extends TypedScalarEncoder {
        double _value;

        protected DoubleEncoder() {
        }

        protected void reset(double d2) {
            this._value = d2;
        }

        public int encodeMore(char[] cArray, int n2, int n3) {
            return NumberUtil.writeDouble(this._value, cArray, n2);
        }

        public int encodeMore(byte[] byArray, int n2, int n3) {
            return NumberUtil.writeDouble(this._value, byArray, n2);
        }
    }

    static final class FloatEncoder
    extends TypedScalarEncoder {
        float _value;

        protected FloatEncoder() {
        }

        protected void reset(float f2) {
            this._value = f2;
        }

        public int encodeMore(char[] cArray, int n2, int n3) {
            return NumberUtil.writeFloat(this._value, cArray, n2);
        }

        public int encodeMore(byte[] byArray, int n2, int n3) {
            return NumberUtil.writeFloat(this._value, byArray, n2);
        }
    }

    static final class LongEncoder
    extends TypedScalarEncoder {
        long _value;

        protected LongEncoder() {
        }

        protected void reset(long l2) {
            this._value = l2;
        }

        public int encodeMore(char[] cArray, int n2, int n3) {
            return NumberUtil.writeLong(this._value, cArray, n2);
        }

        public int encodeMore(byte[] byArray, int n2, int n3) {
            return NumberUtil.writeLong(this._value, byArray, n2);
        }
    }

    static final class IntEncoder
    extends TypedScalarEncoder {
        int _value;

        protected IntEncoder() {
        }

        protected void reset(int n2) {
            this._value = n2;
        }

        public int encodeMore(char[] cArray, int n2, int n3) {
            return NumberUtil.writeInt(this._value, cArray, n2);
        }

        public int encodeMore(byte[] byArray, int n2, int n3) {
            return NumberUtil.writeInt(this._value, byArray, n2);
        }
    }

    static abstract class TypedScalarEncoder
    extends ScalarEncoder {
        protected TypedScalarEncoder() {
        }

        public final boolean isCompleted() {
            return true;
        }
    }

    static final class StringEncoder
    extends ScalarEncoder {
        String _value;
        int _offset;

        protected StringEncoder(String string) {
            this._value = string;
        }

        public boolean isCompleted() {
            return this._value == null;
        }

        public int encodeMore(char[] cArray, int n2, int n3) {
            int n4 = n3 - n2;
            int n5 = this._value.length() - this._offset;
            if (n4 >= n5) {
                this._value.getChars(this._offset, n5, cArray, n2);
                this._value = null;
                return n2 + n5;
            }
            this._value.getChars(this._offset, n4, cArray, n2);
            this._offset += n4;
            return n3;
        }

        public int encodeMore(byte[] byArray, int n2, int n3) {
            int n4 = n3 - n2;
            int n5 = this._value.length() - this._offset;
            if (n4 >= n5) {
                String string = this._value;
                this._value = null;
                int n6 = string.length();
                for (int i2 = this._offset; i2 < n6; ++i2) {
                    byArray[n2++] = (byte)string.charAt(i2);
                }
                return n2;
            }
            while (n2 < n3) {
                byArray[n2] = (byte)this._value.charAt(this._offset++);
                ++n2;
            }
            return n2;
        }
    }

    static final class TokenEncoder
    extends ScalarEncoder {
        String _value;

        protected TokenEncoder() {
        }

        protected void reset(String string) {
            this._value = string;
        }

        public boolean isCompleted() {
            return this._value == null;
        }

        public int encodeMore(char[] cArray, int n2, int n3) {
            String string = this._value;
            this._value = null;
            int n4 = string.length();
            string.getChars(0, n4, cArray, n2);
            return n2 += n4;
        }

        public int encodeMore(byte[] byArray, int n2, int n3) {
            String string = this._value;
            this._value = null;
            int n4 = string.length();
            for (int i2 = 0; i2 < n4; ++i2) {
                byArray[n2++] = (byte)string.charAt(i2);
            }
            return n2;
        }
    }

    static abstract class ScalarEncoder
    extends AsciiValueEncoder {
        protected ScalarEncoder() {
        }
    }
}

