/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.stax2.ri.typed;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.codehaus.stax2.typed.TypedArrayDecoder;
import org.codehaus.stax2.typed.TypedValueDecoder;

public final class ValueDecoderFactory {
    protected BooleanDecoder mBooleanDecoder = null;
    protected IntDecoder mIntDecoder = null;
    protected LongDecoder mLongDecoder = null;
    protected FloatDecoder mFloatDecoder = null;
    protected DoubleDecoder mDoubleDecoder = null;

    public BooleanDecoder getBooleanDecoder() {
        if (this.mBooleanDecoder == null) {
            this.mBooleanDecoder = new BooleanDecoder();
        }
        return this.mBooleanDecoder;
    }

    public IntDecoder getIntDecoder() {
        if (this.mIntDecoder == null) {
            this.mIntDecoder = new IntDecoder();
        }
        return this.mIntDecoder;
    }

    public LongDecoder getLongDecoder() {
        if (this.mLongDecoder == null) {
            this.mLongDecoder = new LongDecoder();
        }
        return this.mLongDecoder;
    }

    public FloatDecoder getFloatDecoder() {
        if (this.mFloatDecoder == null) {
            this.mFloatDecoder = new FloatDecoder();
        }
        return this.mFloatDecoder;
    }

    public DoubleDecoder getDoubleDecoder() {
        if (this.mDoubleDecoder == null) {
            this.mDoubleDecoder = new DoubleDecoder();
        }
        return this.mDoubleDecoder;
    }

    public IntegerDecoder getIntegerDecoder() {
        return new IntegerDecoder();
    }

    public DecimalDecoder getDecimalDecoder() {
        return new DecimalDecoder();
    }

    public QNameDecoder getQNameDecoder(NamespaceContext namespaceContext) {
        return new QNameDecoder(namespaceContext);
    }

    public IntArrayDecoder getIntArrayDecoder(int[] nArray, int n2, int n3) {
        return new IntArrayDecoder(nArray, n2, n3, this.getIntDecoder());
    }

    public IntArrayDecoder getIntArrayDecoder() {
        return new IntArrayDecoder(this.getIntDecoder());
    }

    public LongArrayDecoder getLongArrayDecoder(long[] lArray, int n2, int n3) {
        return new LongArrayDecoder(lArray, n2, n3, this.getLongDecoder());
    }

    public LongArrayDecoder getLongArrayDecoder() {
        return new LongArrayDecoder(this.getLongDecoder());
    }

    public FloatArrayDecoder getFloatArrayDecoder(float[] fArray, int n2, int n3) {
        return new FloatArrayDecoder(fArray, n2, n3, this.getFloatDecoder());
    }

    public FloatArrayDecoder getFloatArrayDecoder() {
        return new FloatArrayDecoder(this.getFloatDecoder());
    }

    public DoubleArrayDecoder getDoubleArrayDecoder(double[] dArray, int n2, int n3) {
        return new DoubleArrayDecoder(dArray, n2, n3, this.getDoubleDecoder());
    }

    public DoubleArrayDecoder getDoubleArrayDecoder() {
        return new DoubleArrayDecoder(this.getDoubleDecoder());
    }

    public static final class DoubleArrayDecoder
    extends BaseArrayDecoder {
        double[] mResult;
        final DoubleDecoder mDecoder;

        public DoubleArrayDecoder(double[] dArray, int n2, int n3, DoubleDecoder doubleDecoder) {
            super(n2, n3);
            this.mResult = dArray;
            this.mDecoder = doubleDecoder;
        }

        public DoubleArrayDecoder(DoubleDecoder doubleDecoder) {
            super(0, 40);
            this.mResult = new double[40];
            this.mDecoder = doubleDecoder;
        }

        public void expand() {
            double[] dArray = this.mResult;
            int n2 = dArray.length;
            int n3 = this.calcNewSize(n2);
            this.mResult = new double[n3];
            System.arraycopy(dArray, this.mStart, this.mResult, 0, n2);
            this.mStart = 0;
            this.mEnd = n3;
        }

        public double[] getValues() {
            double[] dArray = new double[this.mCount];
            System.arraycopy(this.mResult, this.mStart, dArray, 0, this.mCount);
            return dArray;
        }

        public boolean decodeValue(String string) throws IllegalArgumentException {
            this.mDecoder.decode(string);
            this.mResult[this.mStart + this.mCount] = this.mDecoder.getValue();
            return ++this.mCount >= this.mEnd;
        }

        public boolean decodeValue(char[] cArray, int n2, int n3) throws IllegalArgumentException {
            this.mDecoder.decode(cArray, n2, n3);
            this.mResult[this.mStart + this.mCount] = this.mDecoder.getValue();
            return ++this.mCount >= this.mEnd;
        }
    }

    public static final class FloatArrayDecoder
    extends BaseArrayDecoder {
        float[] mResult;
        final FloatDecoder mDecoder;

        public FloatArrayDecoder(float[] fArray, int n2, int n3, FloatDecoder floatDecoder) {
            super(n2, n3);
            this.mResult = fArray;
            this.mDecoder = floatDecoder;
        }

        public FloatArrayDecoder(FloatDecoder floatDecoder) {
            super(0, 40);
            this.mResult = new float[40];
            this.mDecoder = floatDecoder;
        }

        public void expand() {
            float[] fArray = this.mResult;
            int n2 = fArray.length;
            int n3 = this.calcNewSize(n2);
            this.mResult = new float[n3];
            System.arraycopy(fArray, this.mStart, this.mResult, 0, n2);
            this.mStart = 0;
            this.mEnd = n3;
        }

        public float[] getValues() {
            float[] fArray = new float[this.mCount];
            System.arraycopy(this.mResult, this.mStart, fArray, 0, this.mCount);
            return fArray;
        }

        public boolean decodeValue(String string) throws IllegalArgumentException {
            this.mDecoder.decode(string);
            this.mResult[this.mStart + this.mCount] = this.mDecoder.getValue();
            return ++this.mCount >= this.mEnd;
        }

        public boolean decodeValue(char[] cArray, int n2, int n3) throws IllegalArgumentException {
            this.mDecoder.decode(cArray, n2, n3);
            this.mResult[this.mStart + this.mCount] = this.mDecoder.getValue();
            return ++this.mCount >= this.mEnd;
        }
    }

    public static final class LongArrayDecoder
    extends BaseArrayDecoder {
        long[] mResult;
        final LongDecoder mDecoder;

        public LongArrayDecoder(long[] lArray, int n2, int n3, LongDecoder longDecoder) {
            super(n2, n3);
            this.mResult = lArray;
            this.mDecoder = longDecoder;
        }

        public LongArrayDecoder(LongDecoder longDecoder) {
            super(0, 40);
            this.mResult = new long[40];
            this.mDecoder = longDecoder;
        }

        public void expand() {
            long[] lArray = this.mResult;
            int n2 = lArray.length;
            int n3 = this.calcNewSize(n2);
            this.mResult = new long[n3];
            System.arraycopy(lArray, this.mStart, this.mResult, 0, n2);
            this.mStart = 0;
            this.mEnd = n3;
        }

        public long[] getValues() {
            long[] lArray = new long[this.mCount];
            System.arraycopy(this.mResult, this.mStart, lArray, 0, this.mCount);
            return lArray;
        }

        public boolean decodeValue(String string) throws IllegalArgumentException {
            this.mDecoder.decode(string);
            this.mResult[this.mStart + this.mCount] = this.mDecoder.getValue();
            return ++this.mCount >= this.mEnd;
        }

        public boolean decodeValue(char[] cArray, int n2, int n3) throws IllegalArgumentException {
            this.mDecoder.decode(cArray, n2, n3);
            this.mResult[this.mStart + this.mCount] = this.mDecoder.getValue();
            return ++this.mCount >= this.mEnd;
        }
    }

    public static final class IntArrayDecoder
    extends BaseArrayDecoder {
        int[] mResult;
        final IntDecoder mDecoder;

        public IntArrayDecoder(int[] nArray, int n2, int n3, IntDecoder intDecoder) {
            super(n2, n3);
            this.mResult = nArray;
            this.mDecoder = intDecoder;
        }

        public IntArrayDecoder(IntDecoder intDecoder) {
            super(0, 40);
            this.mResult = new int[40];
            this.mDecoder = intDecoder;
        }

        public void expand() {
            int[] nArray = this.mResult;
            int n2 = nArray.length;
            int n3 = this.calcNewSize(n2);
            this.mResult = new int[n3];
            System.arraycopy(nArray, this.mStart, this.mResult, 0, n2);
            this.mStart = 0;
            this.mEnd = n3;
        }

        public int[] getValues() {
            int[] nArray = new int[this.mCount];
            System.arraycopy(this.mResult, this.mStart, nArray, 0, this.mCount);
            return nArray;
        }

        public boolean decodeValue(String string) throws IllegalArgumentException {
            this.mDecoder.decode(string);
            this.mResult[this.mStart + this.mCount] = this.mDecoder.getValue();
            return ++this.mCount >= this.mEnd;
        }

        public boolean decodeValue(char[] cArray, int n2, int n3) throws IllegalArgumentException {
            this.mDecoder.decode(cArray, n2, n3);
            this.mResult[this.mStart + this.mCount] = this.mDecoder.getValue();
            return ++this.mCount >= this.mEnd;
        }
    }

    public static abstract class BaseArrayDecoder
    extends TypedArrayDecoder {
        protected static final int INITIAL_RESULT_BUFFER_SIZE = 40;
        protected static final int SMALL_RESULT_BUFFER_SIZE = 4000;
        protected int mStart;
        protected int mEnd;
        protected int mCount = 0;

        protected BaseArrayDecoder(int n2, int n3) {
            this.mStart = n2;
            if (n3 < 1) {
                throw new IllegalArgumentException("Number of elements to read can not be less than 1");
            }
            this.mEnd = n3;
        }

        public final int getCount() {
            return this.mCount;
        }

        public final boolean hasRoom() {
            return this.mCount < this.mEnd;
        }

        public abstract void expand();

        protected int calcNewSize(int n2) {
            if (n2 < 4000) {
                return n2 << 2;
            }
            return n2 + n2;
        }
    }

    public static final class QNameDecoder
    extends DecoderBase {
        final NamespaceContext mNsCtxt;
        protected QName mValue;

        public QNameDecoder(NamespaceContext namespaceContext) {
            this.mNsCtxt = namespaceContext;
        }

        public String getType() {
            return "QName";
        }

        public QName getValue() {
            return this.mValue;
        }

        public void decode(String string) throws IllegalArgumentException {
            int n2 = string.indexOf(58);
            this.mValue = n2 >= 0 ? this.resolveQName(string.substring(0, n2), string.substring(n2 + 1)) : this.resolveQName(string);
        }

        public void decode(char[] cArray, int n2, int n3) throws IllegalArgumentException {
            for (int i2 = n2; i2 < n3; ++i2) {
                if (cArray[i2] != ':') continue;
                this.mValue = this.resolveQName(new String(cArray, n2, i2 - n2), new String(cArray, i2 + 1, n3 - i2 - 1));
                return;
            }
            this.mValue = this.resolveQName(new String(cArray, n2, n3 - n2));
        }

        protected QName resolveQName(String string) throws IllegalArgumentException {
            String string2 = this.mNsCtxt.getNamespaceURI("");
            if (string2 == null) {
                string2 = "";
            }
            return new QName(string2, string);
        }

        protected QName resolveQName(String string, String string2) throws IllegalArgumentException {
            if (string.length() == 0 || string2.length() == 0) {
                throw this.constructInvalidValue(string + ":" + string2);
            }
            String string3 = this.mNsCtxt.getNamespaceURI(string);
            if (string3 == null || string3.length() == 0) {
                throw new IllegalArgumentException("Value \"" + this.lexicalDesc(string + ":" + string2) + "\" not a valid QName: prefix '" + string + "' not bound to a namespace");
            }
            return new QName(string3, string2, string);
        }
    }

    public static final class DecimalDecoder
    extends DecoderBase {
        protected BigDecimal mValue;

        public String getType() {
            return "decimal";
        }

        public BigDecimal getValue() {
            return this.mValue;
        }

        public void decode(String string) throws IllegalArgumentException {
            try {
                this.mValue = new BigDecimal(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw this.constructInvalidValue(string);
            }
        }

        public void decode(char[] cArray, int n2, int n3) throws IllegalArgumentException {
            int n4 = n3 - n2;
            try {
                this.mValue = new BigDecimal(new String(cArray, n2, n4));
            }
            catch (NumberFormatException numberFormatException) {
                throw this.constructInvalidValue(new String(cArray, n2, n4));
            }
        }
    }

    public static final class IntegerDecoder
    extends DecoderBase {
        protected BigInteger mValue;

        public String getType() {
            return "integer";
        }

        public BigInteger getValue() {
            return this.mValue;
        }

        public void decode(String string) throws IllegalArgumentException {
            try {
                this.mValue = new BigInteger(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw this.constructInvalidValue(string);
            }
        }

        public void decode(char[] cArray, int n2, int n3) throws IllegalArgumentException {
            String string = new String(cArray, n2, n3 - n2);
            try {
                this.mValue = new BigInteger(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw this.constructInvalidValue(string);
            }
        }
    }

    public static final class DoubleDecoder
    extends DecoderBase {
        protected double mValue;

        public String getType() {
            return "double";
        }

        public double getValue() {
            return this.mValue;
        }

        public void decode(String string) throws IllegalArgumentException {
            char c2;
            int n2 = string.length();
            if (n2 == 3) {
                char c3 = string.charAt(0);
                if (c3 == 'I') {
                    if (string.charAt(1) == 'N' && string.charAt(2) == 'F') {
                        this.mValue = Double.POSITIVE_INFINITY;
                        return;
                    }
                } else if (c3 == 'N' && string.charAt(1) == 'a' && string.charAt(2) == 'N') {
                    this.mValue = Double.NaN;
                    return;
                }
            } else if (n2 == 4 && (c2 = string.charAt(0)) == '-' && string.charAt(1) == 'I' && string.charAt(2) == 'N' && string.charAt(3) == 'F') {
                this.mValue = Double.NEGATIVE_INFINITY;
                return;
            }
            try {
                this.mValue = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw this.constructInvalidValue(string);
            }
        }

        public void decode(char[] cArray, int n2, int n3) throws IllegalArgumentException {
            char c2;
            int n4 = n3 - n2;
            if (n4 == 3) {
                c2 = cArray[n2];
                if (c2 == 'I') {
                    if (cArray[n2 + 1] == 'N' && cArray[n2 + 2] == 'F') {
                        this.mValue = Double.POSITIVE_INFINITY;
                        return;
                    }
                } else if (c2 == 'N' && cArray[n2 + 1] == 'a' && cArray[n2 + 2] == 'N') {
                    this.mValue = Double.NaN;
                    return;
                }
            } else if (n4 == 4 && (c2 = cArray[n2]) == '-' && cArray[n2 + 1] == 'I' && cArray[n2 + 2] == 'N' && cArray[n2 + 3] == 'F') {
                this.mValue = Double.NEGATIVE_INFINITY;
                return;
            }
            String string = new String(cArray, n2, n4);
            try {
                this.mValue = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw this.constructInvalidValue(string);
            }
        }
    }

    public static final class FloatDecoder
    extends DecoderBase {
        protected float mValue;

        public String getType() {
            return "float";
        }

        public float getValue() {
            return this.mValue;
        }

        public void decode(String string) throws IllegalArgumentException {
            char c2;
            int n2 = string.length();
            if (n2 == 3) {
                char c3 = string.charAt(0);
                if (c3 == 'I') {
                    if (string.charAt(1) == 'N' && string.charAt(2) == 'F') {
                        this.mValue = Float.POSITIVE_INFINITY;
                        return;
                    }
                } else if (c3 == 'N' && string.charAt(1) == 'a' && string.charAt(2) == 'N') {
                    this.mValue = Float.NaN;
                    return;
                }
            } else if (n2 == 4 && (c2 = string.charAt(0)) == '-' && string.charAt(1) == 'I' && string.charAt(2) == 'N' && string.charAt(3) == 'F') {
                this.mValue = Float.NEGATIVE_INFINITY;
                return;
            }
            try {
                this.mValue = Float.parseFloat(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw this.constructInvalidValue(string);
            }
        }

        public void decode(char[] cArray, int n2, int n3) throws IllegalArgumentException {
            char c2;
            int n4 = n3 - n2;
            if (n4 == 3) {
                c2 = cArray[n2];
                if (c2 == 'I') {
                    if (cArray[n2 + 1] == 'N' && cArray[n2 + 2] == 'F') {
                        this.mValue = Float.POSITIVE_INFINITY;
                        return;
                    }
                } else if (c2 == 'N' && cArray[n2 + 1] == 'a' && cArray[n2 + 2] == 'N') {
                    this.mValue = Float.NaN;
                    return;
                }
            } else if (n4 == 4 && (c2 = cArray[n2]) == '-' && cArray[n2 + 1] == 'I' && cArray[n2 + 2] == 'N' && cArray[n2 + 3] == 'F') {
                this.mValue = Float.NEGATIVE_INFINITY;
                return;
            }
            String string = new String(cArray, n2, n4);
            try {
                this.mValue = Float.parseFloat(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw this.constructInvalidValue(string);
            }
        }
    }

    public static final class LongDecoder
    extends DecoderBase {
        protected long mValue;

        public String getType() {
            return "long";
        }

        public long getValue() {
            return this.mValue;
        }

        public void decode(String string) throws IllegalArgumentException {
            int n2 = string.length();
            char c2 = string.charAt(0);
            boolean bl = c2 == '-';
            int n3 = bl || c2 == '+' ? this.skipSignAndZeroes(string, c2, true, n2) : this.skipSignAndZeroes(string, c2, false, n2);
            int n4 = this.mNextPtr;
            int n5 = n2 - n4;
            if (n5 == 0) {
                this.mValue = bl ? -n3 : n3;
                return;
            }
            this.verifyDigits(string, n4, n2);
            if (n5 <= 8) {
                int n6 = LongDecoder.parseInt(n3, string, n4, n4 + n5);
                this.mValue = bl ? -n6 : n6;
                return;
            }
            --n4;
            if (++n5 <= 18) {
                long l2 = LongDecoder.parseLong(string, n4, n4 + n5);
                this.mValue = bl ? -l2 : l2;
                return;
            }
            this.mValue = this.parseUsingBD(string.substring(n4, n4 + n5), bl);
        }

        public void decode(char[] cArray, int n2, int n3) throws IllegalArgumentException {
            char c2 = cArray[n2];
            boolean bl = c2 == '-';
            int n4 = bl || c2 == '+' ? this.skipSignAndZeroes(cArray, c2, true, n2, n3) : this.skipSignAndZeroes(cArray, c2, false, n2, n3);
            int n5 = this.mNextPtr;
            int n6 = n3 - n5;
            if (n6 == 0) {
                this.mValue = bl ? -n4 : n4;
                return;
            }
            this.verifyDigits(cArray, n2, n3, n5);
            if (n6 <= 8) {
                int n7 = LongDecoder.parseInt(n4, cArray, n5, n5 + n6);
                this.mValue = bl ? (long)(-n7) : (long)n7;
                return;
            }
            --n5;
            if (++n6 <= 18) {
                long l2 = LongDecoder.parseLong(cArray, n5, n5 + n6);
                this.mValue = bl ? -l2 : l2;
                return;
            }
            this.mValue = this.parseUsingBD(new String(cArray, n5, n6), bl);
        }

        private long parseUsingBD(String string, boolean bl) {
            BigInteger bigInteger = new BigInteger(string);
            if (bl ? (bigInteger = bigInteger.negate()).compareTo(BD_MIN_LONG) >= 0 : bigInteger.compareTo(BD_MAX_LONG) <= 0) {
                return bigInteger.longValue();
            }
            throw new IllegalArgumentException("value \"" + this.lexicalDesc(string) + "\" not a valid long: overflow.");
        }
    }

    public static final class IntDecoder
    extends DecoderBase {
        protected int mValue;

        public String getType() {
            return "int";
        }

        public int getValue() {
            return this.mValue;
        }

        public void decode(String string) throws IllegalArgumentException {
            int n2 = string.length();
            char c2 = string.charAt(0);
            boolean bl = c2 == '-';
            int n3 = bl || c2 == '+' ? this.skipSignAndZeroes(string, c2, true, n2) : this.skipSignAndZeroes(string, c2, false, n2);
            int n4 = this.mNextPtr;
            int n5 = n2 - n4;
            if (n5 == 0) {
                this.mValue = bl ? -n3 : n3;
                return;
            }
            this.verifyDigits(string, n4, n2);
            if (n5 <= 8) {
                int n6 = IntDecoder.parseInt(n3, string, n4, n4 + n5);
                this.mValue = bl ? -n6 : n6;
                return;
            }
            if (n5 == 9 && n3 < 3) {
                long l2 = 1000000000L;
                if (n3 == 2) {
                    l2 += 1000000000L;
                }
                int n7 = IntDecoder.parseInt(string, n4, n4 + n5);
                long l3 = l2 + (long)n7;
                if (bl) {
                    if ((l3 = -l3) >= Integer.MIN_VALUE) {
                        this.mValue = (int)l3;
                        return;
                    }
                } else if (l3 <= Integer.MAX_VALUE) {
                    this.mValue = (int)l3;
                    return;
                }
            }
            throw new IllegalArgumentException("value \"" + this.lexicalDesc(string) + "\" not a valid 32-bit integer: overflow.");
        }

        public void decode(char[] cArray, int n2, int n3) throws IllegalArgumentException {
            char c2 = cArray[n2];
            boolean bl = c2 == '-';
            int n4 = bl || c2 == '+' ? this.skipSignAndZeroes(cArray, c2, true, n2, n3) : this.skipSignAndZeroes(cArray, c2, false, n2, n3);
            int n5 = this.mNextPtr;
            int n6 = n3 - n5;
            if (n6 == 0) {
                this.mValue = bl ? -n4 : n4;
                return;
            }
            this.verifyDigits(cArray, n2, n3, n5);
            if (n6 <= 8) {
                int n7 = IntDecoder.parseInt(n4, cArray, n5, n5 + n6);
                this.mValue = bl ? -n7 : n7;
                return;
            }
            if (n6 == 9 && n4 < 3) {
                long l2 = 1000000000L;
                if (n4 == 2) {
                    l2 += 1000000000L;
                }
                int n8 = IntDecoder.parseInt(cArray, n5, n5 + n6);
                long l3 = l2 + (long)n8;
                if (bl) {
                    if ((l3 = -l3) >= Integer.MIN_VALUE) {
                        this.mValue = (int)l3;
                        return;
                    }
                } else if (l3 <= Integer.MAX_VALUE) {
                    this.mValue = (int)l3;
                    return;
                }
            }
            throw new IllegalArgumentException("value \"" + this.lexicalDesc(cArray, n2, n3) + "\" not a valid 32-bit integer: overflow.");
        }
    }

    public static final class BooleanDecoder
    extends DecoderBase {
        protected boolean mValue;

        public String getType() {
            return "boolean";
        }

        public boolean getValue() {
            return this.mValue;
        }

        public void decode(String string) throws IllegalArgumentException {
            int n2 = string.length();
            char c2 = string.charAt(0);
            if (c2 == 't') {
                if (n2 == 4 && string.charAt(1) == 'r' && string.charAt(2) == 'u' && string.charAt(3) == 'e') {
                    this.mValue = true;
                    return;
                }
            } else if (c2 == 'f') {
                if (n2 == 5 && string.charAt(1) == 'a' && string.charAt(2) == 'l' && string.charAt(3) == 's' && string.charAt(4) == 'e') {
                    this.mValue = false;
                    return;
                }
            } else if (c2 == '0') {
                if (n2 == 1) {
                    this.mValue = false;
                    return;
                }
            } else if (c2 == '1' && n2 == 1) {
                this.mValue = true;
                return;
            }
            throw this.constructInvalidValue(string);
        }

        public void decode(char[] cArray, int n2, int n3) throws IllegalArgumentException {
            int n4 = n3 - n2;
            char c2 = cArray[n2];
            if (c2 == 't') {
                if (n4 == 4 && cArray[n2 + 1] == 'r' && cArray[n2 + 2] == 'u' && cArray[n2 + 3] == 'e') {
                    this.mValue = true;
                    return;
                }
            } else if (c2 == 'f') {
                if (n4 == 5 && cArray[n2 + 1] == 'a' && cArray[n2 + 2] == 'l' && cArray[n2 + 3] == 's' && cArray[n2 + 4] == 'e') {
                    this.mValue = false;
                    return;
                }
            } else if (c2 == '0') {
                if (n4 == 1) {
                    this.mValue = false;
                    return;
                }
            } else if (c2 == '1' && n4 == 1) {
                this.mValue = true;
                return;
            }
            throw this.constructInvalidValue(cArray, n2, n3);
        }
    }

    public static abstract class DecoderBase
    extends TypedValueDecoder {
        static final long L_BILLION = 1000000000L;
        static final long L_MAX_INT = Integer.MAX_VALUE;
        static final long L_MIN_INT = Integer.MIN_VALUE;
        static final BigInteger BD_MIN_LONG = BigInteger.valueOf(Long.MIN_VALUE);
        static final BigInteger BD_MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
        protected int mNextPtr;

        protected DecoderBase() {
        }

        public abstract String getType();

        public void handleEmptyValue() {
            throw new IllegalArgumentException("Empty value (all white space) not a valid lexical representation of " + this.getType());
        }

        protected void verifyDigits(String string, int n2, int n3) {
            while (n2 < n3) {
                char c2 = string.charAt(n2);
                if (c2 > '9' || c2 < '0') {
                    throw this.constructInvalidValue(string);
                }
                ++n2;
            }
        }

        protected void verifyDigits(char[] cArray, int n2, int n3, int n4) {
            while (n4 < n3) {
                char c2 = cArray[n4];
                if (c2 > '9' || c2 < '0') {
                    throw this.constructInvalidValue(cArray, n2, n3);
                }
                ++n4;
            }
        }

        protected int skipSignAndZeroes(String string, char c2, boolean bl, int n2) {
            int n3;
            int n4;
            if (bl) {
                n4 = 1;
                if (n4 >= n2) {
                    throw this.constructInvalidValue(string);
                }
                c2 = string.charAt(n4++);
            } else {
                n4 = 1;
            }
            int n5 = c2 - 48;
            if (n5 < 0 || n5 > 9) {
                throw this.constructInvalidValue(string);
            }
            while (n5 == 0 && n4 < n2 && (n3 = string.charAt(n4) - 48) >= 0 && n3 <= 9) {
                ++n4;
                n5 = n3;
            }
            this.mNextPtr = n4;
            return n5;
        }

        protected int skipSignAndZeroes(char[] cArray, char c2, boolean bl, int n2, int n3) {
            int n4;
            int n5;
            int n6 = n2 + 1;
            if (bl) {
                if (n6 >= n3) {
                    throw this.constructInvalidValue(cArray, n2, n3);
                }
                c2 = cArray[n6++];
            }
            if ((n5 = c2 - 48) < 0 || n5 > 9) {
                throw this.constructInvalidValue(cArray, n2, n3);
            }
            while (n5 == 0 && n6 < n3 && (n4 = cArray[n6] - 48) >= 0 && n4 <= 9) {
                ++n6;
                n5 = n4;
            }
            this.mNextPtr = n6;
            return n5;
        }

        protected static final int parseInt(char[] cArray, int n2, int n3) {
            int n4 = cArray[n2] - 48;
            if (++n2 < n3) {
                n4 = n4 * 10 + (cArray[n2] - 48);
                if (++n2 < n3) {
                    n4 = n4 * 10 + (cArray[n2] - 48);
                    if (++n2 < n3) {
                        n4 = n4 * 10 + (cArray[n2] - 48);
                        if (++n2 < n3) {
                            n4 = n4 * 10 + (cArray[n2] - 48);
                            if (++n2 < n3) {
                                n4 = n4 * 10 + (cArray[n2] - 48);
                                if (++n2 < n3) {
                                    n4 = n4 * 10 + (cArray[n2] - 48);
                                    if (++n2 < n3) {
                                        n4 = n4 * 10 + (cArray[n2] - 48);
                                        if (++n2 < n3) {
                                            n4 = n4 * 10 + (cArray[n2] - 48);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            return n4;
        }

        protected static final int parseInt(int n2, char[] cArray, int n3, int n4) {
            n2 = n2 * 10 + (cArray[n3] - 48);
            if (++n3 < n4) {
                n2 = n2 * 10 + (cArray[n3] - 48);
                if (++n3 < n4) {
                    n2 = n2 * 10 + (cArray[n3] - 48);
                    if (++n3 < n4) {
                        n2 = n2 * 10 + (cArray[n3] - 48);
                        if (++n3 < n4) {
                            n2 = n2 * 10 + (cArray[n3] - 48);
                            if (++n3 < n4) {
                                n2 = n2 * 10 + (cArray[n3] - 48);
                                if (++n3 < n4) {
                                    n2 = n2 * 10 + (cArray[n3] - 48);
                                    if (++n3 < n4) {
                                        n2 = n2 * 10 + (cArray[n3] - 48);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            return n2;
        }

        protected static final int parseInt(String string, int n2, int n3) {
            int n4 = string.charAt(n2) - 48;
            if (++n2 < n3) {
                n4 = n4 * 10 + (string.charAt(n2) - 48);
                if (++n2 < n3) {
                    n4 = n4 * 10 + (string.charAt(n2) - 48);
                    if (++n2 < n3) {
                        n4 = n4 * 10 + (string.charAt(n2) - 48);
                        if (++n2 < n3) {
                            n4 = n4 * 10 + (string.charAt(n2) - 48);
                            if (++n2 < n3) {
                                n4 = n4 * 10 + (string.charAt(n2) - 48);
                                if (++n2 < n3) {
                                    n4 = n4 * 10 + (string.charAt(n2) - 48);
                                    if (++n2 < n3) {
                                        n4 = n4 * 10 + (string.charAt(n2) - 48);
                                        if (++n2 < n3) {
                                            n4 = n4 * 10 + (string.charAt(n2) - 48);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            return n4;
        }

        protected static final int parseInt(int n2, String string, int n3, int n4) {
            n2 = n2 * 10 + (string.charAt(n3) - 48);
            if (++n3 < n4) {
                n2 = n2 * 10 + (string.charAt(n3) - 48);
                if (++n3 < n4) {
                    n2 = n2 * 10 + (string.charAt(n3) - 48);
                    if (++n3 < n4) {
                        n2 = n2 * 10 + (string.charAt(n3) - 48);
                        if (++n3 < n4) {
                            n2 = n2 * 10 + (string.charAt(n3) - 48);
                            if (++n3 < n4) {
                                n2 = n2 * 10 + (string.charAt(n3) - 48);
                                if (++n3 < n4) {
                                    n2 = n2 * 10 + (string.charAt(n3) - 48);
                                    if (++n3 < n4) {
                                        n2 = n2 * 10 + (string.charAt(n3) - 48);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            return n2;
        }

        protected static final long parseLong(char[] cArray, int n2, int n3) {
            int n4 = n3 - 9;
            long l2 = (long)DecoderBase.parseInt(cArray, n2, n4) * 1000000000L;
            return l2 + (long)DecoderBase.parseInt(cArray, n4, n3);
        }

        protected static final long parseLong(String string, int n2, int n3) {
            int n4 = n3 - 9;
            long l2 = (long)DecoderBase.parseInt(string, n2, n4) * 1000000000L;
            return l2 + (long)DecoderBase.parseInt(string, n4, n3);
        }

        protected IllegalArgumentException constructInvalidValue(String string) {
            return new IllegalArgumentException("Value \"" + string + "\" not a valid lexical representation of " + this.getType());
        }

        protected IllegalArgumentException constructInvalidValue(char[] cArray, int n2, int n3) {
            return new IllegalArgumentException("Value \"" + this.lexicalDesc(cArray, n2, n3) + "\" not a valid lexical representation of " + this.getType());
        }

        protected String lexicalDesc(char[] cArray, int n2, int n3) {
            return this._clean(new String(cArray, n2, n3 - n2));
        }

        protected String lexicalDesc(String string) {
            return this._clean(string);
        }

        protected String _clean(String string) {
            return string.trim();
        }
    }
}

