/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.generators;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.params.DSAParameters;
import org.bouncycastle.crypto.params.DSAValidationParameters;

public class DSAParametersGenerator {
    private int size;
    private int certainty;
    private SecureRandom random;
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final BigInteger TWO = BigInteger.valueOf(2L);

    public void init(int n2, int n3, SecureRandom secureRandom) {
        this.size = n2;
        this.certainty = n3;
        this.random = secureRandom;
    }

    private void add(byte[] byArray, byte[] byArray2, int n2) {
        int n3 = (byArray2[byArray2.length - 1] & 0xFF) + n2;
        byArray[byArray2.length - 1] = (byte)n3;
        n3 >>>= 8;
        for (int i2 = byArray2.length - 2; i2 >= 0; --i2) {
            byArray[i2] = (byte)(n3 += byArray2[i2] & 0xFF);
            n3 >>>= 8;
        }
    }

    public DSAParameters generateParameters() {
        BigInteger bigInteger;
        byte[] byArray = new byte[20];
        byte[] byArray2 = new byte[20];
        byte[] byArray3 = new byte[20];
        byte[] byArray4 = new byte[20];
        SHA1Digest sHA1Digest = new SHA1Digest();
        int n2 = (this.size - 1) / 160;
        byte[] byArray5 = new byte[this.size / 8];
        BigInteger bigInteger2 = null;
        BigInteger bigInteger3 = null;
        BigInteger bigInteger4 = null;
        int n3 = 0;
        boolean bl = false;
        block0: while (!bl) {
            int n4;
            do {
                this.random.nextBytes(byArray);
                sHA1Digest.update(byArray, 0, byArray.length);
                sHA1Digest.doFinal(byArray2, 0);
                System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
                this.add(byArray3, byArray, 1);
                sHA1Digest.update(byArray3, 0, byArray3.length);
                sHA1Digest.doFinal(byArray3, 0);
                for (n4 = 0; n4 != byArray4.length; ++n4) {
                    byArray4[n4] = (byte)(byArray2[n4] ^ byArray3[n4]);
                }
                byArray4[0] = (byte)(byArray4[0] | 0xFFFFFF80);
                byArray4[19] = (byte)(byArray4[19] | 1);
            } while (!(bigInteger2 = new BigInteger(1, byArray4)).isProbablePrime(this.certainty));
            n3 = 0;
            n4 = 2;
            while (n3 < 4096) {
                for (int i2 = 0; i2 < n2; ++i2) {
                    this.add(byArray2, byArray, n4 + i2);
                    sHA1Digest.update(byArray2, 0, byArray2.length);
                    sHA1Digest.doFinal(byArray2, 0);
                    System.arraycopy(byArray2, 0, byArray5, byArray5.length - (i2 + 1) * byArray2.length, byArray2.length);
                }
                this.add(byArray2, byArray, n4 + n2);
                sHA1Digest.update(byArray2, 0, byArray2.length);
                sHA1Digest.doFinal(byArray2, 0);
                System.arraycopy(byArray2, byArray2.length - (byArray5.length - n2 * byArray2.length), byArray5, 0, byArray5.length - n2 * byArray2.length);
                byArray5[0] = (byte)(byArray5[0] | 0xFFFFFF80);
                bigInteger = new BigInteger(1, byArray5);
                BigInteger bigInteger5 = bigInteger.mod(bigInteger2.multiply(TWO));
                bigInteger3 = bigInteger.subtract(bigInteger5.subtract(ONE));
                if (bigInteger3.testBit(this.size - 1) && bigInteger3.isProbablePrime(this.certainty)) {
                    bl = true;
                    continue block0;
                }
                ++n3;
                n4 += n2 + 1;
            }
        }
        BigInteger bigInteger6 = bigInteger3.subtract(ONE).divide(bigInteger2);
        while ((bigInteger = new BigInteger(this.size, this.random)).compareTo(ONE) <= 0 || bigInteger.compareTo(bigInteger3.subtract(ONE)) >= 0 || (bigInteger4 = bigInteger.modPow(bigInteger6, bigInteger3)).compareTo(ONE) <= 0) {
        }
        return new DSAParameters(bigInteger3, bigInteger2, bigInteger4, new DSAValidationParameters(byArray, n3));
    }
}

