/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import java.math.BigInteger;
import org.bouncycastle.crypto.BasicAgreement;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DerivationFunction;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.params.IESParameters;
import org.bouncycastle.crypto.params.IESWithCipherParameters;
import org.bouncycastle.crypto.params.KDFParameters;
import org.bouncycastle.crypto.params.KeyParameter;

public class IESEngine {
    BasicAgreement agree;
    DerivationFunction kdf;
    Mac mac;
    BufferedBlockCipher cipher;
    byte[] macBuf;
    boolean forEncryption;
    CipherParameters privParam;
    CipherParameters pubParam;
    IESParameters param;

    public IESEngine(BasicAgreement basicAgreement, DerivationFunction derivationFunction, Mac mac) {
        this.agree = basicAgreement;
        this.kdf = derivationFunction;
        this.mac = mac;
        this.macBuf = new byte[mac.getMacSize()];
        this.cipher = null;
    }

    public IESEngine(BasicAgreement basicAgreement, DerivationFunction derivationFunction, Mac mac, BufferedBlockCipher bufferedBlockCipher) {
        this.agree = basicAgreement;
        this.kdf = derivationFunction;
        this.mac = mac;
        this.macBuf = new byte[mac.getMacSize()];
        this.cipher = bufferedBlockCipher;
    }

    public void init(boolean bl, CipherParameters cipherParameters, CipherParameters cipherParameters2, CipherParameters cipherParameters3) {
        this.forEncryption = bl;
        this.privParam = cipherParameters;
        this.pubParam = cipherParameters2;
        this.param = (IESParameters)cipherParameters3;
    }

    private byte[] decryptBlock(byte[] byArray, int n2, int n3, byte[] byArray2) throws InvalidCipherTextException {
        int n4;
        byte[] byArray3;
        byte[] byArray4 = null;
        KeyParameter keyParameter = null;
        KDFParameters kDFParameters = new KDFParameters(byArray2, this.param.getDerivationV());
        int n5 = this.param.getMacKeySize();
        this.kdf.init(kDFParameters);
        n3 -= this.mac.getMacSize();
        if (this.cipher == null) {
            byArray3 = this.generateKdfBytes(kDFParameters, n3 + n5 / 8);
            byArray4 = new byte[n3];
            for (n4 = 0; n4 != n3; ++n4) {
                byArray4[n4] = (byte)(byArray[n2 + n4] ^ byArray3[n4]);
            }
            keyParameter = new KeyParameter(byArray3, n3, n5 / 8);
        } else {
            int n6 = ((IESWithCipherParameters)this.param).getCipherKeySize();
            byte[] byArray5 = this.generateKdfBytes(kDFParameters, n6 / 8 + n5 / 8);
            this.cipher.init(false, new KeyParameter(byArray5, 0, n6 / 8));
            byte[] byArray6 = new byte[this.cipher.getOutputSize(n3)];
            int n7 = this.cipher.processBytes(byArray, n2, n3, byArray6, 0);
            n7 += this.cipher.doFinal(byArray6, n7);
            byArray4 = new byte[n7];
            System.arraycopy(byArray6, 0, byArray4, 0, n7);
            keyParameter = new KeyParameter(byArray5, n6 / 8, n5 / 8);
        }
        byArray3 = this.param.getEncodingV();
        this.mac.init(keyParameter);
        this.mac.update(byArray, n2, n3);
        this.mac.update(byArray3, 0, byArray3.length);
        this.mac.doFinal(this.macBuf, 0);
        n2 += n3;
        for (n4 = 0; n4 < this.macBuf.length; ++n4) {
            if (this.macBuf[n4] == byArray[n2 + n4]) continue;
            throw new InvalidCipherTextException("Mac codes failed to equal.");
        }
        return byArray4;
    }

    private byte[] encryptBlock(byte[] byArray, int n2, int n3, byte[] byArray2) throws InvalidCipherTextException {
        byte[] byArray3;
        byte[] byArray4 = null;
        KeyParameter keyParameter = null;
        KDFParameters kDFParameters = new KDFParameters(byArray2, this.param.getDerivationV());
        int n4 = 0;
        int n5 = this.param.getMacKeySize();
        if (this.cipher == null) {
            byArray3 = this.generateKdfBytes(kDFParameters, n3 + n5 / 8);
            byArray4 = new byte[n3 + this.mac.getMacSize()];
            n4 = n3;
            for (int i2 = 0; i2 != n3; ++i2) {
                byArray4[i2] = (byte)(byArray[n2 + i2] ^ byArray3[i2]);
            }
            keyParameter = new KeyParameter(byArray3, n3, n5 / 8);
        } else {
            int n6 = ((IESWithCipherParameters)this.param).getCipherKeySize();
            byte[] byArray5 = this.generateKdfBytes(kDFParameters, n6 / 8 + n5 / 8);
            this.cipher.init(true, new KeyParameter(byArray5, 0, n6 / 8));
            n4 = this.cipher.getOutputSize(n3);
            byte[] byArray6 = new byte[n4];
            int n7 = this.cipher.processBytes(byArray, n2, n3, byArray6, 0);
            n7 += this.cipher.doFinal(byArray6, n7);
            byArray4 = new byte[n7 + this.mac.getMacSize()];
            n4 = n7;
            System.arraycopy(byArray6, 0, byArray4, 0, n7);
            keyParameter = new KeyParameter(byArray5, n6 / 8, n5 / 8);
        }
        byArray3 = this.param.getEncodingV();
        this.mac.init(keyParameter);
        this.mac.update(byArray4, 0, n4);
        this.mac.update(byArray3, 0, byArray3.length);
        this.mac.doFinal(byArray4, n4);
        return byArray4;
    }

    private byte[] generateKdfBytes(KDFParameters kDFParameters, int n2) {
        byte[] byArray = new byte[n2];
        this.kdf.init(kDFParameters);
        this.kdf.generateBytes(byArray, 0, byArray.length);
        return byArray;
    }

    public byte[] processBlock(byte[] byArray, int n2, int n3) throws InvalidCipherTextException {
        this.agree.init(this.privParam);
        BigInteger bigInteger = this.agree.calculateAgreement(this.pubParam);
        if (this.forEncryption) {
            return this.encryptBlock(byArray, n2, n3, bigInteger.toByteArray());
        }
        return this.decryptBlock(byArray, n2, n3, bigInteger.toByteArray());
    }
}

