/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import org.bouncycastle.crypto.digests.LongDigest;

public class SHA384Digest
extends LongDigest {
    private static final int DIGEST_LENGTH = 48;

    public SHA384Digest() {
    }

    public SHA384Digest(SHA384Digest sHA384Digest) {
        super(sHA384Digest);
    }

    public String getAlgorithmName() {
        return "SHA-384";
    }

    public int getDigestSize() {
        return 48;
    }

    public int doFinal(byte[] byArray, int n2) {
        this.finish();
        this.unpackWord(this.H1, byArray, n2);
        this.unpackWord(this.H2, byArray, n2 + 8);
        this.unpackWord(this.H3, byArray, n2 + 16);
        this.unpackWord(this.H4, byArray, n2 + 24);
        this.unpackWord(this.H5, byArray, n2 + 32);
        this.unpackWord(this.H6, byArray, n2 + 40);
        this.reset();
        return 48;
    }

    public void reset() {
        super.reset();
        this.H1 = -3766243637369397544L;
        this.H2 = 7105036623409894663L;
        this.H3 = -7973340178411365097L;
        this.H4 = 1526699215303891257L;
        this.H5 = 7436329637833083697L;
        this.H6 = -8163818279084223215L;
        this.H7 = -2662702644619276377L;
        this.H8 = 5167115440072839076L;
    }
}

