/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.Time;
import org.bouncycastle.cms.CMSAttributeTableGenerator;

public class DefaultSignedAttributeTableGenerator
implements CMSAttributeTableGenerator {
    private final Hashtable table;

    public DefaultSignedAttributeTableGenerator() {
        this.table = new Hashtable();
    }

    public DefaultSignedAttributeTableGenerator(AttributeTable attributeTable) {
        this.table = attributeTable != null ? attributeTable.toHashtable() : new Hashtable();
    }

    protected Hashtable createStandardAttributeTable(Map map) {
        Object object;
        Hashtable hashtable = (Hashtable)this.table.clone();
        if (this.table.containsKey(CMSAttributes.contentType)) {
            hashtable.put(CMSAttributes.contentType, this.table.get(CMSAttributes.contentType));
        } else {
            object = new Attribute(CMSAttributes.contentType, new DERSet((DERObjectIdentifier)map.get("contentType")));
            hashtable.put(((Attribute)object).getAttrType(), object);
        }
        if (this.table.containsKey(CMSAttributes.signingTime)) {
            hashtable.put(CMSAttributes.signingTime, this.table.get(CMSAttributes.signingTime));
        } else {
            object = new Attribute(CMSAttributes.signingTime, new DERSet(new Time(new Date())));
            hashtable.put(((Attribute)object).getAttrType(), object);
        }
        if (this.table.containsKey(CMSAttributes.messageDigest)) {
            hashtable.put(CMSAttributes.messageDigest, this.table.get(CMSAttributes.messageDigest));
        } else {
            object = (byte[])map.get("digest");
            Attribute attribute = object != null ? new Attribute(CMSAttributes.messageDigest, new DERSet(new DEROctetString((byte[])object))) : new Attribute(CMSAttributes.messageDigest, new DERSet(new DERNull()));
            hashtable.put(attribute.getAttrType(), attribute);
        }
        return hashtable;
    }

    public AttributeTable getAttributes(Map map) {
        return new AttributeTable(this.createStandardAttributeTable(map));
    }
}

