/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;

public class CMSTypedStream {
    private static final int BUF_SIZ = 32768;
    private final String _oid;
    private final InputStream _in;
    private final int _bufSize;

    public CMSTypedStream(InputStream inputStream) {
        this(PKCSObjectIdentifiers.data.getId(), inputStream, 32768);
    }

    public CMSTypedStream(String string, InputStream inputStream) {
        this(string, inputStream, 32768);
    }

    public CMSTypedStream(String string, InputStream inputStream, int n2) {
        this._oid = string;
        this._bufSize = n2;
        this._in = new FullReaderStream(inputStream, n2);
    }

    public String getContentType() {
        return this._oid;
    }

    public InputStream getContentStream() {
        return this._in;
    }

    public void drain() throws IOException {
        byte[] byArray = new byte[this._bufSize];
        while (this._in.read(byArray, 0, byArray.length) > 0) {
        }
        this._in.close();
    }

    private class FullReaderStream
    extends InputStream {
        InputStream _stream;

        FullReaderStream(InputStream inputStream, int n2) {
            this._stream = new BufferedInputStream(inputStream, n2);
        }

        public int read() throws IOException {
            return this._stream.read();
        }

        public int read(byte[] byArray, int n2, int n3) throws IOException {
            int n4 = 0;
            int n5 = 0;
            while (n3 != 0 && (n4 = this._stream.read(byArray, n2, n3)) > 0) {
                n2 += n4;
                n3 -= n4;
                n5 += n4;
            }
            if (n5 > 0) {
                return n5;
            }
            return -1;
        }

        public void close() throws IOException {
            this._stream.close();
        }
    }
}

