/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetStringParser;
import org.bouncycastle.asn1.ASN1SequenceParser;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1SetParser;
import org.bouncycastle.asn1.ASN1StreamParser;
import org.bouncycastle.asn1.BERGenerator;
import org.bouncycastle.asn1.BEROctetStringGenerator;
import org.bouncycastle.asn1.BERSequenceGenerator;
import org.bouncycastle.asn1.BERSetParser;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.ContentInfoParser;
import org.bouncycastle.asn1.cms.SignedDataParser;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSContentInfoParser;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedHelper;
import org.bouncycastle.cms.CMSTypedStream;
import org.bouncycastle.cms.CMSUtils;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.x509.NoSuchStoreException;
import org.bouncycastle.x509.X509Store;

public class CMSSignedDataParser
extends CMSContentInfoParser {
    private static CMSSignedHelper HELPER = CMSSignedHelper.INSTANCE;
    private SignedDataParser _signedData;
    private CMSTypedStream _signedContent;
    private Map _digests;
    private CertStore _certStore;
    private SignerInformationStore _signerInfoStore;
    private X509Store _attributeStore;
    private ASN1Set _certSet;
    private ASN1Set _crlSet;
    private boolean _isCertCrlParsed;
    private X509Store _certificateStore;
    private X509Store _crlStore;

    public CMSSignedDataParser(byte[] byArray) throws CMSException {
        this(new ByteArrayInputStream(byArray));
    }

    public CMSSignedDataParser(CMSTypedStream cMSTypedStream, byte[] byArray) throws CMSException {
        this(cMSTypedStream, new ByteArrayInputStream(byArray));
    }

    public CMSSignedDataParser(InputStream inputStream) throws CMSException {
        this(null, inputStream);
    }

    public CMSSignedDataParser(CMSTypedStream cMSTypedStream, InputStream inputStream) throws CMSException {
        super(inputStream);
        try {
            Object object;
            Object object2;
            DEREncodable dEREncodable;
            this._signedContent = cMSTypedStream;
            this._signedData = SignedDataParser.getInstance(this._contentInfo.getContent(16));
            this._digests = new HashMap();
            ASN1SetParser aSN1SetParser = this._signedData.getDigestAlgorithms();
            while ((dEREncodable = aSN1SetParser.readObject()) != null) {
                object2 = AlgorithmIdentifier.getInstance(dEREncodable.getDERObject());
                try {
                    object = CMSSignedHelper.INSTANCE.getDigestAlgName(((AlgorithmIdentifier)object2).getObjectId().toString());
                    MessageDigest messageDigest = CMSSignedHelper.INSTANCE.getDigestInstance((String)object, null);
                    this._digests.put(object, messageDigest);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                }
                catch (NoSuchProviderException noSuchProviderException) {}
            }
            if (this._signedContent == null) {
                object2 = this._signedData.getEncapContentInfo();
                object = (ASN1OctetStringParser)((ContentInfoParser)object2).getContent(4);
                if (object != null) {
                    this._signedContent = new CMSTypedStream(((ContentInfoParser)object2).getContentType().getId(), object.getOctetStream());
                }
            } else {
                object2 = (ASN1OctetStringParser)this._signedData.getEncapContentInfo().getContent(4);
                if (object2 != null) {
                    object = object2.getOctetStream();
                    while (((InputStream)object).read() >= 0) {
                    }
                }
            }
        }
        catch (IOException iOException) {
            throw new CMSException("io exception: " + iOException.getMessage(), iOException);
        }
        if (this._digests.isEmpty()) {
            throw new CMSException("no digests could be created for message.");
        }
    }

    public int getVersion() {
        return this._signedData.getVersion().getValue().intValue();
    }

    public SignerInformationStore getSignerInfos() throws CMSException {
        if (this._signerInfoStore == null) {
            Object object;
            this.populateCertCrlSets();
            ArrayList<SignerInformation> arrayList = new ArrayList<SignerInformation>();
            HashMap hashMap = new HashMap();
            Iterator iterator = this._digests.keySet().iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                hashMap.put(object, ((MessageDigest)this._digests.get(object)).digest());
            }
            try {
                DEREncodable dEREncodable;
                object = this._signedData.getSignerInfos();
                while ((dEREncodable = object.readObject()) != null) {
                    SignerInfo signerInfo = SignerInfo.getInstance(dEREncodable.getDERObject());
                    String string = CMSSignedHelper.INSTANCE.getDigestAlgName(signerInfo.getDigestAlgorithm().getObjectId().getId());
                    byte[] byArray = (byte[])hashMap.get(string);
                    arrayList.add(new SignerInformation(signerInfo, new DERObjectIdentifier(this._signedContent.getContentType()), null, byArray));
                }
            }
            catch (IOException iOException) {
                throw new CMSException("io exception: " + iOException.getMessage(), iOException);
            }
            this._signerInfoStore = new SignerInformationStore(arrayList);
        }
        return this._signerInfoStore;
    }

    public X509Store getAttributeCertificates(String string, String string2) throws NoSuchStoreException, NoSuchProviderException, CMSException {
        if (this._attributeStore == null) {
            this.populateCertCrlSets();
            this._attributeStore = HELPER.createAttributeStore(string, string2, this._certSet);
        }
        return this._attributeStore;
    }

    public X509Store getCertificates(String string, String string2) throws NoSuchStoreException, NoSuchProviderException, CMSException {
        if (this._certificateStore == null) {
            this.populateCertCrlSets();
            this._certificateStore = HELPER.createCertificateStore(string, string2, this._certSet);
        }
        return this._certificateStore;
    }

    public X509Store getCRLs(String string, String string2) throws NoSuchStoreException, NoSuchProviderException, CMSException {
        if (this._crlStore == null) {
            this.populateCertCrlSets();
            this._crlStore = HELPER.createCRLsStore(string, string2, this._crlSet);
        }
        return this._crlStore;
    }

    public CertStore getCertificatesAndCRLs(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        if (this._certStore == null) {
            this.populateCertCrlSets();
            this._certStore = HELPER.createCertStore(string, string2, this._certSet, this._crlSet);
        }
        return this._certStore;
    }

    private void populateCertCrlSets() throws CMSException {
        if (this._isCertCrlParsed) {
            return;
        }
        this._isCertCrlParsed = true;
        try {
            ASN1SetParser aSN1SetParser;
            ASN1SetParser aSN1SetParser2 = this._signedData.getCertificates();
            if (aSN1SetParser2 != null) {
                this._certSet = ASN1Set.getInstance(aSN1SetParser2.getDERObject());
            }
            if ((aSN1SetParser = this._signedData.getCrls()) != null) {
                this._crlSet = ASN1Set.getInstance(aSN1SetParser.getDERObject());
            }
        }
        catch (IOException iOException) {
            throw new CMSException("problem parsing cert/crl sets", iOException);
        }
    }

    public CMSTypedStream getSignedContent() {
        if (this._signedContent != null) {
            InputStream inputStream = this._signedContent.getContentStream();
            Iterator iterator = this._digests.values().iterator();
            while (iterator.hasNext()) {
                inputStream = new DigestInputStream(inputStream, (MessageDigest)iterator.next());
            }
            return new CMSTypedStream(this._signedContent.getContentType(), inputStream);
        }
        return null;
    }

    public static OutputStream replaceSigners(InputStream inputStream, SignerInformationStore signerInformationStore, OutputStream outputStream) throws CMSException, IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        DEREncodable dEREncodable;
        Object object5;
        ASN1StreamParser aSN1StreamParser = new ASN1StreamParser(inputStream, CMSUtils.getMaximumMemory());
        ContentInfoParser contentInfoParser = new ContentInfoParser((ASN1SequenceParser)aSN1StreamParser.readObject());
        SignedDataParser signedDataParser = SignedDataParser.getInstance(contentInfoParser.getContent(16));
        BERSequenceGenerator bERSequenceGenerator = new BERSequenceGenerator(outputStream);
        bERSequenceGenerator.addObject(CMSObjectIdentifiers.signedData);
        BERSequenceGenerator bERSequenceGenerator2 = new BERSequenceGenerator(bERSequenceGenerator.getRawOutputStream(), 0, true);
        bERSequenceGenerator2.addObject(signedDataParser.getVersion());
        signedDataParser.getDigestAlgorithms().getDERObject();
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        Object object6 = signerInformationStore.getSigners().iterator();
        while (object6.hasNext()) {
            object5 = (SignerInformation)object6.next();
            dEREncodable = CMSSignedDataParser.makeAlgId(((SignerInformation)object5).getDigestAlgOID(), ((SignerInformation)object5).getDigestAlgParams());
            aSN1EncodableVector.add(dEREncodable);
        }
        bERSequenceGenerator2.getRawOutputStream().write(new DERSet(aSN1EncodableVector).getEncoded());
        object6 = signedDataParser.getEncapContentInfo();
        object5 = new BERSequenceGenerator(bERSequenceGenerator2.getRawOutputStream());
        ((BERSequenceGenerator)object5).addObject(((ContentInfoParser)object6).getContentType());
        dEREncodable = (ASN1OctetStringParser)((ContentInfoParser)object6).getContent(4);
        if (dEREncodable != null) {
            int n2;
            object4 = new BEROctetStringGenerator(((BERGenerator)object5).getRawOutputStream(), 0, true);
            object3 = new byte[4096];
            object2 = dEREncodable.getOctetStream();
            object = ((BEROctetStringGenerator)object4).getOctetOutputStream();
            while ((n2 = ((InputStream)object2).read((byte[])object3, 0, ((byte[])object3).length)) >= 0) {
                ((OutputStream)object).write((byte[])object3, 0, n2);
            }
            ((OutputStream)object).close();
        }
        ((BERSequenceGenerator)object5).close();
        object4 = signedDataParser.getCertificates();
        if (object4 instanceof BERSetParser) {
            bERSequenceGenerator2.getRawOutputStream().write(new BERTaggedObject(false, 0, object4.getDERObject()).getEncoded());
        } else if (object4 != null) {
            bERSequenceGenerator2.getRawOutputStream().write(new DERTaggedObject(false, 0, object4.getDERObject()).getEncoded());
        }
        object4 = signedDataParser.getCrls();
        if (object4 instanceof BERSetParser) {
            bERSequenceGenerator2.getRawOutputStream().write(new BERTaggedObject(false, 1, object4.getDERObject()).getEncoded());
        } else if (object4 != null) {
            bERSequenceGenerator2.getRawOutputStream().write(new DERTaggedObject(false, 1, object4.getDERObject()).getEncoded());
        }
        object3 = new ASN1EncodableVector();
        object2 = signerInformationStore.getSigners().iterator();
        while (object2.hasNext()) {
            object = (SignerInformation)object2.next();
            ((DEREncodableVector)object3).add(((SignerInformation)object).toSignerInfo());
        }
        bERSequenceGenerator2.getRawOutputStream().write(new DERSet((DEREncodableVector)object3).getEncoded());
        bERSequenceGenerator2.close();
        bERSequenceGenerator.close();
        return outputStream;
    }

    public static OutputStream replaceCertificatesAndCRLs(InputStream inputStream, CertStore certStore, OutputStream outputStream) throws CMSException, IOException {
        Object object;
        Object object2;
        Object object3;
        ASN1StreamParser aSN1StreamParser = new ASN1StreamParser(inputStream, CMSUtils.getMaximumMemory());
        ContentInfoParser contentInfoParser = new ContentInfoParser((ASN1SequenceParser)aSN1StreamParser.readObject());
        SignedDataParser signedDataParser = SignedDataParser.getInstance(contentInfoParser.getContent(16));
        BERSequenceGenerator bERSequenceGenerator = new BERSequenceGenerator(outputStream);
        bERSequenceGenerator.addObject(CMSObjectIdentifiers.signedData);
        BERSequenceGenerator bERSequenceGenerator2 = new BERSequenceGenerator(bERSequenceGenerator.getRawOutputStream(), 0, true);
        bERSequenceGenerator2.addObject(signedDataParser.getVersion());
        bERSequenceGenerator2.getRawOutputStream().write(signedDataParser.getDigestAlgorithms().getDERObject().getEncoded());
        ContentInfoParser contentInfoParser2 = signedDataParser.getEncapContentInfo();
        BERSequenceGenerator bERSequenceGenerator3 = new BERSequenceGenerator(bERSequenceGenerator2.getRawOutputStream());
        bERSequenceGenerator3.addObject(contentInfoParser2.getContentType());
        ASN1OctetStringParser aSN1OctetStringParser = (ASN1OctetStringParser)contentInfoParser2.getContent(4);
        if (aSN1OctetStringParser != null) {
            int n2;
            object3 = new BEROctetStringGenerator(bERSequenceGenerator3.getRawOutputStream(), 0, true);
            object2 = new byte[4096];
            object = aSN1OctetStringParser.getOctetStream();
            OutputStream outputStream2 = ((BEROctetStringGenerator)object3).getOctetOutputStream();
            while ((n2 = ((InputStream)object).read((byte[])object2, 0, ((Object)object2).length)) >= 0) {
                outputStream2.write((byte[])object2, 0, n2);
            }
            outputStream2.close();
        }
        bERSequenceGenerator3.close();
        object3 = signedDataParser.getCertificates();
        if (object3 != null) {
            object3.getDERObject();
        }
        if ((object3 = signedDataParser.getCrls()) != null) {
            object3.getDERObject();
        }
        try {
            object2 = CMSUtils.createBerSetFromList(CMSUtils.getCertificatesFromStore(certStore));
        }
        catch (CertStoreException certStoreException) {
            throw new CMSException("error getting certs from certStore", certStoreException);
        }
        if (((ASN1Set)object2).size() > 0) {
            bERSequenceGenerator2.getRawOutputStream().write(new DERTaggedObject(false, 0, (DEREncodable)object2).getEncoded());
        }
        try {
            object = CMSUtils.createBerSetFromList(CMSUtils.getCRLsFromStore(certStore));
        }
        catch (CertStoreException certStoreException) {
            throw new CMSException("error getting crls from certStore", certStoreException);
        }
        if (((ASN1Set)object).size() > 0) {
            bERSequenceGenerator2.getRawOutputStream().write(new DERTaggedObject(false, 1, (DEREncodable)object).getEncoded());
        }
        bERSequenceGenerator2.getRawOutputStream().write(signedDataParser.getSignerInfos().getDERObject().getEncoded());
        bERSequenceGenerator2.close();
        bERSequenceGenerator.close();
        return outputStream;
    }

    private static DERObject makeObj(byte[] byArray) throws IOException {
        if (byArray == null) {
            return null;
        }
        ASN1InputStream aSN1InputStream = new ASN1InputStream(byArray);
        return aSN1InputStream.readObject();
    }

    private static AlgorithmIdentifier makeAlgId(String string, byte[] byArray) throws IOException {
        if (byArray != null) {
            return new AlgorithmIdentifier(new DERObjectIdentifier(string), CMSSignedDataParser.makeObj(byArray));
        }
        return new AlgorithmIdentifier(new DERObjectIdentifier(string), new DERNull());
    }
}

