/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AlgorithmParameters;
import java.security.NoSuchProviderException;
import java.util.ArrayList;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.EncryptedContentInfo;
import org.bouncycastle.asn1.cms.EnvelopedData;
import org.bouncycastle.asn1.cms.KEKRecipientInfo;
import org.bouncycastle.asn1.cms.KeyAgreeRecipientInfo;
import org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import org.bouncycastle.asn1.cms.PasswordRecipientInfo;
import org.bouncycastle.asn1.cms.RecipientInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSEnvelopedHelper;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSUtils;
import org.bouncycastle.cms.KEKRecipientInformation;
import org.bouncycastle.cms.KeyAgreeRecipientInformation;
import org.bouncycastle.cms.KeyTransRecipientInformation;
import org.bouncycastle.cms.PasswordRecipientInformation;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;

public class CMSEnvelopedData {
    RecipientInformationStore recipientInfoStore;
    ContentInfo contentInfo;
    private AlgorithmIdentifier encAlg;
    private ASN1Set unprotectedAttributes;
    private AlgorithmIdentifier _encAlg;

    public CMSEnvelopedData(byte[] byArray) throws CMSException {
        this(CMSUtils.readContentInfo(byArray));
    }

    public CMSEnvelopedData(InputStream inputStream) throws CMSException {
        this(CMSUtils.readContentInfo(inputStream));
    }

    public CMSEnvelopedData(ContentInfo contentInfo) throws CMSException {
        this.contentInfo = contentInfo;
        EnvelopedData envelopedData = EnvelopedData.getInstance(contentInfo.getContent());
        EncryptedContentInfo encryptedContentInfo = envelopedData.getEncryptedContentInfo();
        this._encAlg = encryptedContentInfo.getContentEncryptionAlgorithm();
        ASN1Set aSN1Set = envelopedData.getRecipientInfos();
        ArrayList<RecipientInformation> arrayList = new ArrayList<RecipientInformation>();
        for (int i2 = 0; i2 != aSN1Set.size(); ++i2) {
            RecipientInfo recipientInfo = RecipientInfo.getInstance(aSN1Set.getObjectAt(i2));
            DEREncodable dEREncodable = recipientInfo.getInfo();
            if (dEREncodable instanceof KeyTransRecipientInfo) {
                arrayList.add(new KeyTransRecipientInformation((KeyTransRecipientInfo)dEREncodable, this._encAlg, (InputStream)new ByteArrayInputStream(encryptedContentInfo.getEncryptedContent().getOctets())));
                continue;
            }
            if (dEREncodable instanceof KEKRecipientInfo) {
                arrayList.add(new KEKRecipientInformation((KEKRecipientInfo)dEREncodable, this._encAlg, (InputStream)new ByteArrayInputStream(encryptedContentInfo.getEncryptedContent().getOctets())));
                continue;
            }
            if (dEREncodable instanceof KeyAgreeRecipientInfo) {
                arrayList.add(new KeyAgreeRecipientInformation((KeyAgreeRecipientInfo)dEREncodable, this._encAlg, (InputStream)new ByteArrayInputStream(encryptedContentInfo.getEncryptedContent().getOctets())));
                continue;
            }
            if (!(dEREncodable instanceof PasswordRecipientInfo)) continue;
            arrayList.add(new PasswordRecipientInformation((PasswordRecipientInfo)dEREncodable, this._encAlg, (InputStream)new ByteArrayInputStream(encryptedContentInfo.getEncryptedContent().getOctets())));
        }
        this.encAlg = envelopedData.getEncryptedContentInfo().getContentEncryptionAlgorithm();
        this.recipientInfoStore = new RecipientInformationStore(arrayList);
        this.unprotectedAttributes = envelopedData.getUnprotectedAttrs();
    }

    private byte[] encodeObj(DEREncodable dEREncodable) throws IOException {
        if (dEREncodable != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
            aSN1OutputStream.writeObject(dEREncodable);
            return byteArrayOutputStream.toByteArray();
        }
        return null;
    }

    public String getEncryptionAlgOID() {
        return this.encAlg.getObjectId().getId();
    }

    public byte[] getEncryptionAlgParams() {
        try {
            return this.encodeObj(this.encAlg.getParameters());
        }
        catch (Exception exception) {
            throw new RuntimeException("exception getting encryption parameters " + exception);
        }
    }

    public AlgorithmParameters getEncryptionAlgorithmParameters(String string) throws CMSException, NoSuchProviderException {
        return CMSEnvelopedHelper.INSTANCE.getEncryptionAlgorithmParameters(this.getEncryptionAlgOID(), this.getEncryptionAlgParams(), string);
    }

    public RecipientInformationStore getRecipientInfos() {
        return this.recipientInfoStore;
    }

    public AttributeTable getUnprotectedAttributes() {
        if (this.unprotectedAttributes == null) {
            return null;
        }
        return new AttributeTable(this.unprotectedAttributes);
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
        aSN1OutputStream.writeObject(this.contentInfo);
        return byteArrayOutputStream.toByteArray();
    }
}

