/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.util.Strings;

public abstract class X509NameEntryConverter {
    protected DERObject convertHexEncoded(String string, int n2) throws IOException {
        string = Strings.toLowerCase(string);
        byte[] byArray = new byte[(string.length() - n2) / 2];
        for (int i2 = 0; i2 != byArray.length; ++i2) {
            char c2 = string.charAt(i2 * 2 + n2);
            char c3 = string.charAt(i2 * 2 + n2 + 1);
            byArray[i2] = c2 < 'a' ? (byte)(c2 - 48 << 4) : (byte)(c2 - 97 + 10 << 4);
            if (c3 < 'a') {
                int n3 = i2;
                byArray[n3] = (byte)(byArray[n3] | (byte)(c3 - 48));
                continue;
            }
            int n4 = i2;
            byArray[n4] = (byte)(byArray[n4] | (byte)(c3 - 97 + 10));
        }
        ASN1InputStream aSN1InputStream = new ASN1InputStream(byArray);
        return aSN1InputStream.readObject();
    }

    protected boolean canBePrintable(String string) {
        return DERPrintableString.isPrintableString(string);
    }

    public abstract DERObject getConvertedValue(DERObjectIdentifier var1, String var2);
}

