/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.asn1.BERGenerator;
import org.bouncycastle.asn1.DEROctetString;

public class BEROctetStringGenerator
extends BERGenerator {
    public BEROctetStringGenerator(OutputStream outputStream) throws IOException {
        super(outputStream);
        this.writeBERHeader(36);
    }

    public BEROctetStringGenerator(OutputStream outputStream, int n2, boolean bl) throws IOException {
        super(outputStream, n2, bl);
        this.writeBERHeader(36);
    }

    public OutputStream getOctetOutputStream() {
        return this.getOctetOutputStream(new byte[1000]);
    }

    public OutputStream getOctetOutputStream(byte[] byArray) {
        return new BufferedBEROctetStream(byArray);
    }

    private class BufferedBEROctetStream
    extends OutputStream {
        private byte[] _buf;
        private int _off;

        BufferedBEROctetStream(byte[] byArray) {
            this._buf = byArray;
            this._off = 0;
        }

        public void write(int n2) throws IOException {
            this._buf[this._off++] = (byte)n2;
            if (this._off == this._buf.length) {
                BEROctetStringGenerator.this._out.write(new DEROctetString(this._buf).getEncoded());
                this._off = 0;
            }
        }

        public void write(byte[] byArray, int n2, int n3) throws IOException {
            while (n3 > 0) {
                int n4 = Math.min(n3, this._buf.length - this._off);
                System.arraycopy(byArray, n2, this._buf, this._off, n4);
                this._off += n4;
                if (this._off < this._buf.length) break;
                BEROctetStringGenerator.this._out.write(new DEROctetString(this._buf).getEncoded());
                this._off = 0;
                n2 += n4;
                n3 -= n4;
            }
        }

        public void close() throws IOException {
            if (this._off != 0) {
                byte[] byArray = new byte[this._off];
                System.arraycopy(this._buf, 0, byArray, 0, this._off);
                BEROctetStringGenerator.this._out.write(new DEROctetString(byArray).getEncoded());
            }
            BEROctetStringGenerator.this.writeBEREnd();
        }
    }
}

