/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.BEROutputStream;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DEROutputStream;

public class BERConstructedOctetString
extends DEROctetString {
    private static final int MAX_LENGTH = 1000;
    private Vector octs;

    private static byte[] toBytes(Vector vector) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i2 = 0; i2 != vector.size(); ++i2) {
            try {
                DEROctetString dEROctetString = (DEROctetString)vector.elementAt(i2);
                byteArrayOutputStream.write(dEROctetString.getOctets());
                continue;
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException(vector.elementAt(i2).getClass().getName() + " found in input should only contain DEROctetString");
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("exception converting octets " + iOException.toString());
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    public BERConstructedOctetString(byte[] byArray) {
        super(byArray);
    }

    public BERConstructedOctetString(Vector vector) {
        super(BERConstructedOctetString.toBytes(vector));
        this.octs = vector;
    }

    public BERConstructedOctetString(DERObject dERObject) {
        super(dERObject);
    }

    public BERConstructedOctetString(DEREncodable dEREncodable) {
        super(dEREncodable.getDERObject());
    }

    public byte[] getOctets() {
        return this.string;
    }

    public Enumeration getObjects() {
        if (this.octs == null) {
            return this.generateOcts().elements();
        }
        return this.octs.elements();
    }

    private Vector generateOcts() {
        byte[] byArray;
        int n2 = 0;
        int n3 = 0;
        Vector<DEROctetString> vector = new Vector<DEROctetString>();
        while (n3 + 1 < this.string.length) {
            if (this.string[n3] == 0 && this.string[n3 + 1] == 0) {
                byArray = new byte[n3 - n2 + 1];
                System.arraycopy(this.string, n2, byArray, 0, byArray.length);
                vector.addElement(new DEROctetString(byArray));
                n2 = n3 + 1;
            }
            ++n3;
        }
        byArray = new byte[this.string.length - n2];
        System.arraycopy(this.string, n2, byArray, 0, byArray.length);
        vector.addElement(new DEROctetString(byArray));
        return vector;
    }

    public void encode(DEROutputStream dEROutputStream) throws IOException {
        if (dEROutputStream instanceof ASN1OutputStream || dEROutputStream instanceof BEROutputStream) {
            dEROutputStream.write(36);
            dEROutputStream.write(128);
            if (this.octs != null) {
                for (int i2 = 0; i2 != this.octs.size(); ++i2) {
                    dEROutputStream.writeObject(this.octs.elementAt(i2));
                }
            } else {
                for (int i3 = 0; i3 < this.string.length; i3 += 1000) {
                    int n2 = i3 + 1000 > this.string.length ? this.string.length : i3 + 1000;
                    byte[] byArray = new byte[n2 - i3];
                    System.arraycopy(this.string, i3, byArray, 0, byArray.length);
                    dEROutputStream.writeObject(new DEROctetString(byArray));
                }
            }
            dEROutputStream.write(0);
            dEROutputStream.write(0);
        } else {
            super.encode(dEROutputStream);
        }
    }
}

