/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.util;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class BinaryTree
extends AbstractMap {
    final Node[] _root;
    int _size = 0;
    int _modifications = 0;
    private final Set[] _key_set = new Set[]{null, null};
    private final Set[] _entry_set = new Set[]{null, null};
    private final Collection[] _value_collection = new Collection[]{null, null};
    static int _KEY = 0;
    static int _VALUE = 1;
    private static int _INDEX_SUM = _KEY + _VALUE;
    private static int _MINIMUM_INDEX = 0;
    private static int _INDEX_COUNT = 2;
    private static String[] _data_name = new String[]{"key", "value"};

    public BinaryTree() {
        this._root = new Node[]{null, null};
    }

    public BinaryTree(Map map) throws ClassCastException, NullPointerException, IllegalArgumentException {
        this();
        this.putAll(map);
    }

    public Object getKeyForValue(Object value) throws ClassCastException, NullPointerException {
        return this.doGet((Comparable)value, _VALUE);
    }

    public Object removeValue(Object value) {
        return this.doRemove((Comparable)value, _VALUE);
    }

    public Set entrySetByValue() {
        if (this._entry_set[_VALUE] == null) {
            this._entry_set[BinaryTree._VALUE] = new AbstractSet(){

                public Iterator iterator() {
                    return new BinaryTreeIterator(_VALUE){

                        protected Object doGetNext() {
                            return this._last_returned_node;
                        }
                    };
                }

                public boolean contains(Object o2) {
                    if (!(o2 instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)o2;
                    Object key = entry.getKey();
                    Node node = BinaryTree.this.lookup((Comparable)entry.getValue(), _VALUE);
                    return node != null && node.getData(_KEY).equals(key);
                }

                public boolean remove(Object o2) {
                    if (!(o2 instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)o2;
                    Object key = entry.getKey();
                    Node node = BinaryTree.this.lookup((Comparable)entry.getValue(), _VALUE);
                    if (node != null && node.getData(_KEY).equals(key)) {
                        BinaryTree.this.doRedBlackDelete(node);
                        return true;
                    }
                    return false;
                }

                public int size() {
                    return BinaryTree.this.size();
                }

                public void clear() {
                    BinaryTree.this.clear();
                }
            };
        }
        return this._entry_set[_VALUE];
    }

    public Set keySetByValue() {
        if (this._key_set[_VALUE] == null) {
            this._key_set[BinaryTree._VALUE] = new AbstractSet(){

                public Iterator iterator() {
                    return new BinaryTreeIterator(_VALUE){

                        protected Object doGetNext() {
                            return this._last_returned_node.getData(_KEY);
                        }
                    };
                }

                public int size() {
                    return BinaryTree.this.size();
                }

                public boolean contains(Object o2) {
                    return BinaryTree.this.containsKey(o2);
                }

                public boolean remove(Object o2) {
                    int old_size = BinaryTree.this._size;
                    BinaryTree.this.remove(o2);
                    return BinaryTree.this._size != old_size;
                }

                public void clear() {
                    BinaryTree.this.clear();
                }
            };
        }
        return this._key_set[_VALUE];
    }

    public Collection valuesByValue() {
        if (this._value_collection[_VALUE] == null) {
            this._value_collection[BinaryTree._VALUE] = new AbstractCollection(){

                public Iterator iterator() {
                    return new BinaryTreeIterator(_VALUE){

                        protected Object doGetNext() {
                            return this._last_returned_node.getData(_VALUE);
                        }
                    };
                }

                public int size() {
                    return BinaryTree.this.size();
                }

                public boolean contains(Object o2) {
                    return BinaryTree.this.containsValue(o2);
                }

                public boolean remove(Object o2) {
                    int old_size = BinaryTree.this._size;
                    BinaryTree.this.removeValue(o2);
                    return BinaryTree.this._size != old_size;
                }

                public boolean removeAll(Collection c2) {
                    boolean modified = false;
                    Iterator iter = c2.iterator();
                    while (iter.hasNext()) {
                        if (BinaryTree.this.removeValue(iter.next()) == null) continue;
                        modified = true;
                    }
                    return modified;
                }

                public void clear() {
                    BinaryTree.this.clear();
                }
            };
        }
        return this._value_collection[_VALUE];
    }

    private Object doRemove(Comparable o2, int index) {
        Node node = this.lookup(o2, index);
        Comparable rval = null;
        if (node != null) {
            rval = node.getData(this.oppositeIndex(index));
            this.doRedBlackDelete(node);
        }
        return rval;
    }

    private Object doGet(Comparable o2, int index) {
        BinaryTree.checkNonNullComparable(o2, index);
        Node node = this.lookup(o2, index);
        return node == null ? null : node.getData(this.oppositeIndex(index));
    }

    private int oppositeIndex(int index) {
        return _INDEX_SUM - index;
    }

    public Node lookup(Comparable data, int index) {
        Node rval = null;
        Node node = this._root[index];
        while (node != null) {
            int cmp = BinaryTree.compare(data, node.getData(index));
            if (cmp == 0) {
                rval = node;
                break;
            }
            node = cmp < 0 ? node.getLeft(index) : node.getRight(index);
        }
        return rval;
    }

    private static int compare(Comparable o1, Comparable o2) {
        return o1.compareTo(o2);
    }

    static Node leastNode(Node node, int index) {
        Node rval = node;
        if (rval != null) {
            while (rval.getLeft(index) != null) {
                rval = rval.getLeft(index);
            }
        }
        return rval;
    }

    static Node nextGreater(Node node, int index) {
        Node rval = null;
        if (node == null) {
            rval = null;
        } else if (node.getRight(index) != null) {
            rval = BinaryTree.leastNode(node.getRight(index), index);
        } else {
            Node parent;
            Node child = node;
            for (parent = node.getParent(index); parent != null && child == parent.getRight(index); parent = parent.getParent(index)) {
                child = parent;
            }
            rval = parent;
        }
        return rval;
    }

    private static void copyColor(Node from, Node to, int index) {
        if (to != null) {
            if (from == null) {
                to.setBlack(index);
            } else {
                to.copyColor(from, index);
            }
        }
    }

    private static boolean isRed(Node node, int index) {
        return node == null ? false : node.isRed(index);
    }

    private static boolean isBlack(Node node, int index) {
        return node == null ? true : node.isBlack(index);
    }

    private static void makeRed(Node node, int index) {
        if (node != null) {
            node.setRed(index);
        }
    }

    private static void makeBlack(Node node, int index) {
        if (node != null) {
            node.setBlack(index);
        }
    }

    private static Node getGrandParent(Node node, int index) {
        return BinaryTree.getParent(BinaryTree.getParent(node, index), index);
    }

    private static Node getParent(Node node, int index) {
        return node == null ? null : node.getParent(index);
    }

    private static Node getRightChild(Node node, int index) {
        return node == null ? null : node.getRight(index);
    }

    private static Node getLeftChild(Node node, int index) {
        return node == null ? null : node.getLeft(index);
    }

    private static boolean isLeftChild(Node node, int index) {
        if (node == null) {
            return true;
        }
        if (node.getParent(index) == null) {
            return false;
        }
        return node == node.getParent(index).getLeft(index);
    }

    private static boolean isRightChild(Node node, int index) {
        if (node == null) {
            return true;
        }
        if (node.getParent(index) == null) {
            return false;
        }
        return node == node.getParent(index).getRight(index);
    }

    private void rotateLeft(Node node, int index) {
        Node right_child = node.getRight(index);
        node.setRight(right_child.getLeft(index), index);
        if (right_child.getLeft(index) != null) {
            right_child.getLeft(index).setParent(node, index);
        }
        right_child.setParent(node.getParent(index), index);
        if (node.getParent(index) == null) {
            this._root[index] = right_child;
        } else if (node.getParent(index).getLeft(index) == node) {
            node.getParent(index).setLeft(right_child, index);
        } else {
            node.getParent(index).setRight(right_child, index);
        }
        right_child.setLeft(node, index);
        node.setParent(right_child, index);
    }

    private void rotateRight(Node node, int index) {
        Node left_child = node.getLeft(index);
        node.setLeft(left_child.getRight(index), index);
        if (left_child.getRight(index) != null) {
            left_child.getRight(index).setParent(node, index);
        }
        left_child.setParent(node.getParent(index), index);
        if (node.getParent(index) == null) {
            this._root[index] = left_child;
        } else if (node.getParent(index).getRight(index) == node) {
            node.getParent(index).setRight(left_child, index);
        } else {
            node.getParent(index).setLeft(left_child, index);
        }
        left_child.setRight(node, index);
        node.setParent(left_child, index);
    }

    private void doRedBlackInsert(Node inserted_node, int index) {
        Node current_node = inserted_node;
        BinaryTree.makeRed(current_node, index);
        while (current_node != null && current_node != this._root[index] && BinaryTree.isRed(current_node.getParent(index), index)) {
            Node y2;
            if (BinaryTree.isLeftChild(BinaryTree.getParent(current_node, index), index)) {
                y2 = BinaryTree.getRightChild(BinaryTree.getGrandParent(current_node, index), index);
                if (BinaryTree.isRed(y2, index)) {
                    BinaryTree.makeBlack(BinaryTree.getParent(current_node, index), index);
                    BinaryTree.makeBlack(y2, index);
                    BinaryTree.makeRed(BinaryTree.getGrandParent(current_node, index), index);
                    current_node = BinaryTree.getGrandParent(current_node, index);
                    continue;
                }
                if (BinaryTree.isRightChild(current_node, index)) {
                    current_node = BinaryTree.getParent(current_node, index);
                    this.rotateLeft(current_node, index);
                }
                BinaryTree.makeBlack(BinaryTree.getParent(current_node, index), index);
                BinaryTree.makeRed(BinaryTree.getGrandParent(current_node, index), index);
                if (BinaryTree.getGrandParent(current_node, index) == null) continue;
                this.rotateRight(BinaryTree.getGrandParent(current_node, index), index);
                continue;
            }
            y2 = BinaryTree.getLeftChild(BinaryTree.getGrandParent(current_node, index), index);
            if (BinaryTree.isRed(y2, index)) {
                BinaryTree.makeBlack(BinaryTree.getParent(current_node, index), index);
                BinaryTree.makeBlack(y2, index);
                BinaryTree.makeRed(BinaryTree.getGrandParent(current_node, index), index);
                current_node = BinaryTree.getGrandParent(current_node, index);
                continue;
            }
            if (BinaryTree.isLeftChild(current_node, index)) {
                current_node = BinaryTree.getParent(current_node, index);
                this.rotateRight(current_node, index);
            }
            BinaryTree.makeBlack(BinaryTree.getParent(current_node, index), index);
            BinaryTree.makeRed(BinaryTree.getGrandParent(current_node, index), index);
            if (BinaryTree.getGrandParent(current_node, index) == null) continue;
            this.rotateLeft(BinaryTree.getGrandParent(current_node, index), index);
        }
        BinaryTree.makeBlack(this._root[index], index);
    }

    void doRedBlackDelete(Node deleted_node) {
        for (int index = _MINIMUM_INDEX; index < _INDEX_COUNT; ++index) {
            Node replacement;
            if (deleted_node.getLeft(index) != null && deleted_node.getRight(index) != null) {
                this.swapPosition(BinaryTree.nextGreater(deleted_node, index), deleted_node, index);
            }
            Node node = replacement = deleted_node.getLeft(index) != null ? deleted_node.getLeft(index) : deleted_node.getRight(index);
            if (replacement != null) {
                replacement.setParent(deleted_node.getParent(index), index);
                if (deleted_node.getParent(index) == null) {
                    this._root[index] = replacement;
                } else if (deleted_node == deleted_node.getParent(index).getLeft(index)) {
                    deleted_node.getParent(index).setLeft(replacement, index);
                } else {
                    deleted_node.getParent(index).setRight(replacement, index);
                }
                deleted_node.setLeft(null, index);
                deleted_node.setRight(null, index);
                deleted_node.setParent(null, index);
                if (!BinaryTree.isBlack(deleted_node, index)) continue;
                this.doRedBlackDeleteFixup(replacement, index);
                continue;
            }
            if (deleted_node.getParent(index) == null) {
                this._root[index] = null;
                continue;
            }
            if (BinaryTree.isBlack(deleted_node, index)) {
                this.doRedBlackDeleteFixup(deleted_node, index);
            }
            if (deleted_node.getParent(index) == null) continue;
            if (deleted_node == deleted_node.getParent(index).getLeft(index)) {
                deleted_node.getParent(index).setLeft(null, index);
            } else {
                deleted_node.getParent(index).setRight(null, index);
            }
            deleted_node.setParent(null, index);
        }
        this.shrink();
    }

    private void doRedBlackDeleteFixup(Node replacement_node, int index) {
        Node current_node = replacement_node;
        while (current_node != this._root[index] && BinaryTree.isBlack(current_node, index)) {
            Node sibling_node;
            if (BinaryTree.isLeftChild(current_node, index)) {
                sibling_node = BinaryTree.getRightChild(BinaryTree.getParent(current_node, index), index);
                if (BinaryTree.isRed(sibling_node, index)) {
                    BinaryTree.makeBlack(sibling_node, index);
                    BinaryTree.makeRed(BinaryTree.getParent(current_node, index), index);
                    this.rotateLeft(BinaryTree.getParent(current_node, index), index);
                    sibling_node = BinaryTree.getRightChild(BinaryTree.getParent(current_node, index), index);
                }
                if (BinaryTree.isBlack(BinaryTree.getLeftChild(sibling_node, index), index) && BinaryTree.isBlack(BinaryTree.getRightChild(sibling_node, index), index)) {
                    BinaryTree.makeRed(sibling_node, index);
                    current_node = BinaryTree.getParent(current_node, index);
                    continue;
                }
                if (BinaryTree.isBlack(BinaryTree.getRightChild(sibling_node, index), index)) {
                    BinaryTree.makeBlack(BinaryTree.getLeftChild(sibling_node, index), index);
                    BinaryTree.makeRed(sibling_node, index);
                    this.rotateRight(sibling_node, index);
                    sibling_node = BinaryTree.getRightChild(BinaryTree.getParent(current_node, index), index);
                }
                BinaryTree.copyColor(BinaryTree.getParent(current_node, index), sibling_node, index);
                BinaryTree.makeBlack(BinaryTree.getParent(current_node, index), index);
                BinaryTree.makeBlack(BinaryTree.getRightChild(sibling_node, index), index);
                this.rotateLeft(BinaryTree.getParent(current_node, index), index);
                current_node = this._root[index];
                continue;
            }
            sibling_node = BinaryTree.getLeftChild(BinaryTree.getParent(current_node, index), index);
            if (BinaryTree.isRed(sibling_node, index)) {
                BinaryTree.makeBlack(sibling_node, index);
                BinaryTree.makeRed(BinaryTree.getParent(current_node, index), index);
                this.rotateRight(BinaryTree.getParent(current_node, index), index);
                sibling_node = BinaryTree.getLeftChild(BinaryTree.getParent(current_node, index), index);
            }
            if (BinaryTree.isBlack(BinaryTree.getRightChild(sibling_node, index), index) && BinaryTree.isBlack(BinaryTree.getLeftChild(sibling_node, index), index)) {
                BinaryTree.makeRed(sibling_node, index);
                current_node = BinaryTree.getParent(current_node, index);
                continue;
            }
            if (BinaryTree.isBlack(BinaryTree.getLeftChild(sibling_node, index), index)) {
                BinaryTree.makeBlack(BinaryTree.getRightChild(sibling_node, index), index);
                BinaryTree.makeRed(sibling_node, index);
                this.rotateLeft(sibling_node, index);
                sibling_node = BinaryTree.getLeftChild(BinaryTree.getParent(current_node, index), index);
            }
            BinaryTree.copyColor(BinaryTree.getParent(current_node, index), sibling_node, index);
            BinaryTree.makeBlack(BinaryTree.getParent(current_node, index), index);
            BinaryTree.makeBlack(BinaryTree.getLeftChild(sibling_node, index), index);
            this.rotateRight(BinaryTree.getParent(current_node, index), index);
            current_node = this._root[index];
        }
        BinaryTree.makeBlack(current_node, index);
    }

    private void swapPosition(Node x2, Node y2, int index) {
        boolean y_was_left_child;
        Node x_old_parent = x2.getParent(index);
        Node x_old_left_child = x2.getLeft(index);
        Node x_old_right_child = x2.getRight(index);
        Node y_old_parent = y2.getParent(index);
        Node y_old_left_child = y2.getLeft(index);
        Node y_old_right_child = y2.getRight(index);
        boolean x_was_left_child = x2.getParent(index) != null && x2 == x2.getParent(index).getLeft(index);
        boolean bl = y_was_left_child = y2.getParent(index) != null && y2 == y2.getParent(index).getLeft(index);
        if (x2 == y_old_parent) {
            x2.setParent(y2, index);
            if (y_was_left_child) {
                y2.setLeft(x2, index);
                y2.setRight(x_old_right_child, index);
            } else {
                y2.setRight(x2, index);
                y2.setLeft(x_old_left_child, index);
            }
        } else {
            x2.setParent(y_old_parent, index);
            if (y_old_parent != null) {
                if (y_was_left_child) {
                    y_old_parent.setLeft(x2, index);
                } else {
                    y_old_parent.setRight(x2, index);
                }
            }
            y2.setLeft(x_old_left_child, index);
            y2.setRight(x_old_right_child, index);
        }
        if (y2 == x_old_parent) {
            y2.setParent(x2, index);
            if (x_was_left_child) {
                x2.setLeft(y2, index);
                x2.setRight(y_old_right_child, index);
            } else {
                x2.setRight(y2, index);
                x2.setLeft(y_old_left_child, index);
            }
        } else {
            y2.setParent(x_old_parent, index);
            if (x_old_parent != null) {
                if (x_was_left_child) {
                    x_old_parent.setLeft(y2, index);
                } else {
                    x_old_parent.setRight(y2, index);
                }
            }
            x2.setLeft(y_old_left_child, index);
            x2.setRight(y_old_right_child, index);
        }
        if (x2.getLeft(index) != null) {
            x2.getLeft(index).setParent(x2, index);
        }
        if (x2.getRight(index) != null) {
            x2.getRight(index).setParent(x2, index);
        }
        if (y2.getLeft(index) != null) {
            y2.getLeft(index).setParent(y2, index);
        }
        if (y2.getRight(index) != null) {
            y2.getRight(index).setParent(y2, index);
        }
        x2.swapColors(y2, index);
        if (this._root[index] == x2) {
            this._root[index] = y2;
        } else if (this._root[index] == y2) {
            this._root[index] = x2;
        }
    }

    private static void checkNonNullComparable(Object o2, int index) {
        if (o2 == null) {
            throw new NullPointerException(_data_name[index] + " cannot be null");
        }
        if (!(o2 instanceof Comparable)) {
            throw new ClassCastException(_data_name[index] + " must be Comparable");
        }
    }

    private static void checkKey(Object key) {
        BinaryTree.checkNonNullComparable(key, _KEY);
    }

    private static void checkValue(Object value) {
        BinaryTree.checkNonNullComparable(value, _VALUE);
    }

    private static void checkKeyAndValue(Object key, Object value) {
        BinaryTree.checkKey(key);
        BinaryTree.checkValue(value);
    }

    private void modify() {
        ++this._modifications;
    }

    private void grow() {
        this.modify();
        ++this._size;
    }

    private void shrink() {
        this.modify();
        --this._size;
    }

    private void insertValue(Node newNode) throws IllegalArgumentException {
        block4: {
            Node node = this._root[_VALUE];
            while (true) {
                int cmp;
                if ((cmp = BinaryTree.compare(newNode.getData(_VALUE), node.getData(_VALUE))) == 0) {
                    throw new IllegalArgumentException("Cannot store a duplicate value (\"" + newNode.getData(_VALUE) + "\") in this Map");
                }
                if (cmp < 0) {
                    if (node.getLeft(_VALUE) != null) {
                        node = node.getLeft(_VALUE);
                        continue;
                    }
                    node.setLeft(newNode, _VALUE);
                    newNode.setParent(node, _VALUE);
                    this.doRedBlackInsert(newNode, _VALUE);
                    break block4;
                }
                if (node.getRight(_VALUE) == null) break;
                node = node.getRight(_VALUE);
            }
            node.setRight(newNode, _VALUE);
            newNode.setParent(node, _VALUE);
            this.doRedBlackInsert(newNode, _VALUE);
        }
    }

    public int size() {
        return this._size;
    }

    public boolean containsKey(Object key) throws ClassCastException, NullPointerException {
        BinaryTree.checkKey(key);
        return this.lookup((Comparable)key, _KEY) != null;
    }

    public boolean containsValue(Object value) {
        BinaryTree.checkValue(value);
        return this.lookup((Comparable)value, _VALUE) != null;
    }

    public Object get(Object key) throws ClassCastException, NullPointerException {
        return this.doGet((Comparable)key, _KEY);
    }

    public Object put(Object key, Object value) throws ClassCastException, NullPointerException, IllegalArgumentException {
        block6: {
            BinaryTree.checkKeyAndValue(key, value);
            Node node = this._root[_KEY];
            if (node == null) {
                Node root;
                this._root[BinaryTree._KEY] = root = new Node((Comparable)key, (Comparable)value);
                this._root[BinaryTree._VALUE] = root;
                this.grow();
            } else {
                while (true) {
                    int cmp;
                    if ((cmp = BinaryTree.compare((Comparable)key, node.getData(_KEY))) == 0) {
                        throw new IllegalArgumentException("Cannot store a duplicate key (\"" + key + "\") in this Map");
                    }
                    if (cmp < 0) {
                        if (node.getLeft(_KEY) != null) {
                            node = node.getLeft(_KEY);
                            continue;
                        }
                        Node newNode = new Node((Comparable)key, (Comparable)value);
                        this.insertValue(newNode);
                        node.setLeft(newNode, _KEY);
                        newNode.setParent(node, _KEY);
                        this.doRedBlackInsert(newNode, _KEY);
                        this.grow();
                        break block6;
                    }
                    if (node.getRight(_KEY) == null) break;
                    node = node.getRight(_KEY);
                }
                Node newNode = new Node((Comparable)key, (Comparable)value);
                this.insertValue(newNode);
                node.setRight(newNode, _KEY);
                newNode.setParent(node, _KEY);
                this.doRedBlackInsert(newNode, _KEY);
                this.grow();
            }
        }
        return null;
    }

    public Object remove(Object key) {
        return this.doRemove((Comparable)key, _KEY);
    }

    public void clear() {
        this.modify();
        this._size = 0;
        this._root[BinaryTree._KEY] = null;
        this._root[BinaryTree._VALUE] = null;
    }

    public Set keySet() {
        if (this._key_set[_KEY] == null) {
            this._key_set[BinaryTree._KEY] = new AbstractSet(){

                public Iterator iterator() {
                    return new BinaryTreeIterator(_KEY){

                        protected Object doGetNext() {
                            return this._last_returned_node.getData(_KEY);
                        }
                    };
                }

                public int size() {
                    return BinaryTree.this.size();
                }

                public boolean contains(Object o2) {
                    return BinaryTree.this.containsKey(o2);
                }

                public boolean remove(Object o2) {
                    int old_size = BinaryTree.this._size;
                    BinaryTree.this.remove(o2);
                    return BinaryTree.this._size != old_size;
                }

                public void clear() {
                    BinaryTree.this.clear();
                }
            };
        }
        return this._key_set[_KEY];
    }

    public Collection values() {
        if (this._value_collection[_KEY] == null) {
            this._value_collection[BinaryTree._KEY] = new AbstractCollection(){

                public Iterator iterator() {
                    return new BinaryTreeIterator(_KEY){

                        protected Object doGetNext() {
                            return this._last_returned_node.getData(_VALUE);
                        }
                    };
                }

                public int size() {
                    return BinaryTree.this.size();
                }

                public boolean contains(Object o2) {
                    return BinaryTree.this.containsValue(o2);
                }

                public boolean remove(Object o2) {
                    int old_size = BinaryTree.this._size;
                    BinaryTree.this.removeValue(o2);
                    return BinaryTree.this._size != old_size;
                }

                public boolean removeAll(Collection c2) {
                    boolean modified = false;
                    Iterator iter = c2.iterator();
                    while (iter.hasNext()) {
                        if (BinaryTree.this.removeValue(iter.next()) == null) continue;
                        modified = true;
                    }
                    return modified;
                }

                public void clear() {
                    BinaryTree.this.clear();
                }
            };
        }
        return this._value_collection[_KEY];
    }

    public Set entrySet() {
        if (this._entry_set[_KEY] == null) {
            this._entry_set[BinaryTree._KEY] = new AbstractSet(){

                public Iterator iterator() {
                    return new BinaryTreeIterator(_KEY){

                        protected Object doGetNext() {
                            return this._last_returned_node;
                        }
                    };
                }

                public boolean contains(Object o2) {
                    if (!(o2 instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)o2;
                    Object value = entry.getValue();
                    Node node = BinaryTree.this.lookup((Comparable)entry.getKey(), _KEY);
                    return node != null && node.getData(_VALUE).equals(value);
                }

                public boolean remove(Object o2) {
                    if (!(o2 instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)o2;
                    Object value = entry.getValue();
                    Node node = BinaryTree.this.lookup((Comparable)entry.getKey(), _KEY);
                    if (node != null && node.getData(_VALUE).equals(value)) {
                        BinaryTree.this.doRedBlackDelete(node);
                        return true;
                    }
                    return false;
                }

                public int size() {
                    return BinaryTree.this.size();
                }

                public void clear() {
                    BinaryTree.this.clear();
                }
            };
        }
        return this._entry_set[_KEY];
    }

    private static final class Node
    implements Map.Entry {
        private Comparable[] _data;
        private Node[] _left;
        private Node[] _right;
        private Node[] _parent;
        private boolean[] _black;
        private int _hashcode;
        private boolean _calculated_hashcode;

        Node(Comparable key, Comparable value) {
            this._data = new Comparable[]{key, value};
            this._left = new Node[]{null, null};
            this._right = new Node[]{null, null};
            this._parent = new Node[]{null, null};
            this._black = new boolean[]{true, true};
            this._calculated_hashcode = false;
        }

        public Comparable getData(int index) {
            return this._data[index];
        }

        public void setLeft(Node node, int index) {
            this._left[index] = node;
        }

        public Node getLeft(int index) {
            return this._left[index];
        }

        public void setRight(Node node, int index) {
            this._right[index] = node;
        }

        public Node getRight(int index) {
            return this._right[index];
        }

        public void setParent(Node node, int index) {
            this._parent[index] = node;
        }

        public Node getParent(int index) {
            return this._parent[index];
        }

        public void swapColors(Node node, int index) {
            int n2 = index;
            this._black[n2] = this._black[n2] ^ node._black[index];
            int n3 = index;
            node._black[n3] = node._black[n3] ^ this._black[index];
            int n4 = index;
            this._black[n4] = this._black[n4] ^ node._black[index];
        }

        public boolean isBlack(int index) {
            return this._black[index];
        }

        public boolean isRed(int index) {
            return !this._black[index];
        }

        public void setBlack(int index) {
            this._black[index] = true;
        }

        public void setRed(int index) {
            this._black[index] = false;
        }

        public void copyColor(Node node, int index) {
            this._black[index] = node._black[index];
        }

        public Object getKey() {
            return this._data[_KEY];
        }

        public Object getValue() {
            return this._data[_VALUE];
        }

        public Object setValue(Object ignored) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Map.Entry.setValue is not supported");
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e2 = (Map.Entry)o2;
            return this._data[_KEY].equals(e2.getKey()) && this._data[_VALUE].equals(e2.getValue());
        }

        public int hashCode() {
            if (!this._calculated_hashcode) {
                this._hashcode = this._data[_KEY].hashCode() ^ this._data[_VALUE].hashCode();
                this._calculated_hashcode = true;
            }
            return this._hashcode;
        }
    }

    private abstract class BinaryTreeIterator
    implements Iterator {
        private int _expected_modifications;
        protected Node _last_returned_node;
        private Node _next_node;
        private int _type;

        BinaryTreeIterator(int type) {
            this._type = type;
            this._expected_modifications = BinaryTree.this._modifications;
            this._last_returned_node = null;
            this._next_node = BinaryTree.leastNode(BinaryTree.this._root[this._type], this._type);
        }

        protected abstract Object doGetNext();

        public boolean hasNext() {
            return this._next_node != null;
        }

        public Object next() throws NoSuchElementException, ConcurrentModificationException {
            if (this._next_node == null) {
                throw new NoSuchElementException();
            }
            if (BinaryTree.this._modifications != this._expected_modifications) {
                throw new ConcurrentModificationException();
            }
            this._last_returned_node = this._next_node;
            this._next_node = BinaryTree.nextGreater(this._next_node, this._type);
            return this.doGetNext();
        }

        public void remove() throws IllegalStateException, ConcurrentModificationException {
            if (this._last_returned_node == null) {
                throw new IllegalStateException();
            }
            if (BinaryTree.this._modifications != this._expected_modifications) {
                throw new ConcurrentModificationException();
            }
            BinaryTree.this.doRedBlackDelete(this._last_returned_node);
            ++this._expected_modifications;
            this._last_returned_node = null;
        }
    }
}

