/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.usermodel;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BuiltinFormats {
    public static final int FIRST_USER_DEFINED_FORMAT_INDEX = 164;
    private static final String[] _formats;

    private static void putFormat(List<String> m2, int index, String value) {
        if (m2.size() != index) {
            throw new IllegalStateException("index " + index + " is wrong");
        }
        m2.add(value);
    }

    public static Map<Integer, String> getBuiltinFormats() {
        LinkedHashMap<Integer, String> result = new LinkedHashMap<Integer, String>();
        for (int i2 = 0; i2 < _formats.length; ++i2) {
            result.put(i2, _formats[i2]);
        }
        return result;
    }

    public static String[] getAll() {
        return (String[])_formats.clone();
    }

    public static String getBuiltinFormat(int index) {
        if (index < 0 || index >= _formats.length) {
            return null;
        }
        return _formats[index];
    }

    public static int getBuiltinFormat(String pFmt) {
        String fmt = pFmt.equalsIgnoreCase("TEXT") ? "@" : pFmt;
        for (int i2 = 0; i2 < _formats.length; ++i2) {
            if (!fmt.equals(_formats[i2])) continue;
            return i2;
        }
        return -1;
    }

    static {
        ArrayList<String> m2 = new ArrayList<String>();
        BuiltinFormats.putFormat(m2, 0, "General");
        BuiltinFormats.putFormat(m2, 1, "0");
        BuiltinFormats.putFormat(m2, 2, "0.00");
        BuiltinFormats.putFormat(m2, 3, "#,##0");
        BuiltinFormats.putFormat(m2, 4, "#,##0.00");
        BuiltinFormats.putFormat(m2, 5, "$#,##0_);($#,##0)");
        BuiltinFormats.putFormat(m2, 6, "$#,##0_);[Red]($#,##0)");
        BuiltinFormats.putFormat(m2, 7, "$#,##0.00_);($#,##0.00)");
        BuiltinFormats.putFormat(m2, 8, "$#,##0.00_);[Red]($#,##0.00)");
        BuiltinFormats.putFormat(m2, 9, "0%");
        BuiltinFormats.putFormat(m2, 10, "0.00%");
        BuiltinFormats.putFormat(m2, 11, "0.00E+00");
        BuiltinFormats.putFormat(m2, 12, "# ?/?");
        BuiltinFormats.putFormat(m2, 13, "# ??/??");
        BuiltinFormats.putFormat(m2, 14, "m/d/yy");
        BuiltinFormats.putFormat(m2, 15, "d-mmm-yy");
        BuiltinFormats.putFormat(m2, 16, "d-mmm");
        BuiltinFormats.putFormat(m2, 17, "mmm-yy");
        BuiltinFormats.putFormat(m2, 18, "h:mm AM/PM");
        BuiltinFormats.putFormat(m2, 19, "h:mm:ss AM/PM");
        BuiltinFormats.putFormat(m2, 20, "h:mm");
        BuiltinFormats.putFormat(m2, 21, "h:mm:ss");
        BuiltinFormats.putFormat(m2, 22, "m/d/yy h:mm");
        for (int i2 = 23; i2 <= 36; ++i2) {
            BuiltinFormats.putFormat(m2, i2, "reserved-0x" + Integer.toHexString(i2));
        }
        BuiltinFormats.putFormat(m2, 37, "#,##0_);(#,##0)");
        BuiltinFormats.putFormat(m2, 38, "#,##0_);[Red](#,##0)");
        BuiltinFormats.putFormat(m2, 39, "#,##0.00_);(#,##0.00)");
        BuiltinFormats.putFormat(m2, 40, "#,##0.00_);[Red](#,##0.00)");
        BuiltinFormats.putFormat(m2, 41, "_(*#,##0_);_(*(#,##0);_(* \"-\"_);_(@_)");
        BuiltinFormats.putFormat(m2, 42, "_($*#,##0_);_($*(#,##0);_($* \"-\"_);_(@_)");
        BuiltinFormats.putFormat(m2, 43, "_(*#,##0.00_);_(*(#,##0.00);_(*\"-\"??_);_(@_)");
        BuiltinFormats.putFormat(m2, 44, "_($*#,##0.00_);_($*(#,##0.00);_($*\"-\"??_);_(@_)");
        BuiltinFormats.putFormat(m2, 45, "mm:ss");
        BuiltinFormats.putFormat(m2, 46, "[h]:mm:ss");
        BuiltinFormats.putFormat(m2, 47, "mm:ss.0");
        BuiltinFormats.putFormat(m2, 48, "##0.0E+0");
        BuiltinFormats.putFormat(m2, 49, "@");
        String[] ss = new String[m2.size()];
        m2.toArray(ss);
        _formats = ss;
    }
}

