/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.storage;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.poifs.filesystem.BATManaged;
import org.apache.poi.poifs.filesystem.POIFSDocument;
import org.apache.poi.poifs.property.RootProperty;
import org.apache.poi.poifs.storage.BlockAllocationTableWriter;
import org.apache.poi.poifs.storage.BlockWritable;
import org.apache.poi.poifs.storage.SmallDocumentBlock;

public class SmallBlockTableWriter
implements BlockWritable,
BATManaged {
    private BlockAllocationTableWriter _sbat = new BlockAllocationTableWriter();
    private List _small_blocks = new ArrayList();
    private int _big_block_count;
    private RootProperty _root;

    public SmallBlockTableWriter(List documents, RootProperty root) {
        this._root = root;
        for (POIFSDocument doc : documents) {
            BlockWritable[] blocks = doc.getSmallBlocks();
            if (blocks.length != 0) {
                doc.setStartBlock(this._sbat.allocateSpace(blocks.length));
                for (int j2 = 0; j2 < blocks.length; ++j2) {
                    this._small_blocks.add(blocks[j2]);
                }
                continue;
            }
            doc.setStartBlock(-2);
        }
        this._sbat.simpleCreateBlocks();
        this._root.setSize(this._small_blocks.size());
        this._big_block_count = SmallDocumentBlock.fill(this._small_blocks);
    }

    public int getSBATBlockCount() {
        return (this._big_block_count + 15) / 16;
    }

    public BlockAllocationTableWriter getSBAT() {
        return this._sbat;
    }

    public int countBlocks() {
        return this._big_block_count;
    }

    public void setStartBlock(int start_block) {
        this._root.setStartBlock(start_block);
    }

    public void writeBlocks(OutputStream stream) throws IOException {
        Iterator iter = this._small_blocks.iterator();
        while (iter.hasNext()) {
            ((BlockWritable)iter.next()).writeBlocks(stream);
        }
    }
}

