/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.filesystem;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.poifs.dev.POIFSViewable;
import org.apache.poi.poifs.filesystem.BATManaged;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.DocumentNode;
import org.apache.poi.poifs.filesystem.EntryNode;
import org.apache.poi.poifs.filesystem.POIFSDocument;
import org.apache.poi.poifs.filesystem.POIFSWriterListener;
import org.apache.poi.poifs.property.DirectoryProperty;
import org.apache.poi.poifs.property.Property;
import org.apache.poi.poifs.property.PropertyTable;
import org.apache.poi.poifs.storage.BATBlock;
import org.apache.poi.poifs.storage.BlockAllocationTableReader;
import org.apache.poi.poifs.storage.BlockAllocationTableWriter;
import org.apache.poi.poifs.storage.BlockList;
import org.apache.poi.poifs.storage.BlockWritable;
import org.apache.poi.poifs.storage.HeaderBlockReader;
import org.apache.poi.poifs.storage.HeaderBlockWriter;
import org.apache.poi.poifs.storage.RawDataBlockList;
import org.apache.poi.poifs.storage.SmallBlockTableReader;
import org.apache.poi.poifs.storage.SmallBlockTableWriter;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.LongField;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public class POIFSFileSystem
implements POIFSViewable {
    private static final POILogger _logger = POILogFactory.getLogger(POIFSFileSystem.class);
    private PropertyTable _property_table = new PropertyTable();
    private List _documents = new ArrayList();
    private DirectoryNode _root = null;
    private int bigBlockSize = 512;

    public static InputStream createNonClosingInputStream(InputStream is) {
        return new CloseIgnoringInputStream(is);
    }

    public POIFSFileSystem() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public POIFSFileSystem(InputStream stream) throws IOException {
        this();
        RawDataBlockList data_blocks;
        HeaderBlockReader header_block_reader;
        boolean success = false;
        try {
            header_block_reader = new HeaderBlockReader(stream);
            this.bigBlockSize = header_block_reader.getBigBlockSize();
            data_blocks = new RawDataBlockList(stream, this.bigBlockSize);
            success = true;
        }
        finally {
            this.closeInputStream(stream, success);
        }
        new BlockAllocationTableReader(header_block_reader.getBATCount(), header_block_reader.getBATArray(), header_block_reader.getXBATCount(), header_block_reader.getXBATIndex(), data_blocks);
        PropertyTable properties = new PropertyTable(header_block_reader.getPropertyStart(), data_blocks);
        this.processProperties(SmallBlockTableReader.getSmallDocumentBlocks(data_blocks, properties.getRoot(), header_block_reader.getSBATStart()), data_blocks, properties.getRoot().getChildren(), null, header_block_reader.getPropertyStart());
        this.getRoot().setStorageClsid(properties.getRoot().getStorageClsid());
    }

    private void closeInputStream(InputStream stream, boolean success) {
        if (stream.markSupported() && !(stream instanceof ByteArrayInputStream)) {
            String msg = "POIFS is closing the supplied input stream of type (" + stream.getClass().getName() + ") which supports mark/reset.  " + "This will be a problem for the caller if the stream will still be used.  " + "If that is the case the caller should wrap the input stream to avoid this close logic.  " + "This warning is only temporary and will not be present in future versions of POI.";
            _logger.log(POILogger.WARN, msg);
        }
        try {
            stream.close();
        }
        catch (IOException e2) {
            if (success) {
                throw new RuntimeException(e2);
            }
            e2.printStackTrace();
        }
    }

    public static boolean hasPOIFSHeader(InputStream inp) throws IOException {
        inp.mark(8);
        byte[] header = new byte[8];
        IOUtils.readFully(inp, header);
        LongField signature = new LongField(0, header);
        if (inp instanceof PushbackInputStream) {
            PushbackInputStream pin = (PushbackInputStream)inp;
            pin.unread(header);
        } else {
            inp.reset();
        }
        return signature.get() == -2226271756974174256L;
    }

    public DocumentEntry createDocument(InputStream stream, String name) throws IOException {
        return this.getRoot().createDocument(name, stream);
    }

    public DocumentEntry createDocument(String name, int size, POIFSWriterListener writer) throws IOException {
        return this.getRoot().createDocument(name, size, writer);
    }

    public DirectoryEntry createDirectory(String name) throws IOException {
        return this.getRoot().createDirectory(name);
    }

    public void writeFilesystem(OutputStream stream) throws IOException {
        this._property_table.preWrite();
        SmallBlockTableWriter sbtw = new SmallBlockTableWriter(this._documents, this._property_table.getRoot());
        BlockAllocationTableWriter bat = new BlockAllocationTableWriter();
        ArrayList<BlockWritable> bm_objects = new ArrayList<BlockWritable>();
        bm_objects.addAll(this._documents);
        bm_objects.add(this._property_table);
        bm_objects.add(sbtw);
        bm_objects.add(sbtw.getSBAT());
        for (BATManaged bATManaged : bm_objects) {
            int block_count = bATManaged.countBlocks();
            if (block_count == 0) continue;
            bATManaged.setStartBlock(bat.allocateSpace(block_count));
        }
        int n2 = bat.createBlocks();
        HeaderBlockWriter header_block_writer = new HeaderBlockWriter();
        BATBlock[] xbat_blocks = header_block_writer.setBATBlocks(bat.countBlocks(), n2);
        header_block_writer.setPropertyStart(this._property_table.getStartBlock());
        header_block_writer.setSBATStart(sbtw.getSBAT().getStartBlock());
        header_block_writer.setSBATBlockCount(sbtw.getSBATBlockCount());
        ArrayList<BlockWritable> writers = new ArrayList<BlockWritable>();
        writers.add(header_block_writer);
        writers.addAll(this._documents);
        writers.add(this._property_table);
        writers.add(sbtw);
        writers.add(sbtw.getSBAT());
        writers.add(bat);
        for (int j2 = 0; j2 < xbat_blocks.length; ++j2) {
            writers.add(xbat_blocks[j2]);
        }
        for (BlockWritable writer : writers) {
            writer.writeBlocks(stream);
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            System.err.println("two arguments required: input filename and output filename");
            System.exit(1);
        }
        FileInputStream istream = new FileInputStream(args[0]);
        FileOutputStream ostream = new FileOutputStream(args[1]);
        new POIFSFileSystem(istream).writeFilesystem(ostream);
        istream.close();
        ostream.close();
    }

    public DirectoryNode getRoot() {
        if (this._root == null) {
            this._root = new DirectoryNode(this._property_table.getRoot(), this, null);
        }
        return this._root;
    }

    public DocumentInputStream createDocumentInputStream(String documentName) throws IOException {
        return this.getRoot().createDocumentInputStream(documentName);
    }

    void addDocument(POIFSDocument document) {
        this._documents.add(document);
        this._property_table.addProperty(document.getDocumentProperty());
    }

    void addDirectory(DirectoryProperty directory) {
        this._property_table.addProperty(directory);
    }

    void remove(EntryNode entry) {
        this._property_table.removeProperty(entry.getProperty());
        if (entry.isDocumentEntry()) {
            this._documents.remove(((DocumentNode)entry).getDocument());
        }
    }

    private void processProperties(BlockList small_blocks, BlockList big_blocks, Iterator properties, DirectoryNode dir, int headerPropertiesStartAt) throws IOException {
        while (properties.hasNext()) {
            DirectoryNode parent;
            Property property = (Property)properties.next();
            String name = property.getName();
            DirectoryNode directoryNode = parent = dir == null ? this.getRoot() : dir;
            if (property.isDirectory()) {
                DirectoryNode new_dir = (DirectoryNode)parent.createDirectory(name);
                new_dir.setStorageClsid(property.getStorageClsid());
                this.processProperties(small_blocks, big_blocks, ((DirectoryProperty)property).getChildren(), new_dir, headerPropertiesStartAt);
                continue;
            }
            int startBlock = property.getStartBlock();
            int size = property.getSize();
            POIFSDocument document = null;
            document = property.shouldUseSmallBlocks() ? new POIFSDocument(name, small_blocks.fetchBlocks(startBlock, headerPropertiesStartAt), size) : new POIFSDocument(name, big_blocks.fetchBlocks(startBlock, headerPropertiesStartAt), size);
            parent.createDocument(document);
        }
    }

    public Object[] getViewableArray() {
        if (this.preferArray()) {
            return this.getRoot().getViewableArray();
        }
        return new Object[0];
    }

    public Iterator getViewableIterator() {
        if (!this.preferArray()) {
            return this.getRoot().getViewableIterator();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public boolean preferArray() {
        return this.getRoot().preferArray();
    }

    public String getShortDescription() {
        return "POIFS FileSystem";
    }

    public int getBigBlockSize() {
        return this.bigBlockSize;
    }

    private static final class CloseIgnoringInputStream
    extends InputStream {
        private final InputStream _is;

        public CloseIgnoringInputStream(InputStream is) {
            this._is = is;
        }

        public int read() throws IOException {
            return this._is.read();
        }

        public int read(byte[] b2, int off, int len) throws IOException {
            return this._is.read(b2, off, len);
        }

        public void close() {
        }
    }
}

