/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.functions;

final class MathX {
    private MathX() {
    }

    public static double round(double n2, int p2) {
        double retval;
        if (Double.isNaN(n2) || Double.isInfinite(n2)) {
            retval = Double.NaN;
        } else if (p2 != 0) {
            double temp = Math.pow(10.0, p2);
            retval = (double)Math.round(n2 * temp) / temp;
        } else {
            retval = Math.round(n2);
        }
        return retval;
    }

    public static double roundUp(double n2, int p2) {
        double retval;
        if (Double.isNaN(n2) || Double.isInfinite(n2)) {
            retval = Double.NaN;
        } else if (p2 != 0) {
            double temp = Math.pow(10.0, p2);
            double nat = Math.abs(n2 * temp);
            retval = (double)MathX.sign(n2) * (nat == (double)((long)nat) ? nat / temp : (double)Math.round(nat + 0.5) / temp);
        } else {
            double na = Math.abs(n2);
            retval = (double)MathX.sign(n2) * (na == (double)((long)na) ? na : (double)((long)na + 1L));
        }
        return retval;
    }

    public static double roundDown(double n2, int p2) {
        double retval;
        if (Double.isNaN(n2) || Double.isInfinite(n2)) {
            retval = Double.NaN;
        } else if (p2 != 0) {
            double temp = Math.pow(10.0, p2);
            retval = (double)((long)MathX.sign(n2) * Math.round(Math.abs(n2) * temp - 0.5)) / temp;
        } else {
            retval = (long)n2;
        }
        return retval;
    }

    public static short sign(double d2) {
        return (short)(d2 == 0.0 ? 0 : (d2 < 0.0 ? -1 : 1));
    }

    public static double average(double[] values) {
        double ave = 0.0;
        double sum = 0.0;
        int iSize = values.length;
        for (int i2 = 0; i2 < iSize; ++i2) {
            sum += values[i2];
        }
        ave = sum / (double)values.length;
        return ave;
    }

    public static double sum(double[] values) {
        double sum = 0.0;
        int iSize = values.length;
        for (int i2 = 0; i2 < iSize; ++i2) {
            sum += values[i2];
        }
        return sum;
    }

    public static double sumsq(double[] values) {
        double sumsq = 0.0;
        int iSize = values.length;
        for (int i2 = 0; i2 < iSize; ++i2) {
            sumsq += values[i2] * values[i2];
        }
        return sumsq;
    }

    public static double product(double[] values) {
        double product = 0.0;
        if (values != null && values.length > 0) {
            product = 1.0;
            int iSize = values.length;
            for (int i2 = 0; i2 < iSize; ++i2) {
                product *= values[i2];
            }
        }
        return product;
    }

    public static double min(double[] values) {
        double min = Double.POSITIVE_INFINITY;
        int iSize = values.length;
        for (int i2 = 0; i2 < iSize; ++i2) {
            min = Math.min(min, values[i2]);
        }
        return min;
    }

    public static double max(double[] values) {
        double max = Double.NEGATIVE_INFINITY;
        int iSize = values.length;
        for (int i2 = 0; i2 < iSize; ++i2) {
            max = Math.max(max, values[i2]);
        }
        return max;
    }

    public static double floor(double n2, double s2) {
        double f2 = n2 < 0.0 && s2 > 0.0 || n2 > 0.0 && s2 < 0.0 || s2 == 0.0 && n2 != 0.0 ? Double.NaN : (n2 == 0.0 || s2 == 0.0 ? 0.0 : Math.floor(n2 / s2) * s2);
        return f2;
    }

    public static double ceiling(double n2, double s2) {
        double c2 = n2 < 0.0 && s2 > 0.0 || n2 > 0.0 && s2 < 0.0 ? Double.NaN : (n2 == 0.0 || s2 == 0.0 ? 0.0 : Math.ceil(n2 / s2) * s2);
        return c2;
    }

    public static double factorial(int n2) {
        double d2 = 1.0;
        if (n2 >= 0) {
            if (n2 <= 170) {
                for (int i2 = 1; i2 <= n2; ++i2) {
                    d2 *= (double)i2;
                }
            } else {
                d2 = Double.POSITIVE_INFINITY;
            }
        } else {
            d2 = Double.NaN;
        }
        return d2;
    }

    public static double mod(double n2, double d2) {
        double result = 0.0;
        if (d2 == 0.0) {
            result = Double.NaN;
        } else if (MathX.sign(n2) == MathX.sign(d2)) {
            double t2 = Math.abs(n2 / d2);
            t2 -= (double)((long)t2);
            result = (double)MathX.sign(d2) * Math.abs(t2 * d2);
        } else {
            double t3 = Math.abs(n2 / d2);
            t3 -= (double)((long)t3);
            t3 = Math.ceil(t3) - t3;
            result = (double)MathX.sign(d2) * Math.abs(t3 * d2);
        }
        return result;
    }

    public static double acosh(double d2) {
        return Math.log(Math.sqrt(Math.pow(d2, 2.0) - 1.0) + d2);
    }

    public static double asinh(double d2) {
        return Math.log(Math.sqrt(d2 * d2 + 1.0) + d2);
    }

    public static double atanh(double d2) {
        return Math.log((1.0 + d2) / (1.0 - d2)) / 2.0;
    }

    public static double cosh(double d2) {
        double ePowX = Math.pow(Math.E, d2);
        double ePowNegX = Math.pow(Math.E, -d2);
        return (ePowX + ePowNegX) / 2.0;
    }

    public static double sinh(double d2) {
        double ePowX = Math.pow(Math.E, d2);
        double ePowNegX = Math.pow(Math.E, -d2);
        return (ePowX - ePowNegX) / 2.0;
    }

    public static double tanh(double d2) {
        double ePowX = Math.pow(Math.E, d2);
        double ePowNegX = Math.pow(Math.E, -d2);
        return (ePowX - ePowNegX) / (ePowX + ePowNegX);
    }

    public static double nChooseK(int n2, int k2) {
        double d2 = 1.0;
        if (n2 < 0 || k2 < 0 || n2 < k2) {
            d2 = Double.NaN;
        } else {
            int maxnk;
            int minnk = Math.min(n2 - k2, k2);
            for (int i2 = maxnk = Math.max(n2 - k2, k2); i2 < n2; ++i2) {
                d2 *= (double)(i2 + 1);
            }
            d2 /= MathX.factorial(minnk);
        }
        return d2;
    }
}

