/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.eval;

import org.apache.poi.hssf.record.formula.eval.AreaEval;
import org.apache.poi.hssf.record.formula.eval.BlankEval;
import org.apache.poi.hssf.record.formula.eval.BoolEval;
import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.EvaluationException;
import org.apache.poi.hssf.record.formula.eval.NumericValueEval;
import org.apache.poi.hssf.record.formula.eval.RefEval;
import org.apache.poi.hssf.record.formula.eval.StringEval;
import org.apache.poi.hssf.record.formula.eval.StringValueEval;
import org.apache.poi.hssf.record.formula.eval.ValueEval;

public final class OperandResolver {
    private OperandResolver() {
    }

    public static ValueEval getSingleValue(ValueEval arg, int srcCellRow, int srcCellCol) throws EvaluationException {
        ValueEval result = arg instanceof RefEval ? ((RefEval)arg).getInnerValueEval() : (arg instanceof AreaEval ? OperandResolver.chooseSingleElementFromArea((AreaEval)arg, srcCellRow, srcCellCol) : arg);
        if (result instanceof ErrorEval) {
            throw new EvaluationException((ErrorEval)result);
        }
        return result;
    }

    public static ValueEval chooseSingleElementFromArea(AreaEval ae2, int srcCellRow, int srcCellCol) throws EvaluationException {
        ValueEval result = OperandResolver.chooseSingleElementFromAreaInternal(ae2, srcCellRow, (short)srcCellCol);
        if (result == null) {
            result = BlankEval.instance;
        }
        if (result instanceof ErrorEval) {
            throw new EvaluationException((ErrorEval)result);
        }
        return result;
    }

    private static ValueEval chooseSingleElementFromAreaInternal(AreaEval ae2, int srcCellRow, short srcCellCol) throws EvaluationException {
        if (ae2.isColumn()) {
            if (ae2.isRow()) {
                return ae2.getRelativeValue(0, 0);
            }
            if (!ae2.containsRow(srcCellRow)) {
                throw EvaluationException.invalidValue();
            }
            return ae2.getValueAt(srcCellRow, ae2.getFirstColumn());
        }
        if (!ae2.isRow()) {
            if (ae2.containsRow(srcCellRow) && ae2.containsColumn(srcCellCol)) {
                return ae2.getValueAt(ae2.getFirstRow(), ae2.getFirstColumn());
            }
            throw EvaluationException.invalidValue();
        }
        if (!ae2.containsColumn(srcCellCol)) {
            throw EvaluationException.invalidValue();
        }
        return ae2.getValueAt(ae2.getFirstRow(), srcCellCol);
    }

    public static int coerceValueToInt(ValueEval ev) throws EvaluationException {
        if (ev == BlankEval.instance) {
            return 0;
        }
        double d2 = OperandResolver.coerceValueToDouble(ev);
        return (int)Math.floor(d2);
    }

    public static double coerceValueToDouble(ValueEval ev) throws EvaluationException {
        if (ev == BlankEval.instance) {
            return 0.0;
        }
        if (ev instanceof NumericValueEval) {
            return ((NumericValueEval)ev).getNumberValue();
        }
        if (ev instanceof StringEval) {
            Double dd = OperandResolver.parseDouble(((StringEval)ev).getStringValue());
            if (dd == null) {
                throw EvaluationException.invalidValue();
            }
            return dd;
        }
        throw new RuntimeException("Unexpected arg eval type (" + ev.getClass().getName() + ")");
    }

    public static Double parseDouble(String pText) {
        double val;
        String text = pText.trim();
        if (text.length() < 1) {
            return null;
        }
        boolean isPositive = true;
        if (text.charAt(0) == '-') {
            isPositive = false;
            text = text.substring(1).trim();
        }
        if (!Character.isDigit(text.charAt(0))) {
            return null;
        }
        try {
            val = Double.parseDouble(text);
        }
        catch (NumberFormatException e2) {
            return null;
        }
        return new Double(isPositive ? val : -val);
    }

    public static String coerceValueToString(ValueEval ve) {
        if (ve instanceof StringValueEval) {
            StringValueEval sve = (StringValueEval)ve;
            return sve.getStringValue();
        }
        if (ve == BlankEval.instance) {
            return "";
        }
        throw new IllegalArgumentException("Unexpected eval class (" + ve.getClass().getName() + ")");
    }

    public static Boolean coerceValueToBoolean(ValueEval ve, boolean stringsAreBlanks) throws EvaluationException {
        if (ve == null || ve == BlankEval.instance) {
            return null;
        }
        if (ve instanceof BoolEval) {
            return ((BoolEval)ve).getBooleanValue();
        }
        if (ve == BlankEval.instance) {
            return null;
        }
        if (ve instanceof StringEval) {
            if (stringsAreBlanks) {
                return null;
            }
            String str = ((StringEval)ve).getStringValue();
            if (str.equalsIgnoreCase("true")) {
                return Boolean.TRUE;
            }
            if (str.equalsIgnoreCase("false")) {
                return Boolean.FALSE;
            }
            throw new EvaluationException(ErrorEval.VALUE_INVALID);
        }
        if (ve instanceof NumericValueEval) {
            NumericValueEval ne = (NumericValueEval)ve;
            double d2 = ne.getNumberValue();
            if (Double.isNaN(d2)) {
                throw new EvaluationException(ErrorEval.VALUE_INVALID);
            }
            return d2 != 0.0;
        }
        if (ve instanceof ErrorEval) {
            throw new EvaluationException((ErrorEval)ve);
        }
        throw new RuntimeException("Unexpected eval (" + ve.getClass().getName() + ")");
    }
}

