/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.cont.ContinuableRecordOutput;
import org.apache.poi.util.BitField;
import org.apache.poi.util.BitFieldFactory;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndianInput;
import org.apache.poi.util.LittleEndianOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UnicodeString
implements Comparable<UnicodeString> {
    private short field_1_charCount;
    private byte field_2_optionflags;
    private String field_3_string;
    private List<FormatRun> field_4_format_runs;
    private byte[] field_5_ext_rst;
    private static final BitField highByte = BitFieldFactory.getInstance(1);
    private static final BitField extBit = BitFieldFactory.getInstance(4);
    private static final BitField richText = BitFieldFactory.getInstance(8);

    private UnicodeString() {
    }

    public UnicodeString(String str) {
        this.setString(str);
    }

    public int hashCode() {
        int stringHash = 0;
        if (this.field_3_string != null) {
            stringHash = this.field_3_string.hashCode();
        }
        return this.field_1_charCount + stringHash;
    }

    public boolean equals(Object o2) {
        int i2;
        boolean eq;
        if (!(o2 instanceof UnicodeString)) {
            return false;
        }
        UnicodeString other = (UnicodeString)o2;
        boolean bl = eq = this.field_1_charCount == other.field_1_charCount && this.field_2_optionflags == other.field_2_optionflags && this.field_3_string.equals(other.field_3_string);
        if (!eq) {
            return false;
        }
        if (this.field_4_format_runs == null && other.field_4_format_runs == null) {
            return true;
        }
        if (this.field_4_format_runs == null && other.field_4_format_runs != null || this.field_4_format_runs != null && other.field_4_format_runs == null) {
            return false;
        }
        int size = this.field_4_format_runs.size();
        if (size != other.field_4_format_runs.size()) {
            return false;
        }
        for (i2 = 0; i2 < size; ++i2) {
            FormatRun run2;
            FormatRun run1 = this.field_4_format_runs.get(i2);
            if (run1.equals(run2 = other.field_4_format_runs.get(i2))) continue;
            return false;
        }
        if (this.field_5_ext_rst == null && other.field_5_ext_rst == null) {
            return true;
        }
        if (this.field_5_ext_rst == null && other.field_5_ext_rst != null || this.field_5_ext_rst != null && other.field_5_ext_rst == null) {
            return false;
        }
        size = this.field_5_ext_rst.length;
        if (size != this.field_5_ext_rst.length) {
            return false;
        }
        for (i2 = 0; i2 < size; ++i2) {
            if (this.field_5_ext_rst[i2] == other.field_5_ext_rst[i2]) continue;
            return false;
        }
        return true;
    }

    public UnicodeString(RecordInputStream in) {
        int i2;
        this.field_1_charCount = in.readShort();
        this.field_2_optionflags = in.readByte();
        int runCount = 0;
        int extensionLength = 0;
        if (this.isRichText()) {
            runCount = in.readShort();
        }
        if (this.isExtendedText()) {
            extensionLength = in.readInt();
        }
        boolean isCompressed = (this.field_2_optionflags & 1) == 0;
        this.field_3_string = isCompressed ? in.readCompressedUnicode(this.getCharCount()) : in.readUnicodeLEString(this.getCharCount());
        if (this.isRichText() && runCount > 0) {
            this.field_4_format_runs = new ArrayList<FormatRun>(runCount);
            for (i2 = 0; i2 < runCount; ++i2) {
                this.field_4_format_runs.add(new FormatRun(in));
            }
        }
        if (this.isExtendedText() && extensionLength > 0) {
            this.field_5_ext_rst = new byte[extensionLength];
            for (i2 = 0; i2 < extensionLength; ++i2) {
                this.field_5_ext_rst[i2] = in.readByte();
            }
        }
    }

    public int getCharCount() {
        if (this.field_1_charCount < 0) {
            return this.field_1_charCount + 65536;
        }
        return this.field_1_charCount;
    }

    public short getCharCountShort() {
        return this.field_1_charCount;
    }

    public void setCharCount(short cc) {
        this.field_1_charCount = cc;
    }

    public byte getOptionFlags() {
        return this.field_2_optionflags;
    }

    public void setOptionFlags(byte of) {
        this.field_2_optionflags = of;
    }

    public String getString() {
        return this.field_3_string;
    }

    public void setString(String string) {
        this.field_3_string = string;
        this.setCharCount((short)this.field_3_string.length());
        boolean useUTF16 = false;
        int strlen = string.length();
        for (int j2 = 0; j2 < strlen; ++j2) {
            if (string.charAt(j2) <= '\u00ff') continue;
            useUTF16 = true;
            break;
        }
        this.field_2_optionflags = useUTF16 ? highByte.setByte(this.field_2_optionflags) : highByte.clearByte(this.field_2_optionflags);
    }

    public int getFormatRunCount() {
        if (this.field_4_format_runs == null) {
            return 0;
        }
        return this.field_4_format_runs.size();
    }

    public FormatRun getFormatRun(int index) {
        if (this.field_4_format_runs == null) {
            return null;
        }
        if (index < 0 || index >= this.field_4_format_runs.size()) {
            return null;
        }
        return this.field_4_format_runs.get(index);
    }

    private int findFormatRunAt(int characterPos) {
        int size = this.field_4_format_runs.size();
        for (int i2 = 0; i2 < size; ++i2) {
            FormatRun r2 = this.field_4_format_runs.get(i2);
            if (r2._character == characterPos) {
                return i2;
            }
            if (r2._character <= characterPos) continue;
            return -1;
        }
        return -1;
    }

    public void addFormatRun(FormatRun r2) {
        int index;
        if (this.field_4_format_runs == null) {
            this.field_4_format_runs = new ArrayList<FormatRun>();
        }
        if ((index = this.findFormatRunAt(r2._character)) != -1) {
            this.field_4_format_runs.remove(index);
        }
        this.field_4_format_runs.add(r2);
        Collections.sort(this.field_4_format_runs);
        this.field_2_optionflags = richText.setByte(this.field_2_optionflags);
    }

    public Iterator<FormatRun> formatIterator() {
        if (this.field_4_format_runs != null) {
            return this.field_4_format_runs.iterator();
        }
        return null;
    }

    public void removeFormatRun(FormatRun r2) {
        this.field_4_format_runs.remove(r2);
        if (this.field_4_format_runs.size() == 0) {
            this.field_4_format_runs = null;
            this.field_2_optionflags = richText.clearByte(this.field_2_optionflags);
        }
    }

    public void clearFormatting() {
        this.field_4_format_runs = null;
        this.field_2_optionflags = richText.clearByte(this.field_2_optionflags);
    }

    void setExtendedRst(byte[] ext_rst) {
        this.field_2_optionflags = ext_rst != null ? extBit.setByte(this.field_2_optionflags) : extBit.clearByte(this.field_2_optionflags);
        this.field_5_ext_rst = ext_rst;
    }

    public void swapFontUse(short oldFontIndex, short newFontIndex) {
        for (FormatRun run : this.field_4_format_runs) {
            if (run._fontIndex != oldFontIndex) continue;
            run._fontIndex = newFontIndex;
        }
    }

    public String toString() {
        return this.getString();
    }

    public String getDebugInfo() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[UNICODESTRING]\n");
        buffer.append("    .charcount       = ").append(Integer.toHexString(this.getCharCount())).append("\n");
        buffer.append("    .optionflags     = ").append(Integer.toHexString(this.getOptionFlags())).append("\n");
        buffer.append("    .string          = ").append(this.getString()).append("\n");
        if (this.field_4_format_runs != null) {
            for (int i2 = 0; i2 < this.field_4_format_runs.size(); ++i2) {
                FormatRun r2 = this.field_4_format_runs.get(i2);
                buffer.append("      .format_run" + i2 + "          = ").append(r2.toString()).append("\n");
            }
        }
        if (this.field_5_ext_rst != null) {
            buffer.append("    .field_5_ext_rst          = ").append("\n").append(HexDump.toHex(this.field_5_ext_rst)).append("\n");
        }
        buffer.append("[/UNICODESTRING]\n");
        return buffer.toString();
    }

    public void serialize(ContinuableRecordOutput out) {
        int numberOfRichTextRuns = 0;
        int extendedDataSize = 0;
        if (this.isRichText() && this.field_4_format_runs != null) {
            numberOfRichTextRuns = this.field_4_format_runs.size();
        }
        if (this.isExtendedText() && this.field_5_ext_rst != null) {
            extendedDataSize = this.field_5_ext_rst.length;
        }
        out.writeString(this.field_3_string, numberOfRichTextRuns, extendedDataSize);
        if (numberOfRichTextRuns > 0) {
            for (int i2 = 0; i2 < numberOfRichTextRuns; ++i2) {
                if (out.getAvailableSpace() < 4) {
                    out.writeContinue();
                }
                FormatRun r2 = this.field_4_format_runs.get(i2);
                r2.serialize(out);
            }
        }
        if (extendedDataSize > 0) {
            int extPos = 0;
            while (true) {
                int nBytesToWrite = Math.min(extendedDataSize - extPos, out.getAvailableSpace());
                out.write(this.field_5_ext_rst, extPos, nBytesToWrite);
                if ((extPos += nBytesToWrite) >= extendedDataSize) break;
                out.writeContinue();
            }
        }
    }

    @Override
    public int compareTo(UnicodeString str) {
        int i2;
        int result = this.getString().compareTo(str.getString());
        if (result != 0) {
            return result;
        }
        if (this.field_4_format_runs == null && str.field_4_format_runs == null) {
            return 0;
        }
        if (this.field_4_format_runs == null && str.field_4_format_runs != null) {
            return 1;
        }
        if (this.field_4_format_runs != null && str.field_4_format_runs == null) {
            return -1;
        }
        int size = this.field_4_format_runs.size();
        if (size != str.field_4_format_runs.size()) {
            return size - str.field_4_format_runs.size();
        }
        for (i2 = 0; i2 < size; ++i2) {
            FormatRun run2;
            FormatRun run1 = this.field_4_format_runs.get(i2);
            result = run1.compareTo(run2 = str.field_4_format_runs.get(i2));
            if (result == 0) continue;
            return result;
        }
        if (this.field_5_ext_rst == null && str.field_5_ext_rst == null) {
            return 0;
        }
        if (this.field_5_ext_rst == null && str.field_5_ext_rst != null) {
            return 1;
        }
        if (this.field_5_ext_rst != null && str.field_5_ext_rst == null) {
            return -1;
        }
        size = this.field_5_ext_rst.length;
        if (size != this.field_5_ext_rst.length) {
            return size - this.field_5_ext_rst.length;
        }
        for (i2 = 0; i2 < size; ++i2) {
            if (this.field_5_ext_rst[i2] == str.field_5_ext_rst[i2]) continue;
            return this.field_5_ext_rst[i2] - str.field_5_ext_rst[i2];
        }
        return 0;
    }

    private boolean isRichText() {
        return richText.isSet(this.getOptionFlags());
    }

    private boolean isExtendedText() {
        return extBit.isSet(this.getOptionFlags());
    }

    public Object clone() {
        UnicodeString str = new UnicodeString();
        str.field_1_charCount = this.field_1_charCount;
        str.field_2_optionflags = this.field_2_optionflags;
        str.field_3_string = this.field_3_string;
        if (this.field_4_format_runs != null) {
            str.field_4_format_runs = new ArrayList<FormatRun>();
            for (FormatRun r2 : this.field_4_format_runs) {
                str.field_4_format_runs.add(new FormatRun(r2._character, r2._fontIndex));
            }
        }
        if (this.field_5_ext_rst != null) {
            str.field_5_ext_rst = new byte[this.field_5_ext_rst.length];
            System.arraycopy(this.field_5_ext_rst, 0, str.field_5_ext_rst, 0, this.field_5_ext_rst.length);
        }
        return str;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FormatRun
    implements Comparable<FormatRun> {
        final short _character;
        short _fontIndex;

        public FormatRun(short character, short fontIndex) {
            this._character = character;
            this._fontIndex = fontIndex;
        }

        public FormatRun(LittleEndianInput in) {
            this(in.readShort(), in.readShort());
        }

        public short getCharacterPos() {
            return this._character;
        }

        public short getFontIndex() {
            return this._fontIndex;
        }

        public boolean equals(Object o2) {
            if (!(o2 instanceof FormatRun)) {
                return false;
            }
            FormatRun other = (FormatRun)o2;
            return this._character == other._character && this._fontIndex == other._fontIndex;
        }

        @Override
        public int compareTo(FormatRun r2) {
            if (this._character == r2._character && this._fontIndex == r2._fontIndex) {
                return 0;
            }
            if (this._character == r2._character) {
                return this._fontIndex - r2._fontIndex;
            }
            return this._character - r2._character;
        }

        public String toString() {
            return "character=" + this._character + ",fontIndex=" + this._fontIndex;
        }

        public void serialize(LittleEndianOutput out) {
            out.writeShort(this._character);
            out.writeShort(this._fontIndex);
        }
    }
}

